<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("BookingGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fbookinggrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbookinggrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["booking_by", [fields.booking_by.visible && fields.booking_by.required ? ew.Validators.required(fields.booking_by.caption) : null, ew.Validators.integer], fields.booking_by.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["b_quantity", [fields.b_quantity.visible && fields.b_quantity.required ? ew.Validators.required(fields.b_quantity.caption) : null, ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_quantity", [fields.confirm_quantity.visible && fields.confirm_quantity.required ? ew.Validators.required(fields.confirm_quantity.caption) : null, ew.Validators.float], fields.confirm_quantity.isInvalid],
            ["booking_rate", [fields.booking_rate.visible && fields.booking_rate.required ? ew.Validators.required(fields.booking_rate.caption) : null, ew.Validators.float], fields.booking_rate.isInvalid],
            ["currency_current_rate", [fields.currency_current_rate.visible && fields.currency_current_rate.required ? ew.Validators.required(fields.currency_current_rate.caption) : null, ew.Validators.float], fields.currency_current_rate.isInvalid],
            ["booking_date", [fields.booking_date.visible && fields.booking_date.required ? ew.Validators.required(fields.booking_date.caption) : null, ew.Validators.datetime(fields.booking_date.clientFormatPattern)], fields.booking_date.isInvalid],
            ["shipment_date", [fields.shipment_date.visible && fields.shipment_date.required ? ew.Validators.required(fields.shipment_date.caption) : null, ew.Validators.datetime(fields.shipment_date.clientFormatPattern)], fields.shipment_date.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["booking_by",false],["company_id",false],["supplier",false],["ref",false],["status",false],["s_grp",false],["product",false],["rid",false],["quantity",false],["b_quantity",false],["confirm_quantity",false],["booking_rate",false],["currency_current_rate",false],["booking_date",false],["shipment_date",false],["remarks",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
            "supplier": <?= $Grid->supplier->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "rid": <?= $Grid->rid->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fbookinggrid" class="ew-form ew-list-form">
<div id="gmp_booking" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_bookinggrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_booking_id" class="booking_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_by->Visible) { // booking_by ?>
        <th data-name="booking_by" class="<?= $Grid->booking_by->headerCellClass() ?>"><div id="elh_booking_booking_by" class="booking_booking_by"><?= $Grid->renderFieldHeader($Grid->booking_by) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_booking_company_id" class="booking_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php if ($Grid->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Grid->supplier->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_booking_supplier" class="booking_supplier"><?= $Grid->renderFieldHeader($Grid->supplier) ?></div></th>
<?php } ?>
<?php if ($Grid->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Grid->ref->headerCellClass() ?>"><div id="elh_booking_ref" class="booking_ref"><?= $Grid->renderFieldHeader($Grid->ref) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_booking_status" class="booking_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>"><div id="elh_booking_s_grp" class="booking_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_booking_product" class="booking_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>"><div id="elh_booking_rid" class="booking_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Grid->quantity->headerCellClass() ?>"><div id="elh_booking_quantity" class="booking_quantity"><?= $Grid->renderFieldHeader($Grid->quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->b_quantity->Visible) { // b_quantity ?>
        <th data-name="b_quantity" class="<?= $Grid->b_quantity->headerCellClass() ?>"><div id="elh_booking_b_quantity" class="booking_b_quantity"><?= $Grid->renderFieldHeader($Grid->b_quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->confirm_quantity->Visible) { // confirm_quantity ?>
        <th data-name="confirm_quantity" class="<?= $Grid->confirm_quantity->headerCellClass() ?>"><div id="elh_booking_confirm_quantity" class="booking_confirm_quantity"><?= $Grid->renderFieldHeader($Grid->confirm_quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_rate->Visible) { // booking_rate ?>
        <th data-name="booking_rate" class="<?= $Grid->booking_rate->headerCellClass() ?>"><div id="elh_booking_booking_rate" class="booking_booking_rate"><?= $Grid->renderFieldHeader($Grid->booking_rate) ?></div></th>
<?php } ?>
<?php if ($Grid->currency_current_rate->Visible) { // currency_current_rate ?>
        <th data-name="currency_current_rate" class="<?= $Grid->currency_current_rate->headerCellClass() ?>"><div id="elh_booking_currency_current_rate" class="booking_currency_current_rate"><?= $Grid->renderFieldHeader($Grid->currency_current_rate) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_date->Visible) { // booking_date ?>
        <th data-name="booking_date" class="<?= $Grid->booking_date->headerCellClass() ?>"><div id="elh_booking_booking_date" class="booking_booking_date"><?= $Grid->renderFieldHeader($Grid->booking_date) ?></div></th>
<?php } ?>
<?php if ($Grid->shipment_date->Visible) { // shipment_date ?>
        <th data-name="shipment_date" class="<?= $Grid->shipment_date->headerCellClass() ?>"><div id="elh_booking_shipment_date" class="booking_shipment_date"><?= $Grid->renderFieldHeader($Grid->shipment_date) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_booking_remarks" class="booking_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_booking_operator" class="booking_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_booking_datetime" class="booking_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_id" class="el_booking_id"></span>
<input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_id" class="el_booking_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->id->EditValue) && $Grid->id->linkAttributes() != "") { ?>
<a<?= $Grid->id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>">
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_id" class="el_booking_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->id->getViewValue()) && $Grid->id->linkAttributes() != "") { ?>
<a<?= $Grid->id->linkAttributes() ?>><?= $Grid->id->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_id" id="fbookinggrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_id" id="fbookinggrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->booking_by->Visible) { // booking_by ?>
        <td data-name="booking_by"<?= $Grid->booking_by->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_by" class="el_booking_booking_by">
<input type="<?= $Grid->booking_by->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_by" id="x<?= $Grid->RowIndex ?>_booking_by" data-table="booking" data-field="x_booking_by" value="<?= $Grid->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_by->formatPattern()) ?>"<?= $Grid->booking_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_by->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_booking_by" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_by" id="o<?= $Grid->RowIndex ?>_booking_by" value="<?= HtmlEncode($Grid->booking_by->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_by" class="el_booking_booking_by">
<input type="<?= $Grid->booking_by->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_by" id="x<?= $Grid->RowIndex ?>_booking_by" data-table="booking" data-field="x_booking_by" value="<?= $Grid->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_by->formatPattern()) ?>"<?= $Grid->booking_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_by->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_by" class="el_booking_booking_by">
<span<?= $Grid->booking_by->viewAttributes() ?>>
<?= $Grid->booking_by->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_booking_by" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_by" id="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_by" value="<?= HtmlEncode($Grid->booking_by->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_booking_by" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_by" id="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_by" value="<?= HtmlEncode($Grid->booking_by->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_company_id" class="el_booking_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="booking"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_company_id" class="el_booking_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="booking"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_company_id" class="el_booking_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_company_id" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_company_id" id="fbookinggrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_company_id" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_company_id" id="fbookinggrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Grid->supplier->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_supplier" class="el_booking_supplier">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_supplier"
        name="x<?= $Grid->RowIndex ?>_supplier"
        class="form-select ew-select<?= $Grid->supplier->isInvalidClass() ?>"
        <?php if (!$Grid->supplier->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_supplier"
        <?php } ?>
        data-table="booking"
        data-field="x_supplier"
        data-value-separator="<?= $Grid->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->supplier->getPlaceHolder()) ?>"
        <?= $Grid->supplier->editAttributes() ?>>
        <?= $Grid->supplier->selectOptionListHtml("x{$Grid->RowIndex}_supplier") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_partner_view") && !$Grid->supplier->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_supplier" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->supplier->caption() ?>" data-title="<?= $Grid->supplier->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_supplier" data-url="<?= GetUrl("productionpartnerview2addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->supplier->getErrorMessage() ?></div>
<?= $Grid->supplier->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_supplier") ?>
<?php if (!$Grid->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_supplier", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_supplier" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_supplier" id="o<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_supplier" class="el_booking_supplier">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_supplier"
        name="x<?= $Grid->RowIndex ?>_supplier"
        class="form-select ew-select<?= $Grid->supplier->isInvalidClass() ?>"
        <?php if (!$Grid->supplier->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_supplier"
        <?php } ?>
        data-table="booking"
        data-field="x_supplier"
        data-value-separator="<?= $Grid->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->supplier->getPlaceHolder()) ?>"
        <?= $Grid->supplier->editAttributes() ?>>
        <?= $Grid->supplier->selectOptionListHtml("x{$Grid->RowIndex}_supplier") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_partner_view") && !$Grid->supplier->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_supplier" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->supplier->caption() ?>" data-title="<?= $Grid->supplier->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_supplier" data-url="<?= GetUrl("productionpartnerview2addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->supplier->getErrorMessage() ?></div>
<?= $Grid->supplier->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_supplier") ?>
<?php if (!$Grid->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_supplier", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_supplier" class="el_booking_supplier">
<span<?= $Grid->supplier->viewAttributes() ?>>
<?= $Grid->supplier->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_supplier" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_supplier" id="fbookinggrid$x<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_supplier" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_supplier" id="fbookinggrid$o<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Grid->ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref" class="el_booking_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="booking" data-field="x_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ref" id="o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref" class="el_booking_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref" class="el_booking_ref">
<span<?= $Grid->ref->viewAttributes() ?>>
<?= $Grid->ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_ref" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_ref" id="fbookinggrid$x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_ref" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_ref" id="fbookinggrid$o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_status" class="el_booking_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="booking"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_status" class="el_booking_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="booking"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_status" class="el_booking_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_status" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_status" id="fbookinggrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_status" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_status" id="fbookinggrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_s_grp" class="el_booking_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="booking"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_s_grp" class="el_booking_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="booking"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_s_grp" class="el_booking_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?= $Grid->s_grp->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_s_grp" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_s_grp" id="fbookinggrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_s_grp" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_s_grp" id="fbookinggrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_product" class="el_booking_product">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="booking"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "product") && !$Grid->product->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_product" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->product->caption() ?>" data-title="<?= $Grid->product->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_product" data-url="<?= GetUrl("productaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_product" class="el_booking_product">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="booking"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "product") && !$Grid->product->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_product" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->product->caption() ?>" data-title="<?= $Grid->product->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_product" data-url="<?= GetUrl("productaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_product" class="el_booking_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_product" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_product" id="fbookinggrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_product" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_product" id="fbookinggrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_rid" class="el_booking_rid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="booking"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Grid->rid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_rid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->rid->caption() ?>" data-title="<?= $Grid->rid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_rid" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_rid" class="el_booking_rid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fbookinggrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="booking"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Grid->rid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_rid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->rid->caption() ?>" data-title="<?= $Grid->rid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_rid" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookinggrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fbookinggrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookinggrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fbookinggrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fbookinggrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_rid" class="el_booking_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?php if (!EmptyString($Grid->rid->getViewValue()) && $Grid->rid->linkAttributes() != "") { ?>
<a<?= $Grid->rid->linkAttributes() ?>><?= $Grid->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_rid" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_rid" id="fbookinggrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_rid" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_rid" id="fbookinggrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Grid->quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_quantity" class="el_booking_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="booking" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_quantity" id="o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_quantity" class="el_booking_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="booking" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_quantity" class="el_booking_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<?= $Grid->quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_quantity" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_quantity" id="fbookinggrid$x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_quantity" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_quantity" id="fbookinggrid$o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->b_quantity->Visible) { // b_quantity ?>
        <td data-name="b_quantity"<?= $Grid->b_quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_b_quantity" class="el_booking_b_quantity">
<input type="<?= $Grid->b_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_b_quantity" id="x<?= $Grid->RowIndex ?>_b_quantity" data-table="booking" data-field="x_b_quantity" value="<?= $Grid->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->b_quantity->formatPattern()) ?>"<?= $Grid->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->b_quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_b_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_b_quantity" id="o<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_b_quantity" class="el_booking_b_quantity">
<input type="<?= $Grid->b_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_b_quantity" id="x<?= $Grid->RowIndex ?>_b_quantity" data-table="booking" data-field="x_b_quantity" value="<?= $Grid->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->b_quantity->formatPattern()) ?>"<?= $Grid->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->b_quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_b_quantity" class="el_booking_b_quantity">
<span<?= $Grid->b_quantity->viewAttributes() ?>>
<?= $Grid->b_quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_b_quantity" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_b_quantity" id="fbookinggrid$x<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_b_quantity" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_b_quantity" id="fbookinggrid$o<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->confirm_quantity->Visible) { // confirm_quantity ?>
        <td data-name="confirm_quantity"<?= $Grid->confirm_quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_quantity" class="el_booking_confirm_quantity">
<input type="<?= $Grid->confirm_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_quantity" id="x<?= $Grid->RowIndex ?>_confirm_quantity" data-table="booking" data-field="x_confirm_quantity" value="<?= $Grid->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_quantity->formatPattern()) ?>"<?= $Grid->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_confirm_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_confirm_quantity" id="o<?= $Grid->RowIndex ?>_confirm_quantity" value="<?= HtmlEncode($Grid->confirm_quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_quantity" class="el_booking_confirm_quantity">
<input type="<?= $Grid->confirm_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_quantity" id="x<?= $Grid->RowIndex ?>_confirm_quantity" data-table="booking" data-field="x_confirm_quantity" value="<?= $Grid->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_quantity->formatPattern()) ?>"<?= $Grid->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_quantity" class="el_booking_confirm_quantity">
<span<?= $Grid->confirm_quantity->viewAttributes() ?>>
<?= $Grid->confirm_quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_confirm_quantity" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_confirm_quantity" id="fbookinggrid$x<?= $Grid->RowIndex ?>_confirm_quantity" value="<?= HtmlEncode($Grid->confirm_quantity->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_confirm_quantity" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_confirm_quantity" id="fbookinggrid$o<?= $Grid->RowIndex ?>_confirm_quantity" value="<?= HtmlEncode($Grid->confirm_quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->booking_rate->Visible) { // booking_rate ?>
        <td data-name="booking_rate"<?= $Grid->booking_rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_rate" class="el_booking_booking_rate">
<input type="<?= $Grid->booking_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_rate" id="x<?= $Grid->RowIndex ?>_booking_rate" data-table="booking" data-field="x_booking_rate" value="<?= $Grid->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_rate->formatPattern()) ?>"<?= $Grid->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_booking_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_rate" id="o<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_rate" class="el_booking_booking_rate">
<input type="<?= $Grid->booking_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_rate" id="x<?= $Grid->RowIndex ?>_booking_rate" data-table="booking" data-field="x_booking_rate" value="<?= $Grid->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_rate->formatPattern()) ?>"<?= $Grid->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_rate" class="el_booking_booking_rate">
<span<?= $Grid->booking_rate->viewAttributes() ?>>
<?= $Grid->booking_rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_booking_rate" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_rate" id="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_booking_rate" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_rate" id="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency_current_rate->Visible) { // currency_current_rate ?>
        <td data-name="currency_current_rate"<?= $Grid->currency_current_rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_currency_current_rate" class="el_booking_currency_current_rate">
<input type="<?= $Grid->currency_current_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_currency_current_rate" id="x<?= $Grid->RowIndex ?>_currency_current_rate" data-table="booking" data-field="x_currency_current_rate" value="<?= $Grid->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency_current_rate->formatPattern()) ?>"<?= $Grid->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->currency_current_rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_currency_current_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency_current_rate" id="o<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_currency_current_rate" class="el_booking_currency_current_rate">
<input type="<?= $Grid->currency_current_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_currency_current_rate" id="x<?= $Grid->RowIndex ?>_currency_current_rate" data-table="booking" data-field="x_currency_current_rate" value="<?= $Grid->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency_current_rate->formatPattern()) ?>"<?= $Grid->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->currency_current_rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_currency_current_rate" class="el_booking_currency_current_rate">
<span<?= $Grid->currency_current_rate->viewAttributes() ?>>
<?= $Grid->currency_current_rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_currency_current_rate" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_currency_current_rate" id="fbookinggrid$x<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_currency_current_rate" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_currency_current_rate" id="fbookinggrid$o<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->booking_date->Visible) { // booking_date ?>
        <td data-name="booking_date"<?= $Grid->booking_date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_date" class="el_booking_booking_date">
<input type="<?= $Grid->booking_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_date" id="x<?= $Grid->RowIndex ?>_booking_date" data-table="booking" data-field="x_booking_date" value="<?= $Grid->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_date->formatPattern()) ?>"<?= $Grid->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_date->getErrorMessage() ?></div>
<?php if (!$Grid->booking_date->ReadOnly && !$Grid->booking_date->Disabled && !isset($Grid->booking_date->EditAttrs["readonly"]) && !isset($Grid->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookinggrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookinggrid", "x<?= $Grid->RowIndex ?>_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_booking_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_date" id="o<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_date" class="el_booking_booking_date">
<input type="<?= $Grid->booking_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_date" id="x<?= $Grid->RowIndex ?>_booking_date" data-table="booking" data-field="x_booking_date" value="<?= $Grid->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_date->formatPattern()) ?>"<?= $Grid->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_date->getErrorMessage() ?></div>
<?php if (!$Grid->booking_date->ReadOnly && !$Grid->booking_date->Disabled && !isset($Grid->booking_date->EditAttrs["readonly"]) && !isset($Grid->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookinggrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookinggrid", "x<?= $Grid->RowIndex ?>_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_booking_date" class="el_booking_booking_date">
<span<?= $Grid->booking_date->viewAttributes() ?>>
<?= $Grid->booking_date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_booking_date" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_date" id="fbookinggrid$x<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_booking_date" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_date" id="fbookinggrid$o<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->shipment_date->Visible) { // shipment_date ?>
        <td data-name="shipment_date"<?= $Grid->shipment_date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_shipment_date" class="el_booking_shipment_date">
<input type="<?= $Grid->shipment_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_shipment_date" id="x<?= $Grid->RowIndex ?>_shipment_date" data-table="booking" data-field="x_shipment_date" value="<?= $Grid->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->shipment_date->formatPattern()) ?>"<?= $Grid->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->shipment_date->getErrorMessage() ?></div>
<?php if (!$Grid->shipment_date->ReadOnly && !$Grid->shipment_date->Disabled && !isset($Grid->shipment_date->EditAttrs["readonly"]) && !isset($Grid->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookinggrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookinggrid", "x<?= $Grid->RowIndex ?>_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_shipment_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_shipment_date" id="o<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_shipment_date" class="el_booking_shipment_date">
<input type="<?= $Grid->shipment_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_shipment_date" id="x<?= $Grid->RowIndex ?>_shipment_date" data-table="booking" data-field="x_shipment_date" value="<?= $Grid->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->shipment_date->formatPattern()) ?>"<?= $Grid->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->shipment_date->getErrorMessage() ?></div>
<?php if (!$Grid->shipment_date->ReadOnly && !$Grid->shipment_date->Disabled && !isset($Grid->shipment_date->EditAttrs["readonly"]) && !isset($Grid->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookinggrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookinggrid", "x<?= $Grid->RowIndex ?>_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_shipment_date" class="el_booking_shipment_date">
<span<?= $Grid->shipment_date->viewAttributes() ?>>
<?= $Grid->shipment_date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_shipment_date" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_shipment_date" id="fbookinggrid$x<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_shipment_date" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_shipment_date" id="fbookinggrid$o<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_remarks" class="el_booking_remarks">
<textarea data-table="booking" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_remarks" class="el_booking_remarks">
<textarea data-table="booking" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_remarks" class="el_booking_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_remarks" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_remarks" id="fbookinggrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_remarks" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_remarks" id="fbookinggrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_operator" class="el_booking_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_operator" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_operator" id="fbookinggrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_operator" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_operator" id="fbookinggrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_datetime" class="el_booking_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking" data-field="x_datetime" data-hidden="1" name="fbookinggrid$x<?= $Grid->RowIndex ?>_datetime" id="fbookinggrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="booking" data-field="x_datetime" data-hidden="1" data-old name="fbookinggrid$o<?= $Grid->RowIndex ?>_datetime" id="fbookinggrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fbookinggrid","load"], () => fbookinggrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fbookinggrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
