<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fbookingedit" id="fbookingedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fbookingedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbookingedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["booking_by", [fields.booking_by.visible && fields.booking_by.required ? ew.Validators.required(fields.booking_by.caption) : null, ew.Validators.integer], fields.booking_by.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["agent", [fields.agent.visible && fields.agent.required ? ew.Validators.required(fields.agent.caption) : null], fields.agent.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["containers", [fields.containers.visible && fields.containers.required ? ew.Validators.required(fields.containers.caption) : null, ew.Validators.float], fields.containers.isInvalid],
            ["booking_rate", [fields.booking_rate.visible && fields.booking_rate.required ? ew.Validators.required(fields.booking_rate.caption) : null, ew.Validators.float], fields.booking_rate.isInvalid],
            ["booking_currency", [fields.booking_currency.visible && fields.booking_currency.required ? ew.Validators.required(fields.booking_currency.caption) : null], fields.booking_currency.isInvalid],
            ["currency_current_rate", [fields.currency_current_rate.visible && fields.currency_current_rate.required ? ew.Validators.required(fields.currency_current_rate.caption) : null, ew.Validators.float], fields.currency_current_rate.isInvalid],
            ["booking_date", [fields.booking_date.visible && fields.booking_date.required ? ew.Validators.required(fields.booking_date.caption) : null, ew.Validators.datetime(fields.booking_date.clientFormatPattern)], fields.booking_date.isInvalid],
            ["shipment_date", [fields.shipment_date.visible && fields.shipment_date.required ? ew.Validators.required(fields.shipment_date.caption) : null, ew.Validators.datetime(fields.shipment_date.clientFormatPattern)], fields.shipment_date.isInvalid],
            ["our_port", [fields.our_port.visible && fields.our_port.required ? ew.Validators.required(fields.our_port.caption) : null], fields.our_port.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "booking_currency": <?= $Page->booking_currency->toClientList($Page) ?>,
            "our_port": <?= $Page->our_port->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "booking_details") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="booking_details">
<input type="hidden" name="fk_ref" value="<?= HtmlEncode($Page->ref->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_booking_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_booking_id">
<span<?= $Page->id->viewAttributes() ?>>
<?php if (!EmptyString($Page->id->EditValue) && $Page->id->linkAttributes() != "") { ?>
<a<?= $Page->id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>">
<?php } ?>
</span>
<input type="hidden" data-table="booking" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_by->Visible) { // booking_by ?>
    <div id="r_booking_by"<?= $Page->booking_by->rowAttributes() ?>>
        <label id="elh_booking_booking_by" for="x_booking_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_by->caption() ?><?= $Page->booking_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_by->cellAttributes() ?>>
<span id="el_booking_booking_by">
<input type="<?= $Page->booking_by->getInputTextType() ?>" name="x_booking_by" id="x_booking_by" data-table="booking" data-field="x_booking_by" value="<?= $Page->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_by->formatPattern()) ?>"<?= $Page->booking_by->editAttributes() ?> aria-describedby="x_booking_by_help">
<?= $Page->booking_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->booking_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_booking_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_booking_company_id">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_company_id"
        <?php } ?>
        data-table="booking"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?= $Page->company_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_company_id", selectId: "fbookingedit_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_company_id", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier"<?= $Page->supplier->rowAttributes() ?>>
        <label id="elh_booking_supplier" for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><?= $Page->supplier->caption() ?><?= $Page->supplier->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->supplier->cellAttributes() ?>>
<span id="el_booking_supplier">
<div class="input-group flex-nowrap">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_supplier"
        <?php } ?>
        data-table="booking"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_partner_view") && !$Page->supplier->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_supplier" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->supplier->caption() ?>" data-title="<?= $Page->supplier->caption() ?>" data-ew-action="add-option" data-el="x_supplier" data-url="<?= GetUrl("productionpartnerview2addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->supplier->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->supplier->getErrorMessage() ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_supplier", selectId: "fbookingedit_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <label id="elh_booking_ref" for="x_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ref->caption() ?><?= $Page->ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ref->cellAttributes() ?>>
<?php if ($Page->ref->getSessionValue() != "") { ?>
<span<?= $Page->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->ref->getDisplayValue($Page->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x_ref" name="x_ref" value="<?= HtmlEncode($Page->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_booking_ref">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?> aria-describedby="x_ref_help">
<?= $Page->ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_booking_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_booking_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_status"
        <?php } ?>
        data-table="booking"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_status", selectId: "fbookingedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_status", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_booking_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_booking_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_grp"
        <?php } ?>
        data-table="booking"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_grp", selectId: "fbookingedit_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_grp", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_booking_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_booking_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_s_grp"
        <?php } ?>
        data-table="booking"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_s_grp", selectId: "fbookingedit_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_booking_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_booking_product">
<div class="input-group flex-nowrap">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_product"
        <?php } ?>
        data-table="booking"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "product") && !$Page->product->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->product->caption() ?>" data-title="<?= $Page->product->caption() ?>" data-ew-action="add-option" data-el="x_product" data-url="<?= GetUrl("productaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_product", selectId: "fbookingedit_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_product", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_booking_rid" for="x_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_booking_rid">
<div class="input-group flex-nowrap">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_rid"
        <?php } ?>
        data-table="booking"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Page->rid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_rid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->rid->caption() ?>" data-title="<?= $Page->rid->caption() ?>" data-ew-action="add-option" data-el="x_rid" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_rid", selectId: "fbookingedit_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_rid", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent"<?= $Page->agent->rowAttributes() ?>>
        <label id="elh_booking_agent" for="x_agent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agent->caption() ?><?= $Page->agent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agent->cellAttributes() ?>>
<span id="el_booking_agent">
<div class="input-group flex-nowrap">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_agent"
        <?php } ?>
        data-table="booking"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "agent") && !$Page->agent->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_agent" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->agent->caption() ?>" data-title="<?= $Page->agent->caption() ?>" data-ew-action="add-option" data-el="x_agent" data-url="<?= GetUrl("agentaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->agent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_agent", selectId: "fbookingedit_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_agent", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_booking_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_booking_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="booking" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
    <div id="r_containers"<?= $Page->containers->rowAttributes() ?>>
        <label id="elh_booking_containers" for="x_containers" class="<?= $Page->LeftColumnClass ?>"><?= $Page->containers->caption() ?><?= $Page->containers->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->containers->cellAttributes() ?>>
<span id="el_booking_containers">
<input type="<?= $Page->containers->getInputTextType() ?>" name="x_containers" id="x_containers" data-table="booking" data-field="x_containers" value="<?= $Page->containers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->containers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containers->formatPattern()) ?>"<?= $Page->containers->editAttributes() ?> aria-describedby="x_containers_help">
<?= $Page->containers->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->containers->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_rate->Visible) { // booking_rate ?>
    <div id="r_booking_rate"<?= $Page->booking_rate->rowAttributes() ?>>
        <label id="elh_booking_booking_rate" for="x_booking_rate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_rate->caption() ?><?= $Page->booking_rate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_rate->cellAttributes() ?>>
<span id="el_booking_booking_rate">
<input type="<?= $Page->booking_rate->getInputTextType() ?>" name="x_booking_rate" id="x_booking_rate" data-table="booking" data-field="x_booking_rate" value="<?= $Page->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_rate->formatPattern()) ?>"<?= $Page->booking_rate->editAttributes() ?> aria-describedby="x_booking_rate_help">
<?= $Page->booking_rate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->booking_rate->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_currency->Visible) { // booking_currency ?>
    <div id="r_booking_currency"<?= $Page->booking_currency->rowAttributes() ?>>
        <label id="elh_booking_booking_currency" for="x_booking_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_currency->caption() ?><?= $Page->booking_currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_currency->cellAttributes() ?>>
<span id="el_booking_booking_currency">
<div class="input-group flex-nowrap">
    <select
        id="x_booking_currency"
        name="x_booking_currency"
        class="form-select ew-select<?= $Page->booking_currency->isInvalidClass() ?>"
        <?php if (!$Page->booking_currency->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_booking_currency"
        <?php } ?>
        data-table="booking"
        data-field="x_booking_currency"
        data-value-separator="<?= $Page->booking_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_currency->getPlaceHolder()) ?>"
        <?= $Page->booking_currency->editAttributes() ?>>
        <?= $Page->booking_currency->selectOptionListHtml("x_booking_currency") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "currency") && !$Page->booking_currency->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_booking_currency" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->booking_currency->caption() ?>" data-title="<?= $Page->booking_currency->caption() ?>" data-ew-action="add-option" data-el="x_booking_currency" data-url="<?= GetUrl("currencyaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->booking_currency->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->booking_currency->getErrorMessage() ?></div>
<?= $Page->booking_currency->Lookup->getParamTag($Page, "p_x_booking_currency") ?>
<?php if (!$Page->booking_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_booking_currency", selectId: "fbookingedit_x_booking_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.booking_currency?.lookupOptions.length) {
        options.data = { id: "x_booking_currency", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_booking_currency", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.booking_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
    <div id="r_currency_current_rate"<?= $Page->currency_current_rate->rowAttributes() ?>>
        <label id="elh_booking_currency_current_rate" for="x_currency_current_rate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency_current_rate->caption() ?><?= $Page->currency_current_rate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency_current_rate->cellAttributes() ?>>
<span id="el_booking_currency_current_rate">
<input type="<?= $Page->currency_current_rate->getInputTextType() ?>" name="x_currency_current_rate" id="x_currency_current_rate" data-table="booking" data-field="x_currency_current_rate" value="<?= $Page->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_current_rate->formatPattern()) ?>"<?= $Page->currency_current_rate->editAttributes() ?> aria-describedby="x_currency_current_rate_help">
<?= $Page->currency_current_rate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency_current_rate->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_date->Visible) { // booking_date ?>
    <div id="r_booking_date"<?= $Page->booking_date->rowAttributes() ?>>
        <label id="elh_booking_booking_date" for="x_booking_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_date->caption() ?><?= $Page->booking_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_date->cellAttributes() ?>>
<span id="el_booking_booking_date">
<input type="<?= $Page->booking_date->getInputTextType() ?>" name="x_booking_date" id="x_booking_date" data-table="booking" data-field="x_booking_date" value="<?= $Page->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_date->formatPattern()) ?>"<?= $Page->booking_date->editAttributes() ?> aria-describedby="x_booking_date_help">
<?= $Page->booking_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->booking_date->getErrorMessage() ?></div>
<?php if (!$Page->booking_date->ReadOnly && !$Page->booking_date->Disabled && !isset($Page->booking_date->EditAttrs["readonly"]) && !isset($Page->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingedit", "x_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipment_date->Visible) { // shipment_date ?>
    <div id="r_shipment_date"<?= $Page->shipment_date->rowAttributes() ?>>
        <label id="elh_booking_shipment_date" for="x_shipment_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipment_date->caption() ?><?= $Page->shipment_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipment_date->cellAttributes() ?>>
<span id="el_booking_shipment_date">
<input type="<?= $Page->shipment_date->getInputTextType() ?>" name="x_shipment_date" id="x_shipment_date" data-table="booking" data-field="x_shipment_date" value="<?= $Page->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipment_date->formatPattern()) ?>"<?= $Page->shipment_date->editAttributes() ?> aria-describedby="x_shipment_date_help">
<?= $Page->shipment_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipment_date->getErrorMessage() ?></div>
<?php if (!$Page->shipment_date->ReadOnly && !$Page->shipment_date->Disabled && !isset($Page->shipment_date->EditAttrs["readonly"]) && !isset($Page->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingedit", "x_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->our_port->Visible) { // our_port ?>
    <div id="r_our_port"<?= $Page->our_port->rowAttributes() ?>>
        <label id="elh_booking_our_port" for="x_our_port" class="<?= $Page->LeftColumnClass ?>"><?= $Page->our_port->caption() ?><?= $Page->our_port->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->our_port->cellAttributes() ?>>
<span id="el_booking_our_port">
<div class="input-group flex-nowrap">
    <select
        id="x_our_port"
        name="x_our_port"
        class="form-select ew-select<?= $Page->our_port->isInvalidClass() ?>"
        <?php if (!$Page->our_port->IsNativeSelect) { ?>
        data-select2-id="fbookingedit_x_our_port"
        <?php } ?>
        data-table="booking"
        data-field="x_our_port"
        data-value-separator="<?= $Page->our_port->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->our_port->getPlaceHolder()) ?>"
        <?= $Page->our_port->editAttributes() ?>>
        <?= $Page->our_port->selectOptionListHtml("x_our_port") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "port") && !$Page->our_port->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_our_port" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->our_port->caption() ?>" data-title="<?= $Page->our_port->caption() ?>" data-ew-action="add-option" data-el="x_our_port" data-url="<?= GetUrl("portaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->our_port->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->our_port->getErrorMessage() ?></div>
<?= $Page->our_port->Lookup->getParamTag($Page, "p_x_our_port") ?>
<?php if (!$Page->our_port->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingedit", function() {
    var options = { name: "x_our_port", selectId: "fbookingedit_x_our_port" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingedit.lists.our_port?.lookupOptions.length) {
        options.data = { id: "x_our_port", form: "fbookingedit" };
    } else {
        options.ajax = { id: "x_our_port", form: "fbookingedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.our_port.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_booking_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_booking_remarks">
<textarea data-table="booking" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbookingedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbookingedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
