<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingDetailsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_details: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbooking_detailssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_detailssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["agent", [ew.Validators.integer], fields.agent.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["b_quantity", [ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_quantity", [ew.Validators.float], fields.confirm_quantity.isInvalid],
            ["port_eta", [], fields.port_eta.isInvalid],
            ["bl_no", [], fields.bl_no.isInvalid],
            ["booking_currency", [], fields.booking_currency.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["paid", [ew.Validators.float], fields.paid.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["booking_by", [ew.Validators.integer], fields.booking_by.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["t_url", [], fields.t_url.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "booking_currency": <?= $Page->booking_currency->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_detailssearch" id="fbooking_detailssearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_details">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking_details" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_details" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_agent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->agent->getInputTextType() ?>" name="x_agent" id="x_agent" data-table="booking_details" data-field="x_agent" value="<?= $Page->agent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->agent->formatPattern()) ?>"<?= $Page->agent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_quantity->Visible) { // b_quantity ?>
    <div id="r_b_quantity" class="row"<?= $Page->b_quantity->rowAttributes() ?>>
        <label for="x_b_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_b_quantity"><?= $Page->b_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_quantity" id="z_b_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_quantity->getInputTextType() ?>" name="x_b_quantity" id="x_b_quantity" data-table="booking_details" data-field="x_b_quantity" value="<?= $Page->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_quantity->formatPattern()) ?>"<?= $Page->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_quantity->Visible) { // confirm_quantity ?>
    <div id="r_confirm_quantity" class="row"<?= $Page->confirm_quantity->rowAttributes() ?>>
        <label for="x_confirm_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_confirm_quantity"><?= $Page->confirm_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_quantity" id="z_confirm_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_confirm_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_quantity->getInputTextType() ?>" name="x_confirm_quantity" id="x_confirm_quantity" data-table="booking_details" data-field="x_confirm_quantity" value="<?= $Page->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_quantity->formatPattern()) ?>"<?= $Page->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_eta->Visible) { // port_eta ?>
    <div id="r_port_eta" class="row"<?= $Page->port_eta->rowAttributes() ?>>
        <label for="x_port_eta" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_port_eta"><?= $Page->port_eta->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_eta" id="z_port_eta" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_eta->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_port_eta" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="x_port_eta" id="x_port_eta" data-table="booking_details" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bl_no->Visible) { // bl_no ?>
    <div id="r_bl_no" class="row"<?= $Page->bl_no->rowAttributes() ?>>
        <label for="x_bl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_bl_no"><?= $Page->bl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bl_no" id="z_bl_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_bl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bl_no->getInputTextType() ?>" name="x_bl_no" id="x_bl_no" data-table="booking_details" data-field="x_bl_no" value="<?= $Page->bl_no->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bl_no->formatPattern()) ?>"<?= $Page->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_currency->Visible) { // booking_currency ?>
    <div id="r_booking_currency" class="row"<?= $Page->booking_currency->rowAttributes() ?>>
        <label for="x_booking_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_booking_currency"><?= $Page->booking_currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_currency" id="z_booking_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_booking_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_currency"
        name="x_booking_currency"
        class="form-select ew-select<?= $Page->booking_currency->isInvalidClass() ?>"
        <?php if (!$Page->booking_currency->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_booking_currency"
        <?php } ?>
        data-table="booking_details"
        data-field="x_booking_currency"
        data-value-separator="<?= $Page->booking_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_currency->getPlaceHolder()) ?>"
        <?= $Page->booking_currency->editAttributes() ?>>
        <?= $Page->booking_currency->selectOptionListHtml("x_booking_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_currency->getErrorMessage(false) ?></div>
<?= $Page->booking_currency->Lookup->getParamTag($Page, "p_x_booking_currency") ?>
<?php if (!$Page->booking_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_booking_currency", selectId: "fbooking_detailssearch_x_booking_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.booking_currency?.lookupOptions.length) {
        options.data = { id: "x_booking_currency", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_booking_currency", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.booking_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_details" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->paid->Visible) { // paid ?>
    <div id="r_paid" class="row"<?= $Page->paid->rowAttributes() ?>>
        <label for="x_paid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_paid"><?= $Page->paid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_paid" id="z_paid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->paid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_paid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->paid->getInputTextType() ?>" name="x_paid" id="x_paid" data-table="booking_details" data-field="x_paid" value="<?= $Page->paid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->paid->formatPattern()) ?>"<?= $Page->paid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->paid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_balance"><?= $Page->balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance" id="z_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="booking_details" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="booking_details" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_status"
        <?php } ?>
        data-table="booking_details"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_status", selectId: "fbooking_detailssearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_by->Visible) { // booking_by ?>
    <div id="r_booking_by" class="row"<?= $Page->booking_by->rowAttributes() ?>>
        <label for="x_booking_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_booking_by"><?= $Page->booking_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_by" id="z_booking_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_booking_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->booking_by->getInputTextType() ?>" name="x_booking_by" id="x_booking_by" data-table="booking_details" data-field="x_booking_by" value="<?= $Page->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_by->formatPattern()) ?>"<?= $Page->booking_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_company_id"
        <?php } ?>
        data-table="booking_details"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_company_id", selectId: "fbooking_detailssearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_url->Visible) { // t_url ?>
    <div id="r_t_url" class="row"<?= $Page->t_url->rowAttributes() ?>>
        <label for="x_t_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_details_t_url"><?= $Page->t_url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_url" id="z_t_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_details_t_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_url->getInputTextType() ?>" name="x_t_url" id="x_t_url" data-table="booking_details" data-field="x_t_url" value="<?= $Page->t_url->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->t_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_url->formatPattern()) ?>"<?= $Page->t_url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbooking_detailssearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_detailssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbooking_detailssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
