<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingDetailsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_details: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbooking_detailssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_detailssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["agent", [ew.Validators.integer], fields.agent.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["b_quantity", [ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_quantity", [ew.Validators.float], fields.confirm_quantity.isInvalid],
            ["port_eta", [], fields.port_eta.isInvalid],
            ["bl_no", [], fields.bl_no.isInvalid],
            ["booking_currency", [], fields.booking_currency.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["paid", [ew.Validators.float], fields.paid.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["booking_by", [ew.Validators.integer], fields.booking_by.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["t_url", [], fields.t_url.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "booking_currency": <?= $Page->booking_currency->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_detailssearch" id="fbooking_detailssearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("bookingdetailslist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_details">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_booking_details_id" class="booking_detailssearch"><span id="el_booking_details_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking_details" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_ref" class="booking_detailssearch"><span id="el_booking_details_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_details" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_agent" class="booking_detailssearch"><span id="el_booking_details_agent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->agent->getInputTextType() ?>" name="x_agent" id="x_agent" data-table="booking_details" data-field="x_agent" value="<?= $Page->agent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->agent->formatPattern()) ?>"<?= $Page->agent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_supplier" class="booking_detailssearch"><span id="el_booking_details_supplier" class="ew-search-field ew-search-field-single">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_supplier"
        <?php } ?>
        data-table="booking_details"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_supplier", selectId: "fbooking_detailssearch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_details_b_quantity" class="booking_detailssearch"><span id="el_booking_details_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_quantity->getInputTextType() ?>" name="x_b_quantity" id="x_b_quantity" data-table="booking_details" data-field="x_b_quantity" value="<?= $Page->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_quantity->formatPattern()) ?>"<?= $Page->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_confirm_quantity" class="booking_detailssearch"><span id="el_booking_details_confirm_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_quantity->getInputTextType() ?>" name="x_confirm_quantity" id="x_confirm_quantity" data-table="booking_details" data-field="x_confirm_quantity" value="<?= $Page->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_quantity->formatPattern()) ?>"<?= $Page->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_port_eta" class="booking_detailssearch"><span id="el_booking_details_port_eta" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="x_port_eta" id="x_port_eta" data-table="booking_details" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_bl_no" class="booking_detailssearch"><span id="el_booking_details_bl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bl_no->getInputTextType() ?>" name="x_bl_no" id="x_bl_no" data-table="booking_details" data-field="x_bl_no" value="<?= $Page->bl_no->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bl_no->formatPattern()) ?>"<?= $Page->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bl_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_booking_currency" class="booking_detailssearch"><span id="el_booking_details_booking_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_currency"
        name="x_booking_currency"
        class="form-select ew-select<?= $Page->booking_currency->isInvalidClass() ?>"
        <?php if (!$Page->booking_currency->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_booking_currency"
        <?php } ?>
        data-table="booking_details"
        data-field="x_booking_currency"
        data-value-separator="<?= $Page->booking_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_currency->getPlaceHolder()) ?>"
        <?= $Page->booking_currency->editAttributes() ?>>
        <?= $Page->booking_currency->selectOptionListHtml("x_booking_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_currency->getErrorMessage(false) ?></div>
<?= $Page->booking_currency->Lookup->getParamTag($Page, "p_x_booking_currency") ?>
<?php if (!$Page->booking_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_booking_currency", selectId: "fbooking_detailssearch_x_booking_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.booking_currency?.lookupOptions.length) {
        options.data = { id: "x_booking_currency", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_booking_currency", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.booking_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_details_amount" class="booking_detailssearch"><span id="el_booking_details_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_details" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_paid" class="booking_detailssearch"><span id="el_booking_details_paid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->paid->getInputTextType() ?>" name="x_paid" id="x_paid" data-table="booking_details" data-field="x_paid" value="<?= $Page->paid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->paid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->paid->formatPattern()) ?>"<?= $Page->paid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->paid->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_balance" class="booking_detailssearch"><span id="el_booking_details_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="booking_details" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_remarks" class="booking_detailssearch"><span id="el_booking_details_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="booking_details" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_status" class="booking_detailssearch"><span id="el_booking_details_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_status"
        <?php } ?>
        data-table="booking_details"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_status", selectId: "fbooking_detailssearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_details_booking_by" class="booking_detailssearch"><span id="el_booking_details_booking_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->booking_by->getInputTextType() ?>" name="x_booking_by" id="x_booking_by" data-table="booking_details" data-field="x_booking_by" value="<?= $Page->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_by->formatPattern()) ?>"<?= $Page->booking_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_by->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_details_company_id" class="booking_detailssearch"><span id="el_booking_details_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fbooking_detailssearch_x_company_id"
        <?php } ?>
        data-table="booking_details"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_detailssearch", function() {
    var options = { name: "x_company_id", selectId: "fbooking_detailssearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_detailssearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fbooking_detailssearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fbooking_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_details.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_details_t_url" class="booking_detailssearch"><span id="el_booking_details_t_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_url->getInputTextType() ?>" name="x_t_url" id="x_t_url" data-table="booking_details" data-field="x_t_url" value="<?= $Page->t_url->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->t_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_url->formatPattern()) ?>"<?= $Page->t_url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_url->getErrorMessage(false) ?></div>
</span></template>
<div id="booking_details_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "string",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "ref",
                type: "string",
                label: currentTable.fields.ref.caption,
                operators: currentTable.fields.ref.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.ref.validators),
                data: {
                    format: currentTable.fields.ref.clientFormatPattern
                }
            },
            {
                id: "agent",
                type: "integer",
                label: currentTable.fields.agent.caption,
                operators: currentTable.fields.agent.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.agent.validators),
                data: {
                    format: currentTable.fields.agent.clientFormatPattern
                }
            },
            {
                id: "supplier",
                type: "integer",
                label: currentTable.fields.supplier.caption,
                operators: currentTable.fields.supplier.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.supplier.validators),
                data: {
                    format: currentTable.fields.supplier.clientFormatPattern
                }
            },
            {
                id: "b_quantity",
                type: "double",
                label: currentTable.fields.b_quantity.caption,
                operators: currentTable.fields.b_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.b_quantity.validators),
                data: {
                    format: currentTable.fields.b_quantity.clientFormatPattern
                }
            },
            {
                id: "confirm_quantity",
                type: "double",
                label: currentTable.fields.confirm_quantity.caption,
                operators: currentTable.fields.confirm_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.confirm_quantity.validators),
                data: {
                    format: currentTable.fields.confirm_quantity.clientFormatPattern
                }
            },
            {
                id: "port_eta",
                type: "string",
                label: currentTable.fields.port_eta.caption,
                operators: currentTable.fields.port_eta.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.port_eta.validators),
                data: {
                    format: currentTable.fields.port_eta.clientFormatPattern
                }
            },
            {
                id: "bl_no",
                type: "string",
                label: currentTable.fields.bl_no.caption,
                operators: currentTable.fields.bl_no.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.bl_no.validators),
                data: {
                    format: currentTable.fields.bl_no.clientFormatPattern
                }
            },
            {
                id: "booking_currency",
                type: "integer",
                label: currentTable.fields.booking_currency.caption,
                operators: currentTable.fields.booking_currency.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.booking_currency.validators),
                data: {
                    format: currentTable.fields.booking_currency.clientFormatPattern
                }
            },
            {
                id: "amount",
                type: "double",
                label: currentTable.fields.amount.caption,
                operators: currentTable.fields.amount.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.amount.validators),
                data: {
                    format: currentTable.fields.amount.clientFormatPattern
                }
            },
            {
                id: "paid",
                type: "double",
                label: currentTable.fields.paid.caption,
                operators: currentTable.fields.paid.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.paid.validators),
                data: {
                    format: currentTable.fields.paid.clientFormatPattern
                }
            },
            {
                id: "balance",
                type: "double",
                label: currentTable.fields.balance.caption,
                operators: currentTable.fields.balance.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.balance.validators),
                data: {
                    format: currentTable.fields.balance.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "booking_by",
                type: "integer",
                label: currentTable.fields.booking_by.caption,
                operators: currentTable.fields.booking_by.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.booking_by.validators),
                data: {
                    format: currentTable.fields.booking_by.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "integer",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "t_url",
                type: "string",
                label: currentTable.fields.t_url.caption,
                operators: currentTable.fields.t_url.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_detailssearch.fields.t_url.validators),
                data: {
                    format: currentTable.fields.t_url.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#booking_details_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbooking_detailssearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbooking_detailssearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbooking_detailssearch" formaction="<?= HtmlEncode(GetUrl("bookingdetailslist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_detailssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbooking_detailssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
