<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingConfirmSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbooking_confirmsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_confirmsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["confirm_type", [], fields.confirm_type.isInvalid],
            ["booking_ref", [], fields.booking_ref.isInvalid],
            ["approx_qty", [ew.Validators.float], fields.approx_qty.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["y_amount", [ew.Validators.between], false],
            ["currency", [ew.Validators.integer], fields.currency.isInvalid],
            ["date", [ew.Validators.datetime(fields.date.clientFormatPattern)], fields.date.isInvalid],
            ["reference", [], fields.reference.isInvalid],
            ["date_of_dispatch", [ew.Validators.datetime(fields.date_of_dispatch.clientFormatPattern)], fields.date_of_dispatch.isInvalid],
            ["port_eta", [ew.Validators.datetime(fields.port_eta.clientFormatPattern)], fields.port_eta.isInvalid],
            ["y_port_eta", [ew.Validators.between], false],
            ["bl_no", [], fields.bl_no.isInvalid],
            ["s_line", [], fields.s_line.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["ref", [], fields.ref.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "confirm_type": <?= $Page->confirm_type->toClientList($Page) ?>,
            "booking_ref": <?= $Page->booking_ref->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "s_line": <?= $Page->s_line->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_confirmsearch" id="fbooking_confirmsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_confirm">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking_confirm" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier" class="row"<?= $Page->supplier->rowAttributes() ?>>
        <label for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_supplier"><?= $Page->supplier->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->supplier->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_supplier" class="ew-search-field ew-search-field-single">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_supplier"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_supplier", selectId: "fbooking_confirmsearch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_type->Visible) { // confirm_type ?>
    <div id="r_confirm_type" class="row"<?= $Page->confirm_type->rowAttributes() ?>>
        <label for="x_confirm_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_confirm_type"><?= $Page->confirm_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_type" id="z_confirm_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_confirm_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_confirm_type"
        name="x_confirm_type"
        class="form-select ew-select<?= $Page->confirm_type->isInvalidClass() ?>"
        <?php if (!$Page->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Page->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->confirm_type->getPlaceHolder()) ?>"
        <?= $Page->confirm_type->editAttributes() ?>>
        <?= $Page->confirm_type->selectOptionListHtml("x_confirm_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->confirm_type->getErrorMessage(false) ?></div>
<?php if (!$Page->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_confirm_type", selectId: "fbooking_confirmsearch_x_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x_confirm_type", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_confirm_type", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_ref->Visible) { // booking_ref ?>
    <div id="r_booking_ref" class="row"<?= $Page->booking_ref->rowAttributes() ?>>
        <label for="x_booking_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_booking_ref"><?= $Page->booking_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_ref" id="z_booking_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_booking_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_ref"
        name="x_booking_ref"
        class="form-select ew-select<?= $Page->booking_ref->isInvalidClass() ?>"
        <?php if (!$Page->booking_ref->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_booking_ref"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_booking_ref"
        data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>"
        <?= $Page->booking_ref->editAttributes() ?>>
        <?= $Page->booking_ref->selectOptionListHtml("x_booking_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage(false) ?></div>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_x_booking_ref") ?>
<?php if (!$Page->booking_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_booking_ref", selectId: "fbooking_confirmsearch_x_booking_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.booking_ref?.lookupOptions.length) {
        options.data = { id: "x_booking_ref", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_booking_ref", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.booking_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->approx_qty->Visible) { // approx_qty ?>
    <div id="r_approx_qty" class="row"<?= $Page->approx_qty->rowAttributes() ?>>
        <label for="x_approx_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_approx_qty"><?= $Page->approx_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_approx_qty" id="z_approx_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->approx_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_approx_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->approx_qty->getInputTextType() ?>" name="x_approx_qty" id="x_approx_qty" data-table="booking_confirm" data-field="x_approx_qty" value="<?= $Page->approx_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->approx_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->approx_qty->formatPattern()) ?>"<?= $Page->approx_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->approx_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="booking_confirm" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_amount"><?= $Page->amount->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_amount" id="z_amount" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->amount->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->amount->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_confirm_amount" class="ew-search-field">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_confirm_amount" class="ew-search-field2 d-none">
<input type="<?= $Page->amount->getInputTextType() ?>" name="y_amount" id="y_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_currency" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->currency->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_currency" class="ew-auto-suggest">
    <input type="<?= $Page->currency->getInputTextType() ?>" class="form-control" name="sv_x_currency" id="sv_x_currency" value="<?= RemoveHtml($Page->currency->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency->formatPattern()) ?>"<?= $Page->currency->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_currency" data-input="sv_x_currency" data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>" name="x_currency" id="x_currency" value="<?= HtmlEncode($Page->currency->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    fbooking_confirmsearch.createAutoSuggest(Object.assign({"id":"x_currency","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->currency->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.currency.autoSuggestOptions));
});
</script>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->date->Visible) { // date ?>
    <div id="r_date" class="row"<?= $Page->date->rowAttributes() ?>>
        <label for="x_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_date"><?= $Page->date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_date" id="z_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date->getInputTextType() ?>" name="x_date" id="x_date" data-table="booking_confirm" data-field="x_date" value="<?= $Page->date->EditValue ?>" placeholder="<?= HtmlEncode($Page->date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date->formatPattern()) ?>"<?= $Page->date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date->getErrorMessage(false) ?></div>
<?php if (!$Page->date->ReadOnly && !$Page->date->Disabled && !isset($Page->date->EditAttrs["readonly"]) && !isset($Page->date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference" class="row"<?= $Page->reference->rowAttributes() ?>>
        <label for="x_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_reference"><?= $Page->reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reference" id="z_reference" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="booking_confirm" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="50" maxlength="250" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->date_of_dispatch->Visible) { // date_of_dispatch ?>
    <div id="r_date_of_dispatch" class="row"<?= $Page->date_of_dispatch->rowAttributes() ?>>
        <label for="x_date_of_dispatch" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_date_of_dispatch"><?= $Page->date_of_dispatch->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_date_of_dispatch" id="z_date_of_dispatch" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->date_of_dispatch->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_date_of_dispatch" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date_of_dispatch->getInputTextType() ?>" name="x_date_of_dispatch" id="x_date_of_dispatch" data-table="booking_confirm" data-field="x_date_of_dispatch" value="<?= $Page->date_of_dispatch->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_of_dispatch->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_of_dispatch->formatPattern()) ?>"<?= $Page->date_of_dispatch->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date_of_dispatch->getErrorMessage(false) ?></div>
<?php if (!$Page->date_of_dispatch->ReadOnly && !$Page->date_of_dispatch->Disabled && !isset($Page->date_of_dispatch->EditAttrs["readonly"]) && !isset($Page->date_of_dispatch->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_date_of_dispatch", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_eta->Visible) { // port_eta ?>
    <div id="r_port_eta" class="row"<?= $Page->port_eta->rowAttributes() ?>>
        <label for="x_port_eta" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_port_eta"><?= $Page->port_eta->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_eta->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_port_eta" id="z_port_eta" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->port_eta->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->port_eta->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_confirm_port_eta" class="ew-search-field">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="x_port_eta" id="x_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue ?>" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage(false) ?></div>
<?php if (!$Page->port_eta->ReadOnly && !$Page->port_eta->Disabled && !isset($Page->port_eta->EditAttrs["readonly"]) && !isset($Page->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_confirm_port_eta" class="ew-search-field2 d-none">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="y_port_eta" id="y_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage(false) ?></div>
<?php if (!$Page->port_eta->ReadOnly && !$Page->port_eta->Disabled && !isset($Page->port_eta->EditAttrs["readonly"]) && !isset($Page->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "y_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bl_no->Visible) { // bl_no ?>
    <div id="r_bl_no" class="row"<?= $Page->bl_no->rowAttributes() ?>>
        <label for="x_bl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_bl_no"><?= $Page->bl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bl_no" id="z_bl_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_bl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bl_no->getInputTextType() ?>" name="x_bl_no" id="x_bl_no" data-table="booking_confirm" data-field="x_bl_no" value="<?= $Page->bl_no->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bl_no->formatPattern()) ?>"<?= $Page->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_line->Visible) { // s_line ?>
    <div id="r_s_line" class="row"<?= $Page->s_line->rowAttributes() ?>>
        <label for="x_s_line" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_s_line"><?= $Page->s_line->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_line" id="z_s_line" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_line->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_s_line" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_line"
        name="x_s_line"
        class="form-select ew-select<?= $Page->s_line->isInvalidClass() ?>"
        <?php if (!$Page->s_line->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_s_line"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_s_line"
        data-value-separator="<?= $Page->s_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_line->getPlaceHolder()) ?>"
        <?= $Page->s_line->editAttributes() ?>>
        <?= $Page->s_line->selectOptionListHtml("x_s_line") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_line->getErrorMessage(false) ?></div>
<?= $Page->s_line->Lookup->getParamTag($Page, "p_x_s_line") ?>
<?php if (!$Page->s_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_s_line", selectId: "fbooking_confirmsearch_x_s_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.s_line?.lookupOptions.length) {
        options.data = { id: "x_s_line", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_s_line", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.s_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_company_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    fbooking_confirmsearch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_operator"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_operator", selectId: "fbooking_confirmsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_confirm_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="booking_confirm" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_confirm_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="booking_confirm" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_confirm" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbooking_confirmsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_confirmsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbooking_confirmsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_confirm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
