<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingConfirmSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbooking_confirmsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_confirmsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["confirm_type", [], fields.confirm_type.isInvalid],
            ["booking_ref", [], fields.booking_ref.isInvalid],
            ["approx_qty", [ew.Validators.float], fields.approx_qty.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["y_amount", [ew.Validators.between], false],
            ["currency", [ew.Validators.integer], fields.currency.isInvalid],
            ["date", [ew.Validators.datetime(fields.date.clientFormatPattern)], fields.date.isInvalid],
            ["reference", [], fields.reference.isInvalid],
            ["date_of_dispatch", [ew.Validators.datetime(fields.date_of_dispatch.clientFormatPattern)], fields.date_of_dispatch.isInvalid],
            ["port_eta", [ew.Validators.datetime(fields.port_eta.clientFormatPattern)], fields.port_eta.isInvalid],
            ["y_port_eta", [ew.Validators.between], false],
            ["bl_no", [], fields.bl_no.isInvalid],
            ["s_line", [], fields.s_line.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["ref", [], fields.ref.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "confirm_type": <?= $Page->confirm_type->toClientList($Page) ?>,
            "booking_ref": <?= $Page->booking_ref->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "s_line": <?= $Page->s_line->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_confirmsearch" id="fbooking_confirmsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("bookingconfirmlist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_confirm">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_booking_confirm_id" class="booking_confirmsearch"><span id="el_booking_confirm_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking_confirm" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_supplier" class="booking_confirmsearch"><span id="el_booking_confirm_supplier" class="ew-search-field ew-search-field-single">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_supplier"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_supplier", selectId: "fbooking_confirmsearch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_confirm_type" class="booking_confirmsearch"><span id="el_booking_confirm_confirm_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_confirm_type"
        name="x_confirm_type"
        class="form-select ew-select<?= $Page->confirm_type->isInvalidClass() ?>"
        <?php if (!$Page->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Page->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->confirm_type->getPlaceHolder()) ?>"
        <?= $Page->confirm_type->editAttributes() ?>>
        <?= $Page->confirm_type->selectOptionListHtml("x_confirm_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->confirm_type->getErrorMessage(false) ?></div>
<?php if (!$Page->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_confirm_type", selectId: "fbooking_confirmsearch_x_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x_confirm_type", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_confirm_type", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_booking_ref" class="booking_confirmsearch"><span id="el_booking_confirm_booking_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_ref"
        name="x_booking_ref"
        class="form-select ew-select<?= $Page->booking_ref->isInvalidClass() ?>"
        <?php if (!$Page->booking_ref->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_booking_ref"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_booking_ref"
        data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>"
        <?= $Page->booking_ref->editAttributes() ?>>
        <?= $Page->booking_ref->selectOptionListHtml("x_booking_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage(false) ?></div>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_x_booking_ref") ?>
<?php if (!$Page->booking_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_booking_ref", selectId: "fbooking_confirmsearch_x_booking_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.booking_ref?.lookupOptions.length) {
        options.data = { id: "x_booking_ref", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_booking_ref", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.booking_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_approx_qty" class="booking_confirmsearch"><span id="el_booking_confirm_approx_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->approx_qty->getInputTextType() ?>" name="x_approx_qty" id="x_approx_qty" data-table="booking_confirm" data-field="x_approx_qty" value="<?= $Page->approx_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->approx_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->approx_qty->formatPattern()) ?>"<?= $Page->approx_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->approx_qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_packets" class="booking_confirmsearch"><span id="el_booking_confirm_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="booking_confirm" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_amount" class="booking_confirmsearch"><span id="el_booking_confirm_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_currency" class="booking_confirmsearch"><span id="el_booking_confirm_currency" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->currency->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_currency" class="ew-auto-suggest">
    <input type="<?= $Page->currency->getInputTextType() ?>" class="form-control" name="sv_x_currency" id="sv_x_currency" value="<?= RemoveHtml($Page->currency->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency->formatPattern()) ?>"<?= $Page->currency->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_currency" data-input="sv_x_currency" data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>" name="x_currency" id="x_currency" value="<?= HtmlEncode($Page->currency->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    fbooking_confirmsearch.createAutoSuggest(Object.assign({"id":"x_currency","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->currency->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.currency.autoSuggestOptions));
});
</script>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
</span></template>
<template id="tpx_booking_confirm_date" class="booking_confirmsearch"><span id="el_booking_confirm_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date->getInputTextType() ?>" name="x_date" id="x_date" data-table="booking_confirm" data-field="x_date" value="<?= $Page->date->EditValue ?>" placeholder="<?= HtmlEncode($Page->date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date->formatPattern()) ?>"<?= $Page->date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date->getErrorMessage(false) ?></div>
<?php if (!$Page->date->ReadOnly && !$Page->date->Disabled && !isset($Page->date->EditAttrs["readonly"]) && !isset($Page->date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_reference" class="booking_confirmsearch"><span id="el_booking_confirm_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="booking_confirm" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="50" maxlength="250" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_date_of_dispatch" class="booking_confirmsearch"><span id="el_booking_confirm_date_of_dispatch" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date_of_dispatch->getInputTextType() ?>" name="x_date_of_dispatch" id="x_date_of_dispatch" data-table="booking_confirm" data-field="x_date_of_dispatch" value="<?= $Page->date_of_dispatch->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_of_dispatch->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_of_dispatch->formatPattern()) ?>"<?= $Page->date_of_dispatch->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date_of_dispatch->getErrorMessage(false) ?></div>
<?php if (!$Page->date_of_dispatch->ReadOnly && !$Page->date_of_dispatch->Disabled && !isset($Page->date_of_dispatch->EditAttrs["readonly"]) && !isset($Page->date_of_dispatch->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_date_of_dispatch", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_port_eta" class="booking_confirmsearch"><span id="el_booking_confirm_port_eta" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="x_port_eta" id="x_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue ?>" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage(false) ?></div>
<?php if (!$Page->port_eta->ReadOnly && !$Page->port_eta->Disabled && !isset($Page->port_eta->EditAttrs["readonly"]) && !isset($Page->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmsearch", "x_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_bl_no" class="booking_confirmsearch"><span id="el_booking_confirm_bl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bl_no->getInputTextType() ?>" name="x_bl_no" id="x_bl_no" data-table="booking_confirm" data-field="x_bl_no" value="<?= $Page->bl_no->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bl_no->formatPattern()) ?>"<?= $Page->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bl_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_s_line" class="booking_confirmsearch"><span id="el_booking_confirm_s_line" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_line"
        name="x_s_line"
        class="form-select ew-select<?= $Page->s_line->isInvalidClass() ?>"
        <?php if (!$Page->s_line->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_s_line"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_s_line"
        data-value-separator="<?= $Page->s_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_line->getPlaceHolder()) ?>"
        <?= $Page->s_line->editAttributes() ?>>
        <?= $Page->s_line->selectOptionListHtml("x_s_line") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_line->getErrorMessage(false) ?></div>
<?= $Page->s_line->Lookup->getParamTag($Page, "p_x_s_line") ?>
<?php if (!$Page->s_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_s_line", selectId: "fbooking_confirmsearch_x_s_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.s_line?.lookupOptions.length) {
        options.data = { id: "x_s_line", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_s_line", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.s_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_company_id" class="booking_confirmsearch"><span id="el_booking_confirm_company_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    fbooking_confirmsearch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span></template>
<template id="tpx_booking_confirm_operator" class="booking_confirmsearch"><span id="el_booking_confirm_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsearch_x_operator"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsearch", function() {
    var options = { name: "x_operator", selectId: "fbooking_confirmsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbooking_confirmsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbooking_confirmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_booking_confirm_datetime" class="booking_confirmsearch"><span id="el_booking_confirm_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="booking_confirm" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_booking_confirm_ref" class="booking_confirmsearch"><span id="el_booking_confirm_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_confirm" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span></template>
<div id="booking_confirm_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "supplier",
                type: "integer",
                label: currentTable.fields.supplier.caption,
                operators: currentTable.fields.supplier.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.supplier.validators),
                data: {
                    format: currentTable.fields.supplier.clientFormatPattern
                }
            },
            {
                id: "confirm_type",
                type: "string",
                label: currentTable.fields.confirm_type.caption,
                operators: currentTable.fields.confirm_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.confirm_type.validators),
                data: {
                    format: currentTable.fields.confirm_type.clientFormatPattern
                }
            },
            {
                id: "booking_ref",
                type: "integer",
                label: currentTable.fields.booking_ref.caption,
                operators: currentTable.fields.booking_ref.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.booking_ref.validators),
                data: {
                    format: currentTable.fields.booking_ref.clientFormatPattern
                }
            },
            {
                id: "approx_qty",
                type: "double",
                label: currentTable.fields.approx_qty.caption,
                operators: currentTable.fields.approx_qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.approx_qty.validators),
                data: {
                    format: currentTable.fields.approx_qty.clientFormatPattern
                }
            },
            {
                id: "packets",
                type: "integer",
                label: currentTable.fields.packets.caption,
                operators: currentTable.fields.packets.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.packets.validators),
                data: {
                    format: currentTable.fields.packets.clientFormatPattern
                }
            },
            {
                id: "amount",
                type: "double",
                label: currentTable.fields.amount.caption,
                operators: currentTable.fields.amount.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.amount.validators),
                data: {
                    format: currentTable.fields.amount.clientFormatPattern
                }
            },
            {
                id: "currency",
                type: "integer",
                label: currentTable.fields.currency.caption,
                operators: currentTable.fields.currency.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.currency.validators),
                data: {
                    format: currentTable.fields.currency.clientFormatPattern
                }
            },
            {
                id: "date",
                type: "datetime",
                label: currentTable.fields.date.caption,
                operators: currentTable.fields.date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.date.validators),
                data: {
                    format: currentTable.fields.date.clientFormatPattern
                }
            },
            {
                id: "reference",
                type: "string",
                label: currentTable.fields.reference.caption,
                operators: currentTable.fields.reference.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.reference.validators),
                data: {
                    format: currentTable.fields.reference.clientFormatPattern
                }
            },
            {
                id: "date_of_dispatch",
                type: "datetime",
                label: currentTable.fields.date_of_dispatch.caption,
                operators: currentTable.fields.date_of_dispatch.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.date_of_dispatch.validators),
                data: {
                    format: currentTable.fields.date_of_dispatch.clientFormatPattern
                }
            },
            {
                id: "port_eta",
                type: "datetime",
                label: currentTable.fields.port_eta.caption,
                operators: currentTable.fields.port_eta.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.port_eta.validators),
                data: {
                    format: currentTable.fields.port_eta.clientFormatPattern
                }
            },
            {
                id: "bl_no",
                type: "string",
                label: currentTable.fields.bl_no.caption,
                operators: currentTable.fields.bl_no.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.bl_no.validators),
                data: {
                    format: currentTable.fields.bl_no.clientFormatPattern
                }
            },
            {
                id: "s_line",
                type: "integer",
                label: currentTable.fields.s_line.caption,
                operators: currentTable.fields.s_line.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.s_line.validators),
                data: {
                    format: currentTable.fields.s_line.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "integer",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "ref",
                type: "string",
                label: currentTable.fields.ref.caption,
                operators: currentTable.fields.ref.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbooking_confirmsearch.fields.ref.validators),
                data: {
                    format: currentTable.fields.ref.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#booking_confirm_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbooking_confirmsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbooking_confirmsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbooking_confirmsearch" formaction="<?= HtmlEncode(GetUrl("bookingconfirmlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_confirmsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbooking_confirmsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_confirm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
