<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingConfirmList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "booking_details") {
    if ($Page->MasterRecordExists) {
        include_once "views/BookingDetailsMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbooking_confirmsrch" id="fbooking_confirmsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbooking_confirmsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
var currentForm;
var fbooking_confirmsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_confirmsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["supplier", [], fields.supplier.isInvalid],
            ["confirm_type", [], fields.confirm_type.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["y_amount", [ew.Validators.between], false],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "confirm_type": <?= $Page->confirm_type->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->supplier->Visible) { // supplier ?>
<?php
if (!$Page->supplier->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_supplier" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->supplier->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_supplier" class="ew-search-caption ew-label"><?= $Page->supplier->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</div>
        </div>
        <div id="el_booking_confirm_supplier" class="ew-search-field">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsrch_x_supplier"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsrch", function() {
    var options = { name: "x_supplier", selectId: "fbooking_confirmsrch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsrch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbooking_confirmsrch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbooking_confirmsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->confirm_type->Visible) { // confirm_type ?>
<?php
if (!$Page->confirm_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_confirm_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->confirm_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_confirm_type" class="ew-search-caption ew-label"><?= $Page->confirm_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_type" id="z_confirm_type" value="=">
</div>
        </div>
        <div id="el_booking_confirm_confirm_type" class="ew-search-field">
    <select
        id="x_confirm_type"
        name="x_confirm_type"
        class="form-select ew-select<?= $Page->confirm_type->isInvalidClass() ?>"
        <?php if (!$Page->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmsrch_x_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Page->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->confirm_type->getPlaceHolder()) ?>"
        <?= $Page->confirm_type->editAttributes() ?>>
        <?= $Page->confirm_type->selectOptionListHtml("x_confirm_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->confirm_type->getErrorMessage(false) ?></div>
<?php if (!$Page->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmsrch", function() {
    var options = { name: "x_confirm_type", selectId: "fbooking_confirmsrch_x_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmsrch.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x_confirm_type", form: "fbooking_confirmsrch" };
    } else {
        options.ajax = { id: "x_confirm_type", form: "fbooking_confirmsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
<?php
if (!$Page->amount->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_amount" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->amount->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_amount" class="ew-search-caption ew-label"><?= $Page->amount->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_amount" id="z_amount" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->amount->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->amount->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_booking_confirm_amount" class="ew-search-field">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_booking_confirm_amount" class="ew-search-field2 d-none">
<input type="<?= $Page->amount->getInputTextType() ?>" name="y_amount" id="y_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
<?php
if (!$Page->company_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_company_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->company_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->company_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</div>
        </div>
        <div id="el_booking_confirm_company_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_confirmsrch", function() {
    fbooking_confirmsrch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbooking_confirmsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbooking_confirmsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbooking_confirmsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbooking_confirmsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbooking_confirmsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbooking_confirmsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbooking_confirmsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_confirm">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "booking_details" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="booking_details">
<input type="hidden" name="fk_ref" value="<?= HtmlEncode($Page->ref->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_booking_confirm" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_booking_confirmlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_booking_confirm_id" class="booking_confirm_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Page->supplier->headerCellClass() ?>"><div id="elh_booking_confirm_supplier" class="booking_confirm_supplier"><?= $Page->renderFieldHeader($Page->supplier) ?></div></th>
<?php } ?>
<?php if ($Page->confirm_type->Visible) { // confirm_type ?>
        <th data-name="confirm_type" class="<?= $Page->confirm_type->headerCellClass() ?>"><div id="elh_booking_confirm_confirm_type" class="booking_confirm_confirm_type"><?= $Page->renderFieldHeader($Page->confirm_type) ?></div></th>
<?php } ?>
<?php if ($Page->booking_ref->Visible) { // booking_ref ?>
        <th data-name="booking_ref" class="<?= $Page->booking_ref->headerCellClass() ?>"><div id="elh_booking_confirm_booking_ref" class="booking_confirm_booking_ref"><?= $Page->renderFieldHeader($Page->booking_ref) ?></div></th>
<?php } ?>
<?php if ($Page->approx_qty->Visible) { // approx_qty ?>
        <th data-name="approx_qty" class="<?= $Page->approx_qty->headerCellClass() ?>"><div id="elh_booking_confirm_approx_qty" class="booking_confirm_approx_qty"><?= $Page->renderFieldHeader($Page->approx_qty) ?></div></th>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Page->packets->headerCellClass() ?>"><div id="elh_booking_confirm_packets" class="booking_confirm_packets"><?= $Page->renderFieldHeader($Page->packets) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_booking_confirm_amount" class="booking_confirm_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Page->currency->headerCellClass() ?>"><div id="elh_booking_confirm_currency" class="booking_confirm_currency"><?= $Page->renderFieldHeader($Page->currency) ?></div></th>
<?php } ?>
<?php if ($Page->date->Visible) { // date ?>
        <th data-name="date" class="<?= $Page->date->headerCellClass() ?>"><div id="elh_booking_confirm_date" class="booking_confirm_date"><?= $Page->renderFieldHeader($Page->date) ?></div></th>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
        <th data-name="reference" class="<?= $Page->reference->headerCellClass() ?>"><div id="elh_booking_confirm_reference" class="booking_confirm_reference"><?= $Page->renderFieldHeader($Page->reference) ?></div></th>
<?php } ?>
<?php if ($Page->date_of_dispatch->Visible) { // date_of_dispatch ?>
        <th data-name="date_of_dispatch" class="<?= $Page->date_of_dispatch->headerCellClass() ?>"><div id="elh_booking_confirm_date_of_dispatch" class="booking_confirm_date_of_dispatch"><?= $Page->renderFieldHeader($Page->date_of_dispatch) ?></div></th>
<?php } ?>
<?php if ($Page->port_eta->Visible) { // port_eta ?>
        <th data-name="port_eta" class="<?= $Page->port_eta->headerCellClass() ?>"><div id="elh_booking_confirm_port_eta" class="booking_confirm_port_eta"><?= $Page->renderFieldHeader($Page->port_eta) ?></div></th>
<?php } ?>
<?php if ($Page->bl_no->Visible) { // bl_no ?>
        <th data-name="bl_no" class="<?= $Page->bl_no->headerCellClass() ?>"><div id="elh_booking_confirm_bl_no" class="booking_confirm_bl_no"><?= $Page->renderFieldHeader($Page->bl_no) ?></div></th>
<?php } ?>
<?php if ($Page->s_line->Visible) { // s_line ?>
        <th data-name="s_line" class="<?= $Page->s_line->headerCellClass() ?>"><div id="elh_booking_confirm_s_line" class="booking_confirm_s_line"><?= $Page->renderFieldHeader($Page->s_line) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_booking_confirm_company_id" class="booking_confirm_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_booking_confirm_operator" class="booking_confirm_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_booking_confirm_datetime" class="booking_confirm_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_booking_confirm_ref" class="booking_confirm_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_id" class="el_booking_confirm_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Page->supplier->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_supplier" class="el_booking_confirm_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Page->supplier->getViewValue()) && $Page->supplier->linkAttributes() != "") { ?>
<a<?= $Page->supplier->linkAttributes() ?>><?= $Page->supplier->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->confirm_type->Visible) { // confirm_type ?>
        <td data-name="confirm_type"<?= $Page->confirm_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_confirm_type" class="el_booking_confirm_confirm_type">
<span<?= $Page->confirm_type->viewAttributes() ?>>
<?= $Page->confirm_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->booking_ref->Visible) { // booking_ref ?>
        <td data-name="booking_ref"<?= $Page->booking_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_booking_ref" class="el_booking_confirm_booking_ref">
<span<?= $Page->booking_ref->viewAttributes() ?>>
<?= $Page->booking_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->approx_qty->Visible) { // approx_qty ?>
        <td data-name="approx_qty"<?= $Page->approx_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_approx_qty" class="el_booking_confirm_approx_qty">
<span<?= $Page->approx_qty->viewAttributes() ?>>
<?= $Page->approx_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Page->packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_packets" class="el_booking_confirm_packets">
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_amount" class="el_booking_confirm_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Page->currency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_currency" class="el_booking_confirm_currency">
<span<?= $Page->currency->viewAttributes() ?>>
<?= $Page->currency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->date->Visible) { // date ?>
        <td data-name="date"<?= $Page->date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_date" class="el_booking_confirm_date">
<span<?= $Page->date->viewAttributes() ?>>
<?= $Page->date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reference->Visible) { // reference ?>
        <td data-name="reference"<?= $Page->reference->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_reference" class="el_booking_confirm_reference">
<span<?= $Page->reference->viewAttributes() ?>>
<?= $Page->reference->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->date_of_dispatch->Visible) { // date_of_dispatch ?>
        <td data-name="date_of_dispatch"<?= $Page->date_of_dispatch->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_date_of_dispatch" class="el_booking_confirm_date_of_dispatch">
<span<?= $Page->date_of_dispatch->viewAttributes() ?>>
<?= $Page->date_of_dispatch->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_eta->Visible) { // port_eta ?>
        <td data-name="port_eta"<?= $Page->port_eta->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_port_eta" class="el_booking_confirm_port_eta">
<span<?= $Page->port_eta->viewAttributes() ?>>
<?= $Page->port_eta->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bl_no->Visible) { // bl_no ?>
        <td data-name="bl_no"<?= $Page->bl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_bl_no" class="el_booking_confirm_bl_no">
<span<?= $Page->bl_no->viewAttributes() ?>>
<?= $Page->bl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_line->Visible) { // s_line ?>
        <td data-name="s_line"<?= $Page->s_line->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_s_line" class="el_booking_confirm_s_line">
<span<?= $Page->s_line->viewAttributes() ?>>
<?= $Page->s_line->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_company_id" class="el_booking_confirm_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_operator" class="el_booking_confirm_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_datetime" class="el_booking_confirm_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_ref" class="el_booking_confirm_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_confirm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
