<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("BookingConfirmGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fbooking_confirmgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbooking_confirmgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["confirm_type", [fields.confirm_type.visible && fields.confirm_type.required ? ew.Validators.required(fields.confirm_type.caption) : null], fields.confirm_type.isInvalid],
            ["booking_ref", [fields.booking_ref.visible && fields.booking_ref.required ? ew.Validators.required(fields.booking_ref.caption) : null], fields.booking_ref.isInvalid],
            ["approx_qty", [fields.approx_qty.visible && fields.approx_qty.required ? ew.Validators.required(fields.approx_qty.caption) : null, ew.Validators.float], fields.approx_qty.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.integer], fields.packets.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null, ew.Validators.integer], fields.currency.isInvalid],
            ["date", [fields.date.visible && fields.date.required ? ew.Validators.required(fields.date.caption) : null, ew.Validators.datetime(fields.date.clientFormatPattern)], fields.date.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["date_of_dispatch", [fields.date_of_dispatch.visible && fields.date_of_dispatch.required ? ew.Validators.required(fields.date_of_dispatch.caption) : null, ew.Validators.datetime(fields.date_of_dispatch.clientFormatPattern)], fields.date_of_dispatch.isInvalid],
            ["port_eta", [fields.port_eta.visible && fields.port_eta.required ? ew.Validators.required(fields.port_eta.caption) : null, ew.Validators.datetime(fields.port_eta.clientFormatPattern)], fields.port_eta.isInvalid],
            ["bl_no", [fields.bl_no.visible && fields.bl_no.required ? ew.Validators.required(fields.bl_no.caption) : null], fields.bl_no.isInvalid],
            ["s_line", [fields.s_line.visible && fields.s_line.required ? ew.Validators.required(fields.s_line.caption) : null], fields.s_line.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["supplier",false],["confirm_type",false],["booking_ref",false],["approx_qty",false],["packets",false],["amount",false],["currency",false],["date",false],["reference",false],["date_of_dispatch",false],["port_eta",false],["bl_no",false],["s_line",false],["company_id",false],["ref",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Grid->supplier->toClientList($Grid) ?>,
            "confirm_type": <?= $Grid->confirm_type->toClientList($Grid) ?>,
            "booking_ref": <?= $Grid->booking_ref->toClientList($Grid) ?>,
            "currency": <?= $Grid->currency->toClientList($Grid) ?>,
            "s_line": <?= $Grid->s_line->toClientList($Grid) ?>,
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fbooking_confirmgrid" class="ew-form ew-list-form">
<div id="gmp_booking_confirm" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_booking_confirmgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_booking_confirm_id" class="booking_confirm_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Grid->supplier->headerCellClass() ?>"><div id="elh_booking_confirm_supplier" class="booking_confirm_supplier"><?= $Grid->renderFieldHeader($Grid->supplier) ?></div></th>
<?php } ?>
<?php if ($Grid->confirm_type->Visible) { // confirm_type ?>
        <th data-name="confirm_type" class="<?= $Grid->confirm_type->headerCellClass() ?>"><div id="elh_booking_confirm_confirm_type" class="booking_confirm_confirm_type"><?= $Grid->renderFieldHeader($Grid->confirm_type) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_ref->Visible) { // booking_ref ?>
        <th data-name="booking_ref" class="<?= $Grid->booking_ref->headerCellClass() ?>"><div id="elh_booking_confirm_booking_ref" class="booking_confirm_booking_ref"><?= $Grid->renderFieldHeader($Grid->booking_ref) ?></div></th>
<?php } ?>
<?php if ($Grid->approx_qty->Visible) { // approx_qty ?>
        <th data-name="approx_qty" class="<?= $Grid->approx_qty->headerCellClass() ?>"><div id="elh_booking_confirm_approx_qty" class="booking_confirm_approx_qty"><?= $Grid->renderFieldHeader($Grid->approx_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Grid->packets->headerCellClass() ?>"><div id="elh_booking_confirm_packets" class="booking_confirm_packets"><?= $Grid->renderFieldHeader($Grid->packets) ?></div></th>
<?php } ?>
<?php if ($Grid->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Grid->amount->headerCellClass() ?>"><div id="elh_booking_confirm_amount" class="booking_confirm_amount"><?= $Grid->renderFieldHeader($Grid->amount) ?></div></th>
<?php } ?>
<?php if ($Grid->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Grid->currency->headerCellClass() ?>"><div id="elh_booking_confirm_currency" class="booking_confirm_currency"><?= $Grid->renderFieldHeader($Grid->currency) ?></div></th>
<?php } ?>
<?php if ($Grid->date->Visible) { // date ?>
        <th data-name="date" class="<?= $Grid->date->headerCellClass() ?>"><div id="elh_booking_confirm_date" class="booking_confirm_date"><?= $Grid->renderFieldHeader($Grid->date) ?></div></th>
<?php } ?>
<?php if ($Grid->reference->Visible) { // reference ?>
        <th data-name="reference" class="<?= $Grid->reference->headerCellClass() ?>"><div id="elh_booking_confirm_reference" class="booking_confirm_reference"><?= $Grid->renderFieldHeader($Grid->reference) ?></div></th>
<?php } ?>
<?php if ($Grid->date_of_dispatch->Visible) { // date_of_dispatch ?>
        <th data-name="date_of_dispatch" class="<?= $Grid->date_of_dispatch->headerCellClass() ?>"><div id="elh_booking_confirm_date_of_dispatch" class="booking_confirm_date_of_dispatch"><?= $Grid->renderFieldHeader($Grid->date_of_dispatch) ?></div></th>
<?php } ?>
<?php if ($Grid->port_eta->Visible) { // port_eta ?>
        <th data-name="port_eta" class="<?= $Grid->port_eta->headerCellClass() ?>"><div id="elh_booking_confirm_port_eta" class="booking_confirm_port_eta"><?= $Grid->renderFieldHeader($Grid->port_eta) ?></div></th>
<?php } ?>
<?php if ($Grid->bl_no->Visible) { // bl_no ?>
        <th data-name="bl_no" class="<?= $Grid->bl_no->headerCellClass() ?>"><div id="elh_booking_confirm_bl_no" class="booking_confirm_bl_no"><?= $Grid->renderFieldHeader($Grid->bl_no) ?></div></th>
<?php } ?>
<?php if ($Grid->s_line->Visible) { // s_line ?>
        <th data-name="s_line" class="<?= $Grid->s_line->headerCellClass() ?>"><div id="elh_booking_confirm_s_line" class="booking_confirm_s_line"><?= $Grid->renderFieldHeader($Grid->s_line) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_booking_confirm_company_id" class="booking_confirm_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_booking_confirm_operator" class="booking_confirm_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_booking_confirm_datetime" class="booking_confirm_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php if ($Grid->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Grid->ref->headerCellClass() ?>"><div id="elh_booking_confirm_ref" class="booking_confirm_ref"><?= $Grid->renderFieldHeader($Grid->ref) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_id" class="el_booking_confirm_id"></span>
<input type="hidden" data-table="booking_confirm" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_id" class="el_booking_confirm_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="booking_confirm" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_id" class="el_booking_confirm_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_id" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_id" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_id" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_id" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="booking_confirm" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Grid->supplier->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_supplier" class="el_booking_confirm_supplier">
    <select
        id="x<?= $Grid->RowIndex ?>_supplier"
        name="x<?= $Grid->RowIndex ?>_supplier"
        class="form-select ew-select<?= $Grid->supplier->isInvalidClass() ?>"
        <?php if (!$Grid->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_supplier"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_supplier"
        data-value-separator="<?= $Grid->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->supplier->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->supplier->editAttributes() ?>>
        <?= $Grid->supplier->selectOptionListHtml("x{$Grid->RowIndex}_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->supplier->getErrorMessage() ?></div>
<?= $Grid->supplier->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_supplier") ?>
<?php if (!$Grid->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_supplier", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_supplier", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_supplier" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_supplier" id="o<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_supplier" class="el_booking_confirm_supplier">
<span<?= $Grid->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Grid->supplier->EditValue) && $Grid->supplier->linkAttributes() != "") { ?>
<a<?= $Grid->supplier->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->supplier->getDisplayValue($Grid->supplier->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->supplier->getDisplayValue($Grid->supplier->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_supplier" data-hidden="1" name="x<?= $Grid->RowIndex ?>_supplier" id="x<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_supplier" class="el_booking_confirm_supplier">
<span<?= $Grid->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Grid->supplier->getViewValue()) && $Grid->supplier->linkAttributes() != "") { ?>
<a<?= $Grid->supplier->linkAttributes() ?>><?= $Grid->supplier->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_supplier" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_supplier" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_supplier" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_supplier" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_supplier" value="<?= HtmlEncode($Grid->supplier->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->confirm_type->Visible) { // confirm_type ?>
        <td data-name="confirm_type"<?= $Grid->confirm_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_confirm_type" class="el_booking_confirm_confirm_type">
    <select
        id="x<?= $Grid->RowIndex ?>_confirm_type"
        name="x<?= $Grid->RowIndex ?>_confirm_type"
        class="form-select ew-select<?= $Grid->confirm_type->isInvalidClass() ?>"
        <?php if (!$Grid->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Grid->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->confirm_type->getPlaceHolder()) ?>"
        <?= $Grid->confirm_type->editAttributes() ?>>
        <?= $Grid->confirm_type->selectOptionListHtml("x{$Grid->RowIndex}_confirm_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->confirm_type->getErrorMessage() ?></div>
<?php if (!$Grid->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_confirm_type", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_confirm_type", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_confirm_type", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_confirm_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_confirm_type" id="o<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_confirm_type" class="el_booking_confirm_confirm_type">
    <select
        id="x<?= $Grid->RowIndex ?>_confirm_type"
        name="x<?= $Grid->RowIndex ?>_confirm_type"
        class="form-select ew-select<?= $Grid->confirm_type->isInvalidClass() ?>"
        <?php if (!$Grid->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Grid->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->confirm_type->getPlaceHolder()) ?>"
        <?= $Grid->confirm_type->editAttributes() ?>>
        <?= $Grid->confirm_type->selectOptionListHtml("x{$Grid->RowIndex}_confirm_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->confirm_type->getErrorMessage() ?></div>
<?php if (!$Grid->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_confirm_type", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_confirm_type", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_confirm_type", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_confirm_type" class="el_booking_confirm_confirm_type">
<span<?= $Grid->confirm_type->viewAttributes() ?>>
<?= $Grid->confirm_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_confirm_type" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_confirm_type" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_confirm_type" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_confirm_type" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->booking_ref->Visible) { // booking_ref ?>
        <td data-name="booking_ref"<?= $Grid->booking_ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_booking_ref" class="el_booking_confirm_booking_ref">
    <select
        id="x<?= $Grid->RowIndex ?>_booking_ref"
        name="x<?= $Grid->RowIndex ?>_booking_ref"
        class="form-select ew-select<?= $Grid->booking_ref->isInvalidClass() ?>"
        <?php if (!$Grid->booking_ref->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_booking_ref"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_booking_ref"
        data-value-separator="<?= $Grid->booking_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->booking_ref->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->booking_ref->editAttributes() ?>>
        <?= $Grid->booking_ref->selectOptionListHtml("x{$Grid->RowIndex}_booking_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->booking_ref->getErrorMessage() ?></div>
<?= $Grid->booking_ref->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_booking_ref") ?>
<?php if (!$Grid->booking_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_booking_ref", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_booking_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.booking_ref?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_booking_ref", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_booking_ref", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.booking_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_booking_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_ref" id="o<?= $Grid->RowIndex ?>_booking_ref" value="<?= HtmlEncode($Grid->booking_ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_booking_ref" class="el_booking_confirm_booking_ref">
<span<?= $Grid->booking_ref->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->booking_ref->getDisplayValue($Grid->booking_ref->EditValue) ?></span></span>
<input type="hidden" data-table="booking_confirm" data-field="x_booking_ref" data-hidden="1" name="x<?= $Grid->RowIndex ?>_booking_ref" id="x<?= $Grid->RowIndex ?>_booking_ref" value="<?= HtmlEncode($Grid->booking_ref->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_booking_ref" class="el_booking_confirm_booking_ref">
<span<?= $Grid->booking_ref->viewAttributes() ?>>
<?= $Grid->booking_ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_booking_ref" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_booking_ref" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_booking_ref" value="<?= HtmlEncode($Grid->booking_ref->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_booking_ref" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_booking_ref" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_booking_ref" value="<?= HtmlEncode($Grid->booking_ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->approx_qty->Visible) { // approx_qty ?>
        <td data-name="approx_qty"<?= $Grid->approx_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_approx_qty" class="el_booking_confirm_approx_qty">
<input type="<?= $Grid->approx_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_approx_qty" id="x<?= $Grid->RowIndex ?>_approx_qty" data-table="booking_confirm" data-field="x_approx_qty" value="<?= $Grid->approx_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->approx_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->approx_qty->formatPattern()) ?>"<?= $Grid->approx_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->approx_qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_approx_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_approx_qty" id="o<?= $Grid->RowIndex ?>_approx_qty" value="<?= HtmlEncode($Grid->approx_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_approx_qty" class="el_booking_confirm_approx_qty">
<input type="<?= $Grid->approx_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_approx_qty" id="x<?= $Grid->RowIndex ?>_approx_qty" data-table="booking_confirm" data-field="x_approx_qty" value="<?= $Grid->approx_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->approx_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->approx_qty->formatPattern()) ?>"<?= $Grid->approx_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->approx_qty->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_approx_qty" class="el_booking_confirm_approx_qty">
<span<?= $Grid->approx_qty->viewAttributes() ?>>
<?= $Grid->approx_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_approx_qty" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_approx_qty" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_approx_qty" value="<?= HtmlEncode($Grid->approx_qty->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_approx_qty" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_approx_qty" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_approx_qty" value="<?= HtmlEncode($Grid->approx_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Grid->packets->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_packets" class="el_booking_confirm_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="booking_confirm" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_packets" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packets" id="o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_packets" class="el_booking_confirm_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="booking_confirm" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_packets" class="el_booking_confirm_packets">
<span<?= $Grid->packets->viewAttributes() ?>>
<?= $Grid->packets->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_packets" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_packets" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_packets" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_packets" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Grid->amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_amount" class="el_booking_confirm_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_amount" id="o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_amount" class="el_booking_confirm_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_amount" class="el_booking_confirm_amount">
<span<?= $Grid->amount->viewAttributes() ?>>
<?= $Grid->amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_amount" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_amount" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_amount" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_amount" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Grid->currency->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_currency" class="el_booking_confirm_currency">
<?php
if (IsRTL()) {
    $Grid->currency->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_currency" class="ew-auto-suggest">
    <input type="<?= $Grid->currency->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_currency" id="sv_x<?= $Grid->RowIndex ?>_currency" value="<?= RemoveHtml($Grid->currency->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency->formatPattern()) ?>"<?= $Grid->currency->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_currency" data-input="sv_x<?= $Grid->RowIndex ?>_currency" data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_currency" id="x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    fbooking_confirmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_currency","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->currency->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.currency.autoSuggestOptions));
});
</script>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_currency" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency" id="o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_currency" class="el_booking_confirm_currency">
<?php
if (IsRTL()) {
    $Grid->currency->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_currency" class="ew-auto-suggest">
    <input type="<?= $Grid->currency->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_currency" id="sv_x<?= $Grid->RowIndex ?>_currency" value="<?= RemoveHtml($Grid->currency->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency->formatPattern()) ?>"<?= $Grid->currency->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_currency" data-input="sv_x<?= $Grid->RowIndex ?>_currency" data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_currency" id="x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    fbooking_confirmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_currency","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->currency->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.currency.autoSuggestOptions));
});
</script>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_currency" class="el_booking_confirm_currency">
<span<?= $Grid->currency->viewAttributes() ?>>
<?= $Grid->currency->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_currency" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_currency" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_currency" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_currency" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->date->Visible) { // date ?>
        <td data-name="date"<?= $Grid->date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date" class="el_booking_confirm_date">
<input type="<?= $Grid->date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_date" id="x<?= $Grid->RowIndex ?>_date" data-table="booking_confirm" data-field="x_date" value="<?= $Grid->date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->date->formatPattern()) ?>"<?= $Grid->date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->date->getErrorMessage() ?></div>
<?php if (!$Grid->date->ReadOnly && !$Grid->date->Disabled && !isset($Grid->date->EditAttrs["readonly"]) && !isset($Grid->date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_date" id="o<?= $Grid->RowIndex ?>_date" value="<?= HtmlEncode($Grid->date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date" class="el_booking_confirm_date">
<input type="<?= $Grid->date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_date" id="x<?= $Grid->RowIndex ?>_date" data-table="booking_confirm" data-field="x_date" value="<?= $Grid->date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->date->formatPattern()) ?>"<?= $Grid->date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->date->getErrorMessage() ?></div>
<?php if (!$Grid->date->ReadOnly && !$Grid->date->Disabled && !isset($Grid->date->EditAttrs["readonly"]) && !isset($Grid->date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date" class="el_booking_confirm_date">
<span<?= $Grid->date->viewAttributes() ?>>
<?= $Grid->date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_date" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_date" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_date" value="<?= HtmlEncode($Grid->date->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_date" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_date" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_date" value="<?= HtmlEncode($Grid->date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->reference->Visible) { // reference ?>
        <td data-name="reference"<?= $Grid->reference->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_reference" class="el_booking_confirm_reference">
<textarea data-table="booking_confirm" data-field="x_reference" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" cols="50" rows="2" placeholder="<?= HtmlEncode($Grid->reference->getPlaceHolder()) ?>"<?= $Grid->reference->editAttributes() ?>><?= $Grid->reference->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->reference->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_reference" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_reference" id="o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_reference" class="el_booking_confirm_reference">
<textarea data-table="booking_confirm" data-field="x_reference" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" cols="50" rows="2" placeholder="<?= HtmlEncode($Grid->reference->getPlaceHolder()) ?>"<?= $Grid->reference->editAttributes() ?>><?= $Grid->reference->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->reference->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_reference" class="el_booking_confirm_reference">
<span<?= $Grid->reference->viewAttributes() ?>>
<?= $Grid->reference->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_reference" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_reference" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_reference" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_reference" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->date_of_dispatch->Visible) { // date_of_dispatch ?>
        <td data-name="date_of_dispatch"<?= $Grid->date_of_dispatch->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date_of_dispatch" class="el_booking_confirm_date_of_dispatch">
<input type="<?= $Grid->date_of_dispatch->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_date_of_dispatch" id="x<?= $Grid->RowIndex ?>_date_of_dispatch" data-table="booking_confirm" data-field="x_date_of_dispatch" value="<?= $Grid->date_of_dispatch->EditValue ?>" placeholder="<?= HtmlEncode($Grid->date_of_dispatch->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->date_of_dispatch->formatPattern()) ?>"<?= $Grid->date_of_dispatch->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->date_of_dispatch->getErrorMessage() ?></div>
<?php if (!$Grid->date_of_dispatch->ReadOnly && !$Grid->date_of_dispatch->Disabled && !isset($Grid->date_of_dispatch->EditAttrs["readonly"]) && !isset($Grid->date_of_dispatch->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_date_of_dispatch", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_date_of_dispatch" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_date_of_dispatch" id="o<?= $Grid->RowIndex ?>_date_of_dispatch" value="<?= HtmlEncode($Grid->date_of_dispatch->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date_of_dispatch" class="el_booking_confirm_date_of_dispatch">
<input type="<?= $Grid->date_of_dispatch->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_date_of_dispatch" id="x<?= $Grid->RowIndex ?>_date_of_dispatch" data-table="booking_confirm" data-field="x_date_of_dispatch" value="<?= $Grid->date_of_dispatch->EditValue ?>" placeholder="<?= HtmlEncode($Grid->date_of_dispatch->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->date_of_dispatch->formatPattern()) ?>"<?= $Grid->date_of_dispatch->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->date_of_dispatch->getErrorMessage() ?></div>
<?php if (!$Grid->date_of_dispatch->ReadOnly && !$Grid->date_of_dispatch->Disabled && !isset($Grid->date_of_dispatch->EditAttrs["readonly"]) && !isset($Grid->date_of_dispatch->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_date_of_dispatch", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_date_of_dispatch" class="el_booking_confirm_date_of_dispatch">
<span<?= $Grid->date_of_dispatch->viewAttributes() ?>>
<?= $Grid->date_of_dispatch->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_date_of_dispatch" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_date_of_dispatch" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_date_of_dispatch" value="<?= HtmlEncode($Grid->date_of_dispatch->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_date_of_dispatch" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_date_of_dispatch" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_date_of_dispatch" value="<?= HtmlEncode($Grid->date_of_dispatch->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->port_eta->Visible) { // port_eta ?>
        <td data-name="port_eta"<?= $Grid->port_eta->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_port_eta" class="el_booking_confirm_port_eta">
<input type="<?= $Grid->port_eta->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_port_eta" id="x<?= $Grid->RowIndex ?>_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Grid->port_eta->EditValue ?>" placeholder="<?= HtmlEncode($Grid->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->port_eta->formatPattern()) ?>"<?= $Grid->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->port_eta->getErrorMessage() ?></div>
<?php if (!$Grid->port_eta->ReadOnly && !$Grid->port_eta->Disabled && !isset($Grid->port_eta->EditAttrs["readonly"]) && !isset($Grid->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_port_eta" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_port_eta" id="o<?= $Grid->RowIndex ?>_port_eta" value="<?= HtmlEncode($Grid->port_eta->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_port_eta" class="el_booking_confirm_port_eta">
<input type="<?= $Grid->port_eta->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_port_eta" id="x<?= $Grid->RowIndex ?>_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Grid->port_eta->EditValue ?>" placeholder="<?= HtmlEncode($Grid->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->port_eta->formatPattern()) ?>"<?= $Grid->port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->port_eta->getErrorMessage() ?></div>
<?php if (!$Grid->port_eta->ReadOnly && !$Grid->port_eta->Disabled && !isset($Grid->port_eta->EditAttrs["readonly"]) && !isset($Grid->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmgrid", "x<?= $Grid->RowIndex ?>_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_port_eta" class="el_booking_confirm_port_eta">
<span<?= $Grid->port_eta->viewAttributes() ?>>
<?= $Grid->port_eta->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_port_eta" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_port_eta" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_port_eta" value="<?= HtmlEncode($Grid->port_eta->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_port_eta" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_port_eta" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_port_eta" value="<?= HtmlEncode($Grid->port_eta->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->bl_no->Visible) { // bl_no ?>
        <td data-name="bl_no"<?= $Grid->bl_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_bl_no" class="el_booking_confirm_bl_no">
<input type="<?= $Grid->bl_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_bl_no" id="x<?= $Grid->RowIndex ?>_bl_no" data-table="booking_confirm" data-field="x_bl_no" value="<?= $Grid->bl_no->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Grid->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->bl_no->formatPattern()) ?>"<?= $Grid->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->bl_no->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_bl_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_bl_no" id="o<?= $Grid->RowIndex ?>_bl_no" value="<?= HtmlEncode($Grid->bl_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_bl_no" class="el_booking_confirm_bl_no">
<input type="<?= $Grid->bl_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_bl_no" id="x<?= $Grid->RowIndex ?>_bl_no" data-table="booking_confirm" data-field="x_bl_no" value="<?= $Grid->bl_no->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Grid->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->bl_no->formatPattern()) ?>"<?= $Grid->bl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->bl_no->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_bl_no" class="el_booking_confirm_bl_no">
<span<?= $Grid->bl_no->viewAttributes() ?>>
<?= $Grid->bl_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_bl_no" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_bl_no" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_bl_no" value="<?= HtmlEncode($Grid->bl_no->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_bl_no" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_bl_no" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_bl_no" value="<?= HtmlEncode($Grid->bl_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_line->Visible) { // s_line ?>
        <td data-name="s_line"<?= $Grid->s_line->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_s_line" class="el_booking_confirm_s_line">
    <select
        id="x<?= $Grid->RowIndex ?>_s_line"
        name="x<?= $Grid->RowIndex ?>_s_line"
        class="form-select ew-select<?= $Grid->s_line->isInvalidClass() ?>"
        <?php if (!$Grid->s_line->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_s_line"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_s_line"
        data-value-separator="<?= $Grid->s_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_line->getPlaceHolder()) ?>"
        <?= $Grid->s_line->editAttributes() ?>>
        <?= $Grid->s_line->selectOptionListHtml("x{$Grid->RowIndex}_s_line") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_line->getErrorMessage() ?></div>
<?= $Grid->s_line->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_line") ?>
<?php if (!$Grid->s_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_line", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_s_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.s_line?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_line", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_line", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.s_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_s_line" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_line" id="o<?= $Grid->RowIndex ?>_s_line" value="<?= HtmlEncode($Grid->s_line->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_s_line" class="el_booking_confirm_s_line">
    <select
        id="x<?= $Grid->RowIndex ?>_s_line"
        name="x<?= $Grid->RowIndex ?>_s_line"
        class="form-select ew-select<?= $Grid->s_line->isInvalidClass() ?>"
        <?php if (!$Grid->s_line->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_s_line"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_s_line"
        data-value-separator="<?= $Grid->s_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_line->getPlaceHolder()) ?>"
        <?= $Grid->s_line->editAttributes() ?>>
        <?= $Grid->s_line->selectOptionListHtml("x{$Grid->RowIndex}_s_line") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_line->getErrorMessage() ?></div>
<?= $Grid->s_line->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_line") ?>
<?php if (!$Grid->s_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_line", selectId: "fbooking_confirmgrid_x<?= $Grid->RowIndex ?>_s_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmgrid.lists.s_line?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_line", form: "fbooking_confirmgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_line", form: "fbooking_confirmgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.s_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_s_line" class="el_booking_confirm_s_line">
<span<?= $Grid->s_line->viewAttributes() ?>>
<?= $Grid->s_line->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_s_line" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_s_line" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_s_line" value="<?= HtmlEncode($Grid->s_line->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_s_line" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_s_line" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_s_line" value="<?= HtmlEncode($Grid->s_line->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_company_id" class="el_booking_confirm_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    fbooking_confirmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<input type="hidden" data-table="booking_confirm" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_company_id" class="el_booking_confirm_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_confirmgrid", function() {
    fbooking_confirmgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_company_id" class="el_booking_confirm_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_company_id" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_company_id" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_company_id" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_company_id" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking_confirm" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_operator" class="el_booking_confirm_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_operator" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_operator" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_operator" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_operator" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking_confirm" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_datetime" class="el_booking_confirm_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_datetime" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_datetime" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_datetime" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_datetime" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Grid->ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_ref" class="el_booking_confirm_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking_confirm" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="booking_confirm" data-field="x_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ref" id="o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_ref" class="el_booking_confirm_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking_confirm" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_confirm_ref" class="el_booking_confirm_ref">
<span<?= $Grid->ref->viewAttributes() ?>>
<?= $Grid->ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_confirm" data-field="x_ref" data-hidden="1" name="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_ref" id="fbooking_confirmgrid$x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->FormValue) ?>">
<input type="hidden" data-table="booking_confirm" data-field="x_ref" data-hidden="1" data-old name="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_ref" id="fbooking_confirmgrid$o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fbooking_confirmgrid","load"], () => fbooking_confirmgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fbooking_confirmgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_confirm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
