<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingConfirmAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_confirm: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fbooking_confirmadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbooking_confirmadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["confirm_type", [fields.confirm_type.visible && fields.confirm_type.required ? ew.Validators.required(fields.confirm_type.caption) : null], fields.confirm_type.isInvalid],
            ["booking_ref", [fields.booking_ref.visible && fields.booking_ref.required ? ew.Validators.required(fields.booking_ref.caption) : null], fields.booking_ref.isInvalid],
            ["approx_qty", [fields.approx_qty.visible && fields.approx_qty.required ? ew.Validators.required(fields.approx_qty.caption) : null, ew.Validators.float], fields.approx_qty.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.integer], fields.packets.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null, ew.Validators.integer], fields.currency.isInvalid],
            ["date", [fields.date.visible && fields.date.required ? ew.Validators.required(fields.date.caption) : null, ew.Validators.datetime(fields.date.clientFormatPattern)], fields.date.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["date_of_dispatch", [fields.date_of_dispatch.visible && fields.date_of_dispatch.required ? ew.Validators.required(fields.date_of_dispatch.caption) : null, ew.Validators.datetime(fields.date_of_dispatch.clientFormatPattern)], fields.date_of_dispatch.isInvalid],
            ["port_eta", [fields.port_eta.visible && fields.port_eta.required ? ew.Validators.required(fields.port_eta.caption) : null, ew.Validators.datetime(fields.port_eta.clientFormatPattern)], fields.port_eta.isInvalid],
            ["bl_no", [fields.bl_no.visible && fields.bl_no.required ? ew.Validators.required(fields.bl_no.caption) : null], fields.bl_no.isInvalid],
            ["s_line", [fields.s_line.visible && fields.s_line.required ? ew.Validators.required(fields.s_line.caption) : null], fields.s_line.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "confirm_type": <?= $Page->confirm_type->toClientList($Page) ?>,
            "booking_ref": <?= $Page->booking_ref->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "s_line": <?= $Page->s_line->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_confirmadd" id="fbooking_confirmadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_confirm">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "booking_details") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="booking_details">
<input type="hidden" name="fk_ref" value="<?= HtmlEncode($Page->ref->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier"<?= $Page->supplier->rowAttributes() ?>>
        <label id="elh_booking_confirm_supplier" for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><?= $Page->supplier->caption() ?><?= $Page->supplier->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->supplier->cellAttributes() ?>>
<span id="el_booking_confirm_supplier">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmadd_x_supplier"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <?= $Page->supplier->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage() ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmadd", function() {
    var options = { name: "x_supplier", selectId: "fbooking_confirmadd_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmadd.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbooking_confirmadd" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbooking_confirmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->confirm_type->Visible) { // confirm_type ?>
    <div id="r_confirm_type"<?= $Page->confirm_type->rowAttributes() ?>>
        <label id="elh_booking_confirm_confirm_type" for="x_confirm_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->confirm_type->caption() ?><?= $Page->confirm_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->confirm_type->cellAttributes() ?>>
<span id="el_booking_confirm_confirm_type">
    <select
        id="x_confirm_type"
        name="x_confirm_type"
        class="form-select ew-select<?= $Page->confirm_type->isInvalidClass() ?>"
        <?php if (!$Page->confirm_type->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmadd_x_confirm_type"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_confirm_type"
        data-value-separator="<?= $Page->confirm_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->confirm_type->getPlaceHolder()) ?>"
        <?= $Page->confirm_type->editAttributes() ?>>
        <?= $Page->confirm_type->selectOptionListHtml("x_confirm_type") ?>
    </select>
    <?= $Page->confirm_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->confirm_type->getErrorMessage() ?></div>
<?php if (!$Page->confirm_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmadd", function() {
    var options = { name: "x_confirm_type", selectId: "fbooking_confirmadd_x_confirm_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmadd.lists.confirm_type?.lookupOptions.length) {
        options.data = { id: "x_confirm_type", form: "fbooking_confirmadd" };
    } else {
        options.ajax = { id: "x_confirm_type", form: "fbooking_confirmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.confirm_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_ref->Visible) { // booking_ref ?>
    <div id="r_booking_ref"<?= $Page->booking_ref->rowAttributes() ?>>
        <label id="elh_booking_confirm_booking_ref" for="x_booking_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_ref->caption() ?><?= $Page->booking_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_ref->cellAttributes() ?>>
<span id="el_booking_confirm_booking_ref">
    <select
        id="x_booking_ref"
        name="x_booking_ref"
        class="form-select ew-select<?= $Page->booking_ref->isInvalidClass() ?>"
        <?php if (!$Page->booking_ref->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmadd_x_booking_ref"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_booking_ref"
        data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->booking_ref->editAttributes() ?>>
        <?= $Page->booking_ref->selectOptionListHtml("x_booking_ref") ?>
    </select>
    <?= $Page->booking_ref->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage() ?></div>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_x_booking_ref") ?>
<?php if (!$Page->booking_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmadd", function() {
    var options = { name: "x_booking_ref", selectId: "fbooking_confirmadd_x_booking_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmadd.lists.booking_ref?.lookupOptions.length) {
        options.data = { id: "x_booking_ref", form: "fbooking_confirmadd" };
    } else {
        options.ajax = { id: "x_booking_ref", form: "fbooking_confirmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.booking_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->approx_qty->Visible) { // approx_qty ?>
    <div id="r_approx_qty"<?= $Page->approx_qty->rowAttributes() ?>>
        <label id="elh_booking_confirm_approx_qty" for="x_approx_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->approx_qty->caption() ?><?= $Page->approx_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->approx_qty->cellAttributes() ?>>
<span id="el_booking_confirm_approx_qty">
<input type="<?= $Page->approx_qty->getInputTextType() ?>" name="x_approx_qty" id="x_approx_qty" data-table="booking_confirm" data-field="x_approx_qty" value="<?= $Page->approx_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->approx_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->approx_qty->formatPattern()) ?>"<?= $Page->approx_qty->editAttributes() ?> aria-describedby="x_approx_qty_help">
<?= $Page->approx_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->approx_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_booking_confirm_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_booking_confirm_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="booking_confirm" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_booking_confirm_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_booking_confirm_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_confirm" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <label id="elh_booking_confirm_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency->caption() ?><?= $Page->currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency->cellAttributes() ?>>
<span id="el_booking_confirm_currency">
<?php
if (IsRTL()) {
    $Page->currency->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_currency" class="ew-auto-suggest">
    <input type="<?= $Page->currency->getInputTextType() ?>" class="form-control" name="sv_x_currency" id="sv_x_currency" value="<?= RemoveHtml($Page->currency->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency->formatPattern()) ?>"<?= $Page->currency->editAttributes() ?> aria-describedby="x_currency_help">
</span>
<selection-list hidden class="form-control" data-table="booking_confirm" data-field="x_currency" data-input="sv_x_currency" data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>" name="x_currency" id="x_currency" value="<?= HtmlEncode($Page->currency->CurrentValue) ?>"></selection-list>
<?= $Page->currency->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_confirmadd", function() {
    fbooking_confirmadd.createAutoSuggest(Object.assign({"id":"x_currency","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->currency->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_confirm.fields.currency.autoSuggestOptions));
});
</script>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date->Visible) { // date ?>
    <div id="r_date"<?= $Page->date->rowAttributes() ?>>
        <label id="elh_booking_confirm_date" for="x_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->date->caption() ?><?= $Page->date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->date->cellAttributes() ?>>
<span id="el_booking_confirm_date">
<input type="<?= $Page->date->getInputTextType() ?>" name="x_date" id="x_date" data-table="booking_confirm" data-field="x_date" value="<?= $Page->date->EditValue ?>" placeholder="<?= HtmlEncode($Page->date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date->formatPattern()) ?>"<?= $Page->date->editAttributes() ?> aria-describedby="x_date_help">
<?= $Page->date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date->getErrorMessage() ?></div>
<?php if (!$Page->date->ReadOnly && !$Page->date->Disabled && !isset($Page->date->EditAttrs["readonly"]) && !isset($Page->date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmadd", "x_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <label id="elh_booking_confirm_reference" for="x_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference->caption() ?><?= $Page->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference->cellAttributes() ?>>
<span id="el_booking_confirm_reference">
<textarea data-table="booking_confirm" data-field="x_reference" name="x_reference" id="x_reference" cols="50" rows="2" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>"<?= $Page->reference->editAttributes() ?> aria-describedby="x_reference_help"><?= $Page->reference->EditValue ?></textarea>
<?= $Page->reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date_of_dispatch->Visible) { // date_of_dispatch ?>
    <div id="r_date_of_dispatch"<?= $Page->date_of_dispatch->rowAttributes() ?>>
        <label id="elh_booking_confirm_date_of_dispatch" for="x_date_of_dispatch" class="<?= $Page->LeftColumnClass ?>"><?= $Page->date_of_dispatch->caption() ?><?= $Page->date_of_dispatch->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->date_of_dispatch->cellAttributes() ?>>
<span id="el_booking_confirm_date_of_dispatch">
<input type="<?= $Page->date_of_dispatch->getInputTextType() ?>" name="x_date_of_dispatch" id="x_date_of_dispatch" data-table="booking_confirm" data-field="x_date_of_dispatch" value="<?= $Page->date_of_dispatch->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_of_dispatch->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_of_dispatch->formatPattern()) ?>"<?= $Page->date_of_dispatch->editAttributes() ?> aria-describedby="x_date_of_dispatch_help">
<?= $Page->date_of_dispatch->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date_of_dispatch->getErrorMessage() ?></div>
<?php if (!$Page->date_of_dispatch->ReadOnly && !$Page->date_of_dispatch->Disabled && !isset($Page->date_of_dispatch->EditAttrs["readonly"]) && !isset($Page->date_of_dispatch->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmadd", "x_date_of_dispatch", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_eta->Visible) { // port_eta ?>
    <div id="r_port_eta"<?= $Page->port_eta->rowAttributes() ?>>
        <label id="elh_booking_confirm_port_eta" for="x_port_eta" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_eta->caption() ?><?= $Page->port_eta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_eta->cellAttributes() ?>>
<span id="el_booking_confirm_port_eta">
<input type="<?= $Page->port_eta->getInputTextType() ?>" name="x_port_eta" id="x_port_eta" data-table="booking_confirm" data-field="x_port_eta" value="<?= $Page->port_eta->EditValue ?>" placeholder="<?= HtmlEncode($Page->port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_eta->formatPattern()) ?>"<?= $Page->port_eta->editAttributes() ?> aria-describedby="x_port_eta_help">
<?= $Page->port_eta->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_eta->getErrorMessage() ?></div>
<?php if (!$Page->port_eta->ReadOnly && !$Page->port_eta->Disabled && !isset($Page->port_eta->EditAttrs["readonly"]) && !isset($Page->port_eta->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_confirmadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_confirmadd", "x_port_eta", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bl_no->Visible) { // bl_no ?>
    <div id="r_bl_no"<?= $Page->bl_no->rowAttributes() ?>>
        <label id="elh_booking_confirm_bl_no" for="x_bl_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bl_no->caption() ?><?= $Page->bl_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bl_no->cellAttributes() ?>>
<span id="el_booking_confirm_bl_no">
<input type="<?= $Page->bl_no->getInputTextType() ?>" name="x_bl_no" id="x_bl_no" data-table="booking_confirm" data-field="x_bl_no" value="<?= $Page->bl_no->EditValue ?>" size="30" maxlength="32" placeholder="<?= HtmlEncode($Page->bl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bl_no->formatPattern()) ?>"<?= $Page->bl_no->editAttributes() ?> aria-describedby="x_bl_no_help">
<?= $Page->bl_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bl_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_line->Visible) { // s_line ?>
    <div id="r_s_line"<?= $Page->s_line->rowAttributes() ?>>
        <label id="elh_booking_confirm_s_line" for="x_s_line" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_line->caption() ?><?= $Page->s_line->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_line->cellAttributes() ?>>
<span id="el_booking_confirm_s_line">
    <select
        id="x_s_line"
        name="x_s_line"
        class="form-select ew-select<?= $Page->s_line->isInvalidClass() ?>"
        <?php if (!$Page->s_line->IsNativeSelect) { ?>
        data-select2-id="fbooking_confirmadd_x_s_line"
        <?php } ?>
        data-table="booking_confirm"
        data-field="x_s_line"
        data-value-separator="<?= $Page->s_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_line->getPlaceHolder()) ?>"
        <?= $Page->s_line->editAttributes() ?>>
        <?= $Page->s_line->selectOptionListHtml("x_s_line") ?>
    </select>
    <?= $Page->s_line->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_line->getErrorMessage() ?></div>
<?= $Page->s_line->Lookup->getParamTag($Page, "p_x_s_line") ?>
<?php if (!$Page->s_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_confirmadd", function() {
    var options = { name: "x_s_line", selectId: "fbooking_confirmadd_x_s_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_confirmadd.lists.s_line?.lookupOptions.length) {
        options.data = { id: "x_s_line", form: "fbooking_confirmadd" };
    } else {
        options.ajax = { id: "x_s_line", form: "fbooking_confirmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_confirm.fields.s_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <label id="elh_booking_confirm_ref" for="x_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ref->caption() ?><?= $Page->ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ref->cellAttributes() ?>>
<?php if ($Page->ref->getSessionValue() != "") { ?>
<span<?= $Page->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->ref->getDisplayValue($Page->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x_ref" name="x_ref" value="<?= HtmlEncode($Page->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_booking_confirm_ref">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_confirm" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?> aria-describedby="x_ref_help">
<?= $Page->ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbooking_confirmadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_confirmadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_confirm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
