<?php

namespace PHPMaker2024\fibre;

// Page object
$BomSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bom: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbomsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbomsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["warp_weft", [], fields.warp_weft.isInvalid],
            ["m_grp", [], fields.m_grp.isInvalid],
            ["m_sgrp", [], fields.m_sgrp.isInvalid],
            ["m_product", [], fields.m_product.isInvalid],
            ["m_rid", [], fields.m_rid.isInvalid],
            ["m_packing", [], fields.m_packing.isInvalid],
            ["bom_waste", [ew.Validators.float], fields.bom_waste.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["y_quantity", [ew.Validators.between], false],
            ["method", [], fields.method.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["gross_nett", [], fields.gross_nett.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "warp_weft": <?= $Page->warp_weft->toClientList($Page) ?>,
            "m_grp": <?= $Page->m_grp->toClientList($Page) ?>,
            "m_sgrp": <?= $Page->m_sgrp->toClientList($Page) ?>,
            "m_product": <?= $Page->m_product->toClientList($Page) ?>,
            "m_rid": <?= $Page->m_rid->toClientList($Page) ?>,
            "m_packing": <?= $Page->m_packing->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "gross_nett": <?= $Page->gross_nett->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbomsearch" id="fbomsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bom">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="bom" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->warp_weft->Visible) { // warp_weft ?>
    <div id="r_warp_weft" class="row"<?= $Page->warp_weft->rowAttributes() ?>>
        <label for="x_warp_weft" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_warp_weft"><?= $Page->warp_weft->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_warp_weft" id="z_warp_weft" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->warp_weft->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_warp_weft" class="ew-search-field ew-search-field-single">
    <select
        id="x_warp_weft"
        name="x_warp_weft"
        class="form-select ew-select<?= $Page->warp_weft->isInvalidClass() ?>"
        <?php if (!$Page->warp_weft->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_warp_weft"
        <?php } ?>
        data-table="bom"
        data-field="x_warp_weft"
        data-value-separator="<?= $Page->warp_weft->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->warp_weft->getPlaceHolder()) ?>"
        <?= $Page->warp_weft->editAttributes() ?>>
        <?= $Page->warp_weft->selectOptionListHtml("x_warp_weft") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->warp_weft->getErrorMessage(false) ?></div>
<?php if (!$Page->warp_weft->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_warp_weft", selectId: "fbomsearch_x_warp_weft" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.warp_weft?.lookupOptions.length) {
        options.data = { id: "x_warp_weft", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_warp_weft", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.warp_weft.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_grp->Visible) { // m_grp ?>
    <div id="r_m_grp" class="row"<?= $Page->m_grp->rowAttributes() ?>>
        <label for="x_m_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_m_grp"><?= $Page->m_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_grp" id="z_m_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_m_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_grp"
        name="x_m_grp"
        class="form-select ew-select<?= $Page->m_grp->isInvalidClass() ?>"
        <?php if (!$Page->m_grp->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_m_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_m_grp"
        data-value-separator="<?= $Page->m_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_grp->editAttributes() ?>>
        <?= $Page->m_grp->selectOptionListHtml("x_m_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_grp->getErrorMessage(false) ?></div>
<?= $Page->m_grp->Lookup->getParamTag($Page, "p_x_m_grp") ?>
<?php if (!$Page->m_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_m_grp", selectId: "fbomsearch_x_m_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.m_grp?.lookupOptions.length) {
        options.data = { id: "x_m_grp", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_m_grp", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_sgrp->Visible) { // m_sgrp ?>
    <div id="r_m_sgrp" class="row"<?= $Page->m_sgrp->rowAttributes() ?>>
        <label for="x_m_sgrp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_m_sgrp"><?= $Page->m_sgrp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_sgrp" id="z_m_sgrp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_sgrp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_m_sgrp" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_sgrp"
        name="x_m_sgrp"
        class="form-select ew-select<?= $Page->m_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->m_sgrp->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_m_sgrp"
        <?php } ?>
        data-table="bom"
        data-field="x_m_sgrp"
        data-value-separator="<?= $Page->m_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_sgrp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_sgrp->editAttributes() ?>>
        <?= $Page->m_sgrp->selectOptionListHtml("x_m_sgrp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_sgrp->getErrorMessage(false) ?></div>
<?= $Page->m_sgrp->Lookup->getParamTag($Page, "p_x_m_sgrp") ?>
<?php if (!$Page->m_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_m_sgrp", selectId: "fbomsearch_x_m_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.m_sgrp?.lookupOptions.length) {
        options.data = { id: "x_m_sgrp", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_m_sgrp", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_product->Visible) { // m_product ?>
    <div id="r_m_product" class="row"<?= $Page->m_product->rowAttributes() ?>>
        <label for="x_m_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_m_product"><?= $Page->m_product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_product" id="z_m_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_m_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_product"
        name="x_m_product"
        class="form-select ew-select<?= $Page->m_product->isInvalidClass() ?>"
        <?php if (!$Page->m_product->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_m_product"
        <?php } ?>
        data-table="bom"
        data-field="x_m_product"
        data-value-separator="<?= $Page->m_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_product->editAttributes() ?>>
        <?= $Page->m_product->selectOptionListHtml("x_m_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_product->getErrorMessage(false) ?></div>
<?= $Page->m_product->Lookup->getParamTag($Page, "p_x_m_product") ?>
<?php if (!$Page->m_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_m_product", selectId: "fbomsearch_x_m_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.m_product?.lookupOptions.length) {
        options.data = { id: "x_m_product", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_m_product", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_rid->Visible) { // m_rid ?>
    <div id="r_m_rid" class="row"<?= $Page->m_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_m_rid"><?= $Page->m_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_m_rid" id="z_m_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_m_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_rid"
        name="x_m_rid"
        class="form-control ew-select<?= $Page->m_rid->isInvalidClass() ?>"
        data-select2-id="fbomsearch_x_m_rid"
        data-table="bom"
        data-field="x_m_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->m_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->m_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_rid->getPlaceHolder()) ?>"
        <?= $Page->m_rid->editAttributes() ?>>
        <?= $Page->m_rid->selectOptionListHtml("x_m_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_rid->getErrorMessage(false) ?></div>
<?= $Page->m_rid->Lookup->getParamTag($Page, "p_x_m_rid") ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_m_rid", selectId: "fbomsearch_x_m_rid" };
    if (fbomsearch.lists.m_rid?.lookupOptions.length) {
        options.data = { id: "x_m_rid", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_m_rid", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.bom.fields.m_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_packing->Visible) { // m_packing ?>
    <div id="r_m_packing" class="row"<?= $Page->m_packing->rowAttributes() ?>>
        <label for="x_m_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_m_packing"><?= $Page->m_packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_packing" id="z_m_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_m_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_packing"
        name="x_m_packing"
        class="form-select ew-select<?= $Page->m_packing->isInvalidClass() ?>"
        <?php if (!$Page->m_packing->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_m_packing"
        <?php } ?>
        data-table="bom"
        data-field="x_m_packing"
        data-value-separator="<?= $Page->m_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_packing->getPlaceHolder()) ?>"
        <?= $Page->m_packing->editAttributes() ?>>
        <?= $Page->m_packing->selectOptionListHtml("x_m_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_packing->getErrorMessage(false) ?></div>
<?= $Page->m_packing->Lookup->getParamTag($Page, "p_x_m_packing") ?>
<?php if (!$Page->m_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_m_packing", selectId: "fbomsearch_x_m_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.m_packing?.lookupOptions.length) {
        options.data = { id: "x_m_packing", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_m_packing", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bom_waste->Visible) { // bom_waste ?>
    <div id="r_bom_waste" class="row"<?= $Page->bom_waste->rowAttributes() ?>>
        <label for="x_bom_waste" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_bom_waste"><?= $Page->bom_waste->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_bom_waste" id="z_bom_waste" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bom_waste->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_bom_waste" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bom_waste->getInputTextType() ?>" name="x_bom_waste" id="x_bom_waste" data-table="bom" data-field="x_bom_waste" value="<?= $Page->bom_waste->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bom_waste->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom_waste->formatPattern()) ?>"<?= $Page->bom_waste->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bom_waste->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_quantity"><?= $Page->quantity->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_quantity" id="z_quantity" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->quantity->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->quantity->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_bom_quantity" class="ew-search-field">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="bom" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_bom_quantity" class="ew-search-field2 d-none">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="y_quantity" id="y_quantity" data-table="bom" data-field="x_quantity" value="<?= $Page->quantity->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_method" id="z_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_method"
        <?php } ?>
        data-table="bom"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_method", selectId: "fbomsearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_method", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_unit"
        <?php } ?>
        data-table="bom"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_unit", selectId: "fbomsearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gross_nett->Visible) { // gross_nett ?>
    <div id="r_gross_nett" class="row"<?= $Page->gross_nett->rowAttributes() ?>>
        <label for="x_gross_nett" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_gross_nett"><?= $Page->gross_nett->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gross_nett" id="z_gross_nett" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gross_nett->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_gross_nett" class="ew-search-field ew-search-field-single">
    <select
        id="x_gross_nett"
        name="x_gross_nett"
        class="form-select ew-select<?= $Page->gross_nett->isInvalidClass() ?>"
        <?php if (!$Page->gross_nett->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_gross_nett"
        <?php } ?>
        data-table="bom"
        data-field="x_gross_nett"
        data-value-separator="<?= $Page->gross_nett->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gross_nett->getPlaceHolder()) ?>"
        <?= $Page->gross_nett->editAttributes() ?>>
        <?= $Page->gross_nett->selectOptionListHtml("x_gross_nett") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gross_nett->getErrorMessage(false) ?></div>
<?php if (!$Page->gross_nett->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_gross_nett", selectId: "fbomsearch_x_gross_nett" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.gross_nett?.lookupOptions.length) {
        options.data = { id: "x_gross_nett", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_gross_nett", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.gross_nett.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_grp", selectId: "fbomsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_s_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_s_grp", selectId: "fbomsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_product"
        <?php } ?>
        data-table="bom"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_product", selectId: "fbomsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_rid"
        <?php } ?>
        data-table="bom"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_rid", selectId: "fbomsearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_packing_type"
        <?php } ?>
        data-table="bom"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_packing_type", selectId: "fbomsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_batch_no" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_x_batch_no" id="sv_x_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_x_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbomsearch", function() {
    fbomsearch.createAutoSuggest(Object.assign({"id":"x_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_batch_no_1" name="v_batch_no" value="AND"<?= ($Page->batch_no->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_batch_no_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_batch_no_2" name="v_batch_no" value="OR"<?= ($Page->batch_no->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_batch_no_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_batch_no" id="w_batch_no" value="=">
</span>
                    <span id="el2_bom_batch_no" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_y_batch_no" id="sv_y_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_y_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="y_batch_no" id="y_batch_no" value="<?= HtmlEncode($Page->batch_no->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbomsearch", function() {
    fbomsearch.createAutoSuggest(Object.assign({"id":"y_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_y_batch_no") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bom_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbomsearch_x_operator"
        <?php } ?>
        data-table="bom"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbomsearch", function() {
    var options = { name: "x_operator", selectId: "fbomsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbomsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbomsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbomsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bom_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_bom_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="bom" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_bom_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="bom" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbomsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbomsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbomsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bom");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
