<?php

namespace PHPMaker2024\fibre;

// Page object
$BomList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bom: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["warp_weft", [fields.warp_weft.visible && fields.warp_weft.required ? ew.Validators.required(fields.warp_weft.caption) : null], fields.warp_weft.isInvalid],
            ["m_grp", [fields.m_grp.visible && fields.m_grp.required ? ew.Validators.required(fields.m_grp.caption) : null], fields.m_grp.isInvalid],
            ["m_sgrp", [fields.m_sgrp.visible && fields.m_sgrp.required ? ew.Validators.required(fields.m_sgrp.caption) : null], fields.m_sgrp.isInvalid],
            ["m_product", [fields.m_product.visible && fields.m_product.required ? ew.Validators.required(fields.m_product.caption) : null], fields.m_product.isInvalid],
            ["m_rid", [fields.m_rid.visible && fields.m_rid.required ? ew.Validators.required(fields.m_rid.caption) : null], fields.m_rid.isInvalid],
            ["m_packing", [fields.m_packing.visible && fields.m_packing.required ? ew.Validators.required(fields.m_packing.caption) : null], fields.m_packing.isInvalid],
            ["quantity_a", [fields.quantity_a.visible && fields.quantity_a.required ? ew.Validators.required(fields.quantity_a.caption) : null, ew.Validators.float], fields.quantity_a.isInvalid],
            ["bom_waste", [fields.bom_waste.visible && fields.bom_waste.required ? ew.Validators.required(fields.bom_waste.caption) : null, ew.Validators.float], fields.bom_waste.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["gross_nett", [fields.gross_nett.visible && fields.gross_nett.required ? ew.Validators.required(fields.gross_nett.caption) : null], fields.gross_nett.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["warp_weft",false],["m_grp",false],["m_sgrp",false],["m_product",false],["m_rid",false],["m_packing",false],["quantity_a",false],["bom_waste",false],["method",false],["unit",false],["gross_nett",false],["grp",false],["s_grp",false],["product",false],["rid",false],["packing_type",false],["batch_no",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "warp_weft": <?= $Page->warp_weft->toClientList($Page) ?>,
            "m_grp": <?= $Page->m_grp->toClientList($Page) ?>,
            "m_sgrp": <?= $Page->m_sgrp->toClientList($Page) ?>,
            "m_product": <?= $Page->m_product->toClientList($Page) ?>,
            "m_rid": <?= $Page->m_rid->toClientList($Page) ?>,
            "m_packing": <?= $Page->m_packing->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "gross_nett": <?= $Page->gross_nett->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbomsrch" id="fbomsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbomsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bom: currentTable } });
var currentForm;
var fbomsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbomsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["batch_no", [], fields.batch_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
<?php
if (!$Page->batch_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_batch_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->batch_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->batch_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</div>
        </div>
        <div id="el_bom_batch_no" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_x_batch_no" id="sv_x_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_x_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbomsrch", function() {
    fbomsrch.createAutoSuggest(Object.assign({"id":"x_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_batch_no_1" name="v_batch_no" value="AND"<?= ($Page->batch_no->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_batch_no_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_batch_no_2" name="v_batch_no" value="OR"<?= ($Page->batch_no->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_batch_no_2"><?= $Language->phrase("OR") ?></label></div></div>
            <div class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_batch_no" id="w_batch_no" value="=">
</div>
        </div><!-- /.ew-search-field -->
        <div id="el2_bom_batch_no" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_y_batch_no" id="sv_y_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_y_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="y_batch_no" id="y_batch_no" value="<?= HtmlEncode($Page->batch_no->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbomsrch", function() {
    fbomsrch.createAutoSuggest(Object.assign({"id":"y_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_y_batch_no") ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbomsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbomsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbomsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbomsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbomsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbomsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbomsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bom">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_bom" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bomlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_bom_id" class="bom_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->warp_weft->Visible) { // warp_weft ?>
        <th data-name="warp_weft" class="<?= $Page->warp_weft->headerCellClass() ?>"><div id="elh_bom_warp_weft" class="bom_warp_weft"><?= $Page->renderFieldHeader($Page->warp_weft) ?></div></th>
<?php } ?>
<?php if ($Page->m_grp->Visible) { // m_grp ?>
        <th data-name="m_grp" class="<?= $Page->m_grp->headerCellClass() ?>"><div id="elh_bom_m_grp" class="bom_m_grp"><?= $Page->renderFieldHeader($Page->m_grp) ?></div></th>
<?php } ?>
<?php if ($Page->m_sgrp->Visible) { // m_sgrp ?>
        <th data-name="m_sgrp" class="<?= $Page->m_sgrp->headerCellClass() ?>"><div id="elh_bom_m_sgrp" class="bom_m_sgrp"><?= $Page->renderFieldHeader($Page->m_sgrp) ?></div></th>
<?php } ?>
<?php if ($Page->m_product->Visible) { // m_product ?>
        <th data-name="m_product" class="<?= $Page->m_product->headerCellClass() ?>"><div id="elh_bom_m_product" class="bom_m_product"><?= $Page->renderFieldHeader($Page->m_product) ?></div></th>
<?php } ?>
<?php if ($Page->m_rid->Visible) { // m_rid ?>
        <th data-name="m_rid" class="<?= $Page->m_rid->headerCellClass() ?>"><div id="elh_bom_m_rid" class="bom_m_rid"><?= $Page->renderFieldHeader($Page->m_rid) ?></div></th>
<?php } ?>
<?php if ($Page->m_packing->Visible) { // m_packing ?>
        <th data-name="m_packing" class="<?= $Page->m_packing->headerCellClass() ?>"><div id="elh_bom_m_packing" class="bom_m_packing"><?= $Page->renderFieldHeader($Page->m_packing) ?></div></th>
<?php } ?>
<?php if ($Page->quantity_a->Visible) { // quantity_a ?>
        <th data-name="quantity_a" class="<?= $Page->quantity_a->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_bom_quantity_a" class="bom_quantity_a"><?= $Page->renderFieldHeader($Page->quantity_a) ?></div></th>
<?php } ?>
<?php if ($Page->bom_waste->Visible) { // bom_waste ?>
        <th data-name="bom_waste" class="<?= $Page->bom_waste->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_bom_bom_waste" class="bom_bom_waste"><?= $Page->renderFieldHeader($Page->bom_waste) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_bom_method" class="bom_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_bom_unit" class="bom_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->gross_nett->Visible) { // gross_nett ?>
        <th data-name="gross_nett" class="<?= $Page->gross_nett->headerCellClass() ?>"><div id="elh_bom_gross_nett" class="bom_gross_nett"><?= $Page->renderFieldHeader($Page->gross_nett) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_bom_grp" class="bom_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_bom_s_grp" class="bom_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_bom_product" class="bom_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_bom_rid" class="bom_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_bom_packing_type" class="bom_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_bom_batch_no" class="bom_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_bom_operator" class="bom_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_bom_datetime" class="bom_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_id" class="el_bom_id"></span>
<input type="hidden" data-table="bom" data-field="x_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_id" id="o<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_id" class="el_bom_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="bom" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_id" class="el_bom_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="bom" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->warp_weft->Visible) { // warp_weft ?>
        <td data-name="warp_weft"<?= $Page->warp_weft->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_warp_weft" class="el_bom_warp_weft">
    <select
        id="x<?= $Page->RowIndex ?>_warp_weft"
        name="x<?= $Page->RowIndex ?>_warp_weft"
        class="form-select ew-select<?= $Page->warp_weft->isInvalidClass() ?>"
        <?php if (!$Page->warp_weft->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_warp_weft"
        <?php } ?>
        data-table="bom"
        data-field="x_warp_weft"
        data-value-separator="<?= $Page->warp_weft->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->warp_weft->getPlaceHolder()) ?>"
        <?= $Page->warp_weft->editAttributes() ?>>
        <?= $Page->warp_weft->selectOptionListHtml("x{$Page->RowIndex}_warp_weft") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->warp_weft->getErrorMessage() ?></div>
<?php if (!$Page->warp_weft->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_warp_weft", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_warp_weft" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.warp_weft?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_warp_weft", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_warp_weft", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.warp_weft.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_warp_weft" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_warp_weft" id="o<?= $Page->RowIndex ?>_warp_weft" value="<?= HtmlEncode($Page->warp_weft->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_warp_weft" class="el_bom_warp_weft">
    <select
        id="x<?= $Page->RowIndex ?>_warp_weft"
        name="x<?= $Page->RowIndex ?>_warp_weft"
        class="form-select ew-select<?= $Page->warp_weft->isInvalidClass() ?>"
        <?php if (!$Page->warp_weft->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_warp_weft"
        <?php } ?>
        data-table="bom"
        data-field="x_warp_weft"
        data-value-separator="<?= $Page->warp_weft->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->warp_weft->getPlaceHolder()) ?>"
        <?= $Page->warp_weft->editAttributes() ?>>
        <?= $Page->warp_weft->selectOptionListHtml("x{$Page->RowIndex}_warp_weft") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->warp_weft->getErrorMessage() ?></div>
<?php if (!$Page->warp_weft->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_warp_weft", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_warp_weft" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.warp_weft?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_warp_weft", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_warp_weft", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.warp_weft.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_warp_weft" class="el_bom_warp_weft">
<span<?= $Page->warp_weft->viewAttributes() ?>>
<?= $Page->warp_weft->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->m_grp->Visible) { // m_grp ?>
        <td data-name="m_grp"<?= $Page->m_grp->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_grp" class="el_bom_m_grp">
    <select
        id="x<?= $Page->RowIndex ?>_m_grp"
        name="x<?= $Page->RowIndex ?>_m_grp"
        class="form-select ew-select<?= $Page->m_grp->isInvalidClass() ?>"
        <?php if (!$Page->m_grp->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_m_grp"
        data-value-separator="<?= $Page->m_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_grp->editAttributes() ?>>
        <?= $Page->m_grp->selectOptionListHtml("x{$Page->RowIndex}_m_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_grp->getErrorMessage() ?></div>
<?= $Page->m_grp->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_m_grp") ?>
<?php if (!$Page->m_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_m_grp", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.m_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_m_grp", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_m_grp", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_m_grp" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_m_grp" id="o<?= $Page->RowIndex ?>_m_grp" value="<?= HtmlEncode($Page->m_grp->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_grp" class="el_bom_m_grp">
<span<?= $Page->m_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->m_grp->EditValue) && $Page->m_grp->linkAttributes() != "") { ?>
<a<?= $Page->m_grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->m_grp->getDisplayValue($Page->m_grp->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->m_grp->getDisplayValue($Page->m_grp->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_m_grp" data-hidden="1" name="x<?= $Page->RowIndex ?>_m_grp" id="x<?= $Page->RowIndex ?>_m_grp" value="<?= HtmlEncode($Page->m_grp->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_grp" class="el_bom_m_grp">
<span<?= $Page->m_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->m_grp->getViewValue()) && $Page->m_grp->linkAttributes() != "") { ?>
<a<?= $Page->m_grp->linkAttributes() ?>><?= $Page->m_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->m_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->m_sgrp->Visible) { // m_sgrp ?>
        <td data-name="m_sgrp"<?= $Page->m_sgrp->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_sgrp" class="el_bom_m_sgrp">
    <select
        id="x<?= $Page->RowIndex ?>_m_sgrp"
        name="x<?= $Page->RowIndex ?>_m_sgrp"
        class="form-select ew-select<?= $Page->m_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->m_sgrp->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_sgrp"
        <?php } ?>
        data-table="bom"
        data-field="x_m_sgrp"
        data-value-separator="<?= $Page->m_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_sgrp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_sgrp->editAttributes() ?>>
        <?= $Page->m_sgrp->selectOptionListHtml("x{$Page->RowIndex}_m_sgrp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_sgrp->getErrorMessage() ?></div>
<?= $Page->m_sgrp->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_m_sgrp") ?>
<?php if (!$Page->m_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_m_sgrp", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.m_sgrp?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_m_sgrp", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_m_sgrp", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_m_sgrp" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_m_sgrp" id="o<?= $Page->RowIndex ?>_m_sgrp" value="<?= HtmlEncode($Page->m_sgrp->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_sgrp" class="el_bom_m_sgrp">
<span<?= $Page->m_sgrp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->m_sgrp->getDisplayValue($Page->m_sgrp->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_m_sgrp" data-hidden="1" name="x<?= $Page->RowIndex ?>_m_sgrp" id="x<?= $Page->RowIndex ?>_m_sgrp" value="<?= HtmlEncode($Page->m_sgrp->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_sgrp" class="el_bom_m_sgrp">
<span<?= $Page->m_sgrp->viewAttributes() ?>>
<?= $Page->m_sgrp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->m_product->Visible) { // m_product ?>
        <td data-name="m_product"<?= $Page->m_product->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_product" class="el_bom_m_product">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Page->RowIndex ?>_m_product"
        name="x<?= $Page->RowIndex ?>_m_product"
        class="form-select ew-select<?= $Page->m_product->isInvalidClass() ?>"
        <?php if (!$Page->m_product->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_product"
        <?php } ?>
        data-table="bom"
        data-field="x_m_product"
        data-value-separator="<?= $Page->m_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->m_product->editAttributes() ?>>
        <?= $Page->m_product->selectOptionListHtml("x{$Page->RowIndex}_m_product") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "product_view") && !$Page->m_product->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Page->RowIndex ?>_m_product" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->m_product->caption() ?>" data-title="<?= $Page->m_product->caption() ?>" data-ew-action="add-option" data-el="x<?= $Page->RowIndex ?>_m_product" data-url="<?= GetUrl("productview2addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Page->m_product->getErrorMessage() ?></div>
<?= $Page->m_product->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_m_product") ?>
<?php if (!$Page->m_product->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_m_product", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.m_product?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_m_product", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_m_product", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_m_product" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_m_product" id="o<?= $Page->RowIndex ?>_m_product" value="<?= HtmlEncode($Page->m_product->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_product" class="el_bom_m_product">
<span<?= $Page->m_product->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->m_product->getDisplayValue($Page->m_product->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_m_product" data-hidden="1" name="x<?= $Page->RowIndex ?>_m_product" id="x<?= $Page->RowIndex ?>_m_product" value="<?= HtmlEncode($Page->m_product->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_product" class="el_bom_m_product">
<span<?= $Page->m_product->viewAttributes() ?>>
<?= $Page->m_product->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->m_rid->Visible) { // m_rid ?>
        <td data-name="m_rid"<?= $Page->m_rid->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_rid" class="el_bom_m_rid">
    <select
        id="x<?= $Page->RowIndex ?>_m_rid"
        name="x<?= $Page->RowIndex ?>_m_rid"
        class="form-control ew-select<?= $Page->m_rid->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_rid"
        data-table="bom"
        data-field="x_m_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->m_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->m_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_rid->getPlaceHolder()) ?>"
        <?= $Page->m_rid->editAttributes() ?>>
        <?= $Page->m_rid->selectOptionListHtml("x{$Page->RowIndex}_m_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_rid->getErrorMessage() ?></div>
<?= $Page->m_rid->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_m_rid") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_m_rid", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_rid" };
    if (<?= $Page->FormName ?>.lists.m_rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_m_rid", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_m_rid", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.bom.fields.m_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="bom" data-field="x_m_rid" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_m_rid" id="o<?= $Page->RowIndex ?>_m_rid" value="<?= HtmlEncode($Page->m_rid->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_rid" class="el_bom_m_rid">
<span<?= $Page->m_rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->m_rid->getDisplayValue($Page->m_rid->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_m_rid" data-hidden="1" name="x<?= $Page->RowIndex ?>_m_rid" id="x<?= $Page->RowIndex ?>_m_rid" value="<?= HtmlEncode($Page->m_rid->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_rid" class="el_bom_m_rid">
<span<?= $Page->m_rid->viewAttributes() ?>>
<?= $Page->m_rid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->m_packing->Visible) { // m_packing ?>
        <td data-name="m_packing"<?= $Page->m_packing->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_packing" class="el_bom_m_packing">
    <select
        id="x<?= $Page->RowIndex ?>_m_packing"
        name="x<?= $Page->RowIndex ?>_m_packing"
        class="form-select ew-select<?= $Page->m_packing->isInvalidClass() ?>"
        <?php if (!$Page->m_packing->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_packing"
        <?php } ?>
        data-table="bom"
        data-field="x_m_packing"
        data-value-separator="<?= $Page->m_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_packing->getPlaceHolder()) ?>"
        <?= $Page->m_packing->editAttributes() ?>>
        <?= $Page->m_packing->selectOptionListHtml("x{$Page->RowIndex}_m_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_packing->getErrorMessage() ?></div>
<?= $Page->m_packing->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_m_packing") ?>
<?php if (!$Page->m_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_m_packing", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_m_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.m_packing?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_m_packing", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_m_packing", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.m_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_m_packing" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_m_packing" id="o<?= $Page->RowIndex ?>_m_packing" value="<?= HtmlEncode($Page->m_packing->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_packing" class="el_bom_m_packing">
<span<?= $Page->m_packing->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->m_packing->getDisplayValue($Page->m_packing->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_m_packing" data-hidden="1" name="x<?= $Page->RowIndex ?>_m_packing" id="x<?= $Page->RowIndex ?>_m_packing" value="<?= HtmlEncode($Page->m_packing->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_m_packing" class="el_bom_m_packing">
<span<?= $Page->m_packing->viewAttributes() ?>>
<?= $Page->m_packing->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->quantity_a->Visible) { // quantity_a ?>
        <td data-name="quantity_a"<?= $Page->quantity_a->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_quantity_a" class="el_bom_quantity_a">
<input type="<?= $Page->quantity_a->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_quantity_a" id="x<?= $Page->RowIndex ?>_quantity_a" data-table="bom" data-field="x_quantity_a" value="<?= $Page->quantity_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_a->formatPattern()) ?>"<?= $Page->quantity_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_a->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bom" data-field="x_quantity_a" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_quantity_a" id="o<?= $Page->RowIndex ?>_quantity_a" value="<?= HtmlEncode($Page->quantity_a->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_quantity_a" class="el_bom_quantity_a">
<input type="<?= $Page->quantity_a->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_quantity_a" id="x<?= $Page->RowIndex ?>_quantity_a" data-table="bom" data-field="x_quantity_a" value="<?= $Page->quantity_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_a->formatPattern()) ?>"<?= $Page->quantity_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_a->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_quantity_a" class="el_bom_quantity_a">
<span<?= $Page->quantity_a->viewAttributes() ?>>
<?= $Page->quantity_a->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->bom_waste->Visible) { // bom_waste ?>
        <td data-name="bom_waste"<?= $Page->bom_waste->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_bom_waste" class="el_bom_bom_waste">
<input type="<?= $Page->bom_waste->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_bom_waste" id="x<?= $Page->RowIndex ?>_bom_waste" data-table="bom" data-field="x_bom_waste" value="<?= $Page->bom_waste->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bom_waste->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom_waste->formatPattern()) ?>"<?= $Page->bom_waste->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bom_waste->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bom" data-field="x_bom_waste" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_bom_waste" id="o<?= $Page->RowIndex ?>_bom_waste" value="<?= HtmlEncode($Page->bom_waste->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_bom_waste" class="el_bom_bom_waste">
<input type="<?= $Page->bom_waste->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_bom_waste" id="x<?= $Page->RowIndex ?>_bom_waste" data-table="bom" data-field="x_bom_waste" value="<?= $Page->bom_waste->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bom_waste->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom_waste->formatPattern()) ?>"<?= $Page->bom_waste->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bom_waste->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_bom_waste" class="el_bom_bom_waste">
<span<?= $Page->bom_waste->viewAttributes() ?>>
<?= $Page->bom_waste->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_method" class="el_bom_method">
    <select
        id="x<?= $Page->RowIndex ?>_method"
        name="x<?= $Page->RowIndex ?>_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_method"
        <?php } ?>
        data-table="bom"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x{$Page->RowIndex}_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_method", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.method?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_method", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_method", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_method" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_method" id="o<?= $Page->RowIndex ?>_method" value="<?= HtmlEncode($Page->method->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_method" class="el_bom_method">
    <select
        id="x<?= $Page->RowIndex ?>_method"
        name="x<?= $Page->RowIndex ?>_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_method"
        <?php } ?>
        data-table="bom"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x{$Page->RowIndex}_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_method", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.method?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_method", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_method", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_method" class="el_bom_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_unit" class="el_bom_unit">
    <select
        id="x<?= $Page->RowIndex ?>_unit"
        name="x<?= $Page->RowIndex ?>_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_unit"
        <?php } ?>
        data-table="bom"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x{$Page->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_unit", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_unit", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_unit", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_unit" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_unit" id="o<?= $Page->RowIndex ?>_unit" value="<?= HtmlEncode($Page->unit->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_unit" class="el_bom_unit">
    <select
        id="x<?= $Page->RowIndex ?>_unit"
        name="x<?= $Page->RowIndex ?>_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_unit"
        <?php } ?>
        data-table="bom"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x{$Page->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_unit", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_unit", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_unit", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_unit" class="el_bom_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?= $Page->unit->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->gross_nett->Visible) { // gross_nett ?>
        <td data-name="gross_nett"<?= $Page->gross_nett->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_gross_nett" class="el_bom_gross_nett">
    <select
        id="x<?= $Page->RowIndex ?>_gross_nett"
        name="x<?= $Page->RowIndex ?>_gross_nett"
        class="form-select ew-select<?= $Page->gross_nett->isInvalidClass() ?>"
        <?php if (!$Page->gross_nett->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_gross_nett"
        <?php } ?>
        data-table="bom"
        data-field="x_gross_nett"
        data-value-separator="<?= $Page->gross_nett->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gross_nett->getPlaceHolder()) ?>"
        <?= $Page->gross_nett->editAttributes() ?>>
        <?= $Page->gross_nett->selectOptionListHtml("x{$Page->RowIndex}_gross_nett") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gross_nett->getErrorMessage() ?></div>
<?php if (!$Page->gross_nett->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_gross_nett", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_gross_nett" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.gross_nett?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_gross_nett", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_gross_nett", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.gross_nett.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_gross_nett" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_gross_nett" id="o<?= $Page->RowIndex ?>_gross_nett" value="<?= HtmlEncode($Page->gross_nett->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_gross_nett" class="el_bom_gross_nett">
    <select
        id="x<?= $Page->RowIndex ?>_gross_nett"
        name="x<?= $Page->RowIndex ?>_gross_nett"
        class="form-select ew-select<?= $Page->gross_nett->isInvalidClass() ?>"
        <?php if (!$Page->gross_nett->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_gross_nett"
        <?php } ?>
        data-table="bom"
        data-field="x_gross_nett"
        data-value-separator="<?= $Page->gross_nett->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gross_nett->getPlaceHolder()) ?>"
        <?= $Page->gross_nett->editAttributes() ?>>
        <?= $Page->gross_nett->selectOptionListHtml("x{$Page->RowIndex}_gross_nett") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gross_nett->getErrorMessage() ?></div>
<?php if (!$Page->gross_nett->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_gross_nett", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_gross_nett" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.gross_nett?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_gross_nett", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_gross_nett", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.gross_nett.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_gross_nett" class="el_bom_gross_nett">
<span<?= $Page->gross_nett->viewAttributes() ?>>
<?= $Page->gross_nett->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_grp" class="el_bom_grp">
    <select
        id="x<?= $Page->RowIndex ?>_grp"
        name="x<?= $Page->RowIndex ?>_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x{$Page->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_grp", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_grp", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_grp", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_grp" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_grp" id="o<?= $Page->RowIndex ?>_grp" value="<?= HtmlEncode($Page->grp->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_grp" class="el_bom_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_grp" data-hidden="1" name="x<?= $Page->RowIndex ?>_grp" id="x<?= $Page->RowIndex ?>_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_grp" class="el_bom_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_s_grp" class="el_bom_s_grp">
    <select
        id="x<?= $Page->RowIndex ?>_s_grp"
        name="x<?= $Page->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="bom"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x{$Page->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_s_grp", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_s_grp", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_s_grp", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_s_grp" id="o<?= $Page->RowIndex ?>_s_grp" value="<?= HtmlEncode($Page->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_s_grp" class="el_bom_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_s_grp" data-hidden="1" name="x<?= $Page->RowIndex ?>_s_grp" id="x<?= $Page->RowIndex ?>_s_grp" value="<?= HtmlEncode($Page->s_grp->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_s_grp" class="el_bom_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_product" class="el_bom_product">
    <select
        id="x<?= $Page->RowIndex ?>_product"
        name="x<?= $Page->RowIndex ?>_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_product"
        <?php } ?>
        data-table="bom"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x{$Page->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_product", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_product", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_product", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_product" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_product" id="o<?= $Page->RowIndex ?>_product" value="<?= HtmlEncode($Page->product->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_product" class="el_bom_product">
<span<?= $Page->product->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_product" data-hidden="1" name="x<?= $Page->RowIndex ?>_product" id="x<?= $Page->RowIndex ?>_product" value="<?= HtmlEncode($Page->product->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_product" class="el_bom_product">
<span<?= $Page->product->viewAttributes() ?>>
<?= $Page->product->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_rid" class="el_bom_rid">
    <select
        id="x<?= $Page->RowIndex ?>_rid"
        name="x<?= $Page->RowIndex ?>_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_rid"
        <?php } ?>
        data-table="bom"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x{$Page->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_rid", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_rid", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_rid", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_rid" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_rid" id="o<?= $Page->RowIndex ?>_rid" value="<?= HtmlEncode($Page->rid->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_rid" class="el_bom_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->rid->getDisplayValue($Page->rid->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_rid" data-hidden="1" name="x<?= $Page->RowIndex ?>_rid" id="x<?= $Page->RowIndex ?>_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_rid" class="el_bom_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_packing_type" class="el_bom_packing_type">
    <select
        id="x<?= $Page->RowIndex ?>_packing_type"
        name="x<?= $Page->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="bom"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x{$Page->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_packing_type", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_packing_type", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_packing_type", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bom.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bom" data-field="x_packing_type" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_packing_type" id="o<?= $Page->RowIndex ?>_packing_type" value="<?= HtmlEncode($Page->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_packing_type" class="el_bom_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->packing_type->getDisplayValue($Page->packing_type->EditValue) ?></span></span>
<input type="hidden" data-table="bom" data-field="x_packing_type" data-hidden="1" name="x<?= $Page->RowIndex ?>_packing_type" id="x<?= $Page->RowIndex ?>_packing_type" value="<?= HtmlEncode($Page->packing_type->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_packing_type" class="el_bom_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_batch_no" class="el_bom_batch_no">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_batch_no" id="sv_x<?= $Page->RowIndex ?>_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_x<?= $Page->RowIndex ?>_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_batch_no" id="x<?= $Page->RowIndex ?>_batch_no" value="<?= HtmlEncode($Page->batch_no->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_batch_no") ?>
</span>
<input type="hidden" data-table="bom" data-field="x_batch_no" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_batch_no" id="o<?= $Page->RowIndex ?>_batch_no" value="<?= HtmlEncode($Page->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_batch_no" class="el_bom_batch_no">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_batch_no" id="sv_x<?= $Page->RowIndex ?>_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bom" data-field="x_batch_no" data-input="sv_x<?= $Page->RowIndex ?>_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_batch_no" id="x<?= $Page->RowIndex ?>_batch_no" value="<?= HtmlEncode($Page->batch_no->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bom.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_batch_no") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_batch_no" class="el_bom_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="bom" data-field="x_operator" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_operator" id="o<?= $Page->RowIndex ?>_operator" value="<?= HtmlEncode($Page->operator->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_operator" class="el_bom_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="bom" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_datetime" id="o<?= $Page->RowIndex ?>_datetime" value="<?= HtmlEncode($Page->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bom_datetime" class="el_bom_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_bom_id" class="bom_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->warp_weft->Visible) { // warp_weft ?>
        <td data-name="warp_weft" class="<?= $Page->warp_weft->footerCellClass() ?>"><span id="elf_bom_warp_weft" class="bom_warp_weft">
        </span></td>
    <?php } ?>
    <?php if ($Page->m_grp->Visible) { // m_grp ?>
        <td data-name="m_grp" class="<?= $Page->m_grp->footerCellClass() ?>"><span id="elf_bom_m_grp" class="bom_m_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->m_sgrp->Visible) { // m_sgrp ?>
        <td data-name="m_sgrp" class="<?= $Page->m_sgrp->footerCellClass() ?>"><span id="elf_bom_m_sgrp" class="bom_m_sgrp">
        </span></td>
    <?php } ?>
    <?php if ($Page->m_product->Visible) { // m_product ?>
        <td data-name="m_product" class="<?= $Page->m_product->footerCellClass() ?>"><span id="elf_bom_m_product" class="bom_m_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->m_rid->Visible) { // m_rid ?>
        <td data-name="m_rid" class="<?= $Page->m_rid->footerCellClass() ?>"><span id="elf_bom_m_rid" class="bom_m_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->m_packing->Visible) { // m_packing ?>
        <td data-name="m_packing" class="<?= $Page->m_packing->footerCellClass() ?>"><span id="elf_bom_m_packing" class="bom_m_packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity_a->Visible) { // quantity_a ?>
        <td data-name="quantity_a" class="<?= $Page->quantity_a->footerCellClass() ?>"><span id="elf_bom_quantity_a" class="bom_quantity_a">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity_a->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->bom_waste->Visible) { // bom_waste ?>
        <td data-name="bom_waste" class="<?= $Page->bom_waste->footerCellClass() ?>"><span id="elf_bom_bom_waste" class="bom_bom_waste">
        </span></td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method" class="<?= $Page->method->footerCellClass() ?>"><span id="elf_bom_method" class="bom_method">
        </span></td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit" class="<?= $Page->unit->footerCellClass() ?>"><span id="elf_bom_unit" class="bom_unit">
        </span></td>
    <?php } ?>
    <?php if ($Page->gross_nett->Visible) { // gross_nett ?>
        <td data-name="gross_nett" class="<?= $Page->gross_nett->footerCellClass() ?>"><span id="elf_bom_gross_nett" class="bom_gross_nett">
        </span></td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_bom_grp" class="bom_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Page->s_grp->footerCellClass() ?>"><span id="elf_bom_s_grp" class="bom_s_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_bom_product" class="bom_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_bom_rid" class="bom_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_bom_packing_type" class="bom_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_bom_batch_no" class="bom_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_bom_operator" class="bom_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_bom_datetime" class="bom_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bom");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
