<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fbcodeupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbcodeupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["order_date", [fields.order_date.visible && fields.order_date.required ? ew.Validators.required(fields.order_date.caption) : null, ew.Validators.datetime(fields.order_date.clientFormatPattern), ew.Validators.selected], fields.order_date.isInvalid],
            ["dispatch_week_p", [fields.dispatch_week_p.visible && fields.dispatch_week_p.required ? ew.Validators.required(fields.dispatch_week_p.caption) : null], fields.dispatch_week_p.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["current_works", [fields.current_works.visible && fields.current_works.required ? ew.Validators.required(fields.current_works.caption) : null], fields.current_works.isInvalid],
            ["po_price", [fields.po_price.visible && fields.po_price.required ? ew.Validators.required(fields.po_price.caption) : null], fields.po_price.isInvalid],
            ["po_discount", [fields.po_discount.visible && fields.po_discount.required ? ew.Validators.required(fields.po_discount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.po_discount.isInvalid],
            ["po_currency", [fields.po_currency.visible && fields.po_currency.required ? ew.Validators.required(fields.po_currency.caption) : null], fields.po_currency.isInvalid],
            ["completed", [fields.completed.visible && fields.completed.required ? ew.Validators.required(fields.completed.caption) : null], fields.completed.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "dispatch_week_p": <?= $Page->dispatch_week_p->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "po_currency": <?= $Page->po_currency->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbcodeupdate" id="fbcodeupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_bcodeupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->order_date->Visible && (!$Page->isConfirm() || $Page->order_date->multiUpdateSelected())) { // order_date ?>
    <div id="r_order_date"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_order_date" id="u_order_date" class="form-check-input ew-multi-select" value="1"<?= $Page->order_date->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_order_date"><?= $Page->order_date->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_order_date" id="u_order_date" value="<?= $Page->order_date->MultiUpdate ?>">
            <?= $Page->order_date->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_order_date">
                <input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="bcode" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?> aria-describedby="x_order_date_help">
                <?= $Page->order_date->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->order_date->getErrorMessage() ?></div>
                <?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fbcodeupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(111) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fbcodeupdate", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_bcode_order_date">
                <span<?= $Page->order_date->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->order_date->getDisplayValue($Page->order_date->ViewValue))) ?>"></span>
                <input type="hidden" data-table="bcode" data-field="x_order_date" data-hidden="1" name="x_order_date" id="x_order_date" value="<?= HtmlEncode($Page->order_date->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible && (!$Page->isConfirm() || $Page->buyer_loc->multiUpdateSelected())) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_loc" id="u_buyer_loc" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_loc->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_loc"><?= $Page->buyer_loc->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_loc" id="u_buyer_loc" value="<?= $Page->buyer_loc->MultiUpdate ?>">
            <?= $Page->buyer_loc->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_buyer_loc">
                <input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="bcode" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help">
                <?= $Page->buyer_loc->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_bcode_buyer_loc">
                <span<?= $Page->buyer_loc->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_loc->getDisplayValue($Page->buyer_loc->ViewValue))) ?>"></span>
                <input type="hidden" data-table="bcode" data-field="x_buyer_loc" data-hidden="1" name="x_buyer_loc" id="x_buyer_loc" value="<?= HtmlEncode($Page->buyer_loc->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible && (!$Page->isConfirm() || $Page->weaving_works->multiUpdateSelected())) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_weaving_works" id="u_weaving_works" class="form-check-input ew-multi-select" value="1"<?= $Page->weaving_works->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_weaving_works"><?= $Page->weaving_works->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_weaving_works" id="u_weaving_works" value="<?= $Page->weaving_works->MultiUpdate ?>">
            <?= $Page->weaving_works->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_weaving_works">
                    <select
                        id="x_weaving_works"
                        name="x_weaving_works"
                        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
                        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                        data-select2-id="fbcodeupdate_x_weaving_works"
                        <?php } ?>
                        data-table="bcode"
                        data-field="x_weaving_works"
                        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
                        <?= $Page->weaving_works->editAttributes() ?>>
                        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
                    </select>
                    <?= $Page->weaving_works->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
                <?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
                <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbcodeupdate", function() {
                    var options = { name: "x_weaving_works", selectId: "fbcodeupdate_x_weaving_works" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbcodeupdate.lists.weaving_works?.lookupOptions.length) {
                        options.data = { id: "x_weaving_works", form: "fbcodeupdate" };
                    } else {
                        options.ajax = { id: "x_weaving_works", form: "fbcodeupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.weaving_works.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_bcode_weaving_works">
                <span<?= $Page->weaving_works->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->weaving_works->getDisplayValue($Page->weaving_works->ViewValue) ?></span></span>
                <input type="hidden" data-table="bcode" data-field="x_weaving_works" data-hidden="1" name="x_weaving_works" id="x_weaving_works" value="<?= HtmlEncode($Page->weaving_works->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible && (!$Page->isConfirm() || $Page->current_works->multiUpdateSelected())) { // current_works ?>
    <div id="r_current_works"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_current_works" id="u_current_works" class="form-check-input ew-multi-select" value="1"<?= $Page->current_works->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_current_works"><?= $Page->current_works->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_current_works" id="u_current_works" value="<?= $Page->current_works->MultiUpdate ?>">
            <?= $Page->current_works->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_current_works">
                    <select
                        id="x_current_works"
                        name="x_current_works"
                        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
                        <?php if (!$Page->current_works->IsNativeSelect) { ?>
                        data-select2-id="fbcodeupdate_x_current_works"
                        <?php } ?>
                        data-table="bcode"
                        data-field="x_current_works"
                        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
                        <?= $Page->current_works->editAttributes() ?>>
                        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
                    </select>
                    <?= $Page->current_works->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage() ?></div>
                <?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
                <?php if (!$Page->current_works->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbcodeupdate", function() {
                    var options = { name: "x_current_works", selectId: "fbcodeupdate_x_current_works" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbcodeupdate.lists.current_works?.lookupOptions.length) {
                        options.data = { id: "x_current_works", form: "fbcodeupdate" };
                    } else {
                        options.ajax = { id: "x_current_works", form: "fbcodeupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.current_works.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_bcode_current_works">
                <span<?= $Page->current_works->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->current_works->getDisplayValue($Page->current_works->ViewValue) ?></span></span>
                <input type="hidden" data-table="bcode" data-field="x_current_works" data-hidden="1" name="x_current_works" id="x_current_works" value="<?= HtmlEncode($Page->current_works->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible && (!$Page->isConfirm() || $Page->po_discount->multiUpdateSelected())) { // po_discount ?>
    <div id="r_po_discount"<?= $Page->po_discount->rowAttributes() ?>>
        <label for="x_po_discount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_po_discount" id="u_po_discount" class="form-check-input ew-multi-select" value="1"<?= $Page->po_discount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_po_discount"><?= $Page->po_discount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_po_discount" id="u_po_discount" value="<?= $Page->po_discount->MultiUpdate ?>">
            <?= $Page->po_discount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_discount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_po_discount">
                <input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="bcode" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?> aria-describedby="x_po_discount_help">
                <?= $Page->po_discount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_bcode_po_discount">
                <span<?= $Page->po_discount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po_discount->getDisplayValue($Page->po_discount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="bcode" data-field="x_po_discount" data-hidden="1" name="x_po_discount" id="x_po_discount" value="<?= HtmlEncode($Page->po_discount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible && (!$Page->isConfirm() || $Page->completed->multiUpdateSelected())) { // completed ?>
    <div id="r_completed"<?= $Page->completed->rowAttributes() ?>>
        <label for="x_completed" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_completed" id="u_completed" class="form-check-input ew-multi-select" value="1"<?= $Page->completed->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_completed"><?= $Page->completed->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_completed" id="u_completed" value="<?= $Page->completed->MultiUpdate ?>">
            <?= $Page->completed->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_completed">
                    <select
                        id="x_completed"
                        name="x_completed"
                        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
                        <?php if (!$Page->completed->IsNativeSelect) { ?>
                        data-select2-id="fbcodeupdate_x_completed"
                        <?php } ?>
                        data-table="bcode"
                        data-field="x_completed"
                        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
                        <?= $Page->completed->editAttributes() ?>>
                        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
                    </select>
                    <?= $Page->completed->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage() ?></div>
                <?php if (!$Page->completed->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbcodeupdate", function() {
                    var options = { name: "x_completed", selectId: "fbcodeupdate_x_completed" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbcodeupdate.lists.completed?.lookupOptions.length) {
                        options.data = { id: "x_completed", form: "fbcodeupdate" };
                    } else {
                        options.ajax = { id: "x_completed", form: "fbcodeupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.completed.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_bcode_completed">
                <span<?= $Page->completed->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->completed->getDisplayValue($Page->completed->ViewValue) ?></span></span>
                <input type="hidden" data-table="bcode" data-field="x_completed" data-hidden="1" name="x_completed" id="x_completed" value="<?= HtmlEncode($Page->completed->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcodeupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbcodeupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcodeupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fbcodeupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
