<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeTokenUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_token: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fbcode_tokenupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbcode_tokenupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbcode_tokenupdate" id="fbcode_tokenupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode_token">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_bcode_tokenupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->weaving_works->Visible && (!$Page->isConfirm() || $Page->weaving_works->multiUpdateSelected())) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_weaving_works" id="u_weaving_works" class="form-check-input ew-multi-select" value="1"<?= $Page->weaving_works->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_weaving_works"><?= $Page->weaving_works->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_weaving_works" id="u_weaving_works" value="<?= $Page->weaving_works->MultiUpdate ?>">
            <?= $Page->weaving_works->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_bcode_token_weaving_works">
                    <select
                        id="x_weaving_works"
                        name="x_weaving_works"
                        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
                        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                        data-select2-id="fbcode_tokenupdate_x_weaving_works"
                        <?php } ?>
                        data-table="bcode_token"
                        data-field="x_weaving_works"
                        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
                        <?= $Page->weaving_works->editAttributes() ?>>
                        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
                    </select>
                    <?= $Page->weaving_works->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
                <?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
                <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbcode_tokenupdate", function() {
                    var options = { name: "x_weaving_works", selectId: "fbcode_tokenupdate_x_weaving_works" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbcode_tokenupdate.lists.weaving_works?.lookupOptions.length) {
                        options.data = { id: "x_weaving_works", form: "fbcode_tokenupdate" };
                    } else {
                        options.ajax = { id: "x_weaving_works", form: "fbcode_tokenupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.weaving_works.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_bcode_token_weaving_works">
                <span<?= $Page->weaving_works->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->weaving_works->getDisplayValue($Page->weaving_works->ViewValue) ?></span></span>
                <input type="hidden" data-table="bcode_token" data-field="x_weaving_works" data-hidden="1" name="x_weaving_works" id="x_weaving_works" value="<?= HtmlEncode($Page->weaving_works->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcode_tokenupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbcode_tokenupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcode_tokenupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fbcode_tokenupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode_token");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
