<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeTokenList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_token: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["buyer_uid", [fields.buyer_uid.visible && fields.buyer_uid.required ? ew.Validators.required(fields.buyer_uid.caption) : null], fields.buyer_uid.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbcode_tokensrch" id="fbcode_tokensrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbcode_tokensrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_token: currentTable } });
var currentForm;
var fbcode_tokensrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbcode_tokensrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [], fields.po.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["weaving_works", [], fields.weaving_works.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</div>
        </div>
        <div id="el_bcode_token_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="bcode_token" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="=">
</div>
        </div>
        <div id="el_bcode_token__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="bcode_token" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
<?php
if (!$Page->buyer_uid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_uid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_uid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_uid" class="ew-search-caption ew-label"><?= $Page->buyer_uid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</div>
        </div>
        <div id="el_bcode_token_buyer_uid" class="ew-search-field">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="bcode_token" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
<?php
if (!$Page->design_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_design_id" class="ew-search-caption ew-label"><?= $Page->design_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</div>
        </div>
        <div id="el_bcode_token_design_id" class="ew-search-field">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fbcode_tokensrch_x_design_id"
        <?php } ?>
        data-table="bcode_token"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_tokensrch", function() {
    var options = { name: "x_design_id", selectId: "fbcode_tokensrch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_tokensrch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fbcode_tokensrch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fbcode_tokensrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
<?php
if (!$Page->weaving_works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_weaving_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->weaving_works->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_weaving_works" class="ew-search-caption ew-label"><?= $Page->weaving_works->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</div>
        </div>
        <div id="el_bcode_token_weaving_works" class="ew-search-field">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbcode_tokensrch_x_weaving_works"
        <?php } ?>
        data-table="bcode_token"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_tokensrch", function() {
    var options = { name: "x_weaving_works", selectId: "fbcode_tokensrch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_tokensrch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbcode_tokensrch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbcode_tokensrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbcode_tokensrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbcode_tokensrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbcode_tokensrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbcode_tokensrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbcode_tokensrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbcode_tokensrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbcode_tokensrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode_token">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_bcode_token" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bcode_tokenlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_bcode_token_id" class="bcode_token_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_bcode_token_po" class="bcode_token_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_bcode_token__barcode" class="bcode_token__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>"><div id="elh_bcode_token_buyer_uid" class="bcode_token_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
        <th data-name="design_id" class="<?= $Page->design_id->headerCellClass() ?>"><div id="elh_bcode_token_design_id" class="bcode_token_design_id"><?= $Page->renderFieldHeader($Page->design_id) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_bcode_token_size_cm" class="bcode_token_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>"><div id="elh_bcode_token_weaving_works" class="bcode_token_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_id" class="el_bcode_token_id"></span>
<input type="hidden" data-table="bcode_token" data-field="x_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_id" id="o<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_id" class="el_bcode_token_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_token" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_id" class="el_bcode_token_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="bcode_token" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_po" class="el_bcode_token_po">
<input type="<?= $Page->po->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_po" id="x<?= $Page->RowIndex ?>_po" data-table="bcode_token" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_po" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_po" id="o<?= $Page->RowIndex ?>_po" value="<?= HtmlEncode($Page->po->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_po" class="el_bcode_token_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_token" data-field="x_po" data-hidden="1" name="x<?= $Page->RowIndex ?>_po" id="x<?= $Page->RowIndex ?>_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_po" class="el_bcode_token_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token__barcode" class="el_bcode_token__barcode">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>__barcode" id="x<?= $Page->RowIndex ?>__barcode" data-table="bcode_token" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>__barcode" id="o<?= $Page->RowIndex ?>__barcode" value="<?= HtmlEncode($Page->_barcode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token__barcode" class="el_bcode_token__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_barcode->getDisplayValue($Page->_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_token" data-field="x__barcode" data-hidden="1" name="x<?= $Page->RowIndex ?>__barcode" id="x<?= $Page->RowIndex ?>__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token__barcode" class="el_bcode_token__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_buyer_uid" class="el_bcode_token_buyer_uid">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_buyer_uid" id="x<?= $Page->RowIndex ?>_buyer_uid" data-table="bcode_token" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_buyer_uid" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_buyer_uid" id="o<?= $Page->RowIndex ?>_buyer_uid" value="<?= HtmlEncode($Page->buyer_uid->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_buyer_uid" class="el_bcode_token_buyer_uid">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_buyer_uid" id="x<?= $Page->RowIndex ?>_buyer_uid" data-table="bcode_token" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_buyer_uid" class="el_bcode_token_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->design_id->Visible) { // design_id ?>
        <td data-name="design_id"<?= $Page->design_id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_design_id" class="el_bcode_token_design_id">
    <select
        id="x<?= $Page->RowIndex ?>_design_id"
        name="x<?= $Page->RowIndex ?>_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_design_id"
        <?php } ?>
        data-table="bcode_token"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x{$Page->RowIndex}_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage() ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_design_id", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_design_id", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_design_id", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_design_id" id="o<?= $Page->RowIndex ?>_design_id" value="<?= HtmlEncode($Page->design_id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_design_id" class="el_bcode_token_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->EditValue) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_design_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_design_id" id="x<?= $Page->RowIndex ?>_design_id" value="<?= HtmlEncode($Page->design_id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_design_id" class="el_bcode_token_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->getViewValue()) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><?= $Page->design_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_size_cm" class="el_bcode_token_size_cm">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_size_cm" id="x<?= $Page->RowIndex ?>_size_cm" data-table="bcode_token" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_size_cm" id="o<?= $Page->RowIndex ?>_size_cm" value="<?= HtmlEncode($Page->size_cm->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_size_cm" class="el_bcode_token_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_cm->getDisplayValue($Page->size_cm->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_token" data-field="x_size_cm" data-hidden="1" name="x<?= $Page->RowIndex ?>_size_cm" id="x<?= $Page->RowIndex ?>_size_cm" value="<?= HtmlEncode($Page->size_cm->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_size_cm" class="el_bcode_token_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_weaving_works" class="el_bcode_token_weaving_works">
    <select
        id="x<?= $Page->RowIndex ?>_weaving_works"
        name="x<?= $Page->RowIndex ?>_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_weaving_works"
        <?php } ?>
        data-table="bcode_token"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x{$Page->RowIndex}_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_weaving_works", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_weaving_works", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_weaving_works", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_token" data-field="x_weaving_works" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_weaving_works" id="o<?= $Page->RowIndex ?>_weaving_works" value="<?= HtmlEncode($Page->weaving_works->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_weaving_works" class="el_bcode_token_weaving_works">
    <select
        id="x<?= $Page->RowIndex ?>_weaving_works"
        name="x<?= $Page->RowIndex ?>_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_weaving_works"
        <?php } ?>
        data-table="bcode_token"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x{$Page->RowIndex}_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_weaving_works", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_weaving_works", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_weaving_works", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_token.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_token_weaving_works" class="el_bcode_token_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode_token");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
