<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbcodesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbcodesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["pid", [ew.Validators.integer], fields.pid.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["process_d", [], fields.process_d.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["order_date", [ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["despatch_date", [ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["dispatch_week_p", [], fields.dispatch_week_p.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_u", [ew.Validators.float], fields.sqm_u.isInvalid],
            ["c_sqm", [ew.Validators.float], fields.c_sqm.isInvalid],
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["q_sku", [ew.Validators.float], fields.q_sku.isInvalid],
            ["po_price", [], fields.po_price.isInvalid],
            ["po_discount", [ew.Validators.float], fields.po_discount.isInvalid],
            ["po_currency", [], fields.po_currency.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["payment_plan", [], fields.payment_plan.isInvalid],
            ["production_plan", [], fields.production_plan.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["cs", [], fields.cs.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["p_remarks", [], fields.p_remarks.isInvalid],
            ["roll_no", [ew.Validators.integer], fields.roll_no.isInvalid],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["pp_id", [ew.Validators.integer], fields.pp_id.isInvalid],
            ["_11", [], fields._11.isInvalid],
            ["_12", [], fields._12.isInvalid],
            ["_13", [], fields._13.isInvalid],
            ["_14", [], fields._14.isInvalid],
            ["_15", [], fields._15.isInvalid],
            ["_16", [], fields._16.isInvalid],
            ["_17", [], fields._17.isInvalid],
            ["_18", [], fields._18.isInvalid],
            ["_19", [], fields._19.isInvalid],
            ["_20", [], fields._20.isInvalid],
            ["_21", [], fields._21.isInvalid],
            ["_22", [], fields._22.isInvalid],
            ["_23", [], fields._23.isInvalid],
            ["_24", [], fields._24.isInvalid],
            ["_25", [], fields._25.isInvalid],
            ["_26", [], fields._26.isInvalid],
            ["_27", [], fields._27.isInvalid],
            ["_28", [], fields._28.isInvalid],
            ["_29", [], fields._29.isInvalid],
            ["_30", [], fields._30.isInvalid],
            ["_31", [], fields._31.isInvalid],
            ["_32", [], fields._32.isInvalid],
            ["_33", [], fields._33.isInvalid],
            ["_34", [], fields._34.isInvalid],
            ["_35", [], fields._35.isInvalid],
            ["_36", [], fields._36.isInvalid],
            ["_37", [], fields._37.isInvalid],
            ["_38", [], fields._38.isInvalid],
            ["_39", [], fields._39.isInvalid],
            ["_40", [], fields._40.isInvalid],
            ["_41", [], fields._41.isInvalid],
            ["_42", [], fields._42.isInvalid],
            ["_43", [], fields._43.isInvalid],
            ["_44", [], fields._44.isInvalid],
            ["_45", [], fields._45.isInvalid],
            ["_46", [], fields._46.isInvalid],
            ["_47", [], fields._47.isInvalid],
            ["_48", [], fields._48.isInvalid],
            ["_49", [], fields._49.isInvalid],
            ["_50", [], fields._50.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "process_d": <?= $Page->process_d->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "dispatch_week_p": <?= $Page->dispatch_week_p->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "po_currency": <?= $Page->po_currency->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "payment_plan": <?= $Page->payment_plan->toClientList($Page) ?>,
            "production_plan": <?= $Page->production_plan->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "cs": <?= $Page->cs->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbcodesearch" id="fbcodesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="bcode" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pid->Visible) { // pid ?>
    <div id="r_pid" class="row"<?= $Page->pid->rowAttributes() ?>>
        <label for="x_pid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_pid"><?= $Page->pid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pid" id="z_pid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_pid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pid->getInputTextType() ?>" name="x_pid" id="x_pid" data-table="bcode" data-field="x_pid" value="<?= $Page->pid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pid->formatPattern()) ?>"<?= $Page->pid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_bcode_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="bcode" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_bcode_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="bcode" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_design_id"
        <?php } ?>
        data-table="bcode"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_design_id", selectId: "fbcodesearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="bcode" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_bcode__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="bcode" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_bcode__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="bcode" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
    <div id="r_process_d" class="row"<?= $Page->process_d->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_process_d"><?= $Page->process_d->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_d" id="z_process_d" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_d->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_process_d" class="ew-search-field ew-search-field-single">
<template id="tp_x_process_d">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="bcode" data-field="x_process_d" name="x_process_d" id="x_process_d"<?= $Page->process_d->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process_d" class="ew-item-list"></div>
<selection-list hidden
    id="x_process_d[]"
    name="x_process_d[]"
    value="<?= HtmlEncode($Page->process_d->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process_d"
    data-target="dsl_x_process_d"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process_d->isInvalidClass() ?>"
    data-table="bcode"
    data-field="x_process_d"
    data-value-separator="<?= $Page->process_d->displayValueSeparatorAttribute() ?>"
    <?= $Page->process_d->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
<?= $Page->process_d->Lookup->getParamTag($Page, "p_x_process_d") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="bcode" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date" class="row"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_order_date"><?= $Page->order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_date" id="z_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="bcode" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbcodesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbcodesearch", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date" class="row"<?= $Page->despatch_date->rowAttributes() ?>>
        <label for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_despatch_date"><?= $Page->despatch_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_date" id="z_despatch_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_despatch_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="bcode" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage(false) ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbcodesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbcodesearch", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_despatch_week"
        <?php } ?>
        data-table="bcode"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_despatch_week", selectId: "fbcodesearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
    <div id="r_dispatch_week_p" class="row"<?= $Page->dispatch_week_p->rowAttributes() ?>>
        <label for="x_dispatch_week_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_dispatch_week_p"><?= $Page->dispatch_week_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dispatch_week_p" id="z_dispatch_week_p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_week_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_dispatch_week_p" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_week_p"
        name="x_dispatch_week_p"
        class="form-select ew-select<?= $Page->dispatch_week_p->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_dispatch_week_p"
        <?php } ?>
        data-table="bcode"
        data-field="x_dispatch_week_p"
        data-value-separator="<?= $Page->dispatch_week_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week_p->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week_p->editAttributes() ?>>
        <?= $Page->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week_p->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week_p->Lookup->getParamTag($Page, "p_x_dispatch_week_p") ?>
<?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_dispatch_week_p", selectId: "fbcodesearch_x_dispatch_week_p" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.dispatch_week_p?.lookupOptions.length) {
        options.data = { id: "x_dispatch_week_p", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_dispatch_week_p", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.dispatch_week_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_status"
        <?php } ?>
        data-table="bcode"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_status", selectId: "fbcodesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_buyers_id"
        <?php } ?>
        data-table="bcode"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_buyers_id", selectId: "fbcodesearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid" class="row"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_buyer_uid"><?= $Page->buyer_uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="bcode" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="bcode" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="bcode" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="bcode" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_u->Visible) { // sqm_u ?>
    <div id="r_sqm_u" class="row"<?= $Page->sqm_u->rowAttributes() ?>>
        <label for="x_sqm_u" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_sqm_u"><?= $Page->sqm_u->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_u" id="z_sqm_u" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_u->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_sqm_u" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_u->getInputTextType() ?>" name="x_sqm_u" id="x_sqm_u" data-table="bcode" data-field="x_sqm_u" value="<?= $Page->sqm_u->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_u->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_u->formatPattern()) ?>"<?= $Page->sqm_u->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_u->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_sqm->Visible) { // c_sqm ?>
    <div id="r_c_sqm" class="row"<?= $Page->c_sqm->rowAttributes() ?>>
        <label for="x_c_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_c_sqm"><?= $Page->c_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_sqm" id="z_c_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_c_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->c_sqm->getInputTextType() ?>" name="x_c_sqm" id="x_c_sqm" data-table="bcode" data-field="x_c_sqm" value="<?= $Page->c_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_sqm->formatPattern()) ?>"<?= $Page->c_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->c_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works" class="row"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_weaving_works"><?= $Page->weaving_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_weaving_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_weaving_works"
        <?php } ?>
        data-table="bcode"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_weaving_works", selectId: "fbcodesearch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_current_works"
        <?php } ?>
        data-table="bcode"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_current_works", selectId: "fbcodesearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer" class="row"<?= $Page->size_buyer->rowAttributes() ?>>
        <label for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_size_buyer"><?= $Page->size_buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="bcode" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
    <div id="r_q_sku" class="row"<?= $Page->q_sku->rowAttributes() ?>>
        <label for="x_q_sku" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_q_sku"><?= $Page->q_sku->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_q_sku" id="z_q_sku" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->q_sku->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_q_sku" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->q_sku->getInputTextType() ?>" name="x_q_sku" id="x_q_sku" data-table="bcode" data-field="x_q_sku" value="<?= $Page->q_sku->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->q_sku->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->q_sku->formatPattern()) ?>"<?= $Page->q_sku->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->q_sku->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
    <div id="r_po_price" class="row"<?= $Page->po_price->rowAttributes() ?>>
        <label for="x_po_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_po_price"><?= $Page->po_price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po_price" id="z_po_price" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_po_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_price->getInputTextType() ?>" name="x_po_price" id="x_po_price" data-table="bcode" data-field="x_po_price" value="<?= $Page->po_price->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->po_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_price->formatPattern()) ?>"<?= $Page->po_price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible) { // po_discount ?>
    <div id="r_po_discount" class="row"<?= $Page->po_discount->rowAttributes() ?>>
        <label for="x_po_discount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_po_discount"><?= $Page->po_discount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_discount" id="z_po_discount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_discount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_po_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="bcode" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_currency->Visible) { // po_currency ?>
    <div id="r_po_currency" class="row"<?= $Page->po_currency->rowAttributes() ?>>
        <label for="x_po_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_po_currency"><?= $Page->po_currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_currency" id="z_po_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_po_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_po_currency"
        name="x_po_currency"
        class="form-control ew-select<?= $Page->po_currency->isInvalidClass() ?>"
        data-select2-id="fbcodesearch_x_po_currency"
        data-table="bcode"
        data-field="x_po_currency"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->po_currency->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->po_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_currency->getPlaceHolder()) ?>"
        <?= $Page->po_currency->editAttributes() ?>>
        <?= $Page->po_currency->selectOptionListHtml("x_po_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_currency->getErrorMessage(false) ?></div>
<?= $Page->po_currency->Lookup->getParamTag($Page, "p_x_po_currency") ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_po_currency", selectId: "fbcodesearch_x_po_currency" };
    if (fbcodesearch.lists.po_currency?.lookupOptions.length) {
        options.data = { id: "x_po_currency", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_po_currency", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.bcode.fields.po_currency.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_product_type"
        <?php } ?>
        data-table="bcode"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_product_type", selectId: "fbcodesearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_shape"
        <?php } ?>
        data-table="bcode"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_shape", selectId: "fbcodesearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_plan->Visible) { // payment_plan ?>
    <div id="r_payment_plan" class="row"<?= $Page->payment_plan->rowAttributes() ?>>
        <label for="x_payment_plan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_payment_plan"><?= $Page->payment_plan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_plan" id="z_payment_plan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_plan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_payment_plan" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_plan"
        name="x_payment_plan"
        class="form-select ew-select<?= $Page->payment_plan->isInvalidClass() ?>"
        <?php if (!$Page->payment_plan->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_payment_plan"
        <?php } ?>
        data-table="bcode"
        data-field="x_payment_plan"
        data-value-separator="<?= $Page->payment_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_plan->getPlaceHolder()) ?>"
        <?= $Page->payment_plan->editAttributes() ?>>
        <?= $Page->payment_plan->selectOptionListHtml("x_payment_plan") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_plan->getErrorMessage(false) ?></div>
<?= $Page->payment_plan->Lookup->getParamTag($Page, "p_x_payment_plan") ?>
<?php if (!$Page->payment_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_payment_plan", selectId: "fbcodesearch_x_payment_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.payment_plan?.lookupOptions.length) {
        options.data = { id: "x_payment_plan", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_payment_plan", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.payment_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan" class="row"<?= $Page->production_plan->rowAttributes() ?>>
        <label for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_production_plan"><?= $Page->production_plan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_production_plan" id="z_production_plan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->production_plan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_production_plan" class="ew-search-field ew-search-field-single">
    <select
        id="x_production_plan"
        name="x_production_plan"
        class="form-select ew-select<?= $Page->production_plan->isInvalidClass() ?>"
        <?php if (!$Page->production_plan->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_production_plan"
        <?php } ?>
        data-table="bcode"
        data-field="x_production_plan"
        data-value-separator="<?= $Page->production_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>"
        <?= $Page->production_plan->editAttributes() ?>>
        <?= $Page->production_plan->selectOptionListHtml("x_production_plan") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage(false) ?></div>
<?php if (!$Page->production_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_production_plan", selectId: "fbcodesearch_x_production_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.production_plan?.lookupOptions.length) {
        options.data = { id: "x_production_plan", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_production_plan", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.production_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="bcode" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbcodesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbcodesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed" class="row"<?= $Page->completed->rowAttributes() ?>>
        <label for="x_completed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_completed"><?= $Page->completed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_completed" id="z_completed" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_completed" class="ew-search-field ew-search-field-single">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_completed"
        <?php } ?>
        data-table="bcode"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_completed", selectId: "fbcodesearch_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_completed", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po" class="row"<?= $Page->buyer_po->rowAttributes() ?>>
        <label for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_buyer_po"><?= $Page->buyer_po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="bcode" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_operator"
        <?php } ?>
        data-table="bcode"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_operator", selectId: "fbcodesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="bcode" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_batch_no"
        <?php } ?>
        data-table="bcode"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_batch_no", selectId: "fbcodesearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
    <div id="r_cs" class="row"<?= $Page->cs->rowAttributes() ?>>
        <label for="x_cs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_cs"><?= $Page->cs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cs" id="z_cs" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_cs" class="ew-search-field ew-search-field-single">
    <select
        id="x_cs"
        name="x_cs"
        class="form-select ew-select<?= $Page->cs->isInvalidClass() ?>"
        <?php if (!$Page->cs->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_cs"
        <?php } ?>
        data-table="bcode"
        data-field="x_cs"
        data-value-separator="<?= $Page->cs->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cs->getPlaceHolder()) ?>"
        <?= $Page->cs->editAttributes() ?>>
        <?= $Page->cs->selectOptionListHtml("x_cs") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cs->getErrorMessage(false) ?></div>
<?php if (!$Page->cs->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_cs", selectId: "fbcodesearch_x_cs" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.cs?.lookupOptions.length) {
        options.data = { id: "x_cs", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_cs", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.cs.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="bcode" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
    <div id="r_p_remarks" class="row"<?= $Page->p_remarks->rowAttributes() ?>>
        <label for="x_p_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_p_remarks"><?= $Page->p_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_p_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_remarks->getInputTextType() ?>" name="x_p_remarks" id="x_p_remarks" data-table="bcode" data-field="x_p_remarks" value="<?= $Page->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_remarks->formatPattern()) ?>"<?= $Page->p_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
    <div id="r_roll_no" class="row"<?= $Page->roll_no->rowAttributes() ?>>
        <label for="x_roll_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_roll_no"><?= $Page->roll_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_roll_no" id="z_roll_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->roll_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_roll_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="bcode" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="bcode" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_pl_no"><?= $Page->pl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="bcode" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_category" id="z_category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbcodesearch_x_category"
        <?php } ?>
        data-table="bcode"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodesearch", function() {
    var options = { name: "x_category", selectId: "fbcodesearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodesearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbcodesearch" };
    } else {
        options.ajax = { id: "x_category", form: "fbcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id" class="row"<?= $Page->pp_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode_pp_id"><?= $Page->pp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_id" id="z_pp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode_pp_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->pp_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_pp_id" class="ew-auto-suggest">
    <input type="<?= $Page->pp_id->getInputTextType() ?>" class="form-control" name="sv_x_pp_id" id="sv_x_pp_id" value="<?= RemoveHtml($Page->pp_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_id->formatPattern()) ?>"<?= $Page->pp_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bcode" data-field="x_pp_id" data-input="sv_x_pp_id" data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>" name="x_pp_id" id="x_pp_id" value="<?= HtmlEncode($Page->pp_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbcodesearch", function() {
    fbcodesearch.createAutoSuggest(Object.assign({"id":"x_pp_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->pp_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bcode.fields.pp_id.autoSuggestOptions));
});
</script>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_11->Visible) { // 11 ?>
    <div id="r__11" class="row"<?= $Page->_11->rowAttributes() ?>>
        <label for="x__11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__11"><?= $Page->_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__11" id="z__11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_11->getInputTextType() ?>" name="x__11" id="x__11" data-table="bcode" data-field="x__11" value="<?= $Page->_11->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_11->formatPattern()) ?>"<?= $Page->_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_12->Visible) { // 12 ?>
    <div id="r__12" class="row"<?= $Page->_12->rowAttributes() ?>>
        <label for="x__12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__12"><?= $Page->_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__12" id="z__12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_12->getInputTextType() ?>" name="x__12" id="x__12" data-table="bcode" data-field="x__12" value="<?= $Page->_12->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_12->formatPattern()) ?>"<?= $Page->_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_13->Visible) { // 13 ?>
    <div id="r__13" class="row"<?= $Page->_13->rowAttributes() ?>>
        <label for="x__13" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__13"><?= $Page->_13->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__13" id="z__13" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_13->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_13->getInputTextType() ?>" name="x__13" id="x__13" data-table="bcode" data-field="x__13" value="<?= $Page->_13->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_13->formatPattern()) ?>"<?= $Page->_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_13->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_14->Visible) { // 14 ?>
    <div id="r__14" class="row"<?= $Page->_14->rowAttributes() ?>>
        <label for="x__14" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__14"><?= $Page->_14->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__14" id="z__14" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_14->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_14->getInputTextType() ?>" name="x__14" id="x__14" data-table="bcode" data-field="x__14" value="<?= $Page->_14->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_14->formatPattern()) ?>"<?= $Page->_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_14->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_15->Visible) { // 15 ?>
    <div id="r__15" class="row"<?= $Page->_15->rowAttributes() ?>>
        <label for="x__15" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__15"><?= $Page->_15->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__15" id="z__15" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_15->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_15->getInputTextType() ?>" name="x__15" id="x__15" data-table="bcode" data-field="x__15" value="<?= $Page->_15->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_15->formatPattern()) ?>"<?= $Page->_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_15->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_16->Visible) { // 16 ?>
    <div id="r__16" class="row"<?= $Page->_16->rowAttributes() ?>>
        <label for="x__16" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__16"><?= $Page->_16->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__16" id="z__16" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_16->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__16" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_16->getInputTextType() ?>" name="x__16" id="x__16" data-table="bcode" data-field="x__16" value="<?= $Page->_16->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_16->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_16->formatPattern()) ?>"<?= $Page->_16->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_16->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_17->Visible) { // 17 ?>
    <div id="r__17" class="row"<?= $Page->_17->rowAttributes() ?>>
        <label for="x__17" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__17"><?= $Page->_17->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__17" id="z__17" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_17->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__17" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_17->getInputTextType() ?>" name="x__17" id="x__17" data-table="bcode" data-field="x__17" value="<?= $Page->_17->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_17->formatPattern()) ?>"<?= $Page->_17->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_17->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_18->Visible) { // 18 ?>
    <div id="r__18" class="row"<?= $Page->_18->rowAttributes() ?>>
        <label for="x__18" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__18"><?= $Page->_18->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__18" id="z__18" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_18->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__18" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_18->getInputTextType() ?>" name="x__18" id="x__18" data-table="bcode" data-field="x__18" value="<?= $Page->_18->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_18->formatPattern()) ?>"<?= $Page->_18->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_18->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_19->Visible) { // 19 ?>
    <div id="r__19" class="row"<?= $Page->_19->rowAttributes() ?>>
        <label for="x__19" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__19"><?= $Page->_19->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__19" id="z__19" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_19->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__19" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_19->getInputTextType() ?>" name="x__19" id="x__19" data-table="bcode" data-field="x__19" value="<?= $Page->_19->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_19->formatPattern()) ?>"<?= $Page->_19->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_19->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_20->Visible) { // 20 ?>
    <div id="r__20" class="row"<?= $Page->_20->rowAttributes() ?>>
        <label for="x__20" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__20"><?= $Page->_20->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__20" id="z__20" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_20->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__20" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_20->getInputTextType() ?>" name="x__20" id="x__20" data-table="bcode" data-field="x__20" value="<?= $Page->_20->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_20->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_20->formatPattern()) ?>"<?= $Page->_20->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_20->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_21->Visible) { // 21 ?>
    <div id="r__21" class="row"<?= $Page->_21->rowAttributes() ?>>
        <label for="x__21" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__21"><?= $Page->_21->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__21" id="z__21" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_21->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__21" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_21->getInputTextType() ?>" name="x__21" id="x__21" data-table="bcode" data-field="x__21" value="<?= $Page->_21->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_21->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_21->formatPattern()) ?>"<?= $Page->_21->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_21->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_22->Visible) { // 22 ?>
    <div id="r__22" class="row"<?= $Page->_22->rowAttributes() ?>>
        <label for="x__22" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__22"><?= $Page->_22->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__22" id="z__22" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_22->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__22" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_22->getInputTextType() ?>" name="x__22" id="x__22" data-table="bcode" data-field="x__22" value="<?= $Page->_22->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_22->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_22->formatPattern()) ?>"<?= $Page->_22->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_22->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_23->Visible) { // 23 ?>
    <div id="r__23" class="row"<?= $Page->_23->rowAttributes() ?>>
        <label for="x__23" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__23"><?= $Page->_23->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__23" id="z__23" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_23->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__23" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_23->getInputTextType() ?>" name="x__23" id="x__23" data-table="bcode" data-field="x__23" value="<?= $Page->_23->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_23->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_23->formatPattern()) ?>"<?= $Page->_23->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_23->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_24->Visible) { // 24 ?>
    <div id="r__24" class="row"<?= $Page->_24->rowAttributes() ?>>
        <label for="x__24" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__24"><?= $Page->_24->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__24" id="z__24" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_24->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__24" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_24->getInputTextType() ?>" name="x__24" id="x__24" data-table="bcode" data-field="x__24" value="<?= $Page->_24->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_24->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_24->formatPattern()) ?>"<?= $Page->_24->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_24->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_25->Visible) { // 25 ?>
    <div id="r__25" class="row"<?= $Page->_25->rowAttributes() ?>>
        <label for="x__25" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__25"><?= $Page->_25->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__25" id="z__25" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_25->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__25" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_25->getInputTextType() ?>" name="x__25" id="x__25" data-table="bcode" data-field="x__25" value="<?= $Page->_25->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_25->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_25->formatPattern()) ?>"<?= $Page->_25->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_25->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_26->Visible) { // 26 ?>
    <div id="r__26" class="row"<?= $Page->_26->rowAttributes() ?>>
        <label for="x__26" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__26"><?= $Page->_26->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__26" id="z__26" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_26->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__26" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_26->getInputTextType() ?>" name="x__26" id="x__26" data-table="bcode" data-field="x__26" value="<?= $Page->_26->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_26->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_26->formatPattern()) ?>"<?= $Page->_26->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_26->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_27->Visible) { // 27 ?>
    <div id="r__27" class="row"<?= $Page->_27->rowAttributes() ?>>
        <label for="x__27" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__27"><?= $Page->_27->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__27" id="z__27" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_27->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__27" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_27->getInputTextType() ?>" name="x__27" id="x__27" data-table="bcode" data-field="x__27" value="<?= $Page->_27->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_27->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_27->formatPattern()) ?>"<?= $Page->_27->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_27->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_28->Visible) { // 28 ?>
    <div id="r__28" class="row"<?= $Page->_28->rowAttributes() ?>>
        <label for="x__28" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__28"><?= $Page->_28->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__28" id="z__28" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_28->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__28" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_28->getInputTextType() ?>" name="x__28" id="x__28" data-table="bcode" data-field="x__28" value="<?= $Page->_28->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_28->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_28->formatPattern()) ?>"<?= $Page->_28->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_28->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_29->Visible) { // 29 ?>
    <div id="r__29" class="row"<?= $Page->_29->rowAttributes() ?>>
        <label for="x__29" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__29"><?= $Page->_29->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__29" id="z__29" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_29->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__29" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_29->getInputTextType() ?>" name="x__29" id="x__29" data-table="bcode" data-field="x__29" value="<?= $Page->_29->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_29->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_29->formatPattern()) ?>"<?= $Page->_29->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_29->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_30->Visible) { // 30 ?>
    <div id="r__30" class="row"<?= $Page->_30->rowAttributes() ?>>
        <label for="x__30" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__30"><?= $Page->_30->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__30" id="z__30" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_30->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__30" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_30->getInputTextType() ?>" name="x__30" id="x__30" data-table="bcode" data-field="x__30" value="<?= $Page->_30->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_30->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_30->formatPattern()) ?>"<?= $Page->_30->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_30->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_31->Visible) { // 31 ?>
    <div id="r__31" class="row"<?= $Page->_31->rowAttributes() ?>>
        <label for="x__31" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__31"><?= $Page->_31->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__31" id="z__31" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_31->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__31" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_31->getInputTextType() ?>" name="x__31" id="x__31" data-table="bcode" data-field="x__31" value="<?= $Page->_31->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_31->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_31->formatPattern()) ?>"<?= $Page->_31->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_31->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_32->Visible) { // 32 ?>
    <div id="r__32" class="row"<?= $Page->_32->rowAttributes() ?>>
        <label for="x__32" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__32"><?= $Page->_32->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__32" id="z__32" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_32->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__32" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_32->getInputTextType() ?>" name="x__32" id="x__32" data-table="bcode" data-field="x__32" value="<?= $Page->_32->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_32->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_32->formatPattern()) ?>"<?= $Page->_32->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_32->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_33->Visible) { // 33 ?>
    <div id="r__33" class="row"<?= $Page->_33->rowAttributes() ?>>
        <label for="x__33" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__33"><?= $Page->_33->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__33" id="z__33" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_33->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__33" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_33->getInputTextType() ?>" name="x__33" id="x__33" data-table="bcode" data-field="x__33" value="<?= $Page->_33->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_33->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_33->formatPattern()) ?>"<?= $Page->_33->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_33->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_34->Visible) { // 34 ?>
    <div id="r__34" class="row"<?= $Page->_34->rowAttributes() ?>>
        <label for="x__34" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__34"><?= $Page->_34->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__34" id="z__34" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_34->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__34" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_34->getInputTextType() ?>" name="x__34" id="x__34" data-table="bcode" data-field="x__34" value="<?= $Page->_34->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_34->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_34->formatPattern()) ?>"<?= $Page->_34->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_34->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_35->Visible) { // 35 ?>
    <div id="r__35" class="row"<?= $Page->_35->rowAttributes() ?>>
        <label for="x__35" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__35"><?= $Page->_35->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__35" id="z__35" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_35->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__35" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_35->getInputTextType() ?>" name="x__35" id="x__35" data-table="bcode" data-field="x__35" value="<?= $Page->_35->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_35->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_35->formatPattern()) ?>"<?= $Page->_35->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_35->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_36->Visible) { // 36 ?>
    <div id="r__36" class="row"<?= $Page->_36->rowAttributes() ?>>
        <label for="x__36" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__36"><?= $Page->_36->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__36" id="z__36" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_36->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__36" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_36->getInputTextType() ?>" name="x__36" id="x__36" data-table="bcode" data-field="x__36" value="<?= $Page->_36->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_36->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_36->formatPattern()) ?>"<?= $Page->_36->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_36->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_37->Visible) { // 37 ?>
    <div id="r__37" class="row"<?= $Page->_37->rowAttributes() ?>>
        <label for="x__37" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__37"><?= $Page->_37->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__37" id="z__37" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_37->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__37" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_37->getInputTextType() ?>" name="x__37" id="x__37" data-table="bcode" data-field="x__37" value="<?= $Page->_37->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_37->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_37->formatPattern()) ?>"<?= $Page->_37->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_37->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_38->Visible) { // 38 ?>
    <div id="r__38" class="row"<?= $Page->_38->rowAttributes() ?>>
        <label for="x__38" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__38"><?= $Page->_38->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__38" id="z__38" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_38->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__38" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_38->getInputTextType() ?>" name="x__38" id="x__38" data-table="bcode" data-field="x__38" value="<?= $Page->_38->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_38->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_38->formatPattern()) ?>"<?= $Page->_38->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_38->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_39->Visible) { // 39 ?>
    <div id="r__39" class="row"<?= $Page->_39->rowAttributes() ?>>
        <label for="x__39" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__39"><?= $Page->_39->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__39" id="z__39" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_39->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__39" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_39->getInputTextType() ?>" name="x__39" id="x__39" data-table="bcode" data-field="x__39" value="<?= $Page->_39->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_39->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_39->formatPattern()) ?>"<?= $Page->_39->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_39->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // 40 ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__40" id="z__40" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="bcode" data-field="x__40" value="<?= $Page->_40->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_41->Visible) { // 41 ?>
    <div id="r__41" class="row"<?= $Page->_41->rowAttributes() ?>>
        <label for="x__41" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__41"><?= $Page->_41->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__41" id="z__41" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_41->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__41" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_41->getInputTextType() ?>" name="x__41" id="x__41" data-table="bcode" data-field="x__41" value="<?= $Page->_41->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_41->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_41->formatPattern()) ?>"<?= $Page->_41->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_41->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_42->Visible) { // 42 ?>
    <div id="r__42" class="row"<?= $Page->_42->rowAttributes() ?>>
        <label for="x__42" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__42"><?= $Page->_42->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__42" id="z__42" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_42->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__42" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_42->getInputTextType() ?>" name="x__42" id="x__42" data-table="bcode" data-field="x__42" value="<?= $Page->_42->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_42->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_42->formatPattern()) ?>"<?= $Page->_42->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_42->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_43->Visible) { // 43 ?>
    <div id="r__43" class="row"<?= $Page->_43->rowAttributes() ?>>
        <label for="x__43" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__43"><?= $Page->_43->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__43" id="z__43" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_43->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__43" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_43->getInputTextType() ?>" name="x__43" id="x__43" data-table="bcode" data-field="x__43" value="<?= $Page->_43->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_43->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_43->formatPattern()) ?>"<?= $Page->_43->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_43->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_44->Visible) { // 44 ?>
    <div id="r__44" class="row"<?= $Page->_44->rowAttributes() ?>>
        <label for="x__44" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__44"><?= $Page->_44->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__44" id="z__44" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_44->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__44" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_44->getInputTextType() ?>" name="x__44" id="x__44" data-table="bcode" data-field="x__44" value="<?= $Page->_44->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_44->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_44->formatPattern()) ?>"<?= $Page->_44->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_44->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_45->Visible) { // 45 ?>
    <div id="r__45" class="row"<?= $Page->_45->rowAttributes() ?>>
        <label for="x__45" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__45"><?= $Page->_45->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__45" id="z__45" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_45->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__45" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_45->getInputTextType() ?>" name="x__45" id="x__45" data-table="bcode" data-field="x__45" value="<?= $Page->_45->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_45->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_45->formatPattern()) ?>"<?= $Page->_45->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_45->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_46->Visible) { // 46 ?>
    <div id="r__46" class="row"<?= $Page->_46->rowAttributes() ?>>
        <label for="x__46" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__46"><?= $Page->_46->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__46" id="z__46" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_46->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__46" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_46->getInputTextType() ?>" name="x__46" id="x__46" data-table="bcode" data-field="x__46" value="<?= $Page->_46->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_46->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_46->formatPattern()) ?>"<?= $Page->_46->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_46->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_47->Visible) { // 47 ?>
    <div id="r__47" class="row"<?= $Page->_47->rowAttributes() ?>>
        <label for="x__47" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__47"><?= $Page->_47->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__47" id="z__47" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_47->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__47" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_47->getInputTextType() ?>" name="x__47" id="x__47" data-table="bcode" data-field="x__47" value="<?= $Page->_47->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_47->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_47->formatPattern()) ?>"<?= $Page->_47->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_47->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_48->Visible) { // 48 ?>
    <div id="r__48" class="row"<?= $Page->_48->rowAttributes() ?>>
        <label for="x__48" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__48"><?= $Page->_48->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__48" id="z__48" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_48->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__48" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_48->getInputTextType() ?>" name="x__48" id="x__48" data-table="bcode" data-field="x__48" value="<?= $Page->_48->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_48->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_48->formatPattern()) ?>"<?= $Page->_48->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_48->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_49->Visible) { // 49 ?>
    <div id="r__49" class="row"<?= $Page->_49->rowAttributes() ?>>
        <label for="x__49" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__49"><?= $Page->_49->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__49" id="z__49" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_49->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__49" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_49->getInputTextType() ?>" name="x__49" id="x__49" data-table="bcode" data-field="x__49" value="<?= $Page->_49->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_49->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_49->formatPattern()) ?>"<?= $Page->_49->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_49->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_50->Visible) { // 50 ?>
    <div id="r__50" class="row"<?= $Page->_50->rowAttributes() ?>>
        <label for="x__50" class="<?= $Page->LeftColumnClass ?>"><span id="elh_bcode__50"><?= $Page->_50->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__50" id="z__50" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_50->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_bcode__50" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_50->getInputTextType() ?>" name="x__50" id="x__50" data-table="bcode" data-field="x__50" value="<?= $Page->_50->EditValue ?>" maxlength="24" placeholder="<?= HtmlEncode($Page->_50->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_50->formatPattern()) ?>"<?= $Page->_50->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_50->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcodesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbcodesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbcodesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
