<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeSList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_s: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbcode_ssrch" id="fbcode_ssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbcode_ssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_s: currentTable } });
var currentForm;
var fbcode_ssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbcode_ssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbcode_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbcode_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbcode_ssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbcode_ssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbcode_ssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbcode_ssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbcode_ssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_bcode_s" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bcode_slist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_bcode_s_id" class="bcode_s_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_bcode_s_po" class="bcode_s_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_bcode_s__barcode" class="bcode_s__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->pid->Visible) { // pid ?>
        <th data-name="pid" class="<?= $Page->pid->headerCellClass() ?>"><div id="elh_bcode_s_pid" class="bcode_s_pid"><?= $Page->renderFieldHeader($Page->pid) ?></div></th>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_weaving_works" class="bcode_s_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
        <th data-name="current_works" class="<?= $Page->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_current_works" class="bcode_s_current_works"><?= $Page->renderFieldHeader($Page->current_works) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_bcode_s_buyers_id" class="bcode_s_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_bcode_s_buyer_ref" class="bcode_s_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_tid->Visible) { // buyer_tid ?>
        <th data-name="buyer_tid" class="<?= $Page->buyer_tid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_s_buyer_tid" class="bcode_s_buyer_tid"><?= $Page->renderFieldHeader($Page->buyer_tid) ?></div></th>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
        <th data-name="design_id" class="<?= $Page->design_id->headerCellClass() ?>"><div id="elh_bcode_s_design_id" class="bcode_s_design_id"><?= $Page->renderFieldHeader($Page->design_id) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_bcode_s_batch_no" class="bcode_s_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_bcode_s_sqm" class="bcode_s_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_bcode_s_shape" class="bcode_s_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Page->product_type->headerCellClass() ?>"><div id="elh_bcode_s_product_type" class="bcode_s_product_type"><?= $Page->renderFieldHeader($Page->product_type) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_bcode_s_size_cm" class="bcode_s_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>"><div id="elh_bcode_s_buyer_uid" class="bcode_s_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_bcode_s_quantity" class="bcode_s_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
        <th data-name="po_price" class="<?= $Page->po_price->headerCellClass() ?>"><div id="elh_bcode_s_po_price" class="bcode_s_po_price"><?= $Page->renderFieldHeader($Page->po_price) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>"><div id="elh_bcode_s_despatch_date" class="bcode_s_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_bcode_s_status" class="bcode_s_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
        <th data-name="completed" class="<?= $Page->completed->headerCellClass() ?>"><div id="elh_bcode_s_completed" class="bcode_s_completed"><?= $Page->renderFieldHeader($Page->completed) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <th data-name="buyer_po" class="<?= $Page->buyer_po->headerCellClass() ?>"><div id="elh_bcode_s_buyer_po" class="bcode_s_buyer_po"><?= $Page->renderFieldHeader($Page->buyer_po) ?></div></th>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
        <th data-name="pp_id" class="<?= $Page->pp_id->headerCellClass() ?>"><div id="elh_bcode_s_pp_id" class="bcode_s_pp_id"><?= $Page->renderFieldHeader($Page->pp_id) ?></div></th>
<?php } ?>
<?php if ($Page->in_id->Visible) { // in_id ?>
        <th data-name="in_id" class="<?= $Page->in_id->headerCellClass() ?>"><div id="elh_bcode_s_in_id" class="bcode_s_in_id"><?= $Page->renderFieldHeader($Page->in_id) ?></div></th>
<?php } ?>
<?php if ($Page->out_id->Visible) { // out_id ?>
        <th data-name="out_id" class="<?= $Page->out_id->headerCellClass() ?>"><div id="elh_bcode_s_out_id" class="bcode_s_out_id"><?= $Page->renderFieldHeader($Page->out_id) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_id" class="el_bcode_s_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_po" class="el_bcode_s_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s__barcode" class="el_bcode_s__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pid->Visible) { // pid ?>
        <td data-name="pid"<?= $Page->pid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_pid" class="el_bcode_s_pid">
<span<?= $Page->pid->viewAttributes() ?>>
<?= $Page->pid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_weaving_works" class="el_bcode_s_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works"<?= $Page->current_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_current_works" class="el_bcode_s_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<?= $Page->current_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_buyers_id" class="el_bcode_s_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyers_id->getViewValue()) && $Page->buyers_id->linkAttributes() != "") { ?>
<a<?= $Page->buyers_id->linkAttributes() ?>><?= $Page->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_buyer_ref" class="el_bcode_s_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_ref->getViewValue()) && $Page->buyer_ref->linkAttributes() != "") { ?>
<a<?= $Page->buyer_ref->linkAttributes() ?>><?= $Page->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_tid->Visible) { // buyer_tid ?>
        <td data-name="buyer_tid"<?= $Page->buyer_tid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_buyer_tid" class="el_bcode_s_buyer_tid">
<span<?= $Page->buyer_tid->viewAttributes() ?>>
<?= $Page->buyer_tid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_id->Visible) { // design_id ?>
        <td data-name="design_id"<?= $Page->design_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_design_id" class="el_bcode_s_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->getViewValue()) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><?= $Page->design_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_batch_no" class="el_bcode_s_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_sqm" class="el_bcode_s_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_shape" class="el_bcode_s_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_product_type" class="el_bcode_s_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_size_cm" class="el_bcode_s_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_buyer_uid" class="el_bcode_s_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_quantity" class="el_bcode_s_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_price->Visible) { // po_price ?>
        <td data-name="po_price"<?= $Page->po_price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_po_price" class="el_bcode_s_po_price">
<span<?= $Page->po_price->viewAttributes() ?>>
<?= $Page->po_price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_despatch_date" class="el_bcode_s_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_status" class="el_bcode_s_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed"<?= $Page->completed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_completed" class="el_bcode_s_completed">
<span<?= $Page->completed->viewAttributes() ?>>
<?= $Page->completed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po"<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_buyer_po" class="el_bcode_s_buyer_po">
<span<?= $Page->buyer_po->viewAttributes() ?>>
<?= $Page->buyer_po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pp_id->Visible) { // pp_id ?>
        <td data-name="pp_id"<?= $Page->pp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_pp_id" class="el_bcode_s_pp_id">
<span<?= $Page->pp_id->viewAttributes() ?>>
<?= $Page->pp_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_id->Visible) { // in_id ?>
        <td data-name="in_id"<?= $Page->in_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_in_id" class="el_bcode_s_in_id">
<span<?= $Page->in_id->viewAttributes() ?>>
<?= $Page->in_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_id->Visible) { // out_id ?>
        <td data-name="out_id"<?= $Page->out_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_s_out_id" class="el_bcode_s_out_id">
<span<?= $Page->out_id->viewAttributes() ?>>
<?= $Page->out_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
