<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeSEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fbcode_sedit" id="fbcode_sedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_s: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fbcode_sedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbcode_sedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["current_works", [fields.current_works.visible && fields.current_works.required ? ew.Validators.required(fields.current_works.caption) : null], fields.current_works.isInvalid],
            ["buyers_id", [fields.buyers_id.visible && fields.buyers_id.required ? ew.Validators.required(fields.buyers_id.caption) : null], fields.buyers_id.isInvalid],
            ["buyer_ref", [fields.buyer_ref.visible && fields.buyer_ref.required ? ew.Validators.required(fields.buyer_ref.caption) : null], fields.buyer_ref.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null, ew.Validators.integer], fields.batch_no.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["size_buyer", [fields.size_buyer.visible && fields.size_buyer.required ? ew.Validators.required(fields.size_buyer.caption) : null], fields.size_buyer.isInvalid],
            ["buyer_uid", [fields.buyer_uid.visible && fields.buyer_uid.required ? ew.Validators.required(fields.buyer_uid.caption) : null], fields.buyer_uid.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["po_price", [fields.po_price.visible && fields.po_price.required ? ew.Validators.required(fields.po_price.caption) : null], fields.po_price.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["completed", [fields.completed.visible && fields.completed.required ? ew.Validators.required(fields.completed.caption) : null], fields.completed.isInvalid],
            ["buyer_po", [fields.buyer_po.visible && fields.buyer_po.required ? ew.Validators.required(fields.buyer_po.caption) : null], fields.buyer_po.isInvalid],
            ["pp_id", [fields.pp_id.visible && fields.pp_id.required ? ew.Validators.required(fields.pp_id.caption) : null, ew.Validators.integer], fields.pp_id.isInvalid],
            ["in_id", [fields.in_id.visible && fields.in_id.required ? ew.Validators.required(fields.in_id.caption) : null, ew.Validators.integer], fields.in_id.isInvalid],
            ["out_id", [fields.out_id.visible && fields.out_id.required ? ew.Validators.required(fields.out_id.caption) : null, ew.Validators.integer], fields.out_id.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "production_plan": <?= $Page->production_plan->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode_s">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_bcode_s_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_bcode_s_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_bcode_s_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_bcode_s_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_bcode_s__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_bcode_s__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_barcode->getDisplayValue($Page->_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x__barcode" data-hidden="1" name="x__barcode" id="x__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label id="elh_bcode_s_weaving_works" for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weaving_works->caption() ?><?= $Page->weaving_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el_bcode_s_weaving_works">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_weaving_works"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <?= $Page->weaving_works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_weaving_works", selectId: "fbcode_sedit_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works"<?= $Page->current_works->rowAttributes() ?>>
        <label id="elh_bcode_s_current_works" for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_works->caption() ?><?= $Page->current_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_works->cellAttributes() ?>>
<span id="el_bcode_s_current_works">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_current_works"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <?= $Page->current_works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage() ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_current_works", selectId: "fbcode_sedit_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id"<?= $Page->buyers_id->rowAttributes() ?>>
        <label id="elh_bcode_s_buyers_id" for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyers_id->caption() ?><?= $Page->buyers_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el_bcode_s_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyers_id->EditValue) && $Page->buyers_id->linkAttributes() != "") { ?>
<a<?= $Page->buyers_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_buyers_id" data-hidden="1" name="x_buyers_id" id="x_buyers_id" value="<?= HtmlEncode($Page->buyers_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label id="elh_bcode_s_buyer_ref" for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_ref->caption() ?><?= $Page->buyer_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_s_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_ref->EditValue) && $Page->buyer_ref->linkAttributes() != "") { ?>
<a<?= $Page->buyer_ref->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyer_ref->getDisplayValue($Page->buyer_ref->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyer_ref->getDisplayValue($Page->buyer_ref->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_buyer_ref" data-hidden="1" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id"<?= $Page->design_id->rowAttributes() ?>>
        <label id="elh_bcode_s_design_id" for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design_id->caption() ?><?= $Page->design_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design_id->cellAttributes() ?>>
<span id="el_bcode_s_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->EditValue) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode_s" data-field="x_design_id" data-hidden="1" name="x_design_id" id="x_design_id" value="<?= HtmlEncode($Page->design_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_bcode_s_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_bcode_s_batch_no">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="bcode_s" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?> aria-describedby="x_batch_no_help">
<?= $Page->batch_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_bcode_s_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_bcode_s_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape"<?= $Page->shape->rowAttributes() ?>>
        <label id="elh_bcode_s_shape" for="x_shape" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shape->caption() ?><?= $Page->shape->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shape->cellAttributes() ?>>
<span id="el_bcode_s_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->shape->getDisplayValue($Page->shape->EditValue) ?></span></span>
<input type="hidden" data-table="bcode_s" data-field="x_shape" data-hidden="1" name="x_shape" id="x_shape" value="<?= HtmlEncode($Page->shape->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_bcode_s_product_type" for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_bcode_s_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->product_type->getDisplayValue($Page->product_type->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_product_type" data-hidden="1" name="x_product_type" id="x_product_type" value="<?= HtmlEncode($Page->product_type->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_bcode_s_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_bcode_s_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_cm->getDisplayValue($Page->size_cm->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_size_cm" data-hidden="1" name="x_size_cm" id="x_size_cm" value="<?= HtmlEncode($Page->size_cm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer"<?= $Page->size_buyer->rowAttributes() ?>>
        <label id="elh_bcode_s_size_buyer" for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_buyer->caption() ?><?= $Page->size_buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el_bcode_s_size_buyer">
<span<?= $Page->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_buyer->getDisplayValue($Page->size_buyer->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_size_buyer" data-hidden="1" name="x_size_buyer" id="x_size_buyer" value="<?= HtmlEncode($Page->size_buyer->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label id="elh_bcode_s_buyer_uid" for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_uid->caption() ?><?= $Page->buyer_uid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_s_buyer_uid">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="bcode_s" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?> aria-describedby="x_buyer_uid_help">
<?= $Page->buyer_uid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_bcode_s_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_bcode_s_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->quantity->getDisplayValue($Page->quantity->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_quantity" data-hidden="1" name="x_quantity" id="x_quantity" value="<?= HtmlEncode($Page->quantity->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
    <div id="r_po_price"<?= $Page->po_price->rowAttributes() ?>>
        <label id="elh_bcode_s_po_price" for="x_po_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_price->caption() ?><?= $Page->po_price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_price->cellAttributes() ?>>
<span id="el_bcode_s_po_price">
<span<?= $Page->po_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po_price->getDisplayValue($Page->po_price->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode_s" data-field="x_po_price" data-hidden="1" name="x_po_price" id="x_po_price" value="<?= HtmlEncode($Page->po_price->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_bcode_s_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_bcode_s_despatch_week">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_despatch_week"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <?= $Page->despatch_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_despatch_week", selectId: "fbcode_sedit_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_bcode_s_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_bcode_s_despatch_date">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="bcode_s" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?> aria-describedby="x_despatch_date_help">
<?= $Page->despatch_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage() ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbcode_sedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbcode_sedit", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_bcode_s_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_bcode_s_production_plan">
    <select
        id="x_production_plan"
        name="x_production_plan"
        class="form-select ew-select<?= $Page->production_plan->isInvalidClass() ?>"
        <?php if (!$Page->production_plan->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_production_plan"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_production_plan"
        data-value-separator="<?= $Page->production_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>"
        <?= $Page->production_plan->editAttributes() ?>>
        <?= $Page->production_plan->selectOptionListHtml("x_production_plan") ?>
    </select>
    <?= $Page->production_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage() ?></div>
<?php if (!$Page->production_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_production_plan", selectId: "fbcode_sedit_x_production_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.production_plan?.lookupOptions.length) {
        options.data = { id: "x_production_plan", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_production_plan", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.production_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_bcode_s_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_bcode_s_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_status"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_status", selectId: "fbcode_sedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_status", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed"<?= $Page->completed->rowAttributes() ?>>
        <label id="elh_bcode_s_completed" for="x_completed" class="<?= $Page->LeftColumnClass ?>"><?= $Page->completed->caption() ?><?= $Page->completed->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->completed->cellAttributes() ?>>
<span id="el_bcode_s_completed">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fbcode_sedit_x_completed"
        <?php } ?>
        data-table="bcode_s"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <?= $Page->completed->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage() ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_sedit", function() {
    var options = { name: "x_completed", selectId: "fbcode_sedit_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_sedit.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fbcode_sedit" };
    } else {
        options.ajax = { id: "x_completed", form: "fbcode_sedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_s.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po"<?= $Page->buyer_po->rowAttributes() ?>>
        <label id="elh_bcode_s_buyer_po" for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_po->caption() ?><?= $Page->buyer_po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el_bcode_s_buyer_po">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="bcode_s" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?> aria-describedby="x_buyer_po_help">
<?= $Page->buyer_po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id"<?= $Page->pp_id->rowAttributes() ?>>
        <label id="elh_bcode_s_pp_id" for="x_pp_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pp_id->caption() ?><?= $Page->pp_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pp_id->cellAttributes() ?>>
<span id="el_bcode_s_pp_id">
<input type="<?= $Page->pp_id->getInputTextType() ?>" name="x_pp_id" id="x_pp_id" data-table="bcode_s" data-field="x_pp_id" value="<?= $Page->pp_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_id->formatPattern()) ?>"<?= $Page->pp_id->editAttributes() ?> aria-describedby="x_pp_id_help">
<?= $Page->pp_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->in_id->Visible) { // in_id ?>
    <div id="r_in_id"<?= $Page->in_id->rowAttributes() ?>>
        <label id="elh_bcode_s_in_id" for="x_in_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->in_id->caption() ?><?= $Page->in_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->in_id->cellAttributes() ?>>
<span id="el_bcode_s_in_id">
<input type="<?= $Page->in_id->getInputTextType() ?>" name="x_in_id" id="x_in_id" data-table="bcode_s" data-field="x_in_id" value="<?= $Page->in_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->in_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_id->formatPattern()) ?>"<?= $Page->in_id->editAttributes() ?> aria-describedby="x_in_id_help">
<?= $Page->in_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->in_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->out_id->Visible) { // out_id ?>
    <div id="r_out_id"<?= $Page->out_id->rowAttributes() ?>>
        <label id="elh_bcode_s_out_id" for="x_out_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->out_id->caption() ?><?= $Page->out_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->out_id->cellAttributes() ?>>
<span id="el_bcode_s_out_id">
<input type="<?= $Page->out_id->getInputTextType() ?>" name="x_out_id" id="x_out_id" data-table="bcode_s" data-field="x_out_id" value="<?= $Page->out_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->out_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_id->formatPattern()) ?>"<?= $Page->out_id->editAttributes() ?> aria-describedby="x_out_id_help">
<?= $Page->out_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->out_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_bcode_s_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_bcode_s_remarks">
<textarea data-table="bcode_s" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcode_sedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbcode_sedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
