<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeOldList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_old: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbcode_oldsrch" id="fbcode_oldsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbcode_oldsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode_old: currentTable } });
var currentForm;
var fbcode_oldsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbcode_oldsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["current_works", [], fields.current_works.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->current_works->Visible) { // current_works ?>
<?php
if (!$Page->current_works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_current_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->current_works->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_current_works" class="ew-search-caption ew-label"><?= $Page->current_works->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</div>
        </div>
        <div id="el_bcode_old_current_works" class="ew-search-field">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbcode_oldsrch_x_current_works"
        <?php } ?>
        data-table="bcode_old"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_oldsrch", function() {
    var options = { name: "x_current_works", selectId: "fbcode_oldsrch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_oldsrch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbcode_oldsrch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbcode_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_old.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_bcode_old_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="bcode_old" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_bcode_old_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="bcode_old" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_bcode_old__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="bcode_old" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_bcode_old__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="bcode_old" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
<?php
if (!$Page->buyer_uid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_uid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_uid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_uid" class="ew-search-caption ew-label"><?= $Page->buyer_uid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</div>
        </div>
        <div id="el_bcode_old_buyer_uid" class="ew-search-field">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="bcode_old" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_bcode_old_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbcode_oldsrch_x_status"
        <?php } ?>
        data-table="bcode_old"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcode_oldsrch", function() {
    var options = { name: "x_status", selectId: "fbcode_oldsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcode_oldsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbcode_oldsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fbcode_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode_old.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbcode_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbcode_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbcode_oldsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbcode_oldsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbcode_oldsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbcode_oldsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbcode_oldsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode_old">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_bcode_old" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bcode_oldlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_weaving_works" class="bcode_old_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
        <th data-name="current_works" class="<?= $Page->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_current_works" class="bcode_old_current_works"><?= $Page->renderFieldHeader($Page->current_works) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_bcode_old_po" class="bcode_old_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>" style="min-width: 300px;"><div id="elh_bcode_old__barcode" class="bcode_old__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_bcode_old_buyers_id" class="bcode_old_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_bcode_old_buyer_ref" class="bcode_old_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
        <th data-name="design_id" class="<?= $Page->design_id->headerCellClass() ?>"><div id="elh_bcode_old_design_id" class="bcode_old_design_id"><?= $Page->renderFieldHeader($Page->design_id) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_bcode_old_batch_no" class="bcode_old_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_bcode_old_sqm" class="bcode_old_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_bcode_old_shape" class="bcode_old_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
        <th data-name="cs" class="<?= $Page->cs->headerCellClass() ?>"><div id="elh_bcode_old_cs" class="bcode_old_cs"><?= $Page->renderFieldHeader($Page->cs) ?></div></th>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Page->product_type->headerCellClass() ?>"><div id="elh_bcode_old_product_type" class="bcode_old_product_type"><?= $Page->renderFieldHeader($Page->product_type) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_bcode_old_size_cm" class="bcode_old_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_bcode_old_buyer_uid" class="bcode_old_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <th data-name="buyer_loc" class="<?= $Page->buyer_loc->headerCellClass() ?>"><div id="elh_bcode_old_buyer_loc" class="bcode_old_buyer_loc"><?= $Page->renderFieldHeader($Page->buyer_loc) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_bcode_old_quantity" class="bcode_old_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
        <th data-name="po_price" class="<?= $Page->po_price->headerCellClass() ?>"><div id="elh_bcode_old_po_price" class="bcode_old_po_price"><?= $Page->renderFieldHeader($Page->po_price) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_bcode_old_despatch_week" class="bcode_old_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>"><div id="elh_bcode_old_despatch_date" class="bcode_old_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_bcode_old_status" class="bcode_old_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
        <th data-name="completed" class="<?= $Page->completed->headerCellClass() ?>"><div id="elh_bcode_old_completed" class="bcode_old_completed"><?= $Page->renderFieldHeader($Page->completed) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <th data-name="buyer_po" class="<?= $Page->buyer_po->headerCellClass() ?>"><div id="elh_bcode_old_buyer_po" class="bcode_old_buyer_po"><?= $Page->renderFieldHeader($Page->buyer_po) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_bcode_old_jc_no" class="bcode_old_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
        <th data-name="process_d" class="<?= $Page->process_d->headerCellClass() ?>"><div id="elh_bcode_old_process_d" class="bcode_old_process_d"><?= $Page->renderFieldHeader($Page->process_d) ?></div></th>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
        <th data-name="weight" class="<?= $Page->weight->headerCellClass() ?>"><div id="elh_bcode_old_weight" class="bcode_old_weight"><?= $Page->renderFieldHeader($Page->weight) ?></div></th>
<?php } ?>
<?php if ($Page->po_currency->Visible) { // po_currency ?>
        <th data-name="po_currency" class="<?= $Page->po_currency->headerCellClass() ?>"><div id="elh_bcode_old_po_currency" class="bcode_old_po_currency"><?= $Page->renderFieldHeader($Page->po_currency) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
        <th data-name="dispatch_week_p" class="<?= $Page->dispatch_week_p->headerCellClass() ?>"><div id="elh_bcode_old_dispatch_week_p" class="bcode_old_dispatch_week_p"><?= $Page->renderFieldHeader($Page->dispatch_week_p) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_bcode_old_remarks" class="bcode_old_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_bcode_old_pl_no" class="bcode_old_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_bcode_old_category" class="bcode_old_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
        <th data-name="roll_no" class="<?= $Page->roll_no->headerCellClass() ?>"><div id="elh_bcode_old_roll_no" class="bcode_old_roll_no"><?= $Page->renderFieldHeader($Page->roll_no) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <th data-name="buyer_barcode" class="<?= $Page->buyer_barcode->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old_buyer_barcode" class="bcode_old_buyer_barcode"><?= $Page->renderFieldHeader($Page->buyer_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
        <th data-name="q_sku" class="<?= $Page->q_sku->headerCellClass() ?>"><div id="elh_bcode_old_q_sku" class="bcode_old_q_sku"><?= $Page->renderFieldHeader($Page->q_sku) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_u->Visible) { // sqm_u ?>
        <th data-name="sqm_u" class="<?= $Page->sqm_u->headerCellClass() ?>"><div id="elh_bcode_old_sqm_u" class="bcode_old_sqm_u"><?= $Page->renderFieldHeader($Page->sqm_u) ?></div></th>
<?php } ?>
<?php if ($Page->po_discount->Visible) { // po_discount ?>
        <th data-name="po_discount" class="<?= $Page->po_discount->headerCellClass() ?>"><div id="elh_bcode_old_po_discount" class="bcode_old_po_discount"><?= $Page->renderFieldHeader($Page->po_discount) ?></div></th>
<?php } ?>
<?php if ($Page->_11->Visible) { // 11 ?>
        <th data-name="_11" class="<?= $Page->_11->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__11" class="bcode_old__11"><?= $Page->renderFieldHeader($Page->_11) ?></div></th>
<?php } ?>
<?php if ($Page->_12->Visible) { // 12 ?>
        <th data-name="_12" class="<?= $Page->_12->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__12" class="bcode_old__12"><?= $Page->renderFieldHeader($Page->_12) ?></div></th>
<?php } ?>
<?php if ($Page->_13->Visible) { // 13 ?>
        <th data-name="_13" class="<?= $Page->_13->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__13" class="bcode_old__13"><?= $Page->renderFieldHeader($Page->_13) ?></div></th>
<?php } ?>
<?php if ($Page->_14->Visible) { // 14 ?>
        <th data-name="_14" class="<?= $Page->_14->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__14" class="bcode_old__14"><?= $Page->renderFieldHeader($Page->_14) ?></div></th>
<?php } ?>
<?php if ($Page->_15->Visible) { // 15 ?>
        <th data-name="_15" class="<?= $Page->_15->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__15" class="bcode_old__15"><?= $Page->renderFieldHeader($Page->_15) ?></div></th>
<?php } ?>
<?php if ($Page->_16->Visible) { // 16 ?>
        <th data-name="_16" class="<?= $Page->_16->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__16" class="bcode_old__16"><?= $Page->renderFieldHeader($Page->_16) ?></div></th>
<?php } ?>
<?php if ($Page->_17->Visible) { // 17 ?>
        <th data-name="_17" class="<?= $Page->_17->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__17" class="bcode_old__17"><?= $Page->renderFieldHeader($Page->_17) ?></div></th>
<?php } ?>
<?php if ($Page->_18->Visible) { // 18 ?>
        <th data-name="_18" class="<?= $Page->_18->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__18" class="bcode_old__18"><?= $Page->renderFieldHeader($Page->_18) ?></div></th>
<?php } ?>
<?php if ($Page->_19->Visible) { // 19 ?>
        <th data-name="_19" class="<?= $Page->_19->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__19" class="bcode_old__19"><?= $Page->renderFieldHeader($Page->_19) ?></div></th>
<?php } ?>
<?php if ($Page->_20->Visible) { // 20 ?>
        <th data-name="_20" class="<?= $Page->_20->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__20" class="bcode_old__20"><?= $Page->renderFieldHeader($Page->_20) ?></div></th>
<?php } ?>
<?php if ($Page->_21->Visible) { // 21 ?>
        <th data-name="_21" class="<?= $Page->_21->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__21" class="bcode_old__21"><?= $Page->renderFieldHeader($Page->_21) ?></div></th>
<?php } ?>
<?php if ($Page->_22->Visible) { // 22 ?>
        <th data-name="_22" class="<?= $Page->_22->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__22" class="bcode_old__22"><?= $Page->renderFieldHeader($Page->_22) ?></div></th>
<?php } ?>
<?php if ($Page->_23->Visible) { // 23 ?>
        <th data-name="_23" class="<?= $Page->_23->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__23" class="bcode_old__23"><?= $Page->renderFieldHeader($Page->_23) ?></div></th>
<?php } ?>
<?php if ($Page->_24->Visible) { // 24 ?>
        <th data-name="_24" class="<?= $Page->_24->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__24" class="bcode_old__24"><?= $Page->renderFieldHeader($Page->_24) ?></div></th>
<?php } ?>
<?php if ($Page->_25->Visible) { // 25 ?>
        <th data-name="_25" class="<?= $Page->_25->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__25" class="bcode_old__25"><?= $Page->renderFieldHeader($Page->_25) ?></div></th>
<?php } ?>
<?php if ($Page->_26->Visible) { // 26 ?>
        <th data-name="_26" class="<?= $Page->_26->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__26" class="bcode_old__26"><?= $Page->renderFieldHeader($Page->_26) ?></div></th>
<?php } ?>
<?php if ($Page->_27->Visible) { // 27 ?>
        <th data-name="_27" class="<?= $Page->_27->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__27" class="bcode_old__27"><?= $Page->renderFieldHeader($Page->_27) ?></div></th>
<?php } ?>
<?php if ($Page->_28->Visible) { // 28 ?>
        <th data-name="_28" class="<?= $Page->_28->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__28" class="bcode_old__28"><?= $Page->renderFieldHeader($Page->_28) ?></div></th>
<?php } ?>
<?php if ($Page->_29->Visible) { // 29 ?>
        <th data-name="_29" class="<?= $Page->_29->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__29" class="bcode_old__29"><?= $Page->renderFieldHeader($Page->_29) ?></div></th>
<?php } ?>
<?php if ($Page->_30->Visible) { // 30 ?>
        <th data-name="_30" class="<?= $Page->_30->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__30" class="bcode_old__30"><?= $Page->renderFieldHeader($Page->_30) ?></div></th>
<?php } ?>
<?php if ($Page->_31->Visible) { // 31 ?>
        <th data-name="_31" class="<?= $Page->_31->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__31" class="bcode_old__31"><?= $Page->renderFieldHeader($Page->_31) ?></div></th>
<?php } ?>
<?php if ($Page->_32->Visible) { // 32 ?>
        <th data-name="_32" class="<?= $Page->_32->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__32" class="bcode_old__32"><?= $Page->renderFieldHeader($Page->_32) ?></div></th>
<?php } ?>
<?php if ($Page->_33->Visible) { // 33 ?>
        <th data-name="_33" class="<?= $Page->_33->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__33" class="bcode_old__33"><?= $Page->renderFieldHeader($Page->_33) ?></div></th>
<?php } ?>
<?php if ($Page->_34->Visible) { // 34 ?>
        <th data-name="_34" class="<?= $Page->_34->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__34" class="bcode_old__34"><?= $Page->renderFieldHeader($Page->_34) ?></div></th>
<?php } ?>
<?php if ($Page->_35->Visible) { // 35 ?>
        <th data-name="_35" class="<?= $Page->_35->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__35" class="bcode_old__35"><?= $Page->renderFieldHeader($Page->_35) ?></div></th>
<?php } ?>
<?php if ($Page->_36->Visible) { // 36 ?>
        <th data-name="_36" class="<?= $Page->_36->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__36" class="bcode_old__36"><?= $Page->renderFieldHeader($Page->_36) ?></div></th>
<?php } ?>
<?php if ($Page->_37->Visible) { // 37 ?>
        <th data-name="_37" class="<?= $Page->_37->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__37" class="bcode_old__37"><?= $Page->renderFieldHeader($Page->_37) ?></div></th>
<?php } ?>
<?php if ($Page->_38->Visible) { // 38 ?>
        <th data-name="_38" class="<?= $Page->_38->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__38" class="bcode_old__38"><?= $Page->renderFieldHeader($Page->_38) ?></div></th>
<?php } ?>
<?php if ($Page->_39->Visible) { // 39 ?>
        <th data-name="_39" class="<?= $Page->_39->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__39" class="bcode_old__39"><?= $Page->renderFieldHeader($Page->_39) ?></div></th>
<?php } ?>
<?php if ($Page->_40->Visible) { // 40 ?>
        <th data-name="_40" class="<?= $Page->_40->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__40" class="bcode_old__40"><?= $Page->renderFieldHeader($Page->_40) ?></div></th>
<?php } ?>
<?php if ($Page->_41->Visible) { // 41 ?>
        <th data-name="_41" class="<?= $Page->_41->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__41" class="bcode_old__41"><?= $Page->renderFieldHeader($Page->_41) ?></div></th>
<?php } ?>
<?php if ($Page->_42->Visible) { // 42 ?>
        <th data-name="_42" class="<?= $Page->_42->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__42" class="bcode_old__42"><?= $Page->renderFieldHeader($Page->_42) ?></div></th>
<?php } ?>
<?php if ($Page->_43->Visible) { // 43 ?>
        <th data-name="_43" class="<?= $Page->_43->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__43" class="bcode_old__43"><?= $Page->renderFieldHeader($Page->_43) ?></div></th>
<?php } ?>
<?php if ($Page->_44->Visible) { // 44 ?>
        <th data-name="_44" class="<?= $Page->_44->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__44" class="bcode_old__44"><?= $Page->renderFieldHeader($Page->_44) ?></div></th>
<?php } ?>
<?php if ($Page->_45->Visible) { // 45 ?>
        <th data-name="_45" class="<?= $Page->_45->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__45" class="bcode_old__45"><?= $Page->renderFieldHeader($Page->_45) ?></div></th>
<?php } ?>
<?php if ($Page->_46->Visible) { // 46 ?>
        <th data-name="_46" class="<?= $Page->_46->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__46" class="bcode_old__46"><?= $Page->renderFieldHeader($Page->_46) ?></div></th>
<?php } ?>
<?php if ($Page->_47->Visible) { // 47 ?>
        <th data-name="_47" class="<?= $Page->_47->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__47" class="bcode_old__47"><?= $Page->renderFieldHeader($Page->_47) ?></div></th>
<?php } ?>
<?php if ($Page->_48->Visible) { // 48 ?>
        <th data-name="_48" class="<?= $Page->_48->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__48" class="bcode_old__48"><?= $Page->renderFieldHeader($Page->_48) ?></div></th>
<?php } ?>
<?php if ($Page->_49->Visible) { // 49 ?>
        <th data-name="_49" class="<?= $Page->_49->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__49" class="bcode_old__49"><?= $Page->renderFieldHeader($Page->_49) ?></div></th>
<?php } ?>
<?php if ($Page->_50->Visible) { // 50 ?>
        <th data-name="_50" class="<?= $Page->_50->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_bcode_old__50" class="bcode_old__50"><?= $Page->renderFieldHeader($Page->_50) ?></div></th>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
        <th data-name="order_date" class="<?= $Page->order_date->headerCellClass() ?>"><div id="elh_bcode_old_order_date" class="bcode_old_order_date"><?= $Page->renderFieldHeader($Page->order_date) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_weaving_works" class="el_bcode_old_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works"<?= $Page->current_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_current_works" class="el_bcode_old_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<?= $Page->current_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_po" class="el_bcode_old_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__barcode" class="el_bcode_old__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyers_id" class="el_bcode_old_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyers_id->getViewValue()) && $Page->buyers_id->linkAttributes() != "") { ?>
<a<?= $Page->buyers_id->linkAttributes() ?>><?= $Page->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyer_ref" class="el_bcode_old_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_ref->getViewValue()) && $Page->buyer_ref->linkAttributes() != "") { ?>
<a<?= $Page->buyer_ref->linkAttributes() ?>><?= $Page->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_id->Visible) { // design_id ?>
        <td data-name="design_id"<?= $Page->design_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_design_id" class="el_bcode_old_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->getViewValue()) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><?= $Page->design_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_batch_no" class="el_bcode_old_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->getViewValue()) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><?= $Page->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_sqm" class="el_bcode_old_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_shape" class="el_bcode_old_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cs->Visible) { // cs ?>
        <td data-name="cs"<?= $Page->cs->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_cs" class="el_bcode_old_cs">
<span<?= $Page->cs->viewAttributes() ?>>
<?= $Page->cs->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_product_type" class="el_bcode_old_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_size_cm" class="el_bcode_old_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyer_uid" class="el_bcode_old_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc"<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyer_loc" class="el_bcode_old_buyer_loc">
<span<?= $Page->buyer_loc->viewAttributes() ?>>
<?= $Page->buyer_loc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_quantity" class="el_bcode_old_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_price->Visible) { // po_price ?>
        <td data-name="po_price"<?= $Page->po_price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_po_price" class="el_bcode_old_po_price">
<span<?= $Page->po_price->viewAttributes() ?>>
<?= $Page->po_price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_despatch_week" class="el_bcode_old_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_despatch_date" class="el_bcode_old_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_status" class="el_bcode_old_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed"<?= $Page->completed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_completed" class="el_bcode_old_completed">
<span<?= $Page->completed->viewAttributes() ?>>
<?= $Page->completed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po"<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyer_po" class="el_bcode_old_buyer_po">
<span<?= $Page->buyer_po->viewAttributes() ?>>
<?= $Page->buyer_po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_jc_no" class="el_bcode_old_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d"<?= $Page->process_d->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_process_d" class="el_bcode_old_process_d">
<span<?= $Page->process_d->viewAttributes() ?>>
<?= $Page->process_d->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight->Visible) { // weight ?>
        <td data-name="weight"<?= $Page->weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_weight" class="el_bcode_old_weight">
<span<?= $Page->weight->viewAttributes() ?>>
<?= $Page->weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_currency->Visible) { // po_currency ?>
        <td data-name="po_currency"<?= $Page->po_currency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_po_currency" class="el_bcode_old_po_currency">
<span<?= $Page->po_currency->viewAttributes() ?>>
<?= $Page->po_currency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
        <td data-name="dispatch_week_p"<?= $Page->dispatch_week_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_dispatch_week_p" class="el_bcode_old_dispatch_week_p">
<span<?= $Page->dispatch_week_p->viewAttributes() ?>>
<?= $Page->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_remarks" class="el_bcode_old_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_pl_no" class="el_bcode_old_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?= $Page->pl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_category" class="el_bcode_old_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->roll_no->Visible) { // roll_no ?>
        <td data-name="roll_no"<?= $Page->roll_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_roll_no" class="el_bcode_old_roll_no">
<span<?= $Page->roll_no->viewAttributes() ?>>
<?= $Page->roll_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode"<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_buyer_barcode" class="el_bcode_old_buyer_barcode">
<span<?= $Page->buyer_barcode->viewAttributes() ?>>
<?= $Page->buyer_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->q_sku->Visible) { // q_sku ?>
        <td data-name="q_sku"<?= $Page->q_sku->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_q_sku" class="el_bcode_old_q_sku">
<span<?= $Page->q_sku->viewAttributes() ?>>
<?= $Page->q_sku->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_u->Visible) { // sqm_u ?>
        <td data-name="sqm_u"<?= $Page->sqm_u->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_sqm_u" class="el_bcode_old_sqm_u">
<span<?= $Page->sqm_u->viewAttributes() ?>>
<?= $Page->sqm_u->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_discount->Visible) { // po_discount ?>
        <td data-name="po_discount"<?= $Page->po_discount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_po_discount" class="el_bcode_old_po_discount">
<span<?= $Page->po_discount->viewAttributes() ?>>
<?= $Page->po_discount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_11->Visible) { // 11 ?>
        <td data-name="_11"<?= $Page->_11->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__11" class="el_bcode_old__11">
<span<?= $Page->_11->viewAttributes() ?>>
<?= $Page->_11->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_12->Visible) { // 12 ?>
        <td data-name="_12"<?= $Page->_12->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__12" class="el_bcode_old__12">
<span<?= $Page->_12->viewAttributes() ?>>
<?= $Page->_12->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_13->Visible) { // 13 ?>
        <td data-name="_13"<?= $Page->_13->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__13" class="el_bcode_old__13">
<span<?= $Page->_13->viewAttributes() ?>>
<?= $Page->_13->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_14->Visible) { // 14 ?>
        <td data-name="_14"<?= $Page->_14->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__14" class="el_bcode_old__14">
<span<?= $Page->_14->viewAttributes() ?>>
<?= $Page->_14->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_15->Visible) { // 15 ?>
        <td data-name="_15"<?= $Page->_15->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__15" class="el_bcode_old__15">
<span<?= $Page->_15->viewAttributes() ?>>
<?= $Page->_15->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_16->Visible) { // 16 ?>
        <td data-name="_16"<?= $Page->_16->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__16" class="el_bcode_old__16">
<span<?= $Page->_16->viewAttributes() ?>>
<?= $Page->_16->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_17->Visible) { // 17 ?>
        <td data-name="_17"<?= $Page->_17->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__17" class="el_bcode_old__17">
<span<?= $Page->_17->viewAttributes() ?>>
<?= $Page->_17->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_18->Visible) { // 18 ?>
        <td data-name="_18"<?= $Page->_18->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__18" class="el_bcode_old__18">
<span<?= $Page->_18->viewAttributes() ?>>
<?= $Page->_18->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_19->Visible) { // 19 ?>
        <td data-name="_19"<?= $Page->_19->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__19" class="el_bcode_old__19">
<span<?= $Page->_19->viewAttributes() ?>>
<?= $Page->_19->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_20->Visible) { // 20 ?>
        <td data-name="_20"<?= $Page->_20->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__20" class="el_bcode_old__20">
<span<?= $Page->_20->viewAttributes() ?>>
<?= $Page->_20->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_21->Visible) { // 21 ?>
        <td data-name="_21"<?= $Page->_21->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__21" class="el_bcode_old__21">
<span<?= $Page->_21->viewAttributes() ?>>
<?= $Page->_21->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_22->Visible) { // 22 ?>
        <td data-name="_22"<?= $Page->_22->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__22" class="el_bcode_old__22">
<span<?= $Page->_22->viewAttributes() ?>>
<?= $Page->_22->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_23->Visible) { // 23 ?>
        <td data-name="_23"<?= $Page->_23->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__23" class="el_bcode_old__23">
<span<?= $Page->_23->viewAttributes() ?>>
<?= $Page->_23->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_24->Visible) { // 24 ?>
        <td data-name="_24"<?= $Page->_24->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__24" class="el_bcode_old__24">
<span<?= $Page->_24->viewAttributes() ?>>
<?= $Page->_24->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_25->Visible) { // 25 ?>
        <td data-name="_25"<?= $Page->_25->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__25" class="el_bcode_old__25">
<span<?= $Page->_25->viewAttributes() ?>>
<?= $Page->_25->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_26->Visible) { // 26 ?>
        <td data-name="_26"<?= $Page->_26->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__26" class="el_bcode_old__26">
<span<?= $Page->_26->viewAttributes() ?>>
<?= $Page->_26->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_27->Visible) { // 27 ?>
        <td data-name="_27"<?= $Page->_27->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__27" class="el_bcode_old__27">
<span<?= $Page->_27->viewAttributes() ?>>
<?= $Page->_27->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_28->Visible) { // 28 ?>
        <td data-name="_28"<?= $Page->_28->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__28" class="el_bcode_old__28">
<span<?= $Page->_28->viewAttributes() ?>>
<?= $Page->_28->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_29->Visible) { // 29 ?>
        <td data-name="_29"<?= $Page->_29->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__29" class="el_bcode_old__29">
<span<?= $Page->_29->viewAttributes() ?>>
<?= $Page->_29->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_30->Visible) { // 30 ?>
        <td data-name="_30"<?= $Page->_30->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__30" class="el_bcode_old__30">
<span<?= $Page->_30->viewAttributes() ?>>
<?= $Page->_30->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_31->Visible) { // 31 ?>
        <td data-name="_31"<?= $Page->_31->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__31" class="el_bcode_old__31">
<span<?= $Page->_31->viewAttributes() ?>>
<?= $Page->_31->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_32->Visible) { // 32 ?>
        <td data-name="_32"<?= $Page->_32->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__32" class="el_bcode_old__32">
<span<?= $Page->_32->viewAttributes() ?>>
<?= $Page->_32->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_33->Visible) { // 33 ?>
        <td data-name="_33"<?= $Page->_33->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__33" class="el_bcode_old__33">
<span<?= $Page->_33->viewAttributes() ?>>
<?= $Page->_33->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_34->Visible) { // 34 ?>
        <td data-name="_34"<?= $Page->_34->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__34" class="el_bcode_old__34">
<span<?= $Page->_34->viewAttributes() ?>>
<?= $Page->_34->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_35->Visible) { // 35 ?>
        <td data-name="_35"<?= $Page->_35->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__35" class="el_bcode_old__35">
<span<?= $Page->_35->viewAttributes() ?>>
<?= $Page->_35->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_36->Visible) { // 36 ?>
        <td data-name="_36"<?= $Page->_36->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__36" class="el_bcode_old__36">
<span<?= $Page->_36->viewAttributes() ?>>
<?= $Page->_36->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_37->Visible) { // 37 ?>
        <td data-name="_37"<?= $Page->_37->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__37" class="el_bcode_old__37">
<span<?= $Page->_37->viewAttributes() ?>>
<?= $Page->_37->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_38->Visible) { // 38 ?>
        <td data-name="_38"<?= $Page->_38->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__38" class="el_bcode_old__38">
<span<?= $Page->_38->viewAttributes() ?>>
<?= $Page->_38->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_39->Visible) { // 39 ?>
        <td data-name="_39"<?= $Page->_39->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__39" class="el_bcode_old__39">
<span<?= $Page->_39->viewAttributes() ?>>
<?= $Page->_39->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_40->Visible) { // 40 ?>
        <td data-name="_40"<?= $Page->_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__40" class="el_bcode_old__40">
<span<?= $Page->_40->viewAttributes() ?>>
<?= $Page->_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_41->Visible) { // 41 ?>
        <td data-name="_41"<?= $Page->_41->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__41" class="el_bcode_old__41">
<span<?= $Page->_41->viewAttributes() ?>>
<?= $Page->_41->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_42->Visible) { // 42 ?>
        <td data-name="_42"<?= $Page->_42->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__42" class="el_bcode_old__42">
<span<?= $Page->_42->viewAttributes() ?>>
<?= $Page->_42->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_43->Visible) { // 43 ?>
        <td data-name="_43"<?= $Page->_43->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__43" class="el_bcode_old__43">
<span<?= $Page->_43->viewAttributes() ?>>
<?= $Page->_43->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_44->Visible) { // 44 ?>
        <td data-name="_44"<?= $Page->_44->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__44" class="el_bcode_old__44">
<span<?= $Page->_44->viewAttributes() ?>>
<?= $Page->_44->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_45->Visible) { // 45 ?>
        <td data-name="_45"<?= $Page->_45->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__45" class="el_bcode_old__45">
<span<?= $Page->_45->viewAttributes() ?>>
<?= $Page->_45->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_46->Visible) { // 46 ?>
        <td data-name="_46"<?= $Page->_46->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__46" class="el_bcode_old__46">
<span<?= $Page->_46->viewAttributes() ?>>
<?= $Page->_46->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_47->Visible) { // 47 ?>
        <td data-name="_47"<?= $Page->_47->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__47" class="el_bcode_old__47">
<span<?= $Page->_47->viewAttributes() ?>>
<?= $Page->_47->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_48->Visible) { // 48 ?>
        <td data-name="_48"<?= $Page->_48->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__48" class="el_bcode_old__48">
<span<?= $Page->_48->viewAttributes() ?>>
<?= $Page->_48->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_49->Visible) { // 49 ?>
        <td data-name="_49"<?= $Page->_49->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__49" class="el_bcode_old__49">
<span<?= $Page->_49->viewAttributes() ?>>
<?= $Page->_49->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_50->Visible) { // 50 ?>
        <td data-name="_50"<?= $Page->_50->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old__50" class="el_bcode_old__50">
<span<?= $Page->_50->viewAttributes() ?>>
<?= $Page->_50->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date"<?= $Page->order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_bcode_old_order_date" class="el_bcode_old_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<?= $Page->order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
