<?php

namespace PHPMaker2024\fibre;

// Page object
$BcodeEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fbcodeedit" id="fbcodeedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bcode: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fbcodeedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbcodeedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["buyer_ref", [fields.buyer_ref.visible && fields.buyer_ref.required ? ew.Validators.required(fields.buyer_ref.caption) : null], fields.buyer_ref.isInvalid],
            ["order_date", [fields.order_date.visible && fields.order_date.required ? ew.Validators.required(fields.order_date.caption) : null, ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null], fields.despatch_date.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["dispatch_week_p", [fields.dispatch_week_p.visible && fields.dispatch_week_p.required ? ew.Validators.required(fields.dispatch_week_p.caption) : null], fields.dispatch_week_p.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["buyers_id", [fields.buyers_id.visible && fields.buyers_id.required ? ew.Validators.required(fields.buyers_id.caption) : null], fields.buyers_id.isInvalid],
            ["buyer_uid", [fields.buyer_uid.visible && fields.buyer_uid.required ? ew.Validators.required(fields.buyer_uid.caption) : null], fields.buyer_uid.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["sqm_u", [fields.sqm_u.visible && fields.sqm_u.required ? ew.Validators.required(fields.sqm_u.caption) : null, ew.Validators.float], fields.sqm_u.isInvalid],
            ["c_sqm", [fields.c_sqm.visible && fields.c_sqm.required ? ew.Validators.required(fields.c_sqm.caption) : null, ew.Validators.float], fields.c_sqm.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["current_works", [fields.current_works.visible && fields.current_works.required ? ew.Validators.required(fields.current_works.caption) : null], fields.current_works.isInvalid],
            ["size_buyer", [fields.size_buyer.visible && fields.size_buyer.required ? ew.Validators.required(fields.size_buyer.caption) : null], fields.size_buyer.isInvalid],
            ["w_cm", [fields.w_cm.visible && fields.w_cm.required ? ew.Validators.required(fields.w_cm.caption) : null, ew.Validators.integer], fields.w_cm.isInvalid],
            ["l_cm", [fields.l_cm.visible && fields.l_cm.required ? ew.Validators.required(fields.l_cm.caption) : null, ew.Validators.integer], fields.l_cm.isInvalid],
            ["q_sku", [fields.q_sku.visible && fields.q_sku.required ? ew.Validators.required(fields.q_sku.caption) : null, ew.Validators.float], fields.q_sku.isInvalid],
            ["po_price", [fields.po_price.visible && fields.po_price.required ? ew.Validators.required(fields.po_price.caption) : null], fields.po_price.isInvalid],
            ["po_discount", [fields.po_discount.visible && fields.po_discount.required ? ew.Validators.required(fields.po_discount.caption) : null, ew.Validators.float], fields.po_discount.isInvalid],
            ["po_currency", [fields.po_currency.visible && fields.po_currency.required ? ew.Validators.required(fields.po_currency.caption) : null], fields.po_currency.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["completed", [fields.completed.visible && fields.completed.required ? ew.Validators.required(fields.completed.caption) : null], fields.completed.isInvalid],
            ["buyer_po", [fields.buyer_po.visible && fields.buyer_po.required ? ew.Validators.required(fields.buyer_po.caption) : null], fields.buyer_po.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null, ew.Validators.integer], fields.jc_no.isInvalid],
            ["sqm_a", [fields.sqm_a.visible && fields.sqm_a.required ? ew.Validators.required(fields.sqm_a.caption) : null, ew.Validators.float], fields.sqm_a.isInvalid],
            ["_2srm_a", [fields._2srm_a.visible && fields._2srm_a.required ? ew.Validators.required(fields._2srm_a.caption) : null, ew.Validators.float], fields._2srm_a.isInvalid],
            ["_4srm_a", [fields._4srm_a.visible && fields._4srm_a.required ? ew.Validators.required(fields._4srm_a.caption) : null, ew.Validators.float], fields._4srm_a.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["cs", [fields.cs.visible && fields.cs.required ? ew.Validators.required(fields.cs.caption) : null], fields.cs.isInvalid],
            ["weight", [fields.weight.visible && fields.weight.required ? ew.Validators.required(fields.weight.caption) : null, ew.Validators.float], fields.weight.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["p_remarks", [fields.p_remarks.visible && fields.p_remarks.required ? ew.Validators.required(fields.p_remarks.caption) : null], fields.p_remarks.isInvalid],
            ["roll_no", [fields.roll_no.visible && fields.roll_no.required ? ew.Validators.required(fields.roll_no.caption) : null], fields.roll_no.isInvalid],
            ["qty", [fields.qty.visible && fields.qty.required ? ew.Validators.required(fields.qty.caption) : null], fields.qty.isInvalid],
            ["pl_no", [fields.pl_no.visible && fields.pl_no.required ? ew.Validators.required(fields.pl_no.caption) : null], fields.pl_no.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["pp_id", [fields.pp_id.visible && fields.pp_id.required ? ew.Validators.required(fields.pp_id.caption) : null, ew.Validators.integer], fields.pp_id.isInvalid],
            ["buyer_barcode", [fields.buyer_barcode.visible && fields.buyer_barcode.required ? ew.Validators.required(fields.buyer_barcode.caption) : null], fields.buyer_barcode.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "production_plan": <?= $Page->production_plan->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "cs": <?= $Page->cs->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bcode">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_bcode_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_bcode_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_bcode_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_bcode_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id"<?= $Page->design_id->rowAttributes() ?>>
        <label id="elh_bcode_design_id" for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design_id->caption() ?><?= $Page->design_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design_id->cellAttributes() ?>>
<span id="el_bcode_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->design_id->EditValue) && $Page->design_id->linkAttributes() != "") { ?>
<a<?= $Page->design_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode" data-field="x_design_id" data-hidden="1" name="x_design_id" id="x_design_id" value="<?= HtmlEncode($Page->design_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_bcode_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_bcode_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_cm->getDisplayValue($Page->size_cm->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_size_cm" data-hidden="1" name="x_size_cm" id="x_size_cm" value="<?= HtmlEncode($Page->size_cm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_bcode__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_bcode__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_barcode->getDisplayValue($Page->_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x__barcode" data-hidden="1" name="x__barcode" id="x__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label id="elh_bcode_buyer_ref" for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_ref->caption() ?><?= $Page->buyer_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_ref->EditValue) && $Page->buyer_ref->linkAttributes() != "") { ?>
<a<?= $Page->buyer_ref->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyer_ref->getDisplayValue($Page->buyer_ref->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyer_ref->getDisplayValue($Page->buyer_ref->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyer_ref" data-hidden="1" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date"<?= $Page->order_date->rowAttributes() ?>>
        <label id="elh_bcode_order_date" for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_date->caption() ?><?= $Page->order_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_date->cellAttributes() ?>>
<span id="el_bcode_order_date">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="bcode" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?> aria-describedby="x_order_date_help">
<?= $Page->order_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage() ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbcodeedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbcodeedit", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_bcode_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_bcode_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->despatch_date->getDisplayValue($Page->despatch_date->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_despatch_date" data-hidden="1" name="x_despatch_date" id="x_despatch_date" value="<?= HtmlEncode($Page->despatch_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_bcode_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_bcode_despatch_week">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_despatch_week"
        <?php } ?>
        data-table="bcode"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <?= $Page->despatch_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_despatch_week", selectId: "fbcodeedit_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
    <div id="r_dispatch_week_p"<?= $Page->dispatch_week_p->rowAttributes() ?>>
        <label id="elh_bcode_dispatch_week_p" for="x_dispatch_week_p" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dispatch_week_p->caption() ?><?= $Page->dispatch_week_p->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dispatch_week_p->cellAttributes() ?>>
<span id="el_bcode_dispatch_week_p">
<span<?= $Page->dispatch_week_p->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->dispatch_week_p->getDisplayValue($Page->dispatch_week_p->EditValue) ?></span></span>
<input type="hidden" data-table="bcode" data-field="x_dispatch_week_p" data-hidden="1" name="x_dispatch_week_p" id="x_dispatch_week_p" value="<?= HtmlEncode($Page->dispatch_week_p->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_bcode_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_bcode_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_status"
        <?php } ?>
        data-table="bcode"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_status", selectId: "fbcodeedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_status", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id"<?= $Page->buyers_id->rowAttributes() ?>>
        <label id="elh_bcode_buyers_id" for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyers_id->caption() ?><?= $Page->buyers_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el_bcode_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyers_id->EditValue) && $Page->buyers_id->linkAttributes() != "") { ?>
<a<?= $Page->buyers_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyers_id" data-hidden="1" name="x_buyers_id" id="x_buyers_id" value="<?= HtmlEncode($Page->buyers_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label id="elh_bcode_buyer_uid" for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_uid->caption() ?><?= $Page->buyer_uid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_buyer_uid">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="bcode" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?> aria-describedby="x_buyer_uid_help">
<?= $Page->buyer_uid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label id="elh_bcode_buyer_loc" for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_loc->caption() ?><?= $Page->buyer_loc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el_bcode_buyer_loc">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="bcode" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help">
<?= $Page->buyer_loc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_bcode_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_bcode_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->quantity->getDisplayValue($Page->quantity->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_quantity" data-hidden="1" name="x_quantity" id="x_quantity" value="<?= HtmlEncode($Page->quantity->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_bcode_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_bcode_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm_u->Visible) { // sqm_u ?>
    <div id="r_sqm_u"<?= $Page->sqm_u->rowAttributes() ?>>
        <label id="elh_bcode_sqm_u" for="x_sqm_u" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm_u->caption() ?><?= $Page->sqm_u->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm_u->cellAttributes() ?>>
<span id="el_bcode_sqm_u">
<input type="<?= $Page->sqm_u->getInputTextType() ?>" name="x_sqm_u" id="x_sqm_u" data-table="bcode" data-field="x_sqm_u" value="<?= $Page->sqm_u->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_u->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_u->formatPattern()) ?>"<?= $Page->sqm_u->editAttributes() ?> aria-describedby="x_sqm_u_help">
<?= $Page->sqm_u->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm_u->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->c_sqm->Visible) { // c_sqm ?>
    <div id="r_c_sqm"<?= $Page->c_sqm->rowAttributes() ?>>
        <label id="elh_bcode_c_sqm" for="x_c_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->c_sqm->caption() ?><?= $Page->c_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->c_sqm->cellAttributes() ?>>
<span id="el_bcode_c_sqm">
<input type="<?= $Page->c_sqm->getInputTextType() ?>" name="x_c_sqm" id="x_c_sqm" data-table="bcode" data-field="x_c_sqm" value="<?= $Page->c_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_sqm->formatPattern()) ?>"<?= $Page->c_sqm->editAttributes() ?> aria-describedby="x_c_sqm_help">
<?= $Page->c_sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->c_sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label id="elh_bcode_weaving_works" for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weaving_works->caption() ?><?= $Page->weaving_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el_bcode_weaving_works">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_weaving_works"
        <?php } ?>
        data-table="bcode"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <?= $Page->weaving_works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_weaving_works", selectId: "fbcodeedit_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works"<?= $Page->current_works->rowAttributes() ?>>
        <label id="elh_bcode_current_works" for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_works->caption() ?><?= $Page->current_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_works->cellAttributes() ?>>
<span id="el_bcode_current_works">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_current_works"
        <?php } ?>
        data-table="bcode"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <?= $Page->current_works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage() ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_current_works", selectId: "fbcodeedit_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer"<?= $Page->size_buyer->rowAttributes() ?>>
        <label id="elh_bcode_size_buyer" for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_buyer->caption() ?><?= $Page->size_buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el_bcode_size_buyer">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="bcode" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?> aria-describedby="x_size_buyer_help">
<?= $Page->size_buyer->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm"<?= $Page->w_cm->rowAttributes() ?>>
        <label id="elh_bcode_w_cm" for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->w_cm->caption() ?><?= $Page->w_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->w_cm->cellAttributes() ?>>
<span id="el_bcode_w_cm">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="bcode" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?> aria-describedby="x_w_cm_help">
<?= $Page->w_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm"<?= $Page->l_cm->rowAttributes() ?>>
        <label id="elh_bcode_l_cm" for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->l_cm->caption() ?><?= $Page->l_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->l_cm->cellAttributes() ?>>
<span id="el_bcode_l_cm">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="bcode" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?> aria-describedby="x_l_cm_help">
<?= $Page->l_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
    <div id="r_q_sku"<?= $Page->q_sku->rowAttributes() ?>>
        <label id="elh_bcode_q_sku" for="x_q_sku" class="<?= $Page->LeftColumnClass ?>"><?= $Page->q_sku->caption() ?><?= $Page->q_sku->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->q_sku->cellAttributes() ?>>
<span id="el_bcode_q_sku">
<input type="<?= $Page->q_sku->getInputTextType() ?>" name="x_q_sku" id="x_q_sku" data-table="bcode" data-field="x_q_sku" value="<?= $Page->q_sku->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->q_sku->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->q_sku->formatPattern()) ?>"<?= $Page->q_sku->editAttributes() ?> aria-describedby="x_q_sku_help">
<?= $Page->q_sku->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->q_sku->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
    <div id="r_po_price"<?= $Page->po_price->rowAttributes() ?>>
        <label id="elh_bcode_po_price" for="x_po_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_price->caption() ?><?= $Page->po_price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_price->cellAttributes() ?>>
<span id="el_bcode_po_price">
<span<?= $Page->po_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po_price->getDisplayValue($Page->po_price->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_po_price" data-hidden="1" name="x_po_price" id="x_po_price" value="<?= HtmlEncode($Page->po_price->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible) { // po_discount ?>
    <div id="r_po_discount"<?= $Page->po_discount->rowAttributes() ?>>
        <label id="elh_bcode_po_discount" for="x_po_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_discount->caption() ?><?= $Page->po_discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_discount->cellAttributes() ?>>
<span id="el_bcode_po_discount">
<input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="bcode" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?> aria-describedby="x_po_discount_help">
<?= $Page->po_discount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_currency->Visible) { // po_currency ?>
    <div id="r_po_currency"<?= $Page->po_currency->rowAttributes() ?>>
        <label id="elh_bcode_po_currency" for="x_po_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_currency->caption() ?><?= $Page->po_currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_currency->cellAttributes() ?>>
<span id="el_bcode_po_currency">
<span<?= $Page->po_currency->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->po_currency->getDisplayValue($Page->po_currency->EditValue) ?></span></span>
<input type="hidden" data-table="bcode" data-field="x_po_currency" data-hidden="1" name="x_po_currency" id="x_po_currency" value="<?= HtmlEncode($Page->po_currency->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_bcode_product_type" for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_bcode_product_type">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_product_type"
        <?php } ?>
        data-table="bcode"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <?= $Page->product_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage() ?></div>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_product_type", selectId: "fbcodeedit_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_product_type", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape"<?= $Page->shape->rowAttributes() ?>>
        <label id="elh_bcode_shape" for="x_shape" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shape->caption() ?><?= $Page->shape->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shape->cellAttributes() ?>>
<span id="el_bcode_shape">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_shape"
        <?php } ?>
        data-table="bcode"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <?= $Page->shape->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage() ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_shape", selectId: "fbcodeedit_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_shape", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_bcode_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_bcode_production_plan">
    <select
        id="x_production_plan"
        name="x_production_plan"
        class="form-select ew-select<?= $Page->production_plan->isInvalidClass() ?>"
        <?php if (!$Page->production_plan->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_production_plan"
        <?php } ?>
        data-table="bcode"
        data-field="x_production_plan"
        data-value-separator="<?= $Page->production_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>"
        <?= $Page->production_plan->editAttributes() ?>>
        <?= $Page->production_plan->selectOptionListHtml("x_production_plan") ?>
    </select>
    <?= $Page->production_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage() ?></div>
<?php if (!$Page->production_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_production_plan", selectId: "fbcodeedit_x_production_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.production_plan?.lookupOptions.length) {
        options.data = { id: "x_production_plan", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_production_plan", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.production_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed"<?= $Page->completed->rowAttributes() ?>>
        <label id="elh_bcode_completed" for="x_completed" class="<?= $Page->LeftColumnClass ?>"><?= $Page->completed->caption() ?><?= $Page->completed->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->completed->cellAttributes() ?>>
<span id="el_bcode_completed">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_completed"
        <?php } ?>
        data-table="bcode"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <?= $Page->completed->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage() ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_completed", selectId: "fbcodeedit_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_completed", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po"<?= $Page->buyer_po->rowAttributes() ?>>
        <label id="elh_bcode_buyer_po" for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_po->caption() ?><?= $Page->buyer_po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el_bcode_buyer_po">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="bcode" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?> aria-describedby="x_buyer_po_help">
<?= $Page->buyer_po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_bcode_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_bcode_jc_no">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="bcode" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?> aria-describedby="x_jc_no_help">
<?= $Page->jc_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a"<?= $Page->sqm_a->rowAttributes() ?>>
        <label id="elh_bcode_sqm_a" for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm_a->caption() ?><?= $Page->sqm_a->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el_bcode_sqm_a">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="bcode" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?> aria-describedby="x_sqm_a_help">
<?= $Page->sqm_a->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_2srm_a->Visible) { // 2srm_a ?>
    <div id="r__2srm_a"<?= $Page->_2srm_a->rowAttributes() ?>>
        <label id="elh_bcode__2srm_a" for="x__2srm_a" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_2srm_a->caption() ?><?= $Page->_2srm_a->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_2srm_a->cellAttributes() ?>>
<span id="el_bcode__2srm_a">
<input type="<?= $Page->_2srm_a->getInputTextType() ?>" name="x__2srm_a" id="x__2srm_a" data-table="bcode" data-field="x__2srm_a" value="<?= $Page->_2srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2srm_a->formatPattern()) ?>"<?= $Page->_2srm_a->editAttributes() ?> aria-describedby="x__2srm_a_help">
<?= $Page->_2srm_a->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_2srm_a->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_4srm_a->Visible) { // 4srm_a ?>
    <div id="r__4srm_a"<?= $Page->_4srm_a->rowAttributes() ?>>
        <label id="elh_bcode__4srm_a" for="x__4srm_a" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_4srm_a->caption() ?><?= $Page->_4srm_a->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_4srm_a->cellAttributes() ?>>
<span id="el_bcode__4srm_a">
<input type="<?= $Page->_4srm_a->getInputTextType() ?>" name="x__4srm_a" id="x__4srm_a" data-table="bcode" data-field="x__4srm_a" value="<?= $Page->_4srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_4srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4srm_a->formatPattern()) ?>"<?= $Page->_4srm_a->editAttributes() ?> aria-describedby="x__4srm_a_help">
<?= $Page->_4srm_a->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_4srm_a->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_bcode_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_bcode_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_batch_no"
        <?php } ?>
        data-table="bcode"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_batch_no", selectId: "fbcodeedit_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
    <div id="r_cs"<?= $Page->cs->rowAttributes() ?>>
        <label id="elh_bcode_cs" for="x_cs" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cs->caption() ?><?= $Page->cs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cs->cellAttributes() ?>>
<span id="el_bcode_cs">
    <select
        id="x_cs"
        name="x_cs"
        class="form-select ew-select<?= $Page->cs->isInvalidClass() ?>"
        <?php if (!$Page->cs->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_cs"
        <?php } ?>
        data-table="bcode"
        data-field="x_cs"
        data-value-separator="<?= $Page->cs->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cs->getPlaceHolder()) ?>"
        <?= $Page->cs->editAttributes() ?>>
        <?= $Page->cs->selectOptionListHtml("x_cs") ?>
    </select>
    <?= $Page->cs->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->cs->getErrorMessage() ?></div>
<?php if (!$Page->cs->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_cs", selectId: "fbcodeedit_x_cs" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.cs?.lookupOptions.length) {
        options.data = { id: "x_cs", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_cs", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.cs.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
    <div id="r_weight"<?= $Page->weight->rowAttributes() ?>>
        <label id="elh_bcode_weight" for="x_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weight->caption() ?><?= $Page->weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weight->cellAttributes() ?>>
<span id="el_bcode_weight">
<input type="<?= $Page->weight->getInputTextType() ?>" name="x_weight" id="x_weight" data-table="bcode" data-field="x_weight" value="<?= $Page->weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight->formatPattern()) ?>"<?= $Page->weight->editAttributes() ?> aria-describedby="x_weight_help">
<?= $Page->weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_bcode_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_bcode_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="bcode" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
    <div id="r_p_remarks"<?= $Page->p_remarks->rowAttributes() ?>>
        <label id="elh_bcode_p_remarks" for="x_p_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->p_remarks->caption() ?><?= $Page->p_remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->p_remarks->cellAttributes() ?>>
<span id="el_bcode_p_remarks">
<input type="<?= $Page->p_remarks->getInputTextType() ?>" name="x_p_remarks" id="x_p_remarks" data-table="bcode" data-field="x_p_remarks" value="<?= $Page->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_remarks->formatPattern()) ?>"<?= $Page->p_remarks->editAttributes() ?> aria-describedby="x_p_remarks_help">
<?= $Page->p_remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->p_remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
    <div id="r_roll_no"<?= $Page->roll_no->rowAttributes() ?>>
        <label id="elh_bcode_roll_no" for="x_roll_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->roll_no->caption() ?><?= $Page->roll_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->roll_no->cellAttributes() ?>>
<span id="el_bcode_roll_no">
<span<?= $Page->roll_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->roll_no->getDisplayValue($Page->roll_no->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_roll_no" data-hidden="1" name="x_roll_no" id="x_roll_no" value="<?= HtmlEncode($Page->roll_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty"<?= $Page->qty->rowAttributes() ?>>
        <label id="elh_bcode_qty" for="x_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qty->caption() ?><?= $Page->qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qty->cellAttributes() ?>>
<span id="el_bcode_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->qty->getDisplayValue($Page->qty->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_qty" data-hidden="1" name="x_qty" id="x_qty" value="<?= HtmlEncode($Page->qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no"<?= $Page->pl_no->rowAttributes() ?>>
        <label id="elh_bcode_pl_no" for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pl_no->caption() ?><?= $Page->pl_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pl_no->cellAttributes() ?>>
<span id="el_bcode_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pl_no->getDisplayValue($Page->pl_no->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_pl_no" data-hidden="1" name="x_pl_no" id="x_pl_no" value="<?= HtmlEncode($Page->pl_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_bcode_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_bcode_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbcodeedit_x_category"
        <?php } ?>
        data-table="bcode"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbcodeedit", function() {
    var options = { name: "x_category", selectId: "fbcodeedit_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbcodeedit.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbcodeedit" };
    } else {
        options.ajax = { id: "x_category", form: "fbcodeedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bcode.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id"<?= $Page->pp_id->rowAttributes() ?>>
        <label id="elh_bcode_pp_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pp_id->caption() ?><?= $Page->pp_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pp_id->cellAttributes() ?>>
<span id="el_bcode_pp_id">
<?php
if (IsRTL()) {
    $Page->pp_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_pp_id" class="ew-auto-suggest">
    <input type="<?= $Page->pp_id->getInputTextType() ?>" class="form-control" name="sv_x_pp_id" id="sv_x_pp_id" value="<?= RemoveHtml($Page->pp_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_id->formatPattern()) ?>"<?= $Page->pp_id->editAttributes() ?> aria-describedby="x_pp_id_help">
</span>
<selection-list hidden class="form-control" data-table="bcode" data-field="x_pp_id" data-input="sv_x_pp_id" data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>" name="x_pp_id" id="x_pp_id" value="<?= HtmlEncode($Page->pp_id->CurrentValue) ?>"></selection-list>
<?= $Page->pp_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fbcodeedit", function() {
    fbcodeedit.createAutoSuggest(Object.assign({"id":"x_pp_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->pp_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bcode.fields.pp_id.autoSuggestOptions));
});
</script>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
    <div id="r_buyer_barcode"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label id="elh_bcode_buyer_barcode" for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_barcode->caption() ?><?= $Page->buyer_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el_bcode_buyer_barcode">
<span<?= $Page->buyer_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_barcode->getDisplayValue($Page->buyer_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="bcode" data-field="x_buyer_barcode" data-hidden="1" name="x_buyer_barcode" id="x_buyer_barcode" value="<?= HtmlEncode($Page->buyer_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbcodeedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbcodeedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bcode");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
