<?php

namespace PHPMaker2024\fibre;

// Page object
$BatchNoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { batch_no: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbatch_nosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbatch_nosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["y_id", [ew.Validators.between], false],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["y_rid", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["process_id_tmp", [], fields.process_id_tmp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
            "process_id_tmp": <?= $Page->process_id_tmp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbatch_nosearch" id="fbatch_nosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="batch_no">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_id"><?= $Page->id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_id" id="z_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_batch_no_id" class="ew-search-field">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="batch_no" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_batch_no_id" class="ew-search-field2 d-none">
<input type="<?= $Page->id->getInputTextType() ?>" name="y_id" id="y_id" data-table="batch_no" data-field="x_id" value="<?= $Page->id->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_grp"
        <?php } ?>
        data-table="batch_no"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_grp", selectId: "fbatch_nosearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_s_grp"
        <?php } ?>
        data-table="batch_no"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_s_grp", selectId: "fbatch_nosearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_product"
        <?php } ?>
        data-table="batch_no"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_product", selectId: "fbatch_nosearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_product", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_product_1" name="v_product" value="AND"<?= ($Page->product->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_product_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_product_2" name="v_product" value="OR"<?= ($Page->product->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_product_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_product" id="w_product" value="=">
</span>
                    <span id="el2_batch_no_product" class="ew-search-field2">
    <select
        id="y_product"
        name="y_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_y_product"
        <?php } ?>
        data-table="batch_no"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("y_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_y_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "y_product", selectId: "fbatch_nosearch_y_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.product?.lookupOptions.length) {
        options.data = { id: "y_product", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "y_product", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_rid"><?= $Page->rid->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_rid" id="z_rid" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->rid->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->rid->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_batch_no_rid" class="ew-search-field">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_rid"
        <?php } ?>
        data-table="batch_no"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_rid", selectId: "fbatch_nosearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_1" name="v_rid" value="AND"<?= ($Page->rid->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_2" name="v_rid" value="OR"<?= ($Page->rid->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_rid" id="w_rid" value="=">
</span>
                    <span id="el2_batch_no_rid" class="ew-search-field2">
    <select
        id="y_rid"
        name="y_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_y_rid"
        <?php } ?>
        data-table="batch_no"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("y_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_y_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "y_rid", selectId: "fbatch_nosearch_y_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "y_rid", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "y_rid", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_packing_type"
        <?php } ?>
        data-table="batch_no"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_packing_type", selectId: "fbatch_nosearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="batch_no" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" maxlength="36" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="batch_no" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label for="x_payment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_payment"><?= $Page->payment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment" id="z_payment" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_payment" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment->getInputTextType() ?>" name="x_payment" id="x_payment" data-table="batch_no" data-field="x_payment" value="<?= $Page->payment->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment->formatPattern()) ?>"<?= $Page->payment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="batch_no" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_status"
        <?php } ?>
        data-table="batch_no"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_status", selectId: "fbatch_nosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="batch_no" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_a_operator"
        <?php } ?>
        data-table="batch_no"
        data-field="x_a_operator"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_a_operator", selectId: "fbatch_nosearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_id_tmp->Visible) { // process_id_tmp ?>
    <div id="r_process_id_tmp" class="row"<?= $Page->process_id_tmp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_batch_no_process_id_tmp"><?= $Page->process_id_tmp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_id_tmp" id="z_process_id_tmp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_id_tmp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_batch_no_process_id_tmp" class="ew-search-field ew-search-field-single">
<template id="tp_x_process_id_tmp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="batch_no" data-field="x_process_id_tmp" name="x_process_id_tmp" id="x_process_id_tmp"<?= $Page->process_id_tmp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process_id_tmp" class="ew-item-list"></div>
<selection-list hidden
    id="x_process_id_tmp[]"
    name="x_process_id_tmp[]"
    value="<?= HtmlEncode($Page->process_id_tmp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process_id_tmp"
    data-target="dsl_x_process_id_tmp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process_id_tmp->isInvalidClass() ?>"
    data-table="batch_no"
    data-field="x_process_id_tmp"
    data-value-separator="<?= $Page->process_id_tmp->displayValueSeparatorAttribute() ?>"
    <?= $Page->process_id_tmp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process_id_tmp->getErrorMessage(false) ?></div>
<?= $Page->process_id_tmp->Lookup->getParamTag($Page, "p_x_process_id_tmp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbatch_nosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbatch_nosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbatch_nosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("batch_no");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
