<?php

namespace PHPMaker2024\fibre;

// Page object
$BatchNoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { batch_no: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbatch_nosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbatch_nosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["y_id", [ew.Validators.between], false],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["y_rid", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["process_id_tmp", [], fields.process_id_tmp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
            "process_id_tmp": <?= $Page->process_id_tmp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbatch_nosearch" id="fbatch_nosearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("batchnolist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="batch_no">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_batch_no_id" class="batch_nosearch"><span id="el_batch_no_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="batch_no" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_grp" class="batch_nosearch"><span id="el_batch_no_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_grp"
        <?php } ?>
        data-table="batch_no"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_grp", selectId: "fbatch_nosearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_s_grp" class="batch_nosearch"><span id="el_batch_no_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_s_grp"
        <?php } ?>
        data-table="batch_no"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_s_grp", selectId: "fbatch_nosearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_product" class="batch_nosearch"><span id="el_batch_no_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_product"
        <?php } ?>
        data-table="batch_no"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_product", selectId: "fbatch_nosearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_product", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_rid" class="batch_nosearch"><span id="el_batch_no_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_rid"
        <?php } ?>
        data-table="batch_no"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_rid", selectId: "fbatch_nosearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_packing_type" class="batch_nosearch"><span id="el_batch_no_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_packing_type"
        <?php } ?>
        data-table="batch_no"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_packing_type", selectId: "fbatch_nosearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_batch_no" class="batch_nosearch"><span id="el_batch_no_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="batch_no" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" maxlength="36" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_description" class="batch_nosearch"><span id="el_batch_no_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="batch_no" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_payment" class="batch_nosearch"><span id="el_batch_no_payment" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment->getInputTextType() ?>" name="x_payment" id="x_payment" data-table="batch_no" data-field="x_payment" value="<?= $Page->payment->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment->formatPattern()) ?>"<?= $Page->payment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_remarks" class="batch_nosearch"><span id="el_batch_no_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="batch_no" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_status" class="batch_nosearch"><span id="el_batch_no_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_status"
        <?php } ?>
        data-table="batch_no"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_status", selectId: "fbatch_nosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_image" class="batch_nosearch"><span id="el_batch_no_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="batch_no" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_batch_no_a_operator" class="batch_nosearch"><span id="el_batch_no_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fbatch_nosearch_x_a_operator"
        <?php } ?>
        data-table="batch_no"
        data-field="x_a_operator"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbatch_nosearch", function() {
    var options = { name: "x_a_operator", selectId: "fbatch_nosearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbatch_nosearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fbatch_nosearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fbatch_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.batch_no.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_batch_no_process_id_tmp" class="batch_nosearch"><span id="el_batch_no_process_id_tmp" class="ew-search-field ew-search-field-single">
<template id="tp_x_process_id_tmp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="batch_no" data-field="x_process_id_tmp" name="x_process_id_tmp" id="x_process_id_tmp"<?= $Page->process_id_tmp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process_id_tmp" class="ew-item-list"></div>
<selection-list hidden
    id="x_process_id_tmp[]"
    name="x_process_id_tmp[]"
    value="<?= HtmlEncode($Page->process_id_tmp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process_id_tmp"
    data-target="dsl_x_process_id_tmp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process_id_tmp->isInvalidClass() ?>"
    data-table="batch_no"
    data-field="x_process_id_tmp"
    data-value-separator="<?= $Page->process_id_tmp->displayValueSeparatorAttribute() ?>"
    <?= $Page->process_id_tmp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process_id_tmp->getErrorMessage(false) ?></div>
<?= $Page->process_id_tmp->Lookup->getParamTag($Page, "p_x_process_id_tmp") ?>
</span></template>
<div id="batch_no_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "grp",
                type: "integer",
                label: currentTable.fields.grp.caption,
                operators: currentTable.fields.grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.grp.validators),
                data: {
                    format: currentTable.fields.grp.clientFormatPattern
                }
            },
            {
                id: "s_grp",
                type: "integer",
                label: currentTable.fields.s_grp.caption,
                operators: currentTable.fields.s_grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.s_grp.validators),
                data: {
                    format: currentTable.fields.s_grp.clientFormatPattern
                }
            },
            {
                id: "product",
                type: "integer",
                label: currentTable.fields.product.caption,
                operators: currentTable.fields.product.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.product.validators),
                data: {
                    format: currentTable.fields.product.clientFormatPattern
                }
            },
            {
                id: "rid",
                type: "string",
                label: currentTable.fields.rid.caption,
                operators: currentTable.fields.rid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.rid.validators),
                data: {
                    format: currentTable.fields.rid.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "integer",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "batch_no",
                type: "string",
                label: currentTable.fields.batch_no.caption,
                operators: currentTable.fields.batch_no.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.batch_no.validators),
                data: {
                    format: currentTable.fields.batch_no.clientFormatPattern
                }
            },
            {
                id: "description",
                type: "string",
                label: currentTable.fields.description.caption,
                operators: currentTable.fields.description.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.description.validators),
                data: {
                    format: currentTable.fields.description.clientFormatPattern
                }
            },
            {
                id: "payment",
                type: "string",
                label: currentTable.fields.payment.caption,
                operators: currentTable.fields.payment.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.payment.validators),
                data: {
                    format: currentTable.fields.payment.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "image",
                type: "string",
                label: currentTable.fields.image.caption,
                operators: currentTable.fields.image.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.image.validators),
                data: {
                    format: currentTable.fields.image.clientFormatPattern
                }
            },
            {
                id: "a_operator",
                type: "integer",
                label: currentTable.fields.a_operator.caption,
                operators: currentTable.fields.a_operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.a_operator.validators),
                data: {
                    format: currentTable.fields.a_operator.clientFormatPattern
                }
            },
            {
                id: "process_id_tmp",
                type: "string",
                label: currentTable.fields.process_id_tmp.caption,
                operators: currentTable.fields.process_id_tmp.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbatch_nosearch.fields.process_id_tmp.validators),
                data: {
                    format: currentTable.fields.process_id_tmp.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#batch_no_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbatch_nosearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbatch_nosearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbatch_nosearch" formaction="<?= HtmlEncode(GetUrl("batchnolist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbatch_nosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbatch_nosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("batch_no");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
