<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeSearchSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_search: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbarcode_searchsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_searchsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["process_d", [], fields.process_d.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["buyer_barcode", [], fields.buyer_barcode.isInvalid],
            ["dispatch_week", [], fields.dispatch_week.isInvalid],
            ["current_works", [], fields.current_works.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design": <?= $Page->design->toClientList($Page) ?>,
            "dispatch_week": <?= $Page->dispatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode_searchsearch" id="fbarcode_searchsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_search">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_search_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode_search" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_search_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="barcode_search" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_search__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode_search" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_search__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="barcode_search" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_design" class="ew-search-field ew-search-field-single">
    <select
        id="x_design"
        name="x_design"
        class="form-control ew-select<?= $Page->design->isInvalidClass() ?>"
        data-select2-id="fbarcode_searchsearch_x_design"
        data-table="barcode_search"
        data-field="x_design"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->design->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->design->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>"
        <?= $Page->design->editAttributes() ?>>
        <?= $Page->design->selectOptionListHtml("x_design") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
<?= $Page->design->Lookup->getParamTag($Page, "p_x_design") ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_design", selectId: "fbarcode_searchsearch_x_design" };
    if (fbarcode_searchsearch.lists.design?.lookupOptions.length) {
        options.data = { id: "x_design", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_design", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_search.fields.design.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="barcode_search" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
    <div id="r_process_d" class="row"<?= $Page->process_d->rowAttributes() ?>>
        <label for="x_process_d" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_process_d"><?= $Page->process_d->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_d" id="z_process_d" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_d->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_process_d" class="ew-search-field">
<input type="<?= $Page->process_d->getInputTextType() ?>" name="x_process_d" id="x_process_d" data-table="barcode_search" data-field="x_process_d" value="<?= $Page->process_d->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_d->formatPattern()) ?>"<?= $Page->process_d->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_process_d_1" name="v_process_d" value="AND"<?= ($Page->process_d->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_process_d_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_process_d_2" name="v_process_d" value="OR"<?= ($Page->process_d->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_process_d_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_process_d" id="w_process_d" value="=">
</span>
                    <span id="el2_barcode_search_process_d" class="ew-search-field2">
<input type="<?= $Page->process_d->getInputTextType() ?>" name="y_process_d" id="y_process_d" data-table="barcode_search" data-field="x_process_d" value="<?= $Page->process_d->EditValue2 ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_d->formatPattern()) ?>"<?= $Page->process_d->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="barcode_search" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
    <div id="r_buyer_barcode" class="row"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_buyer_barcode"><?= $Page->buyer_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_buyer_barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode_search" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_week->Visible) { // dispatch_week ?>
    <div id="r_dispatch_week" class="row"<?= $Page->dispatch_week->rowAttributes() ?>>
        <label for="x_dispatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_dispatch_week"><?= $Page->dispatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dispatch_week" id="z_dispatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_dispatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_week"
        name="x_dispatch_week"
        class="form-select ew-select<?= $Page->dispatch_week->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode_searchsearch_x_dispatch_week"
        <?php } ?>
        data-table="barcode_search"
        data-field="x_dispatch_week"
        data-value-separator="<?= $Page->dispatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week->editAttributes() ?>>
        <?= $Page->dispatch_week->selectOptionListHtml("x_dispatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week->Lookup->getParamTag($Page, "p_x_dispatch_week") ?>
<?php if (!$Page->dispatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_dispatch_week", selectId: "fbarcode_searchsearch_x_dispatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_searchsearch.lists.dispatch_week?.lookupOptions.length) {
        options.data = { id: "x_dispatch_week", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_dispatch_week", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_search.fields.dispatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_search_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_search_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_searchsearch_x_current_works"
        <?php } ?>
        data-table="barcode_search"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_current_works", selectId: "fbarcode_searchsearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_searchsearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_search.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_searchsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_searchsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbarcode_searchsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_search");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
