<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeSearchSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_search: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbarcode_searchsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_searchsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["process_d", [], fields.process_d.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["buyer_barcode", [], fields.buyer_barcode.isInvalid],
            ["dispatch_week", [], fields.dispatch_week.isInvalid],
            ["current_works", [], fields.current_works.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "design": <?= $Page->design->toClientList($Page) ?>,
            "dispatch_week": <?= $Page->dispatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode_searchsearch" id="fbarcode_searchsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("barcodesearchlist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_search">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_barcode_search_po" class="barcode_searchsearch"><span id="el_barcode_search_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode_search" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search__barcode" class="barcode_searchsearch"><span id="el_barcode_search__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode_search" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search_design" class="barcode_searchsearch"><span id="el_barcode_search_design" class="ew-search-field ew-search-field-single">
    <select
        id="x_design"
        name="x_design"
        class="form-control ew-select<?= $Page->design->isInvalidClass() ?>"
        data-select2-id="fbarcode_searchsearch_x_design"
        data-table="barcode_search"
        data-field="x_design"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->design->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->design->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>"
        <?= $Page->design->editAttributes() ?>>
        <?= $Page->design->selectOptionListHtml("x_design") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
<?= $Page->design->Lookup->getParamTag($Page, "p_x_design") ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_design", selectId: "fbarcode_searchsearch_x_design" };
    if (fbarcode_searchsearch.lists.design?.lookupOptions.length) {
        options.data = { id: "x_design", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_design", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_search.fields.design.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_barcode_search_size" class="barcode_searchsearch"><span id="el_barcode_search_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="barcode_search" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search_process_d" class="barcode_searchsearch"><span id="el_barcode_search_process_d" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_d->getInputTextType() ?>" name="x_process_d" id="x_process_d" data-table="barcode_search" data-field="x_process_d" value="<?= $Page->process_d->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_d->formatPattern()) ?>"<?= $Page->process_d->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search_buyer_ref" class="barcode_searchsearch"><span id="el_barcode_search_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="barcode_search" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search_buyer_barcode" class="barcode_searchsearch"><span id="el_barcode_search_buyer_barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode_search" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode_search_dispatch_week" class="barcode_searchsearch"><span id="el_barcode_search_dispatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_week"
        name="x_dispatch_week"
        class="form-select ew-select<?= $Page->dispatch_week->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode_searchsearch_x_dispatch_week"
        <?php } ?>
        data-table="barcode_search"
        data-field="x_dispatch_week"
        data-value-separator="<?= $Page->dispatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week->editAttributes() ?>>
        <?= $Page->dispatch_week->selectOptionListHtml("x_dispatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week->Lookup->getParamTag($Page, "p_x_dispatch_week") ?>
<?php if (!$Page->dispatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_dispatch_week", selectId: "fbarcode_searchsearch_x_dispatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_searchsearch.lists.dispatch_week?.lookupOptions.length) {
        options.data = { id: "x_dispatch_week", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_dispatch_week", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_search.fields.dispatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode_search_current_works" class="barcode_searchsearch"><span id="el_barcode_search_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_searchsearch_x_current_works"
        <?php } ?>
        data-table="barcode_search"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_searchsearch", function() {
    var options = { name: "x_current_works", selectId: "fbarcode_searchsearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_searchsearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbarcode_searchsearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbarcode_searchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_search.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<div id="barcode_search_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "_barcode",
                type: "string",
                label: currentTable.fields._barcode.caption,
                operators: currentTable.fields._barcode.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields._barcode.validators),
                data: {
                    format: currentTable.fields._barcode.clientFormatPattern
                }
            },
            {
                id: "design",
                type: "string",
                label: currentTable.fields.design.caption,
                operators: currentTable.fields.design.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.design.validators),
                data: {
                    format: currentTable.fields.design.clientFormatPattern
                }
            },
            {
                id: "size",
                type: "string",
                label: currentTable.fields.size.caption,
                operators: currentTable.fields.size.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.size.validators),
                data: {
                    format: currentTable.fields.size.clientFormatPattern
                }
            },
            {
                id: "process_d",
                type: "string",
                label: currentTable.fields.process_d.caption,
                operators: currentTable.fields.process_d.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.process_d.validators),
                data: {
                    format: currentTable.fields.process_d.clientFormatPattern
                }
            },
            {
                id: "buyer_ref",
                type: "string",
                label: currentTable.fields.buyer_ref.caption,
                operators: currentTable.fields.buyer_ref.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.buyer_ref.validators),
                data: {
                    format: currentTable.fields.buyer_ref.clientFormatPattern
                }
            },
            {
                id: "buyer_barcode",
                type: "string",
                label: currentTable.fields.buyer_barcode.caption,
                operators: currentTable.fields.buyer_barcode.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.buyer_barcode.validators),
                data: {
                    format: currentTable.fields.buyer_barcode.clientFormatPattern
                }
            },
            {
                id: "dispatch_week",
                type: "integer",
                label: currentTable.fields.dispatch_week.caption,
                operators: currentTable.fields.dispatch_week.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.dispatch_week.validators),
                data: {
                    format: currentTable.fields.dispatch_week.clientFormatPattern
                }
            },
            {
                id: "current_works",
                type: "integer",
                label: currentTable.fields.current_works.caption,
                operators: currentTable.fields.current_works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode_searchsearch.fields.current_works.validators),
                data: {
                    format: currentTable.fields.current_works.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#barcode_search_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbarcode_searchsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbarcode_searchsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbarcode_searchsearch" formaction="<?= HtmlEncode(GetUrl("barcodesearchlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_searchsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbarcode_searchsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_search");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
