<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeSearchList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_search: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "design": <?= $Page->design->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "process_d": <?= $Page->process_d->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "buyer_barcode": <?= $Page->buyer_barcode->toClientList($Page) ?>,
            "dispatch_week": <?= $Page->dispatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbarcode_searchsrch" id="fbarcode_searchsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbarcode_searchsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_search: currentTable } });
var currentForm;
var fbarcode_searchsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_searchsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "design": <?= $Page->design->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "process_d": <?= $Page->process_d->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "buyer_barcode": <?= $Page->buyer_barcode->toClientList($Page) ?>,
            "dispatch_week": <?= $Page->dispatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_po"
            name="x_po[]"
            class="form-control ew-select<?= $Page->po->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_po"
            data-table="barcode_search"
            data-field="x_po"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->po->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->po->editAttributes() ?>>
            <?= $Page->po->selectOptionListHtml("x_po", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_po",
                selectId: "fbarcode_searchsrch_x_po",
                ajax: { id: "x_po", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.po.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x__barcode"
            name="x__barcode[]"
            class="form-control ew-select<?= $Page->_barcode->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x__barcode"
            data-table="barcode_search"
            data-field="x__barcode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->_barcode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->_barcode->editAttributes() ?>>
            <?= $Page->_barcode->selectOptionListHtml("x__barcode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x__barcode",
                selectId: "fbarcode_searchsrch_x__barcode",
                ajax: { id: "x__barcode", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields._barcode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
<?php
if (!$Page->design->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_design"
            name="x_design[]"
            class="form-control ew-select<?= $Page->design->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_design"
            data-table="barcode_search"
            data-field="x_design"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->design->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->design->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->design->editAttributes() ?>>
            <?= $Page->design->selectOptionListHtml("x_design", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
        <?= $Page->design->Lookup->getParamTag($Page, "p_x_design") ?>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_design",
                selectId: "fbarcode_searchsrch_x_design",
                ajax: { id: "x_design", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.design.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
<?php
if (!$Page->size->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_size" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->size->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_size"
            name="x_size[]"
            class="form-control ew-select<?= $Page->size->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_size"
            data-table="barcode_search"
            data-field="x_size"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->size->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->size->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->size->editAttributes() ?>>
            <?= $Page->size->selectOptionListHtml("x_size", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_size",
                selectId: "fbarcode_searchsrch_x_size",
                ajax: { id: "x_size", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.size.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
<?php
if (!$Page->batch_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_batch_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->batch_no->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_batch_no"
            name="x_batch_no[]"
            class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_batch_no"
            data-table="barcode_search"
            data-field="x_batch_no"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->batch_no->editAttributes() ?>>
            <?= $Page->batch_no->selectOptionListHtml("x_batch_no", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_batch_no",
                selectId: "fbarcode_searchsrch_x_batch_no",
                ajax: { id: "x_batch_no", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.batch_no.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
<?php
if (!$Page->process_d->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_d" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_d->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_process_d"
            name="x_process_d[]"
            class="form-control ew-select<?= $Page->process_d->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_process_d"
            data-table="barcode_search"
            data-field="x_process_d"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->process_d->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->process_d->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->process_d->editAttributes() ?>>
            <?= $Page->process_d->selectOptionListHtml("x_process_d", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_process_d",
                selectId: "fbarcode_searchsrch_x_process_d",
                ajax: { id: "x_process_d", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.process_d.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
<?php
if (!$Page->buyer_ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_ref->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_buyer_ref"
            name="x_buyer_ref[]"
            class="form-control ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_buyer_ref"
            data-table="barcode_search"
            data-field="x_buyer_ref"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_ref->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->buyer_ref->editAttributes() ?>>
            <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_buyer_ref",
                selectId: "fbarcode_searchsrch_x_buyer_ref",
                ajax: { id: "x_buyer_ref", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.buyer_ref.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
<?php
if (!$Page->buyer_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_buyer_barcode"
            name="x_buyer_barcode[]"
            class="form-control ew-select<?= $Page->buyer_barcode->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_buyer_barcode"
            data-table="barcode_search"
            data-field="x_buyer_barcode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_barcode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->buyer_barcode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->buyer_barcode->editAttributes() ?>>
            <?= $Page->buyer_barcode->selectOptionListHtml("x_buyer_barcode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_buyer_barcode",
                selectId: "fbarcode_searchsrch_x_buyer_barcode",
                ajax: { id: "x_buyer_barcode", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.buyer_barcode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->dispatch_week->Visible) { // dispatch_week ?>
<?php
if (!$Page->dispatch_week->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_dispatch_week" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->dispatch_week->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_dispatch_week"
            name="x_dispatch_week[]"
            class="form-control ew-select<?= $Page->dispatch_week->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_dispatch_week"
            data-table="barcode_search"
            data-field="x_dispatch_week"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->dispatch_week->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->dispatch_week->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->dispatch_week->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->dispatch_week->editAttributes() ?>>
            <?= $Page->dispatch_week->selectOptionListHtml("x_dispatch_week", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->dispatch_week->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_dispatch_week",
                selectId: "fbarcode_searchsrch_x_dispatch_week",
                ajax: { id: "x_dispatch_week", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.dispatch_week.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
<?php
if (!$Page->current_works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_current_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->current_works->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_current_works"
            name="x_current_works[]"
            class="form-control ew-select<?= $Page->current_works->isInvalidClass() ?>"
            data-select2-id="fbarcode_searchsrch_x_current_works"
            data-table="barcode_search"
            data-field="x_current_works"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->current_works->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->current_works->editAttributes() ?>>
            <?= $Page->current_works->selectOptionListHtml("x_current_works", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbarcode_searchsrch", function() {
            var options = {
                name: "x_current_works",
                selectId: "fbarcode_searchsrch_x_current_works",
                ajax: { id: "x_current_works", form: "fbarcode_searchsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.barcode_search.fields.current_works.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbarcode_searchsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbarcode_searchsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbarcode_searchsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbarcode_searchsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbarcode_searchsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbarcode_searchsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbarcode_searchsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_barcode_search" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_barcode_searchlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_barcode_search_po" class="barcode_search_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>" style="min-width: 300px;"><div id="elh_barcode_search__barcode" class="barcode_search__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_search_design" class="barcode_search_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
        <th data-name="size" class="<?= $Page->size->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_search_size" class="barcode_search_size"><?= $Page->renderFieldHeader($Page->size) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_barcode_search_batch_no" class="barcode_search_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
        <th data-name="process_d" class="<?= $Page->process_d->headerCellClass() ?>"><div id="elh_barcode_search_process_d" class="barcode_search_process_d"><?= $Page->renderFieldHeader($Page->process_d) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_barcode_search_buyer_ref" class="barcode_search_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <th data-name="buyer_barcode" class="<?= $Page->buyer_barcode->headerCellClass() ?>"><div id="elh_barcode_search_buyer_barcode" class="barcode_search_buyer_barcode"><?= $Page->renderFieldHeader($Page->buyer_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_week->Visible) { // dispatch_week ?>
        <th data-name="dispatch_week" class="<?= $Page->dispatch_week->headerCellClass() ?>"><div id="elh_barcode_search_dispatch_week" class="barcode_search_dispatch_week"><?= $Page->renderFieldHeader($Page->dispatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
        <th data-name="current_works" class="<?= $Page->current_works->headerCellClass() ?>"><div id="elh_barcode_search_current_works" class="barcode_search_current_works"><?= $Page->renderFieldHeader($Page->current_works) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_po" class="el_barcode_search_po">
<span<?= $Page->po->viewAttributes() ?>>
<?php if (!EmptyString($Page->po->getViewValue()) && $Page->po->linkAttributes() != "") { ?>
<a<?= $Page->po->linkAttributes() ?>><?= $Page->po->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search__barcode" class="el_barcode_search__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_design" class="el_barcode_search_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size->Visible) { // size ?>
        <td data-name="size"<?= $Page->size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_size" class="el_barcode_search_size">
<span<?= $Page->size->viewAttributes() ?>>
<?= $Page->size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_batch_no" class="el_barcode_search_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d"<?= $Page->process_d->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_process_d" class="el_barcode_search_process_d">
<span<?= $Page->process_d->viewAttributes() ?>>
<?= $Page->process_d->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_buyer_ref" class="el_barcode_search_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode"<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_buyer_barcode" class="el_barcode_search_buyer_barcode">
<span<?= $Page->buyer_barcode->viewAttributes() ?>>
<?= $Page->buyer_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_week->Visible) { // dispatch_week ?>
        <td data-name="dispatch_week"<?= $Page->dispatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_dispatch_week" class="el_barcode_search_dispatch_week">
<span<?= $Page->dispatch_week->viewAttributes() ?>>
<?= $Page->dispatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works"<?= $Page->current_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_search_current_works" class="el_barcode_search_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<?= $Page->current_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_search");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
