<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeQueryUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_query: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fbarcode_queryupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbarcode_queryupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["buyers_id", [fields.buyers_id.visible && fields.buyers_id.required ? ew.Validators.required(fields.buyers_id.caption) : null], fields.buyers_id.isInvalid],
            ["buyer_ref", [fields.buyer_ref.visible && fields.buyer_ref.required ? ew.Validators.required(fields.buyer_ref.caption) : null], fields.buyer_ref.isInvalid],
            ["buyer_barcode", [fields.buyer_barcode.visible && fields.buyer_barcode.required ? ew.Validators.required(fields.buyer_barcode.caption) : null], fields.buyer_barcode.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["order_date", [fields.order_date.visible && fields.order_date.required ? ew.Validators.required(fields.order_date.caption) : null, ew.Validators.datetime(fields.order_date.clientFormatPattern), ew.Validators.selected], fields.order_date.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["buyer_po", [fields.buyer_po.visible && fields.buyer_po.required ? ew.Validators.required(fields.buyer_po.caption) : null], fields.buyer_po.isInvalid],
            ["po_price", [fields.po_price.visible && fields.po_price.required ? ew.Validators.required(fields.po_price.caption) : null], fields.po_price.isInvalid],
            ["po_discount", [fields.po_discount.visible && fields.po_discount.required ? ew.Validators.required(fields.po_discount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.po_discount.isInvalid],
            ["po_currency", [fields.po_currency.visible && fields.po_currency.required ? ew.Validators.required(fields.po_currency.caption) : null], fields.po_currency.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["consignee", [fields.consignee.visible && fields.consignee.required ? ew.Validators.required(fields.consignee.caption) : null], fields.consignee.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null], fields.jc_no.isInvalid],
            ["completed", [fields.completed.visible && fields.completed.required ? ew.Validators.required(fields.completed.caption) : null], fields.completed.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "po_currency": <?= $Page->po_currency->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "consignee": <?= $Page->consignee->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode_queryupdate" id="fbarcode_queryupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_barcode_queryupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->buyers_id->Visible && (!$Page->isConfirm() || $Page->buyers_id->multiUpdateSelected())) { // buyers_id ?>
    <div id="r_buyers_id"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyers_id" id="u_buyers_id" class="form-check-input ew-multi-select" value="1"<?= $Page->buyers_id->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyers_id"><?= $Page->buyers_id->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyers_id" id="u_buyers_id" value="<?= $Page->buyers_id->MultiUpdate ?>">
            <?= $Page->buyers_id->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_buyers_id">
                    <select
                        id="x_buyers_id"
                        name="x_buyers_id"
                        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
                        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_buyers_id"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_buyers_id"
                        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
                        data-ew-action="update-options"
                        <?= $Page->buyers_id->editAttributes() ?>>
                        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
                    </select>
                    <?= $Page->buyers_id->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage() ?></div>
                <?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
                <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_buyers_id", selectId: "fbarcode_queryupdate_x_buyers_id" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.buyers_id?.lookupOptions.length) {
                        options.data = { id: "x_buyers_id", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_buyers_id", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.buyers_id.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_buyers_id">
                <span<?= $Page->buyers_id->viewAttributes() ?>>
                <?php if (!EmptyString($Page->buyers_id->ViewValue) && $Page->buyers_id->linkAttributes() != "") { ?>
                <a<?= $Page->buyers_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->ViewValue) ?></span></a>
                <?php } else { ?>
                <span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->ViewValue) ?></span>
                <?php } ?>
                </span>
                <input type="hidden" data-table="barcode_query" data-field="x_buyers_id" data-hidden="1" name="x_buyers_id" id="x_buyers_id" value="<?= HtmlEncode($Page->buyers_id->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible && (!$Page->isConfirm() || $Page->buyer_ref->multiUpdateSelected())) { // buyer_ref ?>
    <div id="r_buyer_ref"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_ref" id="u_buyer_ref" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_ref->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_ref"><?= $Page->buyer_ref->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_ref" id="u_buyer_ref" value="<?= $Page->buyer_ref->MultiUpdate ?>">
            <?= $Page->buyer_ref->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_buyer_ref">
                    <select
                        id="x_buyer_ref"
                        name="x_buyer_ref"
                        class="form-control ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
                        data-select2-id="fbarcode_queryupdate_x_buyer_ref"
                        data-table="barcode_query"
                        data-field="x_buyer_ref"
                        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_ref->caption())) ?>"
                        data-modal-lookup="true"
                        data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
                        data-ew-action="autofill"
                        <?= $Page->buyer_ref->editAttributes() ?>>
                        <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
                    </select>
                    <?= $Page->buyer_ref->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage() ?></div>
                <?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_buyer_ref", selectId: "fbarcode_queryupdate_x_buyer_ref" };
                    if (fbarcode_queryupdate.lists.buyer_ref?.lookupOptions.length) {
                        options.data = { id: "x_buyer_ref", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_buyer_ref", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.buyer_ref.modalLookupOptions);
                    ew.createModalLookup(options);
                });
                </script>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_buyer_ref">
                <span<?= $Page->buyer_ref->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->buyer_ref->getDisplayValue($Page->buyer_ref->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_buyer_ref" data-hidden="1" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible && (!$Page->isConfirm() || $Page->buyer_barcode->multiUpdateSelected())) { // buyer_barcode ?>
    <div id="r_buyer_barcode"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_barcode" id="u_buyer_barcode" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_barcode->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_barcode"><?= $Page->buyer_barcode->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_barcode" id="u_buyer_barcode" value="<?= $Page->buyer_barcode->MultiUpdate ?>">
            <?= $Page->buyer_barcode->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_barcode->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_buyer_barcode">
                <input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode_query" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?> aria-describedby="x_buyer_barcode_help">
                <?= $Page->buyer_barcode->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_buyer_barcode">
                <span<?= $Page->buyer_barcode->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_barcode->getDisplayValue($Page->buyer_barcode->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_buyer_barcode" data-hidden="1" name="x_buyer_barcode" id="x_buyer_barcode" value="<?= HtmlEncode($Page->buyer_barcode->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible && (!$Page->isConfirm() || $Page->design_id->multiUpdateSelected())) { // design_id ?>
    <div id="r_design_id"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_design_id" id="u_design_id" class="form-check-input ew-multi-select" value="1"<?= $Page->design_id->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_design_id"><?= $Page->design_id->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_design_id" id="u_design_id" value="<?= $Page->design_id->MultiUpdate ?>">
            <?= $Page->design_id->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_design_id">
                    <select
                        id="x_design_id"
                        name="x_design_id"
                        class="form-control ew-select<?= $Page->design_id->isInvalidClass() ?>"
                        data-select2-id="fbarcode_queryupdate_x_design_id"
                        data-table="barcode_query"
                        data-field="x_design_id"
                        data-caption="<?= HtmlEncode(RemoveHtml($Page->design_id->caption())) ?>"
                        data-modal-lookup="true"
                        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
                        data-ew-action="update-options"
                        <?= $Page->design_id->editAttributes() ?>>
                        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
                    </select>
                    <?= $Page->design_id->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage() ?></div>
                <?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_design_id", selectId: "fbarcode_queryupdate_x_design_id" };
                    if (fbarcode_queryupdate.lists.design_id?.lookupOptions.length) {
                        options.data = { id: "x_design_id", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_design_id", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.design_id.modalLookupOptions);
                    ew.createModalLookup(options);
                });
                </script>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_design_id">
                <span<?= $Page->design_id->viewAttributes() ?>>
                <?php if (!EmptyString($Page->design_id->ViewValue) && $Page->design_id->linkAttributes() != "") { ?>
                <a<?= $Page->design_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->ViewValue) ?></span></a>
                <?php } else { ?>
                <span class="form-control-plaintext"><?= $Page->design_id->getDisplayValue($Page->design_id->ViewValue) ?></span>
                <?php } ?>
                </span>
                <input type="hidden" data-table="barcode_query" data-field="x_design_id" data-hidden="1" name="x_design_id" id="x_design_id" value="<?= HtmlEncode($Page->design_id->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible && (!$Page->isConfirm() || $Page->batch_no->multiUpdateSelected())) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_batch_no" id="u_batch_no" class="form-check-input ew-multi-select" value="1"<?= $Page->batch_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_batch_no"><?= $Page->batch_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_batch_no" id="u_batch_no" value="<?= $Page->batch_no->MultiUpdate ?>">
            <?= $Page->batch_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_batch_no">
                    <select
                        id="x_batch_no"
                        name="x_batch_no"
                        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
                        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_batch_no"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_batch_no"
                        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
                        <?= $Page->batch_no->editAttributes() ?>>
                        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
                    </select>
                    <?= $Page->batch_no->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
                <?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
                <?php if (!$Page->batch_no->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_batch_no", selectId: "fbarcode_queryupdate_x_batch_no" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.batch_no?.lookupOptions.length) {
                        options.data = { id: "x_batch_no", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_batch_no", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.batch_no.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_batch_no">
                <span<?= $Page->batch_no->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->batch_no->getDisplayValue($Page->batch_no->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_batch_no" data-hidden="1" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible && (!$Page->isConfirm() || $Page->category->multiUpdateSelected())) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_category" id="u_category" class="form-check-input ew-multi-select" value="1"<?= $Page->category->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_category"><?= $Page->category->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_category" id="u_category" value="<?= $Page->category->MultiUpdate ?>">
            <?= $Page->category->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_category">
                    <select
                        id="x_category"
                        name="x_category"
                        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
                        <?php if (!$Page->category->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_category"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_category"
                        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
                        <?= $Page->category->editAttributes() ?>>
                        <?= $Page->category->selectOptionListHtml("x_category") ?>
                    </select>
                    <?= $Page->category->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
                <?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
                <?php if (!$Page->category->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_category", selectId: "fbarcode_queryupdate_x_category" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.category?.lookupOptions.length) {
                        options.data = { id: "x_category", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_category", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.category.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_category">
                <span<?= $Page->category->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->category->getDisplayValue($Page->category->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_category" data-hidden="1" name="x_category" id="x_category" value="<?= HtmlEncode($Page->category->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible && (!$Page->isConfirm() || $Page->order_date->multiUpdateSelected())) { // order_date ?>
    <div id="r_order_date"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_order_date" id="u_order_date" class="form-check-input ew-multi-select" value="1"<?= $Page->order_date->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_order_date"><?= $Page->order_date->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_order_date" id="u_order_date" value="<?= $Page->order_date->MultiUpdate ?>">
            <?= $Page->order_date->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_order_date">
                <input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="barcode_query" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?> aria-describedby="x_order_date_help">
                <?= $Page->order_date->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->order_date->getErrorMessage() ?></div>
                <?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
                <script>
                loadjs.ready(["fbarcode_queryupdate", "datetimepicker"], function () {
                    let format = "<?= DateFormat(111) ?>",
                        options = {
                            localization: {
                                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                                hourCycle: format.match(/H/) ? "h24" : "h12",
                                format,
                                ...ew.language.phrase("datetimepicker")
                            },
                            display: {
                                icons: {
                                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                                },
                                components: {
                                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                                    hours: !!format.match(/h/i),
                                    minutes: !!format.match(/m/),
                                    seconds: !!format.match(/s/i)
                                },
                                theme: ew.getPreferredTheme()
                            }
                        };
                    ew.createDateTimePicker("fbarcode_queryupdate", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_order_date">
                <span<?= $Page->order_date->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->order_date->getDisplayValue($Page->order_date->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_order_date" data-hidden="1" name="x_order_date" id="x_order_date" value="<?= HtmlEncode($Page->order_date->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible && (!$Page->isConfirm() || $Page->despatch_week->multiUpdateSelected())) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_despatch_week" id="u_despatch_week" class="form-check-input ew-multi-select" value="1"<?= $Page->despatch_week->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_despatch_week"><?= $Page->despatch_week->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_despatch_week" id="u_despatch_week" value="<?= $Page->despatch_week->MultiUpdate ?>">
            <?= $Page->despatch_week->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_despatch_week">
                    <select
                        id="x_despatch_week"
                        name="x_despatch_week"
                        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
                        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_despatch_week"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_despatch_week"
                        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
                        <?= $Page->despatch_week->editAttributes() ?>>
                        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
                    </select>
                    <?= $Page->despatch_week->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
                <?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
                <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_despatch_week", selectId: "fbarcode_queryupdate_x_despatch_week" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.despatch_week?.lookupOptions.length) {
                        options.data = { id: "x_despatch_week", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_despatch_week", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.despatch_week.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_despatch_week">
                <span<?= $Page->despatch_week->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->despatch_week->getDisplayValue($Page->despatch_week->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_despatch_week" data-hidden="1" name="x_despatch_week" id="x_despatch_week" value="<?= HtmlEncode($Page->despatch_week->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible && (!$Page->isConfirm() || $Page->buyer_po->multiUpdateSelected())) { // buyer_po ?>
    <div id="r_buyer_po"<?= $Page->buyer_po->rowAttributes() ?>>
        <label for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_po" id="u_buyer_po" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_po->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_po"><?= $Page->buyer_po->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_po" id="u_buyer_po" value="<?= $Page->buyer_po->MultiUpdate ?>">
            <?= $Page->buyer_po->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_po->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_buyer_po">
                <input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="barcode_query" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?> aria-describedby="x_buyer_po_help">
                <?= $Page->buyer_po->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_buyer_po">
                <span<?= $Page->buyer_po->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_po->getDisplayValue($Page->buyer_po->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_buyer_po" data-hidden="1" name="x_buyer_po" id="x_buyer_po" value="<?= HtmlEncode($Page->buyer_po->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible && (!$Page->isConfirm() || $Page->po_price->multiUpdateSelected())) { // po_price ?>
    <div id="r_po_price"<?= $Page->po_price->rowAttributes() ?>>
        <label for="x_po_price" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_po_price" id="u_po_price" class="form-check-input ew-multi-select" value="1"<?= $Page->po_price->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_po_price"><?= $Page->po_price->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_po_price" id="u_po_price" value="<?= $Page->po_price->MultiUpdate ?>">
            <?= $Page->po_price->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_price->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_po_price">
                <input type="<?= $Page->po_price->getInputTextType() ?>" name="x_po_price" id="x_po_price" data-table="barcode_query" data-field="x_po_price" value="<?= $Page->po_price->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->po_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_price->formatPattern()) ?>"<?= $Page->po_price->editAttributes() ?> aria-describedby="x_po_price_help">
                <?= $Page->po_price->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->po_price->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_po_price">
                <span<?= $Page->po_price->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po_price->getDisplayValue($Page->po_price->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_po_price" data-hidden="1" name="x_po_price" id="x_po_price" value="<?= HtmlEncode($Page->po_price->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible && (!$Page->isConfirm() || $Page->po_discount->multiUpdateSelected())) { // po_discount ?>
    <div id="r_po_discount"<?= $Page->po_discount->rowAttributes() ?>>
        <label for="x_po_discount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_po_discount" id="u_po_discount" class="form-check-input ew-multi-select" value="1"<?= $Page->po_discount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_po_discount"><?= $Page->po_discount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_po_discount" id="u_po_discount" value="<?= $Page->po_discount->MultiUpdate ?>">
            <?= $Page->po_discount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_discount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_po_discount">
                <input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="barcode_query" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?> aria-describedby="x_po_discount_help">
                <?= $Page->po_discount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_po_discount">
                <span<?= $Page->po_discount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po_discount->getDisplayValue($Page->po_discount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_po_discount" data-hidden="1" name="x_po_discount" id="x_po_discount" value="<?= HtmlEncode($Page->po_discount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_currency->Visible && (!$Page->isConfirm() || $Page->po_currency->multiUpdateSelected())) { // po_currency ?>
    <div id="r_po_currency"<?= $Page->po_currency->rowAttributes() ?>>
        <label for="x_po_currency" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_po_currency" id="u_po_currency" class="form-check-input ew-multi-select" value="1"<?= $Page->po_currency->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_po_currency"><?= $Page->po_currency->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_po_currency" id="u_po_currency" value="<?= $Page->po_currency->MultiUpdate ?>">
            <?= $Page->po_currency->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_currency->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_po_currency">
                    <select
                        id="x_po_currency"
                        name="x_po_currency"
                        class="form-select ew-select<?= $Page->po_currency->isInvalidClass() ?>"
                        <?php if (!$Page->po_currency->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_po_currency"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_po_currency"
                        data-value-separator="<?= $Page->po_currency->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->po_currency->getPlaceHolder()) ?>"
                        <?= $Page->po_currency->editAttributes() ?>>
                        <?= $Page->po_currency->selectOptionListHtml("x_po_currency") ?>
                    </select>
                    <?= $Page->po_currency->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->po_currency->getErrorMessage() ?></div>
                <?= $Page->po_currency->Lookup->getParamTag($Page, "p_x_po_currency") ?>
                <?php if (!$Page->po_currency->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_po_currency", selectId: "fbarcode_queryupdate_x_po_currency" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.po_currency?.lookupOptions.length) {
                        options.data = { id: "x_po_currency", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_po_currency", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.po_currency.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_po_currency">
                <span<?= $Page->po_currency->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->po_currency->getDisplayValue($Page->po_currency->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_po_currency" data-hidden="1" name="x_po_currency" id="x_po_currency" value="<?= HtmlEncode($Page->po_currency->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible && (!$Page->isConfirm() || $Page->weaving_works->multiUpdateSelected())) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_weaving_works" id="u_weaving_works" class="form-check-input ew-multi-select" value="1"<?= $Page->weaving_works->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_weaving_works"><?= $Page->weaving_works->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_weaving_works" id="u_weaving_works" value="<?= $Page->weaving_works->MultiUpdate ?>">
            <?= $Page->weaving_works->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_weaving_works">
                    <select
                        id="x_weaving_works"
                        name="x_weaving_works"
                        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
                        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_weaving_works"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_weaving_works"
                        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
                        <?= $Page->weaving_works->editAttributes() ?>>
                        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
                    </select>
                    <?= $Page->weaving_works->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
                <?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
                <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_weaving_works", selectId: "fbarcode_queryupdate_x_weaving_works" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.weaving_works?.lookupOptions.length) {
                        options.data = { id: "x_weaving_works", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_weaving_works", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.weaving_works.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_weaving_works">
                <span<?= $Page->weaving_works->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->weaving_works->getDisplayValue($Page->weaving_works->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_weaving_works" data-hidden="1" name="x_weaving_works" id="x_weaving_works" value="<?= HtmlEncode($Page->weaving_works->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consignee->Visible && (!$Page->isConfirm() || $Page->consignee->multiUpdateSelected())) { // consignee ?>
    <div id="r_consignee"<?= $Page->consignee->rowAttributes() ?>>
        <label for="x_consignee" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_consignee" id="u_consignee" class="form-check-input ew-multi-select" value="1"<?= $Page->consignee->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_consignee"><?= $Page->consignee->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_consignee" id="u_consignee" value="<?= $Page->consignee->MultiUpdate ?>">
            <?= $Page->consignee->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consignee->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_consignee">
                    <select
                        id="x_consignee"
                        name="x_consignee"
                        class="form-select ew-select<?= $Page->consignee->isInvalidClass() ?>"
                        <?php if (!$Page->consignee->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_consignee"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_consignee"
                        data-value-separator="<?= $Page->consignee->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->consignee->getPlaceHolder()) ?>"
                        <?= $Page->consignee->editAttributes() ?>>
                        <?= $Page->consignee->selectOptionListHtml("x_consignee") ?>
                    </select>
                    <?= $Page->consignee->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->consignee->getErrorMessage() ?></div>
                <?= $Page->consignee->Lookup->getParamTag($Page, "p_x_consignee") ?>
                <?php if (!$Page->consignee->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_consignee", selectId: "fbarcode_queryupdate_x_consignee" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.consignee?.lookupOptions.length) {
                        options.data = { id: "x_consignee", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_consignee", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.consignee.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_consignee">
                <span<?= $Page->consignee->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->consignee->getDisplayValue($Page->consignee->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_consignee" data-hidden="1" name="x_consignee" id="x_consignee" value="<?= HtmlEncode($Page->consignee->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible && (!$Page->isConfirm() || $Page->completed->multiUpdateSelected())) { // completed ?>
    <div id="r_completed"<?= $Page->completed->rowAttributes() ?>>
        <label for="x_completed" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_completed" id="u_completed" class="form-check-input ew-multi-select" value="1"<?= $Page->completed->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_completed"><?= $Page->completed->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_completed" id="u_completed" value="<?= $Page->completed->MultiUpdate ?>">
            <?= $Page->completed->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_completed">
                    <select
                        id="x_completed"
                        name="x_completed"
                        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
                        <?php if (!$Page->completed->IsNativeSelect) { ?>
                        data-select2-id="fbarcode_queryupdate_x_completed"
                        <?php } ?>
                        data-table="barcode_query"
                        data-field="x_completed"
                        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
                        <?= $Page->completed->editAttributes() ?>>
                        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
                    </select>
                    <?= $Page->completed->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage() ?></div>
                <?php if (!$Page->completed->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fbarcode_queryupdate", function() {
                    var options = { name: "x_completed", selectId: "fbarcode_queryupdate_x_completed" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fbarcode_queryupdate.lists.completed?.lookupOptions.length) {
                        options.data = { id: "x_completed", form: "fbarcode_queryupdate" };
                    } else {
                        options.ajax = { id: "x_completed", form: "fbarcode_queryupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.completed.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_completed">
                <span<?= $Page->completed->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->completed->getDisplayValue($Page->completed->ViewValue) ?></span></span>
                <input type="hidden" data-table="barcode_query" data-field="x_completed" data-hidden="1" name="x_completed" id="x_completed" value="<?= HtmlEncode($Page->completed->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible && (!$Page->isConfirm() || $Page->remarks->multiUpdateSelected())) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_remarks" id="u_remarks" class="form-check-input ew-multi-select" value="1"<?= $Page->remarks->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_remarks"><?= $Page->remarks->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_remarks" id="u_remarks" value="<?= $Page->remarks->MultiUpdate ?>">
            <?= $Page->remarks->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_remarks">
                <input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="barcode_query" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
                <?= $Page->remarks->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_remarks">
                <span<?= $Page->remarks->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->remarks->getDisplayValue($Page->remarks->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_remarks" data-hidden="1" name="x_remarks" id="x_remarks" value="<?= HtmlEncode($Page->remarks->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible && (!$Page->isConfirm() || $Page->buyer_loc->multiUpdateSelected())) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_loc" id="u_buyer_loc" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_loc->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_loc"><?= $Page->buyer_loc->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_loc" id="u_buyer_loc" value="<?= $Page->buyer_loc->MultiUpdate ?>">
            <?= $Page->buyer_loc->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_barcode_query_buyer_loc">
                <input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="barcode_query" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help">
                <?= $Page->buyer_loc->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_barcode_query_buyer_loc">
                <span<?= $Page->buyer_loc->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_loc->getDisplayValue($Page->buyer_loc->ViewValue))) ?>"></span>
                <input type="hidden" data-table="barcode_query" data-field="x_buyer_loc" data-hidden="1" name="x_buyer_loc" id="x_buyer_loc" value="<?= HtmlEncode($Page->buyer_loc->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_queryupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_queryupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_queryupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fbarcode_queryupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
