<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeQuerySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_query: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbarcode_querysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_querysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["y_pl_no", [ew.Validators.between], false],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["buyer_barcode", [], fields.buyer_barcode.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["order_date", [ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["po_price", [], fields.po_price.isInvalid],
            ["po_discount", [ew.Validators.float], fields.po_discount.isInvalid],
            ["po_currency", [], fields.po_currency.isInvalid],
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["consignee", [], fields.consignee.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "po_currency": <?= $Page->po_currency->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "consignee": <?= $Page->consignee->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode_querysearch" id="fbarcode_querysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="barcode_query" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_pl_no"><?= $Page->pl_no->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pl_no" id="z_pl_no" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pl_no->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pl_no->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_query_pl_no" class="ew-search-field">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="barcode_query" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_query_pl_no" class="ew-search-field2 d-none">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="y_pl_no" id="y_pl_no" data-table="barcode_query" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_query_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode_query" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_query_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="barcode_query" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_query__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode_query" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_query__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="barcode_query" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_buyers_id"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_buyers_id", selectId: "fbarcode_querysearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_buyer_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_ref"
        name="x_buyer_ref"
        class="form-control ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
        data-select2-id="fbarcode_querysearch_x_buyer_ref"
        data-table="barcode_query"
        data-field="x_buyer_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
        <?= $Page->buyer_ref->editAttributes() ?>>
        <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_buyer_ref", selectId: "fbarcode_querysearch_x_buyer_ref" };
    if (fbarcode_querysearch.lists.buyer_ref?.lookupOptions.length) {
        options.data = { id: "x_buyer_ref", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_buyer_ref", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.buyer_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
    <div id="r_buyer_barcode" class="row"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_barcode"><?= $Page->buyer_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_buyer_barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode_query" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-control ew-select<?= $Page->design_id->isInvalidClass() ?>"
        data-select2-id="fbarcode_querysearch_x_design_id"
        data-table="barcode_query"
        data-field="x_design_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->design_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_design_id", selectId: "fbarcode_querysearch_x_design_id" };
    if (fbarcode_querysearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.design_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_batch_no"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_batch_no", selectId: "fbarcode_querysearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_category" id="z_category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_category"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_category", selectId: "fbarcode_querysearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_category", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="barcode_query" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer" class="row"<?= $Page->size_buyer->rowAttributes() ?>>
        <label for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_size_buyer"><?= $Page->size_buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="barcode_query" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date" class="row"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_order_date"><?= $Page->order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_date" id="z_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="barcode_query" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbarcode_querysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbarcode_querysearch", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_despatch_week"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_despatch_week", selectId: "fbarcode_querysearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="barcode_query" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po" class="row"<?= $Page->buyer_po->rowAttributes() ?>>
        <label for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_po"><?= $Page->buyer_po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="barcode_query" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
    <div id="r_po_price" class="row"<?= $Page->po_price->rowAttributes() ?>>
        <label for="x_po_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_po_price"><?= $Page->po_price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po_price" id="z_po_price" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_po_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_price->getInputTextType() ?>" name="x_po_price" id="x_po_price" data-table="barcode_query" data-field="x_po_price" value="<?= $Page->po_price->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->po_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_price->formatPattern()) ?>"<?= $Page->po_price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible) { // po_discount ?>
    <div id="r_po_discount" class="row"<?= $Page->po_discount->rowAttributes() ?>>
        <label for="x_po_discount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_po_discount"><?= $Page->po_discount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_discount" id="z_po_discount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_discount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_po_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="barcode_query" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_currency->Visible) { // po_currency ?>
    <div id="r_po_currency" class="row"<?= $Page->po_currency->rowAttributes() ?>>
        <label for="x_po_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_po_currency"><?= $Page->po_currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_currency" id="z_po_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_po_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_po_currency"
        name="x_po_currency"
        class="form-select ew-select<?= $Page->po_currency->isInvalidClass() ?>"
        <?php if (!$Page->po_currency->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_po_currency"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_po_currency"
        data-value-separator="<?= $Page->po_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_currency->getPlaceHolder()) ?>"
        <?= $Page->po_currency->editAttributes() ?>>
        <?= $Page->po_currency->selectOptionListHtml("x_po_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_currency->getErrorMessage(false) ?></div>
<?= $Page->po_currency->Lookup->getParamTag($Page, "p_x_po_currency") ?>
<?php if (!$Page->po_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_po_currency", selectId: "fbarcode_querysearch_x_po_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.po_currency?.lookupOptions.length) {
        options.data = { id: "x_po_currency", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_po_currency", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.po_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works" class="row"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_weaving_works"><?= $Page->weaving_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_weaving_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_weaving_works"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_weaving_works", selectId: "fbarcode_querysearch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_current_works"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_current_works", selectId: "fbarcode_querysearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consignee->Visible) { // consignee ?>
    <div id="r_consignee" class="row"<?= $Page->consignee->rowAttributes() ?>>
        <label for="x_consignee" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_consignee"><?= $Page->consignee->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_consignee" id="z_consignee" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consignee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_consignee" class="ew-search-field ew-search-field-single">
    <select
        id="x_consignee"
        name="x_consignee"
        class="form-select ew-select<?= $Page->consignee->isInvalidClass() ?>"
        <?php if (!$Page->consignee->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_consignee"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_consignee"
        data-value-separator="<?= $Page->consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee->getPlaceHolder()) ?>"
        <?= $Page->consignee->editAttributes() ?>>
        <?= $Page->consignee->selectOptionListHtml("x_consignee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->consignee->getErrorMessage(false) ?></div>
<?= $Page->consignee->Lookup->getParamTag($Page, "p_x_consignee") ?>
<?php if (!$Page->consignee->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_consignee", selectId: "fbarcode_querysearch_x_consignee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.consignee?.lookupOptions.length) {
        options.data = { id: "x_consignee", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_consignee", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.consignee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="barcode_query" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="barcode_query" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="barcode_query" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbarcode_querysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbarcode_querysearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed" class="row"<?= $Page->completed->rowAttributes() ?>>
        <label for="x_completed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_completed"><?= $Page->completed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_completed" id="z_completed" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_completed" class="ew-search-field ew-search-field-single">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fbarcode_querysearch_x_completed"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_querysearch", function() {
    var options = { name: "x_completed", selectId: "fbarcode_querysearch_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_querysearch.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fbarcode_querysearch" };
    } else {
        options.ajax = { id: "x_completed", form: "fbarcode_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="barcode_query" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_query_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_query_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="barcode_query" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_querysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_querysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbarcode_querysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
