<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodeQueryEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fbarcode_queryedit" id="fbarcode_queryedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_query: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fbarcode_queryedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbarcode_queryedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["pl_no", [fields.pl_no.visible && fields.pl_no.required ? ew.Validators.required(fields.pl_no.caption) : null], fields.pl_no.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["buyers_id", [fields.buyers_id.visible && fields.buyers_id.required ? ew.Validators.required(fields.buyers_id.caption) : null], fields.buyers_id.isInvalid],
            ["buyer_ref", [fields.buyer_ref.visible && fields.buyer_ref.required ? ew.Validators.required(fields.buyer_ref.caption) : null], fields.buyer_ref.isInvalid],
            ["buyer_barcode", [fields.buyer_barcode.visible && fields.buyer_barcode.required ? ew.Validators.required(fields.buyer_barcode.caption) : null], fields.buyer_barcode.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["size_buyer", [fields.size_buyer.visible && fields.size_buyer.required ? ew.Validators.required(fields.size_buyer.caption) : null], fields.size_buyer.isInvalid],
            ["order_date", [fields.order_date.visible && fields.order_date.required ? ew.Validators.required(fields.order_date.caption) : null, ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["buyer_po", [fields.buyer_po.visible && fields.buyer_po.required ? ew.Validators.required(fields.buyer_po.caption) : null], fields.buyer_po.isInvalid],
            ["po_price", [fields.po_price.visible && fields.po_price.required ? ew.Validators.required(fields.po_price.caption) : null], fields.po_price.isInvalid],
            ["po_discount", [fields.po_discount.visible && fields.po_discount.required ? ew.Validators.required(fields.po_discount.caption) : null, ew.Validators.float], fields.po_discount.isInvalid],
            ["po_currency", [fields.po_currency.visible && fields.po_currency.required ? ew.Validators.required(fields.po_currency.caption) : null], fields.po_currency.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["current_works", [fields.current_works.visible && fields.current_works.required ? ew.Validators.required(fields.current_works.caption) : null], fields.current_works.isInvalid],
            ["consignee", [fields.consignee.visible && fields.consignee.required ? ew.Validators.required(fields.consignee.caption) : null], fields.consignee.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null], fields.jc_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "po_currency": <?= $Page->po_currency->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "consignee": <?= $Page->consignee->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_query">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_barcode_query_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_barcode_query_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no"<?= $Page->pl_no->rowAttributes() ?>>
        <label id="elh_barcode_query_pl_no" for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pl_no->caption() ?><?= $Page->pl_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pl_no->cellAttributes() ?>>
<span id="el_barcode_query_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pl_no->getDisplayValue($Page->pl_no->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_pl_no" data-hidden="1" name="x_pl_no" id="x_pl_no" value="<?= HtmlEncode($Page->pl_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_barcode_query_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_barcode_query_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_barcode_query__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_barcode_query__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_barcode->getDisplayValue($Page->_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x__barcode" data-hidden="1" name="x__barcode" id="x__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id"<?= $Page->buyers_id->rowAttributes() ?>>
        <label id="elh_barcode_query_buyers_id" for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyers_id->caption() ?><?= $Page->buyers_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el_barcode_query_buyers_id">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_buyers_id"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <?= $Page->buyers_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage() ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_buyers_id", selectId: "fbarcode_queryedit_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label id="elh_barcode_query_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_ref->caption() ?><?= $Page->buyer_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el_barcode_query_buyer_ref">
    <select
        id="x_buyer_ref"
        name="x_buyer_ref"
        class="form-control ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
        data-select2-id="fbarcode_queryedit_x_buyer_ref"
        data-table="barcode_query"
        data-field="x_buyer_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->buyer_ref->editAttributes() ?>>
        <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
    </select>
    <?= $Page->buyer_ref->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage() ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_buyer_ref", selectId: "fbarcode_queryedit_x_buyer_ref" };
    if (fbarcode_queryedit.lists.buyer_ref?.lookupOptions.length) {
        options.data = { id: "x_buyer_ref", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_buyer_ref", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.buyer_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
    <div id="r_buyer_barcode"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label id="elh_barcode_query_buyer_barcode" for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_barcode->caption() ?><?= $Page->buyer_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el_barcode_query_buyer_barcode">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode_query" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?> aria-describedby="x_buyer_barcode_help">
<?= $Page->buyer_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id"<?= $Page->design_id->rowAttributes() ?>>
        <label id="elh_barcode_query_design_id" for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design_id->caption() ?><?= $Page->design_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design_id->cellAttributes() ?>>
<span id="el_barcode_query_design_id">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-control ew-select<?= $Page->design_id->isInvalidClass() ?>"
        data-select2-id="fbarcode_queryedit_x_design_id"
        data-table="barcode_query"
        data-field="x_design_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->design_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <?= $Page->design_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage() ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_design_id", selectId: "fbarcode_queryedit_x_design_id" };
    if (fbarcode_queryedit.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_design_id", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode_query.fields.design_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_barcode_query_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_barcode_query_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_batch_no"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_batch_no", selectId: "fbarcode_queryedit_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_barcode_query_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_barcode_query_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_category"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_category", selectId: "fbarcode_queryedit_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_category", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_barcode_query_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_barcode_query_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_cm->getDisplayValue($Page->size_cm->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_size_cm" data-hidden="1" name="x_size_cm" id="x_size_cm" value="<?= HtmlEncode($Page->size_cm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer"<?= $Page->size_buyer->rowAttributes() ?>>
        <label id="elh_barcode_query_size_buyer" for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_buyer->caption() ?><?= $Page->size_buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el_barcode_query_size_buyer">
<span<?= $Page->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_buyer->getDisplayValue($Page->size_buyer->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_size_buyer" data-hidden="1" name="x_size_buyer" id="x_size_buyer" value="<?= HtmlEncode($Page->size_buyer->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date"<?= $Page->order_date->rowAttributes() ?>>
        <label id="elh_barcode_query_order_date" for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_date->caption() ?><?= $Page->order_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_date->cellAttributes() ?>>
<span id="el_barcode_query_order_date">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="barcode_query" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?> aria-describedby="x_order_date_help">
<?= $Page->order_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage() ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbarcode_queryedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbarcode_queryedit", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_barcode_query_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_barcode_query_despatch_week">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_despatch_week"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <?= $Page->despatch_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_despatch_week", selectId: "fbarcode_queryedit_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_barcode_query_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_barcode_query_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po"<?= $Page->buyer_po->rowAttributes() ?>>
        <label id="elh_barcode_query_buyer_po" for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_po->caption() ?><?= $Page->buyer_po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el_barcode_query_buyer_po">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="barcode_query" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?> aria-describedby="x_buyer_po_help">
<?= $Page->buyer_po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_price->Visible) { // po_price ?>
    <div id="r_po_price"<?= $Page->po_price->rowAttributes() ?>>
        <label id="elh_barcode_query_po_price" for="x_po_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_price->caption() ?><?= $Page->po_price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_price->cellAttributes() ?>>
<span id="el_barcode_query_po_price">
<input type="<?= $Page->po_price->getInputTextType() ?>" name="x_po_price" id="x_po_price" data-table="barcode_query" data-field="x_po_price" value="<?= $Page->po_price->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->po_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_price->formatPattern()) ?>"<?= $Page->po_price->editAttributes() ?> aria-describedby="x_po_price_help">
<?= $Page->po_price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_discount->Visible) { // po_discount ?>
    <div id="r_po_discount"<?= $Page->po_discount->rowAttributes() ?>>
        <label id="elh_barcode_query_po_discount" for="x_po_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_discount->caption() ?><?= $Page->po_discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_discount->cellAttributes() ?>>
<span id="el_barcode_query_po_discount">
<input type="<?= $Page->po_discount->getInputTextType() ?>" name="x_po_discount" id="x_po_discount" data-table="barcode_query" data-field="x_po_discount" value="<?= $Page->po_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_discount->formatPattern()) ?>"<?= $Page->po_discount->editAttributes() ?> aria-describedby="x_po_discount_help">
<?= $Page->po_discount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_discount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_currency->Visible) { // po_currency ?>
    <div id="r_po_currency"<?= $Page->po_currency->rowAttributes() ?>>
        <label id="elh_barcode_query_po_currency" for="x_po_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_currency->caption() ?><?= $Page->po_currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_currency->cellAttributes() ?>>
<span id="el_barcode_query_po_currency">
    <select
        id="x_po_currency"
        name="x_po_currency"
        class="form-select ew-select<?= $Page->po_currency->isInvalidClass() ?>"
        <?php if (!$Page->po_currency->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_po_currency"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_po_currency"
        data-value-separator="<?= $Page->po_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_currency->getPlaceHolder()) ?>"
        <?= $Page->po_currency->editAttributes() ?>>
        <?= $Page->po_currency->selectOptionListHtml("x_po_currency") ?>
    </select>
    <?= $Page->po_currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po_currency->getErrorMessage() ?></div>
<?= $Page->po_currency->Lookup->getParamTag($Page, "p_x_po_currency") ?>
<?php if (!$Page->po_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_po_currency", selectId: "fbarcode_queryedit_x_po_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.po_currency?.lookupOptions.length) {
        options.data = { id: "x_po_currency", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_po_currency", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.po_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works"<?= $Page->weaving_works->rowAttributes() ?>>
        <label id="elh_barcode_query_weaving_works" for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weaving_works->caption() ?><?= $Page->weaving_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el_barcode_query_weaving_works">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_weaving_works"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <?= $Page->weaving_works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage() ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_weaving_works", selectId: "fbarcode_queryedit_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works"<?= $Page->current_works->rowAttributes() ?>>
        <label id="elh_barcode_query_current_works" for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_works->caption() ?><?= $Page->current_works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_works->cellAttributes() ?>>
<span id="el_barcode_query_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->current_works->getDisplayValue($Page->current_works->EditValue) ?></span></span>
<input type="hidden" data-table="barcode_query" data-field="x_current_works" data-hidden="1" name="x_current_works" id="x_current_works" value="<?= HtmlEncode($Page->current_works->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consignee->Visible) { // consignee ?>
    <div id="r_consignee"<?= $Page->consignee->rowAttributes() ?>>
        <label id="elh_barcode_query_consignee" for="x_consignee" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consignee->caption() ?><?= $Page->consignee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consignee->cellAttributes() ?>>
<span id="el_barcode_query_consignee">
    <select
        id="x_consignee"
        name="x_consignee"
        class="form-select ew-select<?= $Page->consignee->isInvalidClass() ?>"
        <?php if (!$Page->consignee->IsNativeSelect) { ?>
        data-select2-id="fbarcode_queryedit_x_consignee"
        <?php } ?>
        data-table="barcode_query"
        data-field="x_consignee"
        data-value-separator="<?= $Page->consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee->getPlaceHolder()) ?>"
        <?= $Page->consignee->editAttributes() ?>>
        <?= $Page->consignee->selectOptionListHtml("x_consignee") ?>
    </select>
    <?= $Page->consignee->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->consignee->getErrorMessage() ?></div>
<?= $Page->consignee->Lookup->getParamTag($Page, "p_x_consignee") ?>
<?php if (!$Page->consignee->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_queryedit", function() {
    var options = { name: "x_consignee", selectId: "fbarcode_queryedit_x_consignee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_queryedit.lists.consignee?.lookupOptions.length) {
        options.data = { id: "x_consignee", form: "fbarcode_queryedit" };
    } else {
        options.ajax = { id: "x_consignee", form: "fbarcode_queryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_query.fields.consignee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_barcode_query_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_barcode_query_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->jc_no->getDisplayValue($Page->jc_no->EditValue))) ?>"></span>
<input type="hidden" data-table="barcode_query" data-field="x_jc_no" data-hidden="1" name="x_jc_no" id="x_jc_no" value="<?= HtmlEncode($Page->jc_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_barcode_query_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_barcode_query_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="barcode_query" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label id="elh_barcode_query_buyer_loc" for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_loc->caption() ?><?= $Page->buyer_loc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el_barcode_query_buyer_loc">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="barcode_query" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help">
<?= $Page->buyer_loc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_queryedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_queryedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
