<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodePrintSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_print: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbarcode_printsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_printsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design_size", [ew.Validators.integer], fields.design_size.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode_printsearch" id="fbarcode_printsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_print">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_print_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode_print" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_print_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="barcode_print" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_barcode_print__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode_print" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_barcode_print__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="barcode_print" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
    <div id="r_design_size" class="row"<?= $Page->design_size->rowAttributes() ?>>
        <label for="x_design_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_design_size"><?= $Page->design_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_size" id="z_design_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_design_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="barcode_print" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="243" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_category" id="z_category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbarcode_printsearch_x_category"
        <?php } ?>
        data-table="barcode_print"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_printsearch", function() {
    var options = { name: "x_category", selectId: "fbarcode_printsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_printsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbarcode_printsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fbarcode_printsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_print.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works" class="row"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_weaving_works"><?= $Page->weaving_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_weaving_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode_printsearch_x_weaving_works"
        <?php } ?>
        data-table="barcode_print"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_printsearch", function() {
    var options = { name: "x_weaving_works", selectId: "fbarcode_printsearch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_printsearch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbarcode_printsearch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbarcode_printsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_print.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_buyer_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_ref"
        name="x_buyer_ref"
        class="form-select ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
        <?php if (!$Page->buyer_ref->IsNativeSelect) { ?>
        data-select2-id="fbarcode_printsearch_x_buyer_ref"
        <?php } ?>
        data-table="barcode_print"
        data-field="x_buyer_ref"
        data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
        <?= $Page->buyer_ref->editAttributes() ?>>
        <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
<?php if (!$Page->buyer_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_printsearch", function() {
    var options = { name: "x_buyer_ref", selectId: "fbarcode_printsearch_x_buyer_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_printsearch.lists.buyer_ref?.lookupOptions.length) {
        options.data = { id: "x_buyer_ref", form: "fbarcode_printsearch" };
    } else {
        options.ajax = { id: "x_buyer_ref", form: "fbarcode_printsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_print.fields.buyer_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="barcode_print" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="barcode_print" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fbarcode_printsearch_x_buyers_id"
        <?php } ?>
        data-table="barcode_print"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode_printsearch", function() {
    var options = { name: "x_buyers_id", selectId: "fbarcode_printsearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode_printsearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbarcode_printsearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbarcode_printsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode_print.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
    <div id="r_buyer_uid" class="row"<?= $Page->buyer_uid->rowAttributes() ?>>
        <label for="x_buyer_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_buyer_uid"><?= $Page->buyer_uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="barcode_print" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_barcode_print_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_barcode_print_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="barcode_print" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbarcode_printsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode_printsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbarcode_printsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_print");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
