<?php

namespace PHPMaker2024\fibre;

// Page object
$BarcodePrintList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_print: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbarcode_printsrch" id="fbarcode_printsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbarcode_printsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode_print: currentTable } });
var currentForm;
var fbarcode_printsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode_printsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design_size", [ew.Validators.integer], fields.design_size.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode_print_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode_print" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode_print_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="barcode_print" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode_print__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode_print" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode_print__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="barcode_print" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
<?php
if (!$Page->design_size->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design_size" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design_size->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_design_size" class="ew-search-caption ew-label"><?= $Page->design_size->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_size" id="z_design_size" value="LIKE">
</div>
        </div>
        <div id="el_barcode_print_design_size" class="ew-search-field">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="barcode_print" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="243" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbarcode_printsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbarcode_printsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbarcode_printsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbarcode_printsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbarcode_printsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbarcode_printsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbarcode_printsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode_print">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_barcode_print" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_barcode_printlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_barcode_print_po" class="barcode_print_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_barcode_print__barcode" class="barcode_print__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
        <th data-name="design_size" class="<?= $Page->design_size->headerCellClass() ?>"><div id="elh_barcode_print_design_size" class="barcode_print_design_size"><?= $Page->renderFieldHeader($Page->design_size) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_print_quantity" class="barcode_print_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode_print_category" class="barcode_print_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>"><div id="elh_barcode_print_weaving_works" class="barcode_print_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_barcode_print_buyer_ref" class="barcode_print_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>"><div id="elh_barcode_print_design" class="barcode_print_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_barcode_print_size_cm" class="barcode_print_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_barcode_print_buyers_id" class="barcode_print_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>"><div id="elh_barcode_print_buyer_uid" class="barcode_print_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <th data-name="buyer_loc" class="<?= $Page->buyer_loc->headerCellClass() ?>"><div id="elh_barcode_print_buyer_loc" class="barcode_print_buyer_loc"><?= $Page->renderFieldHeader($Page->buyer_loc) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_po" class="el_barcode_print_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print__barcode" class="el_barcode_print__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_size->Visible) { // design_size ?>
        <td data-name="design_size"<?= $Page->design_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_design_size" class="el_barcode_print_design_size">
<span<?= $Page->design_size->viewAttributes() ?>>
<?= $Page->design_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_quantity" class="el_barcode_print_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_category" class="el_barcode_print_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_weaving_works" class="el_barcode_print_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_buyer_ref" class="el_barcode_print_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_design" class="el_barcode_print_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_size_cm" class="el_barcode_print_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_buyers_id" class="el_barcode_print_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_buyer_uid" class="el_barcode_print_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc"<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode_print_buyer_loc" class="el_barcode_print_buyer_loc">
<span<?= $Page->buyer_loc->viewAttributes() ?>>
<?= $Page->buyer_loc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode_print");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
