<?php

namespace PHPMaker2024\fibre;

// Page object
$Barcode2Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode2: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbarcode2search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode2search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["weight", [ew.Validators.float], fields.weight.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["process_c", [], fields.process_c.isInvalid],
            ["y_process_c", [ew.Validators.between], false],
            ["process_d", [], fields.process_d.isInvalid],
            ["y_process_d", [ew.Validators.between], false],
            ["status", [], fields.status.isInvalid],
            ["buyers_id", [ew.Validators.integer], fields.buyers_id.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["y_despatch_week", [ew.Validators.between], false],
            ["cs", [], fields.cs.isInvalid],
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["p_remarks", [], fields.p_remarks.isInvalid],
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design_size", [ew.Validators.integer], fields.design_size.isInvalid],
            ["buyer_uid", [], fields.buyer_uid.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid],
            ["order_date", [ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["y_pl_no", [ew.Validators.between], false],
            ["pid", [ew.Validators.integer], fields.pid.isInvalid],
            ["y_pid", [ew.Validators.between], false],
            ["buyer_barcode", [], fields.buyer_barcode.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "process_c": <?= $Page->process_c->toClientList($Page) ?>,
            "process_d": <?= $Page->process_d->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "cs": <?= $Page->cs->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbarcode2search" id="fbarcode2search" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("barcode2list")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode2">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_barcode2_po" class="barcode2search"><span id="el_barcode2_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode2" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2__barcode" class="barcode2search"><span id="el_barcode2__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode2" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_batch_no" class="barcode2search"><span id="el_barcode2_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="barcode2" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
</span></template>
<template id="tpx_barcode2_sqm" class="barcode2search"><span id="el_barcode2_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="barcode2" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_weight" class="barcode2search"><span id="el_barcode2_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight->getInputTextType() ?>" name="x_weight" id="x_weight" data-table="barcode2" data-field="x_weight" value="<?= $Page->weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight->formatPattern()) ?>"<?= $Page->weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_jc_no" class="barcode2search"><span id="el_barcode2_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="barcode2" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_process_c" class="barcode2search"><span id="el_barcode2_process_c" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_c[]"
        name="x_process_c[]"
        class="form-control ew-select<?= $Page->process_c->isInvalidClass() ?>"
        data-select2-id="fbarcode2search_x_process_c[]"
        data-table="barcode2"
        data-field="x_process_c"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_c->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("x_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_x_process_c") ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_process_c[]", selectId: "fbarcode2search_x_process_c[]" };
    options.multiple = true;
    if (fbarcode2search.lists.process_c?.lookupOptions.length) {
        options.data = { id: "x_process_c[]", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_process_c[]", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_c.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_barcode2_process_d" class="barcode2search"><span id="el_barcode2_process_d" class="ew-search-field ew-search-field-single">
    <select
        id="x_process_d[]"
        name="x_process_d[]"
        class="form-control ew-select<?= $Page->process_d->isInvalidClass() ?>"
        data-select2-id="fbarcode2search_x_process_d[]"
        data-table="barcode2"
        data-field="x_process_d"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_d->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_d->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>"
        <?= $Page->process_d->editAttributes() ?>>
        <?= $Page->process_d->selectOptionListHtml("x_process_d[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
<?= $Page->process_d->Lookup->getParamTag($Page, "p_x_process_d") ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_process_d[]", selectId: "fbarcode2search_x_process_d[]" };
    options.multiple = true;
    if (fbarcode2search.lists.process_d?.lookupOptions.length) {
        options.data = { id: "x_process_d[]", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_process_d[]", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_d.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_barcode2_status" class="barcode2search"><span id="el_barcode2_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_status"
        <?php } ?>
        data-table="barcode2"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_status", selectId: "fbarcode2search_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_status", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_buyers_id" class="barcode2search"><span id="el_barcode2_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-control ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        data-select2-id="fbarcode2search_x_buyers_id"
        data-table="barcode2"
        data-field="x_buyers_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyers_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_buyers_id", selectId: "fbarcode2search_x_buyers_id" };
    if (fbarcode2search.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.buyers_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_barcode2_despatch_week" class="barcode2search"><span id="el_barcode2_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_despatch_week"
        <?php } ?>
        data-table="barcode2"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_despatch_week", selectId: "fbarcode2search_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_cs" class="barcode2search"><span id="el_barcode2_cs" class="ew-search-field ew-search-field-single">
    <select
        id="x_cs"
        name="x_cs"
        class="form-select ew-select<?= $Page->cs->isInvalidClass() ?>"
        <?php if (!$Page->cs->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_cs"
        <?php } ?>
        data-table="barcode2"
        data-field="x_cs"
        data-value-separator="<?= $Page->cs->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cs->getPlaceHolder()) ?>"
        <?= $Page->cs->editAttributes() ?>>
        <?= $Page->cs->selectOptionListHtml("x_cs") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cs->getErrorMessage(false) ?></div>
<?php if (!$Page->cs->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_cs", selectId: "fbarcode2search_x_cs" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.cs?.lookupOptions.length) {
        options.data = { id: "x_cs", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_cs", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.cs.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_weaving_works" class="barcode2search"><span id="el_barcode2_weaving_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_weaving_works"
        <?php } ?>
        data-table="barcode2"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_weaving_works", selectId: "fbarcode2search_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_current_works" class="barcode2search"><span id="el_barcode2_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_current_works"
        <?php } ?>
        data-table="barcode2"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_current_works", selectId: "fbarcode2search_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_current_works", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_remarks" class="barcode2search"><span id="el_barcode2_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="barcode2" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_p_remarks" class="barcode2search"><span id="el_barcode2_p_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_remarks->getInputTextType() ?>" name="x_p_remarks" id="x_p_remarks" data-table="barcode2" data-field="x_p_remarks" value="<?= $Page->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_remarks->formatPattern()) ?>"<?= $Page->p_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_buyer_po" class="barcode2search"><span id="el_barcode2_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="barcode2" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_buyer_ref" class="barcode2search"><span id="el_barcode2_buyer_ref" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->buyer_ref->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_ref" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_ref->getInputTextType() ?>" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?= RemoveHtml($Page->buyer_ref->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="barcode2" data-field="x_buyer_ref" data-input="sv_x_buyer_ref" data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbarcode2search", function() {
    fbarcode2search.createAutoSuggest(Object.assign({"id":"x_buyer_ref","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer_ref->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.barcode2.fields.buyer_ref.autoSuggestOptions));
});
</script>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
</span></template>
<template id="tpx_barcode2_design_size" class="barcode2search"><span id="el_barcode2_design_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="barcode2" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="243" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_buyer_uid" class="barcode2search"><span id="el_barcode2_buyer_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_uid->getInputTextType() ?>" name="x_buyer_uid" id="x_buyer_uid" data-table="barcode2" data-field="x_buyer_uid" value="<?= $Page->buyer_uid->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_uid->formatPattern()) ?>"<?= $Page->buyer_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_uid->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_buyer_loc" class="barcode2search"><span id="el_barcode2_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="barcode2" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_order_date" class="barcode2search"><span id="el_barcode2_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="barcode2" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbarcode2search", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbarcode2search", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_completed" class="barcode2search"><span id="el_barcode2_completed" class="ew-search-field ew-search-field-single">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_completed"
        <?php } ?>
        data-table="barcode2"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_completed", selectId: "fbarcode2search_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_completed", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_category" class="barcode2search"><span id="el_barcode2_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbarcode2search_x_category"
        <?php } ?>
        data-table="barcode2"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2search", function() {
    var options = { name: "x_category", selectId: "fbarcode2search_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2search.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbarcode2search" };
    } else {
        options.ajax = { id: "x_category", form: "fbarcode2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_barcode2_pl_no" class="barcode2search"><span id="el_barcode2_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="barcode2" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_pid" class="barcode2search"><span id="el_barcode2_pid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pid->getInputTextType() ?>" name="x_pid" id="x_pid" data-table="barcode2" data-field="x_pid" value="<?= $Page->pid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pid->formatPattern()) ?>"<?= $Page->pid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pid->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_barcode2_buyer_barcode" class="barcode2search"><span id="el_barcode2_buyer_barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="barcode2" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
</span></template>
<div id="barcode2_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "_barcode",
                type: "integer",
                label: currentTable.fields._barcode.caption,
                operators: currentTable.fields._barcode.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields._barcode.validators),
                data: {
                    format: currentTable.fields._barcode.clientFormatPattern
                }
            },
            {
                id: "batch_no",
                type: "string",
                label: currentTable.fields.batch_no.caption,
                operators: currentTable.fields.batch_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.batch_no.validators),
                data: {
                    format: currentTable.fields.batch_no.clientFormatPattern
                }
            },
            {
                id: "sqm",
                type: "double",
                label: currentTable.fields.sqm.caption,
                operators: currentTable.fields.sqm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.sqm.validators),
                data: {
                    format: currentTable.fields.sqm.clientFormatPattern
                }
            },
            {
                id: "weight",
                type: "double",
                label: currentTable.fields.weight.caption,
                operators: currentTable.fields.weight.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.weight.validators),
                data: {
                    format: currentTable.fields.weight.clientFormatPattern
                }
            },
            {
                id: "jc_no",
                type: "integer",
                label: currentTable.fields.jc_no.caption,
                operators: currentTable.fields.jc_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.jc_no.validators),
                data: {
                    format: currentTable.fields.jc_no.clientFormatPattern
                }
            },
            {
                id: "process_c",
                type: "string",
                label: currentTable.fields.process_c.caption,
                operators: currentTable.fields.process_c.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.process_c.validators),
                data: {
                    format: currentTable.fields.process_c.clientFormatPattern
                }
            },
            {
                id: "process_d",
                type: "string",
                label: currentTable.fields.process_d.caption,
                operators: currentTable.fields.process_d.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.process_d.validators),
                data: {
                    format: currentTable.fields.process_d.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "buyers_id",
                type: "integer",
                label: currentTable.fields.buyers_id.caption,
                operators: currentTable.fields.buyers_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyers_id.validators),
                data: {
                    format: currentTable.fields.buyers_id.clientFormatPattern
                }
            },
            {
                id: "despatch_week",
                type: "integer",
                label: currentTable.fields.despatch_week.caption,
                operators: currentTable.fields.despatch_week.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.despatch_week.validators),
                data: {
                    format: currentTable.fields.despatch_week.clientFormatPattern
                }
            },
            {
                id: "cs",
                type: "integer",
                label: currentTable.fields.cs.caption,
                operators: currentTable.fields.cs.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.cs.validators),
                data: {
                    format: currentTable.fields.cs.clientFormatPattern
                }
            },
            {
                id: "weaving_works",
                type: "integer",
                label: currentTable.fields.weaving_works.caption,
                operators: currentTable.fields.weaving_works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.weaving_works.validators),
                data: {
                    format: currentTable.fields.weaving_works.clientFormatPattern
                }
            },
            {
                id: "current_works",
                type: "integer",
                label: currentTable.fields.current_works.caption,
                operators: currentTable.fields.current_works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.current_works.validators),
                data: {
                    format: currentTable.fields.current_works.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "p_remarks",
                type: "string",
                label: currentTable.fields.p_remarks.caption,
                operators: currentTable.fields.p_remarks.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.p_remarks.validators),
                data: {
                    format: currentTable.fields.p_remarks.clientFormatPattern
                }
            },
            {
                id: "buyer_po",
                type: "string",
                label: currentTable.fields.buyer_po.caption,
                operators: currentTable.fields.buyer_po.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyer_po.validators),
                data: {
                    format: currentTable.fields.buyer_po.clientFormatPattern
                }
            },
            {
                id: "buyer_ref",
                type: "integer",
                label: currentTable.fields.buyer_ref.caption,
                operators: currentTable.fields.buyer_ref.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyer_ref.validators),
                data: {
                    format: currentTable.fields.buyer_ref.clientFormatPattern
                }
            },
            {
                id: "design_size",
                type: "string",
                label: currentTable.fields.design_size.caption,
                operators: currentTable.fields.design_size.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.design_size.validators),
                data: {
                    format: currentTable.fields.design_size.clientFormatPattern
                }
            },
            {
                id: "buyer_uid",
                type: "string",
                label: currentTable.fields.buyer_uid.caption,
                operators: currentTable.fields.buyer_uid.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyer_uid.validators),
                data: {
                    format: currentTable.fields.buyer_uid.clientFormatPattern
                }
            },
            {
                id: "buyer_loc",
                type: "string",
                label: currentTable.fields.buyer_loc.caption,
                operators: currentTable.fields.buyer_loc.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyer_loc.validators),
                data: {
                    format: currentTable.fields.buyer_loc.clientFormatPattern
                }
            },
            {
                id: "order_date",
                type: "datetime",
                label: currentTable.fields.order_date.caption,
                operators: currentTable.fields.order_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.order_date.validators),
                data: {
                    format: currentTable.fields.order_date.clientFormatPattern
                }
            },
            {
                id: "completed",
                type: "integer",
                label: currentTable.fields.completed.caption,
                operators: currentTable.fields.completed.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.completed.validators),
                data: {
                    format: currentTable.fields.completed.clientFormatPattern
                }
            },
            {
                id: "category",
                type: "string",
                label: currentTable.fields.category.caption,
                operators: currentTable.fields.category.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.category.validators),
                data: {
                    format: currentTable.fields.category.clientFormatPattern
                }
            },
            {
                id: "pl_no",
                type: "double",
                label: currentTable.fields.pl_no.caption,
                operators: currentTable.fields.pl_no.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.pl_no.validators),
                data: {
                    format: currentTable.fields.pl_no.clientFormatPattern
                }
            },
            {
                id: "pid",
                type: "double",
                label: currentTable.fields.pid.caption,
                operators: currentTable.fields.pid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.pid.validators),
                data: {
                    format: currentTable.fields.pid.clientFormatPattern
                }
            },
            {
                id: "buyer_barcode",
                type: "string",
                label: currentTable.fields.buyer_barcode.caption,
                operators: currentTable.fields.buyer_barcode.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbarcode2search.fields.buyer_barcode.validators),
                data: {
                    format: currentTable.fields.buyer_barcode.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#barcode2_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbarcode2search input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbarcode2search").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbarcode2search" formaction="<?= HtmlEncode(GetUrl("barcode2list")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbarcode2search"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbarcode2search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
