<?php

namespace PHPMaker2024\fibre;

// Page object
$Barcode2List = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode2: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbarcode2srch" id="fbarcode2srch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbarcode2srch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { barcode2: currentTable } });
var currentForm;
var fbarcode2srch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbarcode2srch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["_barcode", [], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["process_c", [], fields.process_c.isInvalid],
            ["y_process_c", [ew.Validators.between], false],
            ["process_d", [], fields.process_d.isInvalid],
            ["y_process_d", [ew.Validators.between], false],
            ["status", [], fields.status.isInvalid],
            ["buyers_id", [ew.Validators.integer], fields.buyers_id.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["y_despatch_week", [ew.Validators.between], false],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design_size", [ew.Validators.integer], fields.design_size.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["y_pl_no", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process_c": <?= $Page->process_c->toClientList($Page) ?>,
            "process_d": <?= $Page->process_d->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="barcode2" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="barcode2" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="barcode2" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="barcode2" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
<?php
if (!$Page->process_c->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_c" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_c->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_c" class="ew-search-caption ew-label"><?= $Page->process_c->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_process_c" id="z_process_c" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->process_c->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->process_c->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2_process_c" class="ew-search-field">
    <select
        id="x_process_c[]"
        name="x_process_c[]"
        class="form-control ew-select<?= $Page->process_c->isInvalidClass() ?>"
        data-select2-id="fbarcode2srch_x_process_c[]"
        data-table="barcode2"
        data-field="x_process_c"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_c->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("x_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_x_process_c") ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "x_process_c[]", selectId: "fbarcode2srch_x_process_c[]" };
    options.multiple = true;
    if (fbarcode2srch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "x_process_c[]", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "x_process_c[]", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_c.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2_process_c" class="ew-search-field2 d-none">
    <select
        id="y_process_c[]"
        name="y_process_c[]"
        class="form-control ew-select<?= $Page->process_c->isInvalidClass() ?>"
        data-select2-id="fbarcode2srch_y_process_c[]"
        data-table="barcode2"
        data-field="x_process_c"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_c->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("y_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_y_process_c") ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "y_process_c[]", selectId: "fbarcode2srch_y_process_c[]" };
    options.multiple = true;
    if (fbarcode2srch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "y_process_c[]", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "y_process_c[]", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_c.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
<?php
if (!$Page->process_d->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_d" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_d->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_d" class="ew-search-caption ew-label"><?= $Page->process_d->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_process_d" id="z_process_d" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->process_d->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->process_d->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2_process_d" class="ew-search-field">
    <select
        id="x_process_d[]"
        name="x_process_d[]"
        class="form-control ew-select<?= $Page->process_d->isInvalidClass() ?>"
        data-select2-id="fbarcode2srch_x_process_d[]"
        data-table="barcode2"
        data-field="x_process_d"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_d->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_d->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>"
        <?= $Page->process_d->editAttributes() ?>>
        <?= $Page->process_d->selectOptionListHtml("x_process_d[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
<?= $Page->process_d->Lookup->getParamTag($Page, "p_x_process_d") ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "x_process_d[]", selectId: "fbarcode2srch_x_process_d[]" };
    options.multiple = true;
    if (fbarcode2srch.lists.process_d?.lookupOptions.length) {
        options.data = { id: "x_process_d[]", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "x_process_d[]", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_d.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2_process_d" class="ew-search-field2 d-none">
    <select
        id="y_process_d[]"
        name="y_process_d[]"
        class="form-control ew-select<?= $Page->process_d->isInvalidClass() ?>"
        data-select2-id="fbarcode2srch_y_process_d[]"
        data-table="barcode2"
        data-field="x_process_d"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->process_d->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_d->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>"
        <?= $Page->process_d->editAttributes() ?>>
        <?= $Page->process_d->selectOptionListHtml("y_process_d[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
<?= $Page->process_d->Lookup->getParamTag($Page, "p_y_process_d") ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "y_process_d[]", selectId: "fbarcode2srch_y_process_d[]" };
    options.multiple = true;
    if (fbarcode2srch.lists.process_d?.lookupOptions.length) {
        options.data = { id: "y_process_d[]", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "y_process_d[]", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.process_d.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_barcode2_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbarcode2srch_x_status"
        <?php } ?>
        data-table="barcode2"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "x_status", selectId: "fbarcode2srch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2srch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "x_status", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
<?php
if (!$Page->buyers_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyers_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyers_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyers_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</div>
        </div>
        <div id="el_barcode2_buyers_id" class="ew-search-field">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-control ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        data-select2-id="fbarcode2srch_x_buyers_id"
        data-table="barcode2"
        data-field="x_buyers_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyers_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "x_buyers_id", selectId: "fbarcode2srch_x_buyers_id" };
    if (fbarcode2srch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.barcode2.fields.buyers_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
<?php
if (!$Page->despatch_week->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_despatch_week" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->despatch_week->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_despatch_week" class="ew-search-caption ew-label"><?= $Page->despatch_week->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_despatch_week" id="z_despatch_week" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->despatch_week->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->despatch_week->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2_despatch_week" class="ew-search-field">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode2srch_x_despatch_week"
        <?php } ?>
        data-table="barcode2"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "x_despatch_week", selectId: "fbarcode2srch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2srch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2_despatch_week" class="ew-search-field2 d-none">
    <select
        id="y_despatch_week"
        name="y_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fbarcode2srch_y_despatch_week"
        <?php } ?>
        data-table="barcode2"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("y_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_y_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fbarcode2srch", function() {
    var options = { name: "y_despatch_week", selectId: "fbarcode2srch_y_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbarcode2srch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "y_despatch_week", form: "fbarcode2srch" };
    } else {
        options.ajax = { id: "y_despatch_week", form: "fbarcode2srch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.barcode2.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
<?php
if (!$Page->buyer_ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_ref->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyer_ref->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="=">
</div>
        </div>
        <div id="el_barcode2_buyer_ref" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->buyer_ref->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer_ref" class="ew-auto-suggest">
    <input type="<?= $Page->buyer_ref->getInputTextType() ?>" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?= RemoveHtml($Page->buyer_ref->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="barcode2" data-field="x_buyer_ref" data-input="sv_x_buyer_ref" data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbarcode2srch", function() {
    fbarcode2srch.createAutoSuggest(Object.assign({"id":"x_buyer_ref","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer_ref->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.barcode2.fields.buyer_ref.autoSuggestOptions));
});
</script>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
<?php
if (!$Page->design_size->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design_size" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design_size->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_design_size" class="ew-search-caption ew-label"><?= $Page->design_size->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_size" id="z_design_size" value="LIKE">
</div>
        </div>
        <div id="el_barcode2_design_size" class="ew-search-field">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="barcode2" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="243" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
<?php
if (!$Page->pl_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pl_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pl_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pl_no" class="ew-search-caption ew-label"><?= $Page->pl_no->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pl_no" id="z_pl_no" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pl_no->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pl_no->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_barcode2_pl_no" class="ew-search-field">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="barcode2" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_barcode2_pl_no" class="ew-search-field2 d-none">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="y_pl_no" id="y_pl_no" data-table="barcode2" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbarcode2srch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbarcode2srch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbarcode2srch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbarcode2srch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbarcode2srch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbarcode2srch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbarcode2srch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="barcode2">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_barcode2" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_barcode2list" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_barcode2_po" class="barcode2_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_barcode2__barcode" class="barcode2__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_barcode2_batch_no" class="barcode2_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode2_size_cm" class="barcode2_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_barcode2_sqm" class="barcode2_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <th data-name="sqm_a" class="<?= $Page->sqm_a->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode2_sqm_a" class="barcode2_sqm_a"><?= $Page->renderFieldHeader($Page->sqm_a) ?></div></th>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
        <th data-name="weight" class="<?= $Page->weight->headerCellClass() ?>"><div id="elh_barcode2_weight" class="barcode2_weight"><?= $Page->renderFieldHeader($Page->weight) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode2_quantity" class="barcode2_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_barcode2_jc_no" class="barcode2_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
        <th data-name="process_c" class="<?= $Page->process_c->headerCellClass() ?>"><div id="elh_barcode2_process_c" class="barcode2_process_c"><?= $Page->renderFieldHeader($Page->process_c) ?></div></th>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
        <th data-name="process_d" class="<?= $Page->process_d->headerCellClass() ?>"><div id="elh_barcode2_process_d" class="barcode2_process_d"><?= $Page->renderFieldHeader($Page->process_d) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_barcode2_status" class="barcode2_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode2_buyers_id" class="barcode2_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_barcode2_despatch_week" class="barcode2_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
        <th data-name="cs" class="<?= $Page->cs->headerCellClass() ?>"><div id="elh_barcode2_cs" class="barcode2_cs"><?= $Page->renderFieldHeader($Page->cs) ?></div></th>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>"><div id="elh_barcode2_weaving_works" class="barcode2_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
        <th data-name="current_works" class="<?= $Page->current_works->headerCellClass() ?>"><div id="elh_barcode2_current_works" class="barcode2_current_works"><?= $Page->renderFieldHeader($Page->current_works) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_barcode2_remarks" class="barcode2_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <th data-name="p_remarks" class="<?= $Page->p_remarks->headerCellClass() ?>"><div id="elh_barcode2_p_remarks" class="barcode2_p_remarks"><?= $Page->renderFieldHeader($Page->p_remarks) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <th data-name="buyer_po" class="<?= $Page->buyer_po->headerCellClass() ?>"><div id="elh_barcode2_buyer_po" class="barcode2_buyer_po"><?= $Page->renderFieldHeader($Page->buyer_po) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_barcode2_buyer_ref" class="barcode2_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
        <th data-name="design_size" class="<?= $Page->design_size->headerCellClass() ?>"><div id="elh_barcode2_design_size" class="barcode2_design_size"><?= $Page->renderFieldHeader($Page->design_size) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>"><div id="elh_barcode2_buyer_uid" class="barcode2_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <th data-name="buyer_loc" class="<?= $Page->buyer_loc->headerCellClass() ?>"><div id="elh_barcode2_buyer_loc" class="barcode2_buyer_loc"><?= $Page->renderFieldHeader($Page->buyer_loc) ?></div></th>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
        <th data-name="order_date" class="<?= $Page->order_date->headerCellClass() ?>"><div id="elh_barcode2_order_date" class="barcode2_order_date"><?= $Page->renderFieldHeader($Page->order_date) ?></div></th>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
        <th data-name="completed" class="<?= $Page->completed->headerCellClass() ?>"><div id="elh_barcode2_completed" class="barcode2_completed"><?= $Page->renderFieldHeader($Page->completed) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_barcode2_category" class="barcode2_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_barcode2_pl_no" class="barcode2_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <th data-name="buyer_barcode" class="<?= $Page->buyer_barcode->headerCellClass() ?>"><div id="elh_barcode2_buyer_barcode" class="barcode2_buyer_barcode"><?= $Page->renderFieldHeader($Page->buyer_barcode) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_po" class="el_barcode2_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2__barcode" class="el_barcode2__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_batch_no" class="el_barcode2_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_size_cm" class="el_barcode2_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_sqm" class="el_barcode2_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a"<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_sqm_a" class="el_barcode2_sqm_a">
<span<?= $Page->sqm_a->viewAttributes() ?>>
<?= $Page->sqm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight->Visible) { // weight ?>
        <td data-name="weight"<?= $Page->weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_weight" class="el_barcode2_weight">
<span<?= $Page->weight->viewAttributes() ?>>
<?= $Page->weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_quantity" class="el_barcode2_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_jc_no" class="el_barcode2_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c"<?= $Page->process_c->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_process_c" class="el_barcode2_process_c">
<span<?= $Page->process_c->viewAttributes() ?>>
<?= $Page->process_c->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d"<?= $Page->process_d->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_process_d" class="el_barcode2_process_d">
<span<?= $Page->process_d->viewAttributes() ?>>
<?= $Page->process_d->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_status" class="el_barcode2_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyers_id" class="el_barcode2_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_despatch_week" class="el_barcode2_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cs->Visible) { // cs ?>
        <td data-name="cs"<?= $Page->cs->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_cs" class="el_barcode2_cs">
<span<?= $Page->cs->viewAttributes() ?>>
<?= $Page->cs->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_weaving_works" class="el_barcode2_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works"<?= $Page->current_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_current_works" class="el_barcode2_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<?= $Page->current_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_remarks" class="el_barcode2_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks"<?= $Page->p_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_p_remarks" class="el_barcode2_p_remarks">
<span<?= $Page->p_remarks->viewAttributes() ?>>
<?= $Page->p_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po"<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyer_po" class="el_barcode2_buyer_po">
<span<?= $Page->buyer_po->viewAttributes() ?>>
<?= $Page->buyer_po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyer_ref" class="el_barcode2_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_size->Visible) { // design_size ?>
        <td data-name="design_size"<?= $Page->design_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_design_size" class="el_barcode2_design_size">
<span<?= $Page->design_size->viewAttributes() ?>>
<?= $Page->design_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyer_uid" class="el_barcode2_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc"<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyer_loc" class="el_barcode2_buyer_loc">
<span<?= $Page->buyer_loc->viewAttributes() ?>>
<?= $Page->buyer_loc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date"<?= $Page->order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_order_date" class="el_barcode2_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<?= $Page->order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed"<?= $Page->completed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_completed" class="el_barcode2_completed">
<span<?= $Page->completed->viewAttributes() ?>>
<?= $Page->completed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_category" class="el_barcode2_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_pl_no" class="el_barcode2_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?= $Page->pl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode"<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_barcode2_buyer_barcode" class="el_barcode2_buyer_barcode">
<span<?= $Page->buyer_barcode->viewAttributes() ?>>
<?= $Page->buyer_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_barcode2_po" class="barcode2_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_barcode2__barcode" class="barcode2__barcode">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_barcode2_batch_no" class="barcode2_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm" class="<?= $Page->size_cm->footerCellClass() ?>"><span id="elf_barcode2_size_cm" class="barcode2_size_cm">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_barcode2_sqm" class="barcode2_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a" class="<?= $Page->sqm_a->footerCellClass() ?>"><span id="elf_barcode2_sqm_a" class="barcode2_sqm_a">
        </span></td>
    <?php } ?>
    <?php if ($Page->weight->Visible) { // weight ?>
        <td data-name="weight" class="<?= $Page->weight->footerCellClass() ?>"><span id="elf_barcode2_weight" class="barcode2_weight">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_barcode2_quantity" class="barcode2_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no" class="<?= $Page->jc_no->footerCellClass() ?>"><span id="elf_barcode2_jc_no" class="barcode2_jc_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c" class="<?= $Page->process_c->footerCellClass() ?>"><span id="elf_barcode2_process_c" class="barcode2_process_c">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d" class="<?= $Page->process_d->footerCellClass() ?>"><span id="elf_barcode2_process_d" class="barcode2_process_d">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_barcode2_status" class="barcode2_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id" class="<?= $Page->buyers_id->footerCellClass() ?>"><span id="elf_barcode2_buyers_id" class="barcode2_buyers_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week" class="<?= $Page->despatch_week->footerCellClass() ?>"><span id="elf_barcode2_despatch_week" class="barcode2_despatch_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->cs->Visible) { // cs ?>
        <td data-name="cs" class="<?= $Page->cs->footerCellClass() ?>"><span id="elf_barcode2_cs" class="barcode2_cs">
        </span></td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works" class="<?= $Page->weaving_works->footerCellClass() ?>"><span id="elf_barcode2_weaving_works" class="barcode2_weaving_works">
        </span></td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works" class="<?= $Page->current_works->footerCellClass() ?>"><span id="elf_barcode2_current_works" class="barcode2_current_works">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_barcode2_remarks" class="barcode2_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks" class="<?= $Page->p_remarks->footerCellClass() ?>"><span id="elf_barcode2_p_remarks" class="barcode2_p_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po" class="<?= $Page->buyer_po->footerCellClass() ?>"><span id="elf_barcode2_buyer_po" class="barcode2_buyer_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref" class="<?= $Page->buyer_ref->footerCellClass() ?>"><span id="elf_barcode2_buyer_ref" class="barcode2_buyer_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->design_size->Visible) { // design_size ?>
        <td data-name="design_size" class="<?= $Page->design_size->footerCellClass() ?>"><span id="elf_barcode2_design_size" class="barcode2_design_size">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid" class="<?= $Page->buyer_uid->footerCellClass() ?>"><span id="elf_barcode2_buyer_uid" class="barcode2_buyer_uid">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc" class="<?= $Page->buyer_loc->footerCellClass() ?>"><span id="elf_barcode2_buyer_loc" class="barcode2_buyer_loc">
        </span></td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date" class="<?= $Page->order_date->footerCellClass() ?>"><span id="elf_barcode2_order_date" class="barcode2_order_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed" class="<?= $Page->completed->footerCellClass() ?>"><span id="elf_barcode2_completed" class="barcode2_completed">
        </span></td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category" class="<?= $Page->category->footerCellClass() ?>"><span id="elf_barcode2_category" class="barcode2_category">
        </span></td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no" class="<?= $Page->pl_no->footerCellClass() ?>"><span id="elf_barcode2_pl_no" class="barcode2_pl_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode" class="<?= $Page->buyer_barcode->footerCellClass() ?>"><span id="elf_barcode2_buyer_barcode" class="barcode2_buyer_barcode">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("barcode2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
