<?php

namespace PHPMaker2024\fibre;

// Page object
$BannerAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { banner: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fbanneradd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbanneradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["_title", [fields._title.visible && fields._title.required ? ew.Validators.required(fields._title.caption) : null], fields._title.isInvalid],
            ["images", [fields.images.visible && fields.images.required ? ew.Validators.fileRequired(fields.images.caption) : null], fields.images.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["show_at", [fields.show_at.visible && fields.show_at.required ? ew.Validators.required(fields.show_at.caption) : null], fields.show_at.isInvalid],
            ["text", [fields.text.visible && fields.text.required ? ew.Validators.required(fields.text.caption) : null], fields.text.isInvalid],
            ["day", [fields.day.visible && fields.day.required ? ew.Validators.required(fields.day.caption) : null, ew.Validators.integer], fields.day.isInvalid],
            ["start_time", [fields.start_time.visible && fields.start_time.required ? ew.Validators.required(fields.start_time.caption) : null, ew.Validators.datetime(fields.start_time.clientFormatPattern)], fields.start_time.isInvalid],
            ["end_time", [fields.end_time.visible && fields.end_time.required ? ew.Validators.required(fields.end_time.caption) : null, ew.Validators.datetime(fields.end_time.clientFormatPattern)], fields.end_time.isInvalid],
            ["order_by", [fields.order_by.visible && fields.order_by.required ? ew.Validators.required(fields.order_by.caption) : null], fields.order_by.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "show_at": <?= $Page->show_at->toClientList($Page) ?>,
            "order_by": <?= $Page->order_by->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbanneradd" id="fbanneradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="banner">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->_title->Visible) { // title ?>
    <div id="r__title"<?= $Page->_title->rowAttributes() ?>>
        <label id="elh_banner__title" for="x__title" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_title->caption() ?><?= $Page->_title->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_title->cellAttributes() ?>>
<span id="el_banner__title">
<input type="<?= $Page->_title->getInputTextType() ?>" name="x__title" id="x__title" data-table="banner" data-field="x__title" value="<?= $Page->_title->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_title->formatPattern()) ?>"<?= $Page->_title->editAttributes() ?> aria-describedby="x__title_help">
<?= $Page->_title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->images->Visible) { // images ?>
    <div id="r_images"<?= $Page->images->rowAttributes() ?>>
        <label id="elh_banner_images" class="<?= $Page->LeftColumnClass ?>"><?= $Page->images->caption() ?><?= $Page->images->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->images->cellAttributes() ?>>
<span id="el_banner_images">
<div id="fd_x_images" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_images"
        name="x_images"
        class="form-control ew-file-input"
        title="<?= $Page->images->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="banner"
        data-field="x_images"
        data-size="100"
        data-accept-file-types="<?= $Page->images->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->images->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->images->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_images_help"
        <?= ($Page->images->ReadOnly || $Page->images->Disabled) ? " disabled" : "" ?>
        <?= $Page->images->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->images->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->images->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_images" id= "fn_x_images" value="<?= $Page->images->Upload->FileName ?>">
<input type="hidden" name="fa_x_images" id= "fa_x_images" value="0">
<table id="ft_x_images" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_banner_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_banner_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="banner" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->show_at->Visible) { // show_at ?>
    <div id="r_show_at"<?= $Page->show_at->rowAttributes() ?>>
        <label id="elh_banner_show_at" for="x_show_at" class="<?= $Page->LeftColumnClass ?>"><?= $Page->show_at->caption() ?><?= $Page->show_at->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->show_at->cellAttributes() ?>>
<span id="el_banner_show_at">
    <select
        id="x_show_at"
        name="x_show_at"
        class="form-select ew-select<?= $Page->show_at->isInvalidClass() ?>"
        <?php if (!$Page->show_at->IsNativeSelect) { ?>
        data-select2-id="fbanneradd_x_show_at"
        <?php } ?>
        data-table="banner"
        data-field="x_show_at"
        data-value-separator="<?= $Page->show_at->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->show_at->getPlaceHolder()) ?>"
        <?= $Page->show_at->editAttributes() ?>>
        <?= $Page->show_at->selectOptionListHtml("x_show_at") ?>
    </select>
    <?= $Page->show_at->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->show_at->getErrorMessage() ?></div>
<?php if (!$Page->show_at->IsNativeSelect) { ?>
<script>
loadjs.ready("fbanneradd", function() {
    var options = { name: "x_show_at", selectId: "fbanneradd_x_show_at" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbanneradd.lists.show_at?.lookupOptions.length) {
        options.data = { id: "x_show_at", form: "fbanneradd" };
    } else {
        options.ajax = { id: "x_show_at", form: "fbanneradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.banner.fields.show_at.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->text->Visible) { // text ?>
    <div id="r_text"<?= $Page->text->rowAttributes() ?>>
        <label id="elh_banner_text" for="x_text" class="<?= $Page->LeftColumnClass ?>"><?= $Page->text->caption() ?><?= $Page->text->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->text->cellAttributes() ?>>
<span id="el_banner_text">
<input type="<?= $Page->text->getInputTextType() ?>" name="x_text" id="x_text" data-table="banner" data-field="x_text" value="<?= $Page->text->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->text->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->text->formatPattern()) ?>"<?= $Page->text->editAttributes() ?> aria-describedby="x_text_help">
<?= $Page->text->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->text->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->day->Visible) { // day ?>
    <div id="r_day"<?= $Page->day->rowAttributes() ?>>
        <label id="elh_banner_day" for="x_day" class="<?= $Page->LeftColumnClass ?>"><?= $Page->day->caption() ?><?= $Page->day->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->day->cellAttributes() ?>>
<span id="el_banner_day">
<input type="<?= $Page->day->getInputTextType() ?>" name="x_day" id="x_day" data-table="banner" data-field="x_day" value="<?= $Page->day->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->day->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->day->formatPattern()) ?>"<?= $Page->day->editAttributes() ?> aria-describedby="x_day_help">
<?= $Page->day->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->day->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->start_time->Visible) { // start_time ?>
    <div id="r_start_time"<?= $Page->start_time->rowAttributes() ?>>
        <label id="elh_banner_start_time" for="x_start_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->start_time->caption() ?><?= $Page->start_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->start_time->cellAttributes() ?>>
<span id="el_banner_start_time">
<input type="<?= $Page->start_time->getInputTextType() ?>" name="x_start_time" id="x_start_time" data-table="banner" data-field="x_start_time" value="<?= $Page->start_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->start_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->start_time->formatPattern()) ?>"<?= $Page->start_time->editAttributes() ?> aria-describedby="x_start_time_help">
<?= $Page->start_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->start_time->getErrorMessage() ?></div>
<?php if (!$Page->start_time->ReadOnly && !$Page->start_time->Disabled && !isset($Page->start_time->EditAttrs["readonly"]) && !isset($Page->start_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbanneradd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbanneradd", "x_start_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->end_time->Visible) { // end_time ?>
    <div id="r_end_time"<?= $Page->end_time->rowAttributes() ?>>
        <label id="elh_banner_end_time" for="x_end_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->end_time->caption() ?><?= $Page->end_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->end_time->cellAttributes() ?>>
<span id="el_banner_end_time">
<input type="<?= $Page->end_time->getInputTextType() ?>" name="x_end_time" id="x_end_time" data-table="banner" data-field="x_end_time" value="<?= $Page->end_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->end_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->end_time->formatPattern()) ?>"<?= $Page->end_time->editAttributes() ?> aria-describedby="x_end_time_help">
<?= $Page->end_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->end_time->getErrorMessage() ?></div>
<?php if (!$Page->end_time->ReadOnly && !$Page->end_time->Disabled && !isset($Page->end_time->EditAttrs["readonly"]) && !isset($Page->end_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbanneradd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbanneradd", "x_end_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <div id="r_order_by"<?= $Page->order_by->rowAttributes() ?>>
        <label id="elh_banner_order_by" for="x_order_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_by->caption() ?><?= $Page->order_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_by->cellAttributes() ?>>
<span id="el_banner_order_by">
    <select
        id="x_order_by"
        name="x_order_by"
        class="form-select ew-select<?= $Page->order_by->isInvalidClass() ?>"
        <?php if (!$Page->order_by->IsNativeSelect) { ?>
        data-select2-id="fbanneradd_x_order_by"
        <?php } ?>
        data-table="banner"
        data-field="x_order_by"
        data-value-separator="<?= $Page->order_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->order_by->getPlaceHolder()) ?>"
        <?= $Page->order_by->editAttributes() ?>>
        <?= $Page->order_by->selectOptionListHtml("x_order_by") ?>
    </select>
    <?= $Page->order_by->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->order_by->getErrorMessage() ?></div>
<?php if (!$Page->order_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fbanneradd", function() {
    var options = { name: "x_order_by", selectId: "fbanneradd_x_order_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbanneradd.lists.order_by?.lookupOptions.length) {
        options.data = { id: "x_order_by", form: "fbanneradd" };
    } else {
        options.ajax = { id: "x_order_by", form: "fbanneradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.banner.fields.order_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_banner_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_banner_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbanneradd_x_status"
        <?php } ?>
        data-table="banner"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbanneradd", function() {
    var options = { name: "x_status", selectId: "fbanneradd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbanneradd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbanneradd" };
    } else {
        options.ajax = { id: "x_status", form: "fbanneradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.banner.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbanneradd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbanneradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("banner");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
