<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("BankInfoGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fbank_infogrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { bank_info: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbank_infogrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["user_id", [fields.user_id.visible && fields.user_id.required ? ew.Validators.required(fields.user_id.caption) : null], fields.user_id.isInvalid],
            ["account_holder_name", [fields.account_holder_name.visible && fields.account_holder_name.required ? ew.Validators.required(fields.account_holder_name.caption) : null], fields.account_holder_name.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["account_no", [fields.account_no.visible && fields.account_no.required ? ew.Validators.required(fields.account_no.caption) : null], fields.account_no.isInvalid],
            ["c_account_no", [fields.c_account_no.visible && fields.c_account_no.required ? ew.Validators.required(fields.c_account_no.caption) : null], fields.c_account_no.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["ifsc", [fields.ifsc.visible && fields.ifsc.required ? ew.Validators.required(fields.ifsc.caption) : null], fields.ifsc.isInvalid],
            ["swift", [fields.swift.visible && fields.swift.required ? ew.Validators.required(fields.swift.caption) : null, ew.Validators.integer], fields.swift.isInvalid],
            ["ad", [fields.ad.visible && fields.ad.required ? ew.Validators.required(fields.ad.caption) : null, ew.Validators.integer], fields.ad.isInvalid],
            ["routing", [fields.routing.visible && fields.routing.required ? ew.Validators.required(fields.routing.caption) : null, ew.Validators.integer], fields.routing.isInvalid],
            ["routing_swift", [fields.routing_swift.visible && fields.routing_swift.required ? ew.Validators.required(fields.routing_swift.caption) : null, ew.Validators.integer], fields.routing_swift.isInvalid],
            ["nostro_account", [fields.nostro_account.visible && fields.nostro_account.required ? ew.Validators.required(fields.nostro_account.caption) : null, ew.Validators.integer], fields.nostro_account.isInvalid],
            ["upi", [fields.upi.visible && fields.upi.required ? ew.Validators.required(fields.upi.caption) : null], fields.upi.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["user_id",false],["account_holder_name",false],["currency",false],["bank_name",false],["account_no",false],["c_account_no",false],["address",false],["ifsc",false],["swift",false],["ad",false],["routing",false],["routing_swift",false],["nostro_account",false],["upi",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "user_id": <?= $Grid->user_id->toClientList($Grid) ?>,
            "currency": <?= $Grid->currency->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fbank_infogrid" class="ew-form ew-list-form">
<div id="gmp_bank_info" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_bank_infogrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_bank_info_id" class="bank_info_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->user_id->Visible) { // user_id ?>
        <th data-name="user_id" class="<?= $Grid->user_id->headerCellClass() ?>"><div id="elh_bank_info_user_id" class="bank_info_user_id"><?= $Grid->renderFieldHeader($Grid->user_id) ?></div></th>
<?php } ?>
<?php if ($Grid->account_holder_name->Visible) { // account_holder_name ?>
        <th data-name="account_holder_name" class="<?= $Grid->account_holder_name->headerCellClass() ?>"><div id="elh_bank_info_account_holder_name" class="bank_info_account_holder_name"><?= $Grid->renderFieldHeader($Grid->account_holder_name) ?></div></th>
<?php } ?>
<?php if ($Grid->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Grid->currency->headerCellClass() ?>"><div id="elh_bank_info_currency" class="bank_info_currency"><?= $Grid->renderFieldHeader($Grid->currency) ?></div></th>
<?php } ?>
<?php if ($Grid->bank_name->Visible) { // bank_name ?>
        <th data-name="bank_name" class="<?= $Grid->bank_name->headerCellClass() ?>"><div id="elh_bank_info_bank_name" class="bank_info_bank_name"><?= $Grid->renderFieldHeader($Grid->bank_name) ?></div></th>
<?php } ?>
<?php if ($Grid->account_no->Visible) { // account_no ?>
        <th data-name="account_no" class="<?= $Grid->account_no->headerCellClass() ?>"><div id="elh_bank_info_account_no" class="bank_info_account_no"><?= $Grid->renderFieldHeader($Grid->account_no) ?></div></th>
<?php } ?>
<?php if ($Grid->c_account_no->Visible) { // c_account_no ?>
        <th data-name="c_account_no" class="<?= $Grid->c_account_no->headerCellClass() ?>"><div id="elh_bank_info_c_account_no" class="bank_info_c_account_no"><?= $Grid->renderFieldHeader($Grid->c_account_no) ?></div></th>
<?php } ?>
<?php if ($Grid->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Grid->address->headerCellClass() ?>"><div id="elh_bank_info_address" class="bank_info_address"><?= $Grid->renderFieldHeader($Grid->address) ?></div></th>
<?php } ?>
<?php if ($Grid->ifsc->Visible) { // ifsc ?>
        <th data-name="ifsc" class="<?= $Grid->ifsc->headerCellClass() ?>"><div id="elh_bank_info_ifsc" class="bank_info_ifsc"><?= $Grid->renderFieldHeader($Grid->ifsc) ?></div></th>
<?php } ?>
<?php if ($Grid->swift->Visible) { // swift ?>
        <th data-name="swift" class="<?= $Grid->swift->headerCellClass() ?>"><div id="elh_bank_info_swift" class="bank_info_swift"><?= $Grid->renderFieldHeader($Grid->swift) ?></div></th>
<?php } ?>
<?php if ($Grid->ad->Visible) { // ad ?>
        <th data-name="ad" class="<?= $Grid->ad->headerCellClass() ?>"><div id="elh_bank_info_ad" class="bank_info_ad"><?= $Grid->renderFieldHeader($Grid->ad) ?></div></th>
<?php } ?>
<?php if ($Grid->routing->Visible) { // routing ?>
        <th data-name="routing" class="<?= $Grid->routing->headerCellClass() ?>"><div id="elh_bank_info_routing" class="bank_info_routing"><?= $Grid->renderFieldHeader($Grid->routing) ?></div></th>
<?php } ?>
<?php if ($Grid->routing_swift->Visible) { // routing_swift ?>
        <th data-name="routing_swift" class="<?= $Grid->routing_swift->headerCellClass() ?>"><div id="elh_bank_info_routing_swift" class="bank_info_routing_swift"><?= $Grid->renderFieldHeader($Grid->routing_swift) ?></div></th>
<?php } ?>
<?php if ($Grid->nostro_account->Visible) { // nostro_account ?>
        <th data-name="nostro_account" class="<?= $Grid->nostro_account->headerCellClass() ?>"><div id="elh_bank_info_nostro_account" class="bank_info_nostro_account"><?= $Grid->renderFieldHeader($Grid->nostro_account) ?></div></th>
<?php } ?>
<?php if ($Grid->upi->Visible) { // upi ?>
        <th data-name="upi" class="<?= $Grid->upi->headerCellClass() ?>"><div id="elh_bank_info_upi" class="bank_info_upi"><?= $Grid->renderFieldHeader($Grid->upi) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_bank_info_status" class="bank_info_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_bank_info_operator" class="bank_info_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_bank_info_datetime" class="bank_info_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_id" class="el_bank_info_id"></span>
<input type="hidden" data-table="bank_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_id" class="el_bank_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="bank_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_id" class="el_bank_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_id" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_id" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_id" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_id" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="bank_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->user_id->Visible) { // user_id ?>
        <td data-name="user_id"<?= $Grid->user_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->user_id->getSessionValue() != "") { ?>
<span<?= $Grid->user_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->user_id->getDisplayValue($Grid->user_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_user_id" name="x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_user_id" class="el_bank_info_user_id">
    <select
        id="x<?= $Grid->RowIndex ?>_user_id"
        name="x<?= $Grid->RowIndex ?>_user_id"
        class="form-select ew-select<?= $Grid->user_id->isInvalidClass() ?>"
        <?php if (!$Grid->user_id->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_user_id"
        <?php } ?>
        data-table="bank_info"
        data-field="x_user_id"
        data-value-separator="<?= $Grid->user_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->user_id->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->user_id->editAttributes() ?>>
        <?= $Grid->user_id->selectOptionListHtml("x{$Grid->RowIndex}_user_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->user_id->getErrorMessage() ?></div>
<?= $Grid->user_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_user_id") ?>
<?php if (!$Grid->user_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_user_id", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_user_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.user_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.user_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="bank_info" data-field="x_user_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_user_id" id="o<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->user_id->getSessionValue() != "") { ?>
<span<?= $Grid->user_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->user_id->getDisplayValue($Grid->user_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_user_id" name="x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_user_id" class="el_bank_info_user_id">
    <select
        id="x<?= $Grid->RowIndex ?>_user_id"
        name="x<?= $Grid->RowIndex ?>_user_id"
        class="form-select ew-select<?= $Grid->user_id->isInvalidClass() ?>"
        <?php if (!$Grid->user_id->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_user_id"
        <?php } ?>
        data-table="bank_info"
        data-field="x_user_id"
        data-value-separator="<?= $Grid->user_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->user_id->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->user_id->editAttributes() ?>>
        <?= $Grid->user_id->selectOptionListHtml("x{$Grid->RowIndex}_user_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->user_id->getErrorMessage() ?></div>
<?= $Grid->user_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_user_id") ?>
<?php if (!$Grid->user_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_user_id", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_user_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.user_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.user_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_user_id" class="el_bank_info_user_id">
<span<?= $Grid->user_id->viewAttributes() ?>>
<?= $Grid->user_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_user_id" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_user_id" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_user_id" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_user_id" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->account_holder_name->Visible) { // account_holder_name ?>
        <td data-name="account_holder_name"<?= $Grid->account_holder_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_holder_name" class="el_bank_info_account_holder_name">
<input type="<?= $Grid->account_holder_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_account_holder_name" id="x<?= $Grid->RowIndex ?>_account_holder_name" data-table="bank_info" data-field="x_account_holder_name" value="<?= $Grid->account_holder_name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->account_holder_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->account_holder_name->formatPattern()) ?>"<?= $Grid->account_holder_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->account_holder_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_account_holder_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_account_holder_name" id="o<?= $Grid->RowIndex ?>_account_holder_name" value="<?= HtmlEncode($Grid->account_holder_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_holder_name" class="el_bank_info_account_holder_name">
<input type="<?= $Grid->account_holder_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_account_holder_name" id="x<?= $Grid->RowIndex ?>_account_holder_name" data-table="bank_info" data-field="x_account_holder_name" value="<?= $Grid->account_holder_name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->account_holder_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->account_holder_name->formatPattern()) ?>"<?= $Grid->account_holder_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->account_holder_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_holder_name" class="el_bank_info_account_holder_name">
<span<?= $Grid->account_holder_name->viewAttributes() ?>>
<?= $Grid->account_holder_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_account_holder_name" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_account_holder_name" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_account_holder_name" value="<?= HtmlEncode($Grid->account_holder_name->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_account_holder_name" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_account_holder_name" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_account_holder_name" value="<?= HtmlEncode($Grid->account_holder_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Grid->currency->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_currency" class="el_bank_info_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="bank_info"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bank_info" data-field="x_currency" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency" id="o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_currency" class="el_bank_info_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="bank_info"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_currency" class="el_bank_info_currency">
<span<?= $Grid->currency->viewAttributes() ?>>
<?= $Grid->currency->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_currency" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_currency" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_currency" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_currency" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->bank_name->Visible) { // bank_name ?>
        <td data-name="bank_name"<?= $Grid->bank_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_bank_name" class="el_bank_info_bank_name">
<input type="<?= $Grid->bank_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_bank_name" id="x<?= $Grid->RowIndex ?>_bank_name" data-table="bank_info" data-field="x_bank_name" value="<?= $Grid->bank_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->bank_name->formatPattern()) ?>"<?= $Grid->bank_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->bank_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_bank_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_bank_name" id="o<?= $Grid->RowIndex ?>_bank_name" value="<?= HtmlEncode($Grid->bank_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_bank_name" class="el_bank_info_bank_name">
<input type="<?= $Grid->bank_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_bank_name" id="x<?= $Grid->RowIndex ?>_bank_name" data-table="bank_info" data-field="x_bank_name" value="<?= $Grid->bank_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->bank_name->formatPattern()) ?>"<?= $Grid->bank_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->bank_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_bank_name" class="el_bank_info_bank_name">
<span<?= $Grid->bank_name->viewAttributes() ?>>
<?= $Grid->bank_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_bank_name" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_bank_name" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_bank_name" value="<?= HtmlEncode($Grid->bank_name->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_bank_name" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_bank_name" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_bank_name" value="<?= HtmlEncode($Grid->bank_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->account_no->Visible) { // account_no ?>
        <td data-name="account_no"<?= $Grid->account_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_no" class="el_bank_info_account_no">
<div class="input-group">
    <input type="password" name="x<?= $Grid->RowIndex ?>_account_no" id="x<?= $Grid->RowIndex ?>_account_no" autocomplete="new-password" data-table="bank_info" data-field="x_account_no" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->account_no->getPlaceHolder()) ?>"<?= $Grid->account_no->editAttributes() ?>>
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<div class="invalid-feedback"><?= $Grid->account_no->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_account_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_account_no" id="o<?= $Grid->RowIndex ?>_account_no" value="<?= HtmlEncode($Grid->account_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_no" class="el_bank_info_account_no">
<div class="input-group">
    <input type="password" name="x<?= $Grid->RowIndex ?>_account_no" id="x<?= $Grid->RowIndex ?>_account_no" autocomplete="new-password" data-table="bank_info" data-field="x_account_no" value="<?= $Grid->account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->account_no->getPlaceHolder()) ?>"<?= $Grid->account_no->editAttributes() ?>>
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<div class="invalid-feedback"><?= $Grid->account_no->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_account_no" class="el_bank_info_account_no">
<span<?= $Grid->account_no->viewAttributes() ?>>
<?= $Grid->account_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_account_no" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_account_no" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_account_no" value="<?= HtmlEncode($Grid->account_no->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_account_no" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_account_no" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_account_no" value="<?= HtmlEncode($Grid->account_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->c_account_no->Visible) { // c_account_no ?>
        <td data-name="c_account_no"<?= $Grid->c_account_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_c_account_no" class="el_bank_info_c_account_no">
<input type="<?= $Grid->c_account_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_c_account_no" id="x<?= $Grid->RowIndex ?>_c_account_no" data-table="bank_info" data-field="x_c_account_no" value="<?= $Grid->c_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->c_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->c_account_no->formatPattern()) ?>"<?= $Grid->c_account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->c_account_no->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_c_account_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_c_account_no" id="o<?= $Grid->RowIndex ?>_c_account_no" value="<?= HtmlEncode($Grid->c_account_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_c_account_no" class="el_bank_info_c_account_no">
<input type="<?= $Grid->c_account_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_c_account_no" id="x<?= $Grid->RowIndex ?>_c_account_no" data-table="bank_info" data-field="x_c_account_no" value="<?= $Grid->c_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->c_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->c_account_no->formatPattern()) ?>"<?= $Grid->c_account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->c_account_no->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_c_account_no" class="el_bank_info_c_account_no">
<span<?= $Grid->c_account_no->viewAttributes() ?>>
<?= $Grid->c_account_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_c_account_no" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_c_account_no" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_c_account_no" value="<?= HtmlEncode($Grid->c_account_no->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_c_account_no" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_c_account_no" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_c_account_no" value="<?= HtmlEncode($Grid->c_account_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->address->Visible) { // address ?>
        <td data-name="address"<?= $Grid->address->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_address" class="el_bank_info_address">
<textarea data-table="bank_info" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_address" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_address" id="o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_address" class="el_bank_info_address">
<textarea data-table="bank_info" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_address" class="el_bank_info_address">
<span<?= $Grid->address->viewAttributes() ?>>
<?= $Grid->address->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_address" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_address" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_address" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_address" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ifsc->Visible) { // ifsc ?>
        <td data-name="ifsc"<?= $Grid->ifsc->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ifsc" class="el_bank_info_ifsc">
<input type="<?= $Grid->ifsc->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ifsc" id="x<?= $Grid->RowIndex ?>_ifsc" data-table="bank_info" data-field="x_ifsc" value="<?= $Grid->ifsc->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->ifsc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ifsc->formatPattern()) ?>"<?= $Grid->ifsc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ifsc->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_ifsc" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ifsc" id="o<?= $Grid->RowIndex ?>_ifsc" value="<?= HtmlEncode($Grid->ifsc->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ifsc" class="el_bank_info_ifsc">
<input type="<?= $Grid->ifsc->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ifsc" id="x<?= $Grid->RowIndex ?>_ifsc" data-table="bank_info" data-field="x_ifsc" value="<?= $Grid->ifsc->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->ifsc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ifsc->formatPattern()) ?>"<?= $Grid->ifsc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ifsc->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ifsc" class="el_bank_info_ifsc">
<span<?= $Grid->ifsc->viewAttributes() ?>>
<?= $Grid->ifsc->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_ifsc" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_ifsc" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_ifsc" value="<?= HtmlEncode($Grid->ifsc->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_ifsc" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_ifsc" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_ifsc" value="<?= HtmlEncode($Grid->ifsc->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->swift->Visible) { // swift ?>
        <td data-name="swift"<?= $Grid->swift->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_swift" class="el_bank_info_swift">
<input type="<?= $Grid->swift->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_swift" id="x<?= $Grid->RowIndex ?>_swift" data-table="bank_info" data-field="x_swift" value="<?= $Grid->swift->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->swift->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->swift->formatPattern()) ?>"<?= $Grid->swift->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->swift->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_swift" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_swift" id="o<?= $Grid->RowIndex ?>_swift" value="<?= HtmlEncode($Grid->swift->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_swift" class="el_bank_info_swift">
<input type="<?= $Grid->swift->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_swift" id="x<?= $Grid->RowIndex ?>_swift" data-table="bank_info" data-field="x_swift" value="<?= $Grid->swift->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->swift->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->swift->formatPattern()) ?>"<?= $Grid->swift->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->swift->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_swift" class="el_bank_info_swift">
<span<?= $Grid->swift->viewAttributes() ?>>
<?= $Grid->swift->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_swift" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_swift" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_swift" value="<?= HtmlEncode($Grid->swift->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_swift" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_swift" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_swift" value="<?= HtmlEncode($Grid->swift->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ad->Visible) { // ad ?>
        <td data-name="ad"<?= $Grid->ad->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ad" class="el_bank_info_ad">
<input type="<?= $Grid->ad->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ad" id="x<?= $Grid->RowIndex ?>_ad" data-table="bank_info" data-field="x_ad" value="<?= $Grid->ad->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->ad->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ad->formatPattern()) ?>"<?= $Grid->ad->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ad->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_ad" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ad" id="o<?= $Grid->RowIndex ?>_ad" value="<?= HtmlEncode($Grid->ad->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ad" class="el_bank_info_ad">
<input type="<?= $Grid->ad->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ad" id="x<?= $Grid->RowIndex ?>_ad" data-table="bank_info" data-field="x_ad" value="<?= $Grid->ad->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->ad->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ad->formatPattern()) ?>"<?= $Grid->ad->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ad->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_ad" class="el_bank_info_ad">
<span<?= $Grid->ad->viewAttributes() ?>>
<?= $Grid->ad->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_ad" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_ad" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_ad" value="<?= HtmlEncode($Grid->ad->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_ad" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_ad" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_ad" value="<?= HtmlEncode($Grid->ad->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->routing->Visible) { // routing ?>
        <td data-name="routing"<?= $Grid->routing->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing" class="el_bank_info_routing">
<input type="<?= $Grid->routing->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_routing" id="x<?= $Grid->RowIndex ?>_routing" data-table="bank_info" data-field="x_routing" value="<?= $Grid->routing->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->routing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->routing->formatPattern()) ?>"<?= $Grid->routing->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->routing->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_routing" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_routing" id="o<?= $Grid->RowIndex ?>_routing" value="<?= HtmlEncode($Grid->routing->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing" class="el_bank_info_routing">
<input type="<?= $Grid->routing->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_routing" id="x<?= $Grid->RowIndex ?>_routing" data-table="bank_info" data-field="x_routing" value="<?= $Grid->routing->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->routing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->routing->formatPattern()) ?>"<?= $Grid->routing->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->routing->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing" class="el_bank_info_routing">
<span<?= $Grid->routing->viewAttributes() ?>>
<?= $Grid->routing->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_routing" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_routing" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_routing" value="<?= HtmlEncode($Grid->routing->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_routing" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_routing" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_routing" value="<?= HtmlEncode($Grid->routing->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->routing_swift->Visible) { // routing_swift ?>
        <td data-name="routing_swift"<?= $Grid->routing_swift->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing_swift" class="el_bank_info_routing_swift">
<input type="<?= $Grid->routing_swift->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_routing_swift" id="x<?= $Grid->RowIndex ?>_routing_swift" data-table="bank_info" data-field="x_routing_swift" value="<?= $Grid->routing_swift->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->routing_swift->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->routing_swift->formatPattern()) ?>"<?= $Grid->routing_swift->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->routing_swift->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_routing_swift" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_routing_swift" id="o<?= $Grid->RowIndex ?>_routing_swift" value="<?= HtmlEncode($Grid->routing_swift->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing_swift" class="el_bank_info_routing_swift">
<input type="<?= $Grid->routing_swift->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_routing_swift" id="x<?= $Grid->RowIndex ?>_routing_swift" data-table="bank_info" data-field="x_routing_swift" value="<?= $Grid->routing_swift->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->routing_swift->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->routing_swift->formatPattern()) ?>"<?= $Grid->routing_swift->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->routing_swift->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_routing_swift" class="el_bank_info_routing_swift">
<span<?= $Grid->routing_swift->viewAttributes() ?>>
<?= $Grid->routing_swift->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_routing_swift" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_routing_swift" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_routing_swift" value="<?= HtmlEncode($Grid->routing_swift->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_routing_swift" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_routing_swift" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_routing_swift" value="<?= HtmlEncode($Grid->routing_swift->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->nostro_account->Visible) { // nostro_account ?>
        <td data-name="nostro_account"<?= $Grid->nostro_account->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_nostro_account" class="el_bank_info_nostro_account">
<input type="<?= $Grid->nostro_account->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_nostro_account" id="x<?= $Grid->RowIndex ?>_nostro_account" data-table="bank_info" data-field="x_nostro_account" value="<?= $Grid->nostro_account->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->nostro_account->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->nostro_account->formatPattern()) ?>"<?= $Grid->nostro_account->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->nostro_account->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_nostro_account" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_nostro_account" id="o<?= $Grid->RowIndex ?>_nostro_account" value="<?= HtmlEncode($Grid->nostro_account->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_nostro_account" class="el_bank_info_nostro_account">
<input type="<?= $Grid->nostro_account->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_nostro_account" id="x<?= $Grid->RowIndex ?>_nostro_account" data-table="bank_info" data-field="x_nostro_account" value="<?= $Grid->nostro_account->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->nostro_account->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->nostro_account->formatPattern()) ?>"<?= $Grid->nostro_account->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->nostro_account->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_nostro_account" class="el_bank_info_nostro_account">
<span<?= $Grid->nostro_account->viewAttributes() ?>>
<?= $Grid->nostro_account->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_nostro_account" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_nostro_account" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_nostro_account" value="<?= HtmlEncode($Grid->nostro_account->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_nostro_account" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_nostro_account" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_nostro_account" value="<?= HtmlEncode($Grid->nostro_account->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->upi->Visible) { // upi ?>
        <td data-name="upi"<?= $Grid->upi->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_upi" class="el_bank_info_upi">
<input type="<?= $Grid->upi->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_upi" id="x<?= $Grid->RowIndex ?>_upi" data-table="bank_info" data-field="x_upi" value="<?= $Grid->upi->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->upi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->upi->formatPattern()) ?>"<?= $Grid->upi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->upi->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="bank_info" data-field="x_upi" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_upi" id="o<?= $Grid->RowIndex ?>_upi" value="<?= HtmlEncode($Grid->upi->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_upi" class="el_bank_info_upi">
<input type="<?= $Grid->upi->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_upi" id="x<?= $Grid->RowIndex ?>_upi" data-table="bank_info" data-field="x_upi" value="<?= $Grid->upi->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->upi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->upi->formatPattern()) ?>"<?= $Grid->upi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->upi->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_upi" class="el_bank_info_upi">
<span<?= $Grid->upi->viewAttributes() ?>>
<?= $Grid->upi->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_upi" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_upi" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_upi" value="<?= HtmlEncode($Grid->upi->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_upi" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_upi" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_upi" value="<?= HtmlEncode($Grid->upi->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_status" class="el_bank_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="bank_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="bank_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_status" class="el_bank_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbank_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="bank_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbank_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbank_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbank_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbank_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbank_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bank_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_status" class="el_bank_info_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_status" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_status" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_status" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_status" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="bank_info" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_operator" class="el_bank_info_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_operator" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_operator" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_operator" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_operator" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="bank_info" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_bank_info_datetime" class="el_bank_info_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="bank_info" data-field="x_datetime" data-hidden="1" name="fbank_infogrid$x<?= $Grid->RowIndex ?>_datetime" id="fbank_infogrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="bank_info" data-field="x_datetime" data-hidden="1" data-old name="fbank_infogrid$o<?= $Grid->RowIndex ?>_datetime" id="fbank_infogrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fbank_infogrid","load"], () => fbank_infogrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fbank_infogrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bank_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
