<?php

namespace PHPMaker2024\fibre;

// Page object
$BalanceSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { balance: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbalancesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbalancesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["sub_category", [], fields.sub_category.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["debit", [ew.Validators.float], fields.debit.isInvalid],
            ["y_debit", [ew.Validators.between], false],
            ["credit", [ew.Validators.float], fields.credit.isInvalid],
            ["y_credit", [ew.Validators.between], false],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["y_balance", [ew.Validators.between], false],
            ["city", [], fields.city.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbalancesearch" id="fbalancesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="balance">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_grp" id="z_grp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_balance_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fbalancesearch_x_grp"
        <?php } ?>
        data-table="balance"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbalancesearch", function() {
    var options = { name: "x_grp", selectId: "fbalancesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbalancesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fbalancesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fbalancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.balance.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
    <div id="r_sub_category" class="row"<?= $Page->sub_category->rowAttributes() ?>>
        <label for="x_sub_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_sub_category"><?= $Page->sub_category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sub_category" id="z_sub_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_balance_sub_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_sub_category"
        name="x_sub_category"
        class="form-select ew-select<?= $Page->sub_category->isInvalidClass() ?>"
        <?php if (!$Page->sub_category->IsNativeSelect) { ?>
        data-select2-id="fbalancesearch_x_sub_category"
        <?php } ?>
        data-table="balance"
        data-field="x_sub_category"
        data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_category->getPlaceHolder()) ?>"
        <?= $Page->sub_category->editAttributes() ?>>
        <?= $Page->sub_category->selectOptionListHtml("x_sub_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage(false) ?></div>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
<?php if (!$Page->sub_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbalancesearch", function() {
    var options = { name: "x_sub_category", selectId: "fbalancesearch_x_sub_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbalancesearch.lists.sub_category?.lookupOptions.length) {
        options.data = { id: "x_sub_category", form: "fbalancesearch" };
    } else {
        options.ajax = { id: "x_sub_category", form: "fbalancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.balance.fields.sub_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_balance_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="balance" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->debit->Visible) { // debit ?>
    <div id="r_debit" class="row"<?= $Page->debit->rowAttributes() ?>>
        <label for="x_debit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_debit"><?= $Page->debit->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->debit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_debit" id="z_debit" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->debit->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->debit->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_balance_debit" class="ew-search-field">
<input type="<?= $Page->debit->getInputTextType() ?>" name="x_debit" id="x_debit" data-table="balance" data-field="x_debit" value="<?= $Page->debit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->debit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->debit->formatPattern()) ?>"<?= $Page->debit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->debit->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_balance_debit" class="ew-search-field2 d-none">
<input type="<?= $Page->debit->getInputTextType() ?>" name="y_debit" id="y_debit" data-table="balance" data-field="x_debit" value="<?= $Page->debit->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->debit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->debit->formatPattern()) ?>"<?= $Page->debit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->debit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->credit->Visible) { // credit ?>
    <div id="r_credit" class="row"<?= $Page->credit->rowAttributes() ?>>
        <label for="x_credit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_credit"><?= $Page->credit->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->credit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_credit" id="z_credit" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->credit->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->credit->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_balance_credit" class="ew-search-field">
<input type="<?= $Page->credit->getInputTextType() ?>" name="x_credit" id="x_credit" data-table="balance" data-field="x_credit" value="<?= $Page->credit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->credit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->credit->formatPattern()) ?>"<?= $Page->credit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->credit->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_balance_credit" class="ew-search-field2 d-none">
<input type="<?= $Page->credit->getInputTextType() ?>" name="y_credit" id="y_credit" data-table="balance" data-field="x_credit" value="<?= $Page->credit->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->credit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->credit->formatPattern()) ?>"<?= $Page->credit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->credit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_balance"><?= $Page->balance->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_balance" id="z_balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_balance_balance" class="ew-search-field">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="balance" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_balance_balance" class="ew-search-field2 d-none">
<input type="<?= $Page->balance->getInputTextType() ?>" name="y_balance" id="y_balance" data-table="balance" data-field="x_balance" value="<?= $Page->balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city" class="row"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>"><span id="elh_balance_city"><?= $Page->city->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city" id="z_city" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_balance_city" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city->getInputTextType() ?>" name="x_city" id="x_city" data-table="balance" data-field="x_city" value="<?= $Page->city->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbalancesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbalancesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbalancesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("balance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
