<?php

namespace PHPMaker2024\fibre;

// Page object
$BalanceList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { balance: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "account": <?= $Page->account->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbalancesrch" id="fbalancesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbalancesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { balance: currentTable } });
var currentForm;
var fbalancesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbalancesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["sub_category", [], fields.sub_category.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["y_balance", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "account": <?= $Page->account->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
<?php
if (!$Page->sub_category->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sub_category" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sub_category->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sub_category" class="ew-search-caption ew-label"><?= $Page->sub_category->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sub_category" id="z_sub_category" value="=">
</div>
        </div>
        <div id="el_balance_sub_category" class="ew-search-field">
    <select
        id="x_sub_category"
        name="x_sub_category"
        class="form-select ew-select<?= $Page->sub_category->isInvalidClass() ?>"
        <?php if (!$Page->sub_category->IsNativeSelect) { ?>
        data-select2-id="fbalancesrch_x_sub_category"
        <?php } ?>
        data-table="balance"
        data-field="x_sub_category"
        data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_category->getPlaceHolder()) ?>"
        <?= $Page->sub_category->editAttributes() ?>>
        <?= $Page->sub_category->selectOptionListHtml("x_sub_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage(false) ?></div>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
<?php if (!$Page->sub_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbalancesrch", function() {
    var options = { name: "x_sub_category", selectId: "fbalancesrch_x_sub_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbalancesrch.lists.sub_category?.lookupOptions.length) {
        options.data = { id: "x_sub_category", form: "fbalancesrch" };
    } else {
        options.ajax = { id: "x_sub_category", form: "fbalancesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.balance.fields.sub_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->account->Visible) { // account ?>
<?php
if (!$Page->account->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_account" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->account->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_account"
            name="x_account[]"
            class="form-control ew-select<?= $Page->account->isInvalidClass() ?>"
            data-select2-id="fbalancesrch_x_account"
            data-table="balance"
            data-field="x_account"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->account->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->account->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->account->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->account->editAttributes() ?>>
            <?= $Page->account->selectOptionListHtml("x_account", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->account->getErrorMessage(false) ?></div>
        <?= $Page->account->Lookup->getParamTag($Page, "p_x_account") ?>
        <script>
        loadjs.ready("fbalancesrch", function() {
            var options = {
                name: "x_account",
                selectId: "fbalancesrch_x_account",
                ajax: { id: "x_account", form: "fbalancesrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.balance.fields.account.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
<?php
if (!$Page->name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_name"
            name="x_name[]"
            class="form-control ew-select<?= $Page->name->isInvalidClass() ?>"
            data-select2-id="fbalancesrch_x_name"
            data-table="balance"
            data-field="x_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->name->editAttributes() ?>>
            <?= $Page->name->selectOptionListHtml("x_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbalancesrch", function() {
            var options = {
                name: "x_name",
                selectId: "fbalancesrch_x_name",
                ajax: { id: "x_name", form: "fbalancesrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.balance.fields.name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
<?php
if (!$Page->balance->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_balance" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->balance->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_balance" class="ew-search-caption ew-label"><?= $Page->balance->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_balance" id="z_balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_balance_balance" class="ew-search-field">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="balance" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_balance_balance" class="ew-search-field2 d-none">
<input type="<?= $Page->balance->getInputTextType() ?>" name="y_balance" id="y_balance" data-table="balance" data-field="x_balance" value="<?= $Page->balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
<?php
if (!$Page->city->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_city" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->city->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_city"
            name="x_city[]"
            class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
            data-select2-id="fbalancesrch_x_city"
            data-table="balance"
            data-field="x_city"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->city->editAttributes() ?>>
            <?= $Page->city->selectOptionListHtml("x_city", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbalancesrch", function() {
            var options = {
                name: "x_city",
                selectId: "fbalancesrch_x_city",
                ajax: { id: "x_city", form: "fbalancesrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.balance.fields.city.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbalancesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbalancesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbalancesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbalancesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbalancesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbalancesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbalancesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="balance">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_balance" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_balancelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
        <th data-name="sub_category" class="<?= $Page->sub_category->headerCellClass() ?>"><div id="elh_balance_sub_category" class="balance_sub_category"><?= $Page->renderFieldHeader($Page->sub_category) ?></div></th>
<?php } ?>
<?php if ($Page->account->Visible) { // account ?>
        <th data-name="account" class="<?= $Page->account->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_balance_account" class="balance_account"><?= $Page->renderFieldHeader($Page->account) ?></div></th>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Page->name->headerCellClass() ?>"><div id="elh_balance_name" class="balance_name"><?= $Page->renderFieldHeader($Page->name) ?></div></th>
<?php } ?>
<?php if ($Page->debit->Visible) { // debit ?>
        <th data-name="debit" class="<?= $Page->debit->headerCellClass() ?>"><div id="elh_balance_debit" class="balance_debit"><?= $Page->renderFieldHeader($Page->debit) ?></div></th>
<?php } ?>
<?php if ($Page->credit->Visible) { // credit ?>
        <th data-name="credit" class="<?= $Page->credit->headerCellClass() ?>"><div id="elh_balance_credit" class="balance_credit"><?= $Page->renderFieldHeader($Page->credit) ?></div></th>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
        <th data-name="balance" class="<?= $Page->balance->headerCellClass() ?>"><div id="elh_balance_balance" class="balance_balance"><?= $Page->renderFieldHeader($Page->balance) ?></div></th>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
        <th data-name="city" class="<?= $Page->city->headerCellClass() ?>"><div id="elh_balance_city" class="balance_city"><?= $Page->renderFieldHeader($Page->city) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->sub_category->Visible) { // sub_category ?>
        <td data-name="sub_category"<?= $Page->sub_category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_sub_category" class="el_balance_sub_category">
<span<?= $Page->sub_category->viewAttributes() ?>>
<?= $Page->sub_category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->account->Visible) { // account ?>
        <td data-name="account"<?= $Page->account->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_account" class="el_balance_account">
<span<?= $Page->account->viewAttributes() ?>>
<?php if (!EmptyString($Page->account->getViewValue()) && $Page->account->linkAttributes() != "") { ?>
<a<?= $Page->account->linkAttributes() ?>><?= $Page->account->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_name" class="el_balance_name">
<span<?= $Page->name->viewAttributes() ?>>
<?php if (!EmptyString($Page->name->getViewValue()) && $Page->name->linkAttributes() != "") { ?>
<a<?= $Page->name->linkAttributes() ?>><?= $Page->name->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->debit->Visible) { // debit ?>
        <td data-name="debit"<?= $Page->debit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_debit" class="el_balance_debit">
<span<?= $Page->debit->viewAttributes() ?>>
<?= $Page->debit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->credit->Visible) { // credit ?>
        <td data-name="credit"<?= $Page->credit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_credit" class="el_balance_credit">
<span<?= $Page->credit->viewAttributes() ?>>
<?= $Page->credit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->balance->Visible) { // balance ?>
        <td data-name="balance"<?= $Page->balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_balance" class="el_balance_balance">
<span<?= $Page->balance->viewAttributes() ?>>
<?php if (!EmptyString($Page->balance->getViewValue()) && $Page->balance->linkAttributes() != "") { ?>
<a<?= $Page->balance->linkAttributes() ?>><?= $Page->balance->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city->Visible) { // city ?>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_balance_city" class="el_balance_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->sub_category->Visible) { // sub_category ?>
        <td data-name="sub_category" class="<?= $Page->sub_category->footerCellClass() ?>"><span id="elf_balance_sub_category" class="balance_sub_category">
        </span></td>
    <?php } ?>
    <?php if ($Page->account->Visible) { // account ?>
        <td data-name="account" class="<?= $Page->account->footerCellClass() ?>"><span id="elf_balance_account" class="balance_account">
        </span></td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name" class="<?= $Page->name->footerCellClass() ?>"><span id="elf_balance_name" class="balance_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->debit->Visible) { // debit ?>
        <td data-name="debit" class="<?= $Page->debit->footerCellClass() ?>"><span id="elf_balance_debit" class="balance_debit">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->debit->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->credit->Visible) { // credit ?>
        <td data-name="credit" class="<?= $Page->credit->footerCellClass() ?>"><span id="elf_balance_credit" class="balance_credit">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->credit->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->balance->Visible) { // balance ?>
        <td data-name="balance" class="<?= $Page->balance->footerCellClass() ?>"><span id="elf_balance_balance" class="balance_balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->balance->ViewValue) && $Page->balance->linkAttributes() != "") { ?>
        <a<?= $Page->balance->linkAttributes() ?>><?= $Page->balance->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->balance->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->city->Visible) { // city ?>
        <td data-name="city" class="<?= $Page->city->footerCellClass() ?>"><span id="elf_balance_city" class="balance_city">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("balance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
