<?php

namespace PHPMaker2024\fibre;

// Page object
$BIncentivePpSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_incentive_pp: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_incentive_ppsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_incentive_ppsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["partner", [ew.Validators.integer], fields.partner.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["target_amount", [ew.Validators.integer], fields.target_amount.isInvalid],
            ["target_file", [ew.Validators.integer], fields.target_file.isInvalid],
            ["file_inc", [ew.Validators.integer], fields.file_inc.isInvalid],
            ["neg_file_inc", [ew.Validators.integer], fields.neg_file_inc.isInvalid],
            ["inc_min_amount", [ew.Validators.integer], fields.inc_min_amount.isInvalid],
            ["inc_max_amount", [ew.Validators.integer], fields.inc_max_amount.isInvalid],
            ["inc_percent", [ew.Validators.float], fields.inc_percent.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner": <?= $Page->partner->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_incentive_ppsearch" id="fb_incentive_ppsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_incentive_pp">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="b_incentive_pp" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner->Visible) { // partner ?>
    <div id="r_partner" class="row"<?= $Page->partner->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_partner"><?= $Page->partner->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner" id="z_partner" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_partner" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner"
        name="x_partner"
        class="form-control ew-select<?= $Page->partner->isInvalidClass() ?>"
        data-select2-id="fb_incentive_ppsearch_x_partner"
        data-table="b_incentive_pp"
        data-field="x_partner"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner->getPlaceHolder()) ?>"
        <?= $Page->partner->editAttributes() ?>>
        <?= $Page->partner->selectOptionListHtml("x_partner") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner->getErrorMessage(false) ?></div>
<?= $Page->partner->Lookup->getParamTag($Page, "p_x_partner") ?>
<script>
loadjs.ready("fb_incentive_ppsearch", function() {
    var options = { name: "x_partner", selectId: "fb_incentive_ppsearch_x_partner" };
    if (fb_incentive_ppsearch.lists.partner?.lookupOptions.length) {
        options.data = { id: "x_partner", form: "fb_incentive_ppsearch" };
    } else {
        options.ajax = { id: "x_partner", form: "fb_incentive_ppsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.b_incentive_pp.fields.partner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fb_incentive_ppsearch_x_category"
        <?php } ?>
        data-table="b_incentive_pp"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_incentive_ppsearch", function() {
    var options = { name: "x_category", selectId: "fb_incentive_ppsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_incentive_ppsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fb_incentive_ppsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fb_incentive_ppsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_incentive_pp.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fb_incentive_ppsearch_x_type"
        <?php } ?>
        data-table="b_incentive_pp"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_incentive_ppsearch", function() {
    var options = { name: "x_type", selectId: "fb_incentive_ppsearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_incentive_ppsearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fb_incentive_ppsearch" };
    } else {
        options.ajax = { id: "x_type", form: "fb_incentive_ppsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_incentive_pp.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->target_amount->Visible) { // target_amount ?>
    <div id="r_target_amount" class="row"<?= $Page->target_amount->rowAttributes() ?>>
        <label for="x_target_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_target_amount"><?= $Page->target_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_target_amount" id="z_target_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->target_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_target_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->target_amount->getInputTextType() ?>" name="x_target_amount" id="x_target_amount" data-table="b_incentive_pp" data-field="x_target_amount" value="<?= $Page->target_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->target_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->target_amount->formatPattern()) ?>"<?= $Page->target_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->target_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->target_file->Visible) { // target_file ?>
    <div id="r_target_file" class="row"<?= $Page->target_file->rowAttributes() ?>>
        <label for="x_target_file" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_target_file"><?= $Page->target_file->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_target_file" id="z_target_file" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->target_file->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_target_file" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->target_file->getInputTextType() ?>" name="x_target_file" id="x_target_file" data-table="b_incentive_pp" data-field="x_target_file" value="<?= $Page->target_file->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->target_file->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->target_file->formatPattern()) ?>"<?= $Page->target_file->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->target_file->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->file_inc->Visible) { // file_inc ?>
    <div id="r_file_inc" class="row"<?= $Page->file_inc->rowAttributes() ?>>
        <label for="x_file_inc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_file_inc"><?= $Page->file_inc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_file_inc" id="z_file_inc" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->file_inc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_file_inc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->file_inc->getInputTextType() ?>" name="x_file_inc" id="x_file_inc" data-table="b_incentive_pp" data-field="x_file_inc" value="<?= $Page->file_inc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->file_inc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->file_inc->formatPattern()) ?>"<?= $Page->file_inc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->file_inc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->neg_file_inc->Visible) { // neg_file_inc ?>
    <div id="r_neg_file_inc" class="row"<?= $Page->neg_file_inc->rowAttributes() ?>>
        <label for="x_neg_file_inc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_neg_file_inc"><?= $Page->neg_file_inc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_neg_file_inc" id="z_neg_file_inc" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->neg_file_inc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_neg_file_inc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->neg_file_inc->getInputTextType() ?>" name="x_neg_file_inc" id="x_neg_file_inc" data-table="b_incentive_pp" data-field="x_neg_file_inc" value="<?= $Page->neg_file_inc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->neg_file_inc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->neg_file_inc->formatPattern()) ?>"<?= $Page->neg_file_inc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->neg_file_inc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->inc_min_amount->Visible) { // inc_min_amount ?>
    <div id="r_inc_min_amount" class="row"<?= $Page->inc_min_amount->rowAttributes() ?>>
        <label for="x_inc_min_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_inc_min_amount"><?= $Page->inc_min_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_inc_min_amount" id="z_inc_min_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->inc_min_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_inc_min_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->inc_min_amount->getInputTextType() ?>" name="x_inc_min_amount" id="x_inc_min_amount" data-table="b_incentive_pp" data-field="x_inc_min_amount" value="<?= $Page->inc_min_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->inc_min_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inc_min_amount->formatPattern()) ?>"<?= $Page->inc_min_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inc_min_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->inc_max_amount->Visible) { // inc_max_amount ?>
    <div id="r_inc_max_amount" class="row"<?= $Page->inc_max_amount->rowAttributes() ?>>
        <label for="x_inc_max_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_inc_max_amount"><?= $Page->inc_max_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_inc_max_amount" id="z_inc_max_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->inc_max_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_inc_max_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->inc_max_amount->getInputTextType() ?>" name="x_inc_max_amount" id="x_inc_max_amount" data-table="b_incentive_pp" data-field="x_inc_max_amount" value="<?= $Page->inc_max_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->inc_max_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inc_max_amount->formatPattern()) ?>"<?= $Page->inc_max_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inc_max_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->inc_percent->Visible) { // inc_percent ?>
    <div id="r_inc_percent" class="row"<?= $Page->inc_percent->rowAttributes() ?>>
        <label for="x_inc_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_inc_percent"><?= $Page->inc_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_inc_percent" id="z_inc_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->inc_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_inc_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->inc_percent->getInputTextType() ?>" name="x_inc_percent" id="x_inc_percent" data-table="b_incentive_pp" data-field="x_inc_percent" value="<?= $Page->inc_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->inc_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inc_percent->formatPattern()) ?>"<?= $Page->inc_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inc_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="b_incentive_pp" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_incentive_pp_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_incentive_pp_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_incentive_pp" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_incentive_ppsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_incentive_ppsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_incentive_ppsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_incentive_ppsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_incentive_ppsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_incentive_pp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
