<?php

namespace PHPMaker2024\fibre;

// Page object
$BChargesPlanSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_charges_plan: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_charges_plansearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_charges_plansearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["plan_type", [], fields.plan_type.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["fix", [], fields.fix.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["min_range", [ew.Validators.float], fields.min_range.isInvalid],
            ["max_range", [ew.Validators.float], fields.max_range.isInvalid],
            ["from_date", [ew.Validators.datetime(fields.from_date.clientFormatPattern)], fields.from_date.isInvalid],
            ["to_date", [ew.Validators.datetime(fields.to_date.clientFormatPattern)], fields.to_date.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "plan_type": <?= $Page->plan_type->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "fix": <?= $Page->fix->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_charges_plansearch" id="fb_charges_plansearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_charges_plan">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="b_charges_plan" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_location" class="ew-search-field ew-search-field-single">
<template id="tp_x_location">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_charges_plan" data-field="x_location" name="x_location" id="x_location"<?= $Page->location->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_location" class="ew-item-list"></div>
<selection-list hidden
    id="x_location[]"
    name="x_location[]"
    value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_location"
    data-target="dsl_x_location"
    data-repeatcolumn="5"
    class="form-control<?= $Page->location->isInvalidClass() ?>"
    data-table="b_charges_plan"
    data-field="x_location"
    data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
    <?= $Page->location->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_charges_plan" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="b_charges_plan"
    data-field="x_grp"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_s_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_s_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_charges_plan" data-field="x_s_grp" name="x_s_grp" id="x_s_grp"<?= $Page->s_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_s_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_s_grp[]"
    name="x_s_grp[]"
    value="<?= HtmlEncode($Page->s_grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_s_grp"
    data-target="dsl_x_s_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->s_grp->isInvalidClass() ?>"
    data-table="b_charges_plan"
    data-field="x_s_grp"
    data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->s_grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="b_charges_plan" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->plan_type->Visible) { // plan_type ?>
    <div id="r_plan_type" class="row"<?= $Page->plan_type->rowAttributes() ?>>
        <label for="x_plan_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_plan_type"><?= $Page->plan_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_plan_type" id="z_plan_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->plan_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_plan_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_plan_type"
        name="x_plan_type"
        class="form-select ew-select<?= $Page->plan_type->isInvalidClass() ?>"
        <?php if (!$Page->plan_type->IsNativeSelect) { ?>
        data-select2-id="fb_charges_plansearch_x_plan_type"
        <?php } ?>
        data-table="b_charges_plan"
        data-field="x_plan_type"
        data-value-separator="<?= $Page->plan_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->plan_type->getPlaceHolder()) ?>"
        <?= $Page->plan_type->editAttributes() ?>>
        <?= $Page->plan_type->selectOptionListHtml("x_plan_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->plan_type->getErrorMessage(false) ?></div>
<?= $Page->plan_type->Lookup->getParamTag($Page, "p_x_plan_type") ?>
<?php if (!$Page->plan_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_charges_plansearch", function() {
    var options = { name: "x_plan_type", selectId: "fb_charges_plansearch_x_plan_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_charges_plansearch.lists.plan_type?.lookupOptions.length) {
        options.data = { id: "x_plan_type", form: "fb_charges_plansearch" };
    } else {
        options.ajax = { id: "x_plan_type", form: "fb_charges_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_charges_plan.fields.plan_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_method" id="z_method" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fb_charges_plansearch_x_method"
        <?php } ?>
        data-table="b_charges_plan"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_charges_plansearch", function() {
    var options = { name: "x_method", selectId: "fb_charges_plansearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_charges_plansearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fb_charges_plansearch" };
    } else {
        options.ajax = { id: "x_method", form: "fb_charges_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_charges_plan.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fix->Visible) { // fix ?>
    <div id="r_fix" class="row"<?= $Page->fix->rowAttributes() ?>>
        <label for="x_fix" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_fix"><?= $Page->fix->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fix" id="z_fix" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fix->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_fix" class="ew-search-field ew-search-field-single">
    <select
        id="x_fix"
        name="x_fix"
        class="form-select ew-select<?= $Page->fix->isInvalidClass() ?>"
        <?php if (!$Page->fix->IsNativeSelect) { ?>
        data-select2-id="fb_charges_plansearch_x_fix"
        <?php } ?>
        data-table="b_charges_plan"
        data-field="x_fix"
        data-value-separator="<?= $Page->fix->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fix->getPlaceHolder()) ?>"
        <?= $Page->fix->editAttributes() ?>>
        <?= $Page->fix->selectOptionListHtml("x_fix") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->fix->getErrorMessage(false) ?></div>
<?php if (!$Page->fix->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_charges_plansearch", function() {
    var options = { name: "x_fix", selectId: "fb_charges_plansearch_x_fix" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_charges_plansearch.lists.fix?.lookupOptions.length) {
        options.data = { id: "x_fix", form: "fb_charges_plansearch" };
    } else {
        options.ajax = { id: "x_fix", form: "fb_charges_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_charges_plan.fields.fix.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="b_charges_plan" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->min_range->Visible) { // min_range ?>
    <div id="r_min_range" class="row"<?= $Page->min_range->rowAttributes() ?>>
        <label for="x_min_range" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_min_range"><?= $Page->min_range->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_min_range" id="z_min_range" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->min_range->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_min_range" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->min_range->getInputTextType() ?>" name="x_min_range" id="x_min_range" data-table="b_charges_plan" data-field="x_min_range" value="<?= $Page->min_range->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->min_range->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->min_range->formatPattern()) ?>"<?= $Page->min_range->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->min_range->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->max_range->Visible) { // max_range ?>
    <div id="r_max_range" class="row"<?= $Page->max_range->rowAttributes() ?>>
        <label for="x_max_range" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_max_range"><?= $Page->max_range->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_max_range" id="z_max_range" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->max_range->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_max_range" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->max_range->getInputTextType() ?>" name="x_max_range" id="x_max_range" data-table="b_charges_plan" data-field="x_max_range" value="<?= $Page->max_range->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_range->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_range->formatPattern()) ?>"<?= $Page->max_range->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->max_range->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->from_date->Visible) { // from_date ?>
    <div id="r_from_date" class="row"<?= $Page->from_date->rowAttributes() ?>>
        <label for="x_from_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_from_date"><?= $Page->from_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_from_date" id="z_from_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->from_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_from_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->from_date->getInputTextType() ?>" name="x_from_date" id="x_from_date" data-table="b_charges_plan" data-field="x_from_date" value="<?= $Page->from_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->from_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->from_date->formatPattern()) ?>"<?= $Page->from_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->from_date->getErrorMessage(false) ?></div>
<?php if (!$Page->from_date->ReadOnly && !$Page->from_date->Disabled && !isset($Page->from_date->EditAttrs["readonly"]) && !isset($Page->from_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_charges_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_charges_plansearch", "x_from_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->to_date->Visible) { // to_date ?>
    <div id="r_to_date" class="row"<?= $Page->to_date->rowAttributes() ?>>
        <label for="x_to_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_to_date"><?= $Page->to_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_to_date" id="z_to_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->to_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_to_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->to_date->getInputTextType() ?>" name="x_to_date" id="x_to_date" data-table="b_charges_plan" data-field="x_to_date" value="<?= $Page->to_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->to_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->to_date->formatPattern()) ?>"<?= $Page->to_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->to_date->getErrorMessage(false) ?></div>
<?php if (!$Page->to_date->ReadOnly && !$Page->to_date->Disabled && !isset($Page->to_date->EditAttrs["readonly"]) && !isset($Page->to_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_charges_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_charges_plansearch", "x_to_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fb_charges_plansearch_x_status"
        <?php } ?>
        data-table="b_charges_plan"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_charges_plansearch", function() {
    var options = { name: "x_status", selectId: "fb_charges_plansearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_charges_plansearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fb_charges_plansearch" };
    } else {
        options.ajax = { id: "x_status", form: "fb_charges_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_charges_plan.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fb_charges_plansearch_x_operator"
        <?php } ?>
        data-table="b_charges_plan"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_charges_plansearch", function() {
    var options = { name: "x_operator", selectId: "fb_charges_plansearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_charges_plansearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fb_charges_plansearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fb_charges_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_charges_plan.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_charges_plan_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_charges_plan_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_charges_plan" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_charges_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_charges_plansearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_charges_plansearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_charges_plansearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_charges_plansearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_charges_plan");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
