<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountTypeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_type: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_account_typesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_account_typesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["minimum", [ew.Validators.integer], fields.minimum.isInvalid],
            ["maximum", [ew.Validators.integer], fields.maximum.isInvalid],
            ["int_", [ew.Validators.float], fields.int_.isInvalid],
            ["no_of_emi", [ew.Validators.integer], fields.no_of_emi.isInvalid],
            ["repay_frequency", [], fields.repay_frequency.isInvalid],
            ["one_time_charge", [], fields.one_time_charge.isInvalid],
            ["action_charge", [], fields.action_charge.isInvalid],
            ["month_charge", [], fields.month_charge.isInvalid],
            ["quarter_charge", [], fields.quarter_charge.isInvalid],
            ["annual_charge", [], fields.annual_charge.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "repay_frequency": <?= $Page->repay_frequency->toClientList($Page) ?>,
            "one_time_charge": <?= $Page->one_time_charge->toClientList($Page) ?>,
            "action_charge": <?= $Page->action_charge->toClientList($Page) ?>,
            "month_charge": <?= $Page->month_charge->toClientList($Page) ?>,
            "quarter_charge": <?= $Page->quarter_charge->toClientList($Page) ?>,
            "annual_charge": <?= $Page->annual_charge->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_typesearch" id="fb_account_typesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_type">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="b_account_type" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_location" id="z_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_location" class="ew-search-field ew-search-field-single">
<template id="tp_x_location">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_location" name="x_location" id="x_location"<?= $Page->location->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_location" class="ew-item-list"></div>
<selection-list hidden
    id="x_location[]"
    name="x_location[]"
    value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_location"
    data-target="dsl_x_location"
    data-repeatcolumn="5"
    class="form-control<?= $Page->location->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_location"
    data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
    <?= $Page->location->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fb_account_typesearch_x_grp"
        <?php } ?>
        data-table="b_account_type"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_typesearch", function() {
    var options = { name: "x_grp", selectId: "fb_account_typesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_typesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fb_account_typesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fb_account_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_type.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fb_account_typesearch_x_s_grp"
        <?php } ?>
        data-table="b_account_type"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_typesearch", function() {
    var options = { name: "x_s_grp", selectId: "fb_account_typesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_typesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fb_account_typesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fb_account_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_type.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="b_account_type" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_code" id="z_code" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="b_account_type" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->minimum->Visible) { // minimum ?>
    <div id="r_minimum" class="row"<?= $Page->minimum->rowAttributes() ?>>
        <label for="x_minimum" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_minimum"><?= $Page->minimum->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_minimum" id="z_minimum" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->minimum->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_minimum" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->minimum->getInputTextType() ?>" name="x_minimum" id="x_minimum" data-table="b_account_type" data-field="x_minimum" value="<?= $Page->minimum->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->minimum->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->minimum->formatPattern()) ?>"<?= $Page->minimum->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->minimum->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->maximum->Visible) { // maximum ?>
    <div id="r_maximum" class="row"<?= $Page->maximum->rowAttributes() ?>>
        <label for="x_maximum" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_maximum"><?= $Page->maximum->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_maximum" id="z_maximum" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->maximum->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_maximum" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->maximum->getInputTextType() ?>" name="x_maximum" id="x_maximum" data-table="b_account_type" data-field="x_maximum" value="<?= $Page->maximum->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->maximum->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->maximum->formatPattern()) ?>"<?= $Page->maximum->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->maximum->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible) { // int_@ ?>
    <div id="r_int_" class="row"<?= $Page->int_->rowAttributes() ?>>
        <label for="x_int_" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_int_"><?= $Page->int_->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_int_" id="z_int_" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->int_->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_int_" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_type" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->int_->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
    <div id="r_no_of_emi" class="row"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_no_of_emi"><?= $Page->no_of_emi->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_emi->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_no_of_emi" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_type" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->repay_frequency->Visible) { // repay_frequency ?>
    <div id="r_repay_frequency" class="row"<?= $Page->repay_frequency->rowAttributes() ?>>
        <label for="x_repay_frequency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_repay_frequency"><?= $Page->repay_frequency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_repay_frequency" id="z_repay_frequency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->repay_frequency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_repay_frequency" class="ew-search-field ew-search-field-single">
    <select
        id="x_repay_frequency"
        name="x_repay_frequency"
        class="form-select ew-select<?= $Page->repay_frequency->isInvalidClass() ?>"
        <?php if (!$Page->repay_frequency->IsNativeSelect) { ?>
        data-select2-id="fb_account_typesearch_x_repay_frequency"
        <?php } ?>
        data-table="b_account_type"
        data-field="x_repay_frequency"
        data-value-separator="<?= $Page->repay_frequency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->repay_frequency->getPlaceHolder()) ?>"
        <?= $Page->repay_frequency->editAttributes() ?>>
        <?= $Page->repay_frequency->selectOptionListHtml("x_repay_frequency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->repay_frequency->getErrorMessage(false) ?></div>
<?php if (!$Page->repay_frequency->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_typesearch", function() {
    var options = { name: "x_repay_frequency", selectId: "fb_account_typesearch_x_repay_frequency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_typesearch.lists.repay_frequency?.lookupOptions.length) {
        options.data = { id: "x_repay_frequency", form: "fb_account_typesearch" };
    } else {
        options.ajax = { id: "x_repay_frequency", form: "fb_account_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_type.fields.repay_frequency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->one_time_charge->Visible) { // one_time_charge ?>
    <div id="r_one_time_charge" class="row"<?= $Page->one_time_charge->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_one_time_charge"><?= $Page->one_time_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_one_time_charge" id="z_one_time_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->one_time_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_one_time_charge" class="ew-search-field ew-search-field-single">
<template id="tp_x_one_time_charge">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_one_time_charge" name="x_one_time_charge" id="x_one_time_charge"<?= $Page->one_time_charge->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_one_time_charge" class="ew-item-list"></div>
<selection-list hidden
    id="x_one_time_charge[]"
    name="x_one_time_charge[]"
    value="<?= HtmlEncode($Page->one_time_charge->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_one_time_charge"
    data-target="dsl_x_one_time_charge"
    data-repeatcolumn="5"
    class="form-control<?= $Page->one_time_charge->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_one_time_charge"
    data-value-separator="<?= $Page->one_time_charge->displayValueSeparatorAttribute() ?>"
    <?= $Page->one_time_charge->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->one_time_charge->getErrorMessage(false) ?></div>
<?= $Page->one_time_charge->Lookup->getParamTag($Page, "p_x_one_time_charge") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->action_charge->Visible) { // action_charge ?>
    <div id="r_action_charge" class="row"<?= $Page->action_charge->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_action_charge"><?= $Page->action_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_action_charge" id="z_action_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->action_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_action_charge" class="ew-search-field ew-search-field-single">
<template id="tp_x_action_charge">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_action_charge" name="x_action_charge" id="x_action_charge"<?= $Page->action_charge->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_action_charge" class="ew-item-list"></div>
<selection-list hidden
    id="x_action_charge[]"
    name="x_action_charge[]"
    value="<?= HtmlEncode($Page->action_charge->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_action_charge"
    data-target="dsl_x_action_charge"
    data-repeatcolumn="5"
    class="form-control<?= $Page->action_charge->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_action_charge"
    data-value-separator="<?= $Page->action_charge->displayValueSeparatorAttribute() ?>"
    <?= $Page->action_charge->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->action_charge->getErrorMessage(false) ?></div>
<?= $Page->action_charge->Lookup->getParamTag($Page, "p_x_action_charge") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->month_charge->Visible) { // month_charge ?>
    <div id="r_month_charge" class="row"<?= $Page->month_charge->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_month_charge"><?= $Page->month_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_month_charge" id="z_month_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->month_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_month_charge" class="ew-search-field ew-search-field-single">
<template id="tp_x_month_charge">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_month_charge" name="x_month_charge" id="x_month_charge"<?= $Page->month_charge->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_month_charge" class="ew-item-list"></div>
<selection-list hidden
    id="x_month_charge[]"
    name="x_month_charge[]"
    value="<?= HtmlEncode($Page->month_charge->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_month_charge"
    data-target="dsl_x_month_charge"
    data-repeatcolumn="5"
    class="form-control<?= $Page->month_charge->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_month_charge"
    data-value-separator="<?= $Page->month_charge->displayValueSeparatorAttribute() ?>"
    <?= $Page->month_charge->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->month_charge->getErrorMessage(false) ?></div>
<?= $Page->month_charge->Lookup->getParamTag($Page, "p_x_month_charge") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quarter_charge->Visible) { // quarter_charge ?>
    <div id="r_quarter_charge" class="row"<?= $Page->quarter_charge->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_quarter_charge"><?= $Page->quarter_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_quarter_charge" id="z_quarter_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quarter_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_quarter_charge" class="ew-search-field ew-search-field-single">
<template id="tp_x_quarter_charge">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_quarter_charge" name="x_quarter_charge" id="x_quarter_charge"<?= $Page->quarter_charge->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_quarter_charge" class="ew-item-list"></div>
<selection-list hidden
    id="x_quarter_charge[]"
    name="x_quarter_charge[]"
    value="<?= HtmlEncode($Page->quarter_charge->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_quarter_charge"
    data-target="dsl_x_quarter_charge"
    data-repeatcolumn="5"
    class="form-control<?= $Page->quarter_charge->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_quarter_charge"
    data-value-separator="<?= $Page->quarter_charge->displayValueSeparatorAttribute() ?>"
    <?= $Page->quarter_charge->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->quarter_charge->getErrorMessage(false) ?></div>
<?= $Page->quarter_charge->Lookup->getParamTag($Page, "p_x_quarter_charge") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->annual_charge->Visible) { // annual_charge ?>
    <div id="r_annual_charge" class="row"<?= $Page->annual_charge->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_annual_charge"><?= $Page->annual_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_annual_charge" id="z_annual_charge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->annual_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_annual_charge" class="ew-search-field ew-search-field-single">
<template id="tp_x_annual_charge">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="b_account_type" data-field="x_annual_charge" name="x_annual_charge" id="x_annual_charge"<?= $Page->annual_charge->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_annual_charge" class="ew-item-list"></div>
<selection-list hidden
    id="x_annual_charge[]"
    name="x_annual_charge[]"
    value="<?= HtmlEncode($Page->annual_charge->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_annual_charge"
    data-target="dsl_x_annual_charge"
    data-repeatcolumn="2"
    class="form-control<?= $Page->annual_charge->isInvalidClass() ?>"
    data-table="b_account_type"
    data-field="x_annual_charge"
    data-value-separator="<?= $Page->annual_charge->displayValueSeparatorAttribute() ?>"
    <?= $Page->annual_charge->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->annual_charge->getErrorMessage(false) ?></div>
<?= $Page->annual_charge->Lookup->getParamTag($Page, "p_x_annual_charge") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fb_account_typesearch_x_status"
        <?php } ?>
        data-table="b_account_type"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_typesearch", function() {
    var options = { name: "x_status", selectId: "fb_account_typesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_typesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fb_account_typesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fb_account_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_type.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="b_account_type" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_type_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_type_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_account_type" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_typesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_typesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_typesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_typesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_account_typesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_type");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
