<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountIntLogSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_int_log: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_account_int_logsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_account_int_logsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["account_no", [ew.Validators.integer], fields.account_no.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["emi_no", [ew.Validators.integer], fields.emi_no.isInvalid],
            ["emi_date", [ew.Validators.datetime(fields.emi_date.clientFormatPattern)], fields.emi_date.isInvalid],
            ["y_emi_date", [ew.Validators.between], false],
            ["principal", [ew.Validators.float], fields.principal.isInvalid],
            ["emi", [ew.Validators.float], fields.emi.isInvalid],
            ["interest", [ew.Validators.float], fields.interest.isInvalid],
            ["deposited", [ew.Validators.float], fields.deposited.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["y_balance", [ew.Validators.between], false],
            ["description", [], fields.description.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "account_no": <?= $Page->account_no->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_int_logsearch" id="fb_account_int_logsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_int_log">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="b_account_int_log" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
    <div id="r_account_no" class="row"<?= $Page->account_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_account_no"><?= $Page->account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_account_no" id="z_account_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_account_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_account_no"
        name="x_account_no"
        class="form-control ew-select<?= $Page->account_no->isInvalidClass() ?>"
        data-select2-id="fb_account_int_logsearch_x_account_no"
        data-table="b_account_int_log"
        data-field="x_account_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->account_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->account_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>"
        <?= $Page->account_no->editAttributes() ?>>
        <?= $Page->account_no->selectOptionListHtml("x_account_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->account_no->getErrorMessage(false) ?></div>
<?= $Page->account_no->Lookup->getParamTag($Page, "p_x_account_no") ?>
<script>
loadjs.ready("fb_account_int_logsearch", function() {
    var options = { name: "x_account_no", selectId: "fb_account_int_logsearch_x_account_no" };
    if (fb_account_int_logsearch.lists.account_no?.lookupOptions.length) {
        options.data = { id: "x_account_no", form: "fb_account_int_logsearch" };
    } else {
        options.ajax = { id: "x_account_no", form: "fb_account_int_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.b_account_int_log.fields.account_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fb_account_int_logsearch_x_status"
        <?php } ?>
        data-table="b_account_int_log"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_int_logsearch", function() {
    var options = { name: "x_status", selectId: "fb_account_int_logsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_int_logsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fb_account_int_logsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fb_account_int_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_int_log.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_no->Visible) { // emi_no ?>
    <div id="r_emi_no" class="row"<?= $Page->emi_no->rowAttributes() ?>>
        <label for="x_emi_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi_no"><?= $Page->emi_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emi_no" id="z_emi_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_emi_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emi_no->getInputTextType() ?>" name="x_emi_no" id="x_emi_no" data-table="b_account_int_log" data-field="x_emi_no" value="<?= $Page->emi_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_no->formatPattern()) ?>"<?= $Page->emi_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_date->Visible) { // emi_date ?>
    <div id="r_emi_date" class="row"<?= $Page->emi_date->rowAttributes() ?>>
        <label for="x_emi_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi_date"><?= $Page->emi_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_emi_date" id="z_emi_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->emi_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->emi_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_b_account_int_log_emi_date" class="ew-search-field">
<input type="<?= $Page->emi_date->getInputTextType() ?>" name="x_emi_date" id="x_emi_date" data-table="b_account_int_log" data-field="x_emi_date" value="<?= $Page->emi_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->emi_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_date->formatPattern()) ?>"<?= $Page->emi_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_date->getErrorMessage(false) ?></div>
<?php if (!$Page->emi_date->ReadOnly && !$Page->emi_date->Disabled && !isset($Page->emi_date->EditAttrs["readonly"]) && !isset($Page->emi_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_int_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_int_logsearch", "x_emi_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_b_account_int_log_emi_date" class="ew-search-field2 d-none">
<input type="<?= $Page->emi_date->getInputTextType() ?>" name="y_emi_date" id="y_emi_date" data-table="b_account_int_log" data-field="x_emi_date" value="<?= $Page->emi_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->emi_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_date->formatPattern()) ?>"<?= $Page->emi_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_date->getErrorMessage(false) ?></div>
<?php if (!$Page->emi_date->ReadOnly && !$Page->emi_date->Disabled && !isset($Page->emi_date->EditAttrs["readonly"]) && !isset($Page->emi_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_int_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_int_logsearch", "y_emi_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->principal->Visible) { // principal ?>
    <div id="r_principal" class="row"<?= $Page->principal->rowAttributes() ?>>
        <label for="x_principal" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_principal"><?= $Page->principal->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_principal" id="z_principal" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->principal->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_principal" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->principal->getInputTextType() ?>" name="x_principal" id="x_principal" data-table="b_account_int_log" data-field="x_principal" value="<?= $Page->principal->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->principal->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->principal->formatPattern()) ?>"<?= $Page->principal->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->principal->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi->Visible) { // emi ?>
    <div id="r_emi" class="row"<?= $Page->emi->rowAttributes() ?>>
        <label for="x_emi" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_emi"><?= $Page->emi->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emi" id="z_emi" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_emi" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emi->getInputTextType() ?>" name="x_emi" id="x_emi" data-table="b_account_int_log" data-field="x_emi" value="<?= $Page->emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi->formatPattern()) ?>"<?= $Page->emi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->interest->Visible) { // interest ?>
    <div id="r_interest" class="row"<?= $Page->interest->rowAttributes() ?>>
        <label for="x_interest" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_interest"><?= $Page->interest->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_interest" id="z_interest" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->interest->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_interest" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->interest->getInputTextType() ?>" name="x_interest" id="x_interest" data-table="b_account_int_log" data-field="x_interest" value="<?= $Page->interest->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->interest->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->interest->formatPattern()) ?>"<?= $Page->interest->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->interest->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->deposited->Visible) { // deposited ?>
    <div id="r_deposited" class="row"<?= $Page->deposited->rowAttributes() ?>>
        <label for="x_deposited" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_deposited"><?= $Page->deposited->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_deposited" id="z_deposited" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->deposited->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_deposited" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->deposited->getInputTextType() ?>" name="x_deposited" id="x_deposited" data-table="b_account_int_log" data-field="x_deposited" value="<?= $Page->deposited->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deposited->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deposited->formatPattern()) ?>"<?= $Page->deposited->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deposited->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_balance"><?= $Page->balance->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_balance" id="z_balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_b_account_int_log_balance" class="ew-search-field">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="b_account_int_log" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_b_account_int_log_balance" class="ew-search-field2 d-none">
<input type="<?= $Page->balance->getInputTextType() ?>" name="y_balance" id="y_balance" data-table="b_account_int_log" data-field="x_balance" value="<?= $Page->balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="b_account_int_log" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fb_account_int_logsearch_x_operator"
        <?php } ?>
        data-table="b_account_int_log"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_int_logsearch", function() {
    var options = { name: "x_operator", selectId: "fb_account_int_logsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_int_logsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fb_account_int_logsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fb_account_int_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_int_log.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_int_log_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_int_log_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_account_int_log" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_int_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_int_logsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_int_logsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_int_logsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_account_int_logsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_int_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
