<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fb_account_infoupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fb_account_infoupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["b_type", [fields.b_type.visible && fields.b_type.required ? ew.Validators.required(fields.b_type.caption) : null], fields.b_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["branch", [fields.branch.visible && fields.branch.required ? ew.Validators.required(fields.branch.caption) : null], fields.branch.isInvalid],
            ["account_type", [fields.account_type.visible && fields.account_type.required ? ew.Validators.required(fields.account_type.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.account_type.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email, ew.Validators.selected], fields._email.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["sign_image", [fields.sign_image.visible && fields.sign_image.required ? ew.Validators.fileRequired(fields.sign_image.caption) : null], fields.sign_image.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.status.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.aadhaar_no.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null, ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/), ew.Validators.selected], fields.pan_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.fileRequired(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["agent", [fields.agent.visible && fields.agent.required ? ew.Validators.required(fields.agent.caption) : null], fields.agent.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["account_no", [fields.account_no.visible && fields.account_no.required ? ew.Validators.required(fields.account_no.caption) : null], fields.account_no.isInvalid],
            ["loan_amount", [fields.loan_amount.visible && fields.loan_amount.required ? ew.Validators.required(fields.loan_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.loan_amount.isInvalid],
            ["emi_amount", [fields.emi_amount.visible && fields.emi_amount.required ? ew.Validators.required(fields.emi_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.emi_amount.isInvalid],
            ["frequency", [fields.frequency.visible && fields.frequency.required ? ew.Validators.required(fields.frequency.caption) : null], fields.frequency.isInvalid],
            ["disbursement_amount", [fields.disbursement_amount.visible && fields.disbursement_amount.required ? ew.Validators.required(fields.disbursement_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.disbursement_amount.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["d_operator", [fields.d_operator.visible && fields.d_operator.required ? ew.Validators.required(fields.d_operator.caption) : null], fields.d_operator.isInvalid],
            ["d_datetime", [fields.d_datetime.visible && fields.d_datetime.required ? ew.Validators.required(fields.d_datetime.caption) : null], fields.d_datetime.isInvalid],
            ["no_of_emi", [fields.no_of_emi.visible && fields.no_of_emi.required ? ew.Validators.required(fields.no_of_emi.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.no_of_emi.isInvalid],
            ["fund_o", [fields.fund_o.visible && fields.fund_o.required ? ew.Validators.required(fields.fund_o.caption) : null, ew.Validators.float, ew.Validators.selected], fields.fund_o.isInvalid],
            ["fund_o_no", [fields.fund_o_no.visible && fields.fund_o_no.required ? ew.Validators.required(fields.fund_o_no.caption) : null], fields.fund_o_no.isInvalid],
            ["int_", [fields.int_.visible && fields.int_.required ? ew.Validators.required(fields.int_.caption) : null, ew.Validators.float, ew.Validators.selected], fields.int_.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "branch": <?= $Page->branch->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
            "fund_o_no": <?= $Page->fund_o_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_infoupdate" id="fb_account_infoupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_b_account_infoupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->b_type->Visible && (!$Page->isConfirm() || $Page->b_type->multiUpdateSelected())) { // b_type ?>
    <div id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <label for="x_b_type" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_b_type" id="u_b_type" class="form-check-input ew-multi-select" value="1"<?= $Page->b_type->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_b_type"><?= $Page->b_type->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_b_type" id="u_b_type" value="<?= $Page->b_type->MultiUpdate ?>">
            <?= $Page->b_type->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_type->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_b_type">
                    <select
                        id="x_b_type"
                        name="x_b_type"
                        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
                        <?php if (!$Page->b_type->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_b_type"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_b_type"
                        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
                        <?= $Page->b_type->editAttributes() ?>>
                        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
                    </select>
                    <?= $Page->b_type->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage() ?></div>
                <?php if (!$Page->b_type->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_b_type", selectId: "fb_account_infoupdate_x_b_type" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.b_type?.lookupOptions.length) {
                        options.data = { id: "x_b_type", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_b_type", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.b_type.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_b_type">
                <span<?= $Page->b_type->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->b_type->getDisplayValue($Page->b_type->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_b_type" data-hidden="1" name="x_b_type" id="x_b_type" value="<?= HtmlEncode($Page->b_type->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->branch->Visible && (!$Page->isConfirm() || $Page->branch->multiUpdateSelected())) { // branch ?>
    <div id="r_branch"<?= $Page->branch->rowAttributes() ?>>
        <label for="x_branch" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_branch" id="u_branch" class="form-check-input ew-multi-select" value="1"<?= $Page->branch->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_branch"><?= $Page->branch->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_branch" id="u_branch" value="<?= $Page->branch->MultiUpdate ?>">
            <?= $Page->branch->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->branch->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_branch">
                    <select
                        id="x_branch"
                        name="x_branch"
                        class="form-select ew-select<?= $Page->branch->isInvalidClass() ?>"
                        <?php if (!$Page->branch->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_branch"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_branch"
                        data-value-separator="<?= $Page->branch->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->branch->getPlaceHolder()) ?>"
                        <?= $Page->branch->editAttributes() ?>>
                        <?= $Page->branch->selectOptionListHtml("x_branch") ?>
                    </select>
                    <?= $Page->branch->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->branch->getErrorMessage() ?></div>
                <?= $Page->branch->Lookup->getParamTag($Page, "p_x_branch") ?>
                <?php if (!$Page->branch->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_branch", selectId: "fb_account_infoupdate_x_branch" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.branch?.lookupOptions.length) {
                        options.data = { id: "x_branch", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_branch", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.branch.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_branch">
                <span<?= $Page->branch->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->branch->getDisplayValue($Page->branch->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_branch" data-hidden="1" name="x_branch" id="x_branch" value="<?= HtmlEncode($Page->branch->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_type->Visible && (!$Page->isConfirm() || $Page->account_type->multiUpdateSelected())) { // account_type ?>
    <div id="r_account_type"<?= $Page->account_type->rowAttributes() ?>>
        <label for="x_account_type" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_account_type" id="u_account_type" class="form-check-input ew-multi-select" value="1"<?= $Page->account_type->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_account_type"><?= $Page->account_type->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_account_type" id="u_account_type" value="<?= $Page->account_type->MultiUpdate ?>">
            <?= $Page->account_type->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_type->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_account_type">
                <input type="<?= $Page->account_type->getInputTextType() ?>" name="x_account_type" id="x_account_type" data-table="b_account_info" data-field="x_account_type" value="<?= $Page->account_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->account_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_type->formatPattern()) ?>"<?= $Page->account_type->editAttributes() ?> aria-describedby="x_account_type_help">
                <?= $Page->account_type->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->account_type->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_account_type">
                <span<?= $Page->account_type->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->account_type->getDisplayValue($Page->account_type->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_account_type" data-hidden="1" name="x_account_type" id="x_account_type" value="<?= HtmlEncode($Page->account_type->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible && (!$Page->isConfirm() || $Page->type->multiUpdateSelected())) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_type" id="u_type" class="form-check-input ew-multi-select" value="1"<?= $Page->type->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_type"><?= $Page->type->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_type" id="u_type" value="<?= $Page->type->MultiUpdate ?>">
            <?= $Page->type->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_type">
                    <select
                        id="x_type"
                        name="x_type"
                        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
                        <?php if (!$Page->type->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_type"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_type"
                        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
                        <?= $Page->type->editAttributes() ?>>
                        <?= $Page->type->selectOptionListHtml("x_type") ?>
                    </select>
                    <?= $Page->type->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
                <?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
                <?php if (!$Page->type->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_type", selectId: "fb_account_infoupdate_x_type" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.type?.lookupOptions.length) {
                        options.data = { id: "x_type", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_type", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.type.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_type">
                <span<?= $Page->type->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->type->getDisplayValue($Page->type->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_type" data-hidden="1" name="x_type" id="x_type" value="<?= HtmlEncode($Page->type->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible && (!$Page->isConfirm() || $Page->formal_name->multiUpdateSelected())) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_formal_name" id="u_formal_name" class="form-check-input ew-multi-select" value="1"<?= $Page->formal_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_formal_name"><?= $Page->formal_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_formal_name" id="u_formal_name" value="<?= $Page->formal_name->MultiUpdate ?>">
            <?= $Page->formal_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_formal_name">
                <input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
                <?= $Page->formal_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_formal_name">
                <span<?= $Page->formal_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->formal_name->getDisplayValue($Page->formal_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_formal_name" data-hidden="1" name="x_formal_name" id="x_formal_name" value="<?= HtmlEncode($Page->formal_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible && (!$Page->isConfirm() || $Page->mobile->multiUpdateSelected())) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mobile" id="u_mobile" class="form-check-input ew-multi-select" value="1"<?= $Page->mobile->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mobile"><?= $Page->mobile->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mobile" id="u_mobile" value="<?= $Page->mobile->MultiUpdate ?>">
            <?= $Page->mobile->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_mobile">
                <input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="b_account_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
                <?= $Page->mobile->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_mobile">
                <span<?= $Page->mobile->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mobile->getDisplayValue($Page->mobile->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_mobile" data-hidden="1" name="x_mobile" id="x_mobile" value="<?= HtmlEncode($Page->mobile->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible && (!$Page->isConfirm() || $Page->_email->multiUpdateSelected())) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?= $Page->_email->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__email"><?= $Page->_email->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u__email" id="u__email" value="<?= $Page->_email->MultiUpdate ?>">
            <?= $Page->_email->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info__email">
                <input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
                <?= $Page->_email->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info__email">
                <span<?= $Page->_email->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_email->getDisplayValue($Page->_email->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x__email" data-hidden="1" name="x__email" id="x__email" value="<?= HtmlEncode($Page->_email->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible && (!$Page->isConfirm() || $Page->image->multiUpdateSelected())) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?= $Page->image->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_image"><?= $Page->image->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_image" id="u_image" value="<?= $Page->image->MultiUpdate ?>">
            <?= $Page->image->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_image">
                <div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
                        <?= $Page->image->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_image">
                <div id="fd_x_image">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= $Page->image->editAttributes() ?>
                    >
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sign_image->Visible && (!$Page->isConfirm() || $Page->sign_image->multiUpdateSelected())) { // sign_image ?>
    <div id="r_sign_image"<?= $Page->sign_image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_sign_image" id="u_sign_image" class="form-check-input ew-multi-select" value="1"<?= $Page->sign_image->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_sign_image"><?= $Page->sign_image->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_sign_image" id="u_sign_image" value="<?= $Page->sign_image->MultiUpdate ?>">
            <?= $Page->sign_image->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sign_image->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_sign_image">
                <div id="fd_x_sign_image" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_sign_image"
                        name="x_sign_image"
                        class="form-control ew-file-input"
                        title="<?= $Page->sign_image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_sign_image"
                        data-size="255"
                        data-accept-file-types="<?= $Page->sign_image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->sign_image->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->sign_image->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->sign_image->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_sign_image_help"
                        <?= ($Page->sign_image->ReadOnly || $Page->sign_image->Disabled) ? " disabled" : "" ?>
                        <?= $Page->sign_image->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
                    <?= $Page->sign_image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->sign_image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_sign_image" id= "fn_x_sign_image" value="<?= $Page->sign_image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="<?= (Post("fa_x_sign_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_sign_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_sign_image">
                <div id="fd_x_sign_image">
                    <input
                        type="file"
                        id="x_sign_image"
                        name="x_sign_image"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->sign_image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_sign_image"
                        data-size="255"
                        data-accept-file-types="<?= $Page->sign_image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->sign_image->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->sign_image->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->sign_image->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_sign_image_help"
                        <?= $Page->sign_image->editAttributes() ?>
                    >
                    <?= $Page->sign_image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->sign_image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_sign_image" id= "fn_x_sign_image" value="<?= $Page->sign_image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="<?= (Post("fa_x_sign_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_sign_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible && (!$Page->isConfirm() || $Page->status->multiUpdateSelected())) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?= $Page->status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_status"><?= $Page->status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_status" id="u_status" value="<?= $Page->status->MultiUpdate ?>">
            <?= $Page->status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_status">
                <?php
                if (IsRTL()) {
                    $Page->status->EditAttrs["dir"] = "rtl";
                }
                ?>
                <span id="as_x_status" class="ew-auto-suggest">
                    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
                </span>
                <selection-list hidden class="form-control" data-table="b_account_info" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
                <?= $Page->status->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    fb_account_infoupdate.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.b_account_info.fields.status.autoSuggestOptions));
                });
                </script>
                <?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_status">
                <span<?= $Page->status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible && (!$Page->isConfirm() || $Page->aadhaar_no->multiUpdateSelected())) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_aadhaar_no" id="u_aadhaar_no" class="form-check-input ew-multi-select" value="1"<?= $Page->aadhaar_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_aadhaar_no" id="u_aadhaar_no" value="<?= $Page->aadhaar_no->MultiUpdate ?>">
            <?= $Page->aadhaar_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_aadhaar_no">
                <input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="b_account_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
                <?= $Page->aadhaar_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_aadhaar_no">
                <span<?= $Page->aadhaar_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->aadhaar_no->getDisplayValue($Page->aadhaar_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_aadhaar_no" data-hidden="1" name="x_aadhaar_no" id="x_aadhaar_no" value="<?= HtmlEncode($Page->aadhaar_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible && (!$Page->isConfirm() || $Page->pan_no->multiUpdateSelected())) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_pan_no" id="u_pan_no" class="form-check-input ew-multi-select" value="1"<?= $Page->pan_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_pan_no"><?= $Page->pan_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_pan_no" id="u_pan_no" value="<?= $Page->pan_no->MultiUpdate ?>">
            <?= $Page->pan_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_pan_no">
                <input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="b_account_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
                <?= $Page->pan_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_pan_no">
                <span<?= $Page->pan_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pan_no->getDisplayValue($Page->pan_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_pan_no" data-hidden="1" name="x_pan_no" id="x_pan_no" value="<?= HtmlEncode($Page->pan_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible && (!$Page->isConfirm() || $Page->id_proof->multiUpdateSelected())) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?= $Page->id_proof->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_id_proof"><?= $Page->id_proof->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_id_proof" id="u_id_proof" value="<?= $Page->id_proof->MultiUpdate ?>">
            <?= $Page->id_proof->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_id_proof">
                <div id="fd_x_id_proof" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= ($Page->id_proof->ReadOnly || $Page->id_proof->Disabled) ? " disabled" : "" ?>
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_id_proof">
                <div id="fd_x_id_proof">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible && (!$Page->isConfirm() || $Page->agent->multiUpdateSelected())) { // agent ?>
    <div id="r_agent"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_agent" id="u_agent" class="form-check-input ew-multi-select" value="1"<?= $Page->agent->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_agent"><?= $Page->agent->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_agent" id="u_agent" value="<?= $Page->agent->MultiUpdate ?>">
            <?= $Page->agent->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent">
                    <select
                        id="x_agent"
                        name="x_agent"
                        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
                        <?php if (!$Page->agent->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_agent"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_agent"
                        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
                        <?= $Page->agent->editAttributes() ?>>
                        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
                    </select>
                    <?= $Page->agent->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
                <?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
                <?php if (!$Page->agent->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_agent", selectId: "fb_account_infoupdate_x_agent" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.agent?.lookupOptions.length) {
                        options.data = { id: "x_agent", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_agent", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.agent.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent">
                <span<?= $Page->agent->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->agent->getDisplayValue($Page->agent->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_agent" data-hidden="1" name="x_agent" id="x_agent" value="<?= HtmlEncode($Page->agent->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible && (!$Page->isConfirm() || $Page->other_details->multiUpdateSelected())) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?= $Page->other_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_other_details"><?= $Page->other_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_other_details" id="u_other_details" value="<?= $Page->other_details->MultiUpdate ?>">
            <?= $Page->other_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_other_details">
                <input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="b_account_info" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help">
                <?= $Page->other_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_other_details">
                <span<?= $Page->other_details->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->other_details->getDisplayValue($Page->other_details->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_other_details" data-hidden="1" name="x_other_details" id="x_other_details" value="<?= HtmlEncode($Page->other_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible && (!$Page->isConfirm() || $Page->bank_name->multiUpdateSelected())) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label for="x_bank_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_name" id="u_bank_name" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_name"><?= $Page->bank_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_name" id="u_bank_name" value="<?= $Page->bank_name->MultiUpdate ?>">
            <?= $Page->bank_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_bank_name">
                <input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="b_account_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
                <?= $Page->bank_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_bank_name">
                <span<?= $Page->bank_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_name->getDisplayValue($Page->bank_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_bank_name" data-hidden="1" name="x_bank_name" id="x_bank_name" value="<?= HtmlEncode($Page->bank_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible && (!$Page->isConfirm() || $Page->bank_ifsc_code->multiUpdateSelected())) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_ifsc_code" id="u_bank_ifsc_code" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_ifsc_code->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_ifsc_code" id="u_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->MultiUpdate ?>">
            <?= $Page->bank_ifsc_code->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_bank_ifsc_code">
                <input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="b_account_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
                <?= $Page->bank_ifsc_code->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_bank_ifsc_code">
                <span<?= $Page->bank_ifsc_code->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_ifsc_code->getDisplayValue($Page->bank_ifsc_code->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_bank_ifsc_code" data-hidden="1" name="x_bank_ifsc_code" id="x_bank_ifsc_code" value="<?= HtmlEncode($Page->bank_ifsc_code->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible && (!$Page->isConfirm() || $Page->bank_account_no->multiUpdateSelected())) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_bank_account_no" id="u_bank_account_no" class="form-check-input ew-multi-select" value="1"<?= $Page->bank_account_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_bank_account_no"><?= $Page->bank_account_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_bank_account_no" id="u_bank_account_no" value="<?= $Page->bank_account_no->MultiUpdate ?>">
            <?= $Page->bank_account_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_account_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_bank_account_no">
                <input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="b_account_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
                <?= $Page->bank_account_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_bank_account_no">
                <span<?= $Page->bank_account_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->bank_account_no->getDisplayValue($Page->bank_account_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_bank_account_no" data-hidden="1" name="x_bank_account_no" id="x_bank_account_no" value="<?= HtmlEncode($Page->bank_account_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible && (!$Page->isConfirm() || $Page->loan_amount->multiUpdateSelected())) { // loan_amount ?>
    <div id="r_loan_amount"<?= $Page->loan_amount->rowAttributes() ?>>
        <label for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_loan_amount" id="u_loan_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->loan_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_loan_amount"><?= $Page->loan_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_loan_amount" id="u_loan_amount" value="<?= $Page->loan_amount->MultiUpdate ?>">
            <?= $Page->loan_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loan_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_loan_amount">
                <input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_info" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?> aria-describedby="x_loan_amount_help">
                <?= $Page->loan_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_loan_amount">
                <span<?= $Page->loan_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->loan_amount->getDisplayValue($Page->loan_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_loan_amount" data-hidden="1" name="x_loan_amount" id="x_loan_amount" value="<?= HtmlEncode($Page->loan_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible && (!$Page->isConfirm() || $Page->emi_amount->multiUpdateSelected())) { // emi_amount ?>
    <div id="r_emi_amount"<?= $Page->emi_amount->rowAttributes() ?>>
        <label for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_emi_amount" id="u_emi_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->emi_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_emi_amount"><?= $Page->emi_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_emi_amount" id="u_emi_amount" value="<?= $Page->emi_amount->MultiUpdate ?>">
            <?= $Page->emi_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_emi_amount">
                <input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_info" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?> aria-describedby="x_emi_amount_help">
                <?= $Page->emi_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_emi_amount">
                <span<?= $Page->emi_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->emi_amount->getDisplayValue($Page->emi_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_emi_amount" data-hidden="1" name="x_emi_amount" id="x_emi_amount" value="<?= HtmlEncode($Page->emi_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible && (!$Page->isConfirm() || $Page->frequency->multiUpdateSelected())) { // frequency ?>
    <div id="r_frequency"<?= $Page->frequency->rowAttributes() ?>>
        <label for="x_frequency" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_frequency" id="u_frequency" class="form-check-input ew-multi-select" value="1"<?= $Page->frequency->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_frequency"><?= $Page->frequency->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_frequency" id="u_frequency" value="<?= $Page->frequency->MultiUpdate ?>">
            <?= $Page->frequency->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->frequency->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_frequency">
                    <select
                        id="x_frequency"
                        name="x_frequency"
                        class="form-select ew-select<?= $Page->frequency->isInvalidClass() ?>"
                        <?php if (!$Page->frequency->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_frequency"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_frequency"
                        data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->frequency->getPlaceHolder()) ?>"
                        <?= $Page->frequency->editAttributes() ?>>
                        <?= $Page->frequency->selectOptionListHtml("x_frequency") ?>
                    </select>
                    <?= $Page->frequency->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->frequency->getErrorMessage() ?></div>
                <?php if (!$Page->frequency->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_frequency", selectId: "fb_account_infoupdate_x_frequency" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.frequency?.lookupOptions.length) {
                        options.data = { id: "x_frequency", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_frequency", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.frequency.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_frequency">
                <span<?= $Page->frequency->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->frequency->getDisplayValue($Page->frequency->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_frequency" data-hidden="1" name="x_frequency" id="x_frequency" value="<?= HtmlEncode($Page->frequency->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible && (!$Page->isConfirm() || $Page->disbursement_amount->multiUpdateSelected())) { // disbursement_amount ?>
    <div id="r_disbursement_amount"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_disbursement_amount" id="u_disbursement_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->disbursement_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_disbursement_amount"><?= $Page->disbursement_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_disbursement_amount" id="u_disbursement_amount" value="<?= $Page->disbursement_amount->MultiUpdate ?>">
            <?= $Page->disbursement_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->disbursement_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_disbursement_amount">
                <input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_info" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?> aria-describedby="x_disbursement_amount_help">
                <?= $Page->disbursement_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_disbursement_amount">
                <span<?= $Page->disbursement_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->disbursement_amount->getDisplayValue($Page->disbursement_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_disbursement_amount" data-hidden="1" name="x_disbursement_amount" id="x_disbursement_amount" value="<?= HtmlEncode($Page->disbursement_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible && (!$Page->isConfirm() || $Page->operator->multiUpdateSelected())) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?= $Page->operator->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_operator"><?= $Page->operator->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_operator" id="u_operator" value="<?= $Page->operator->MultiUpdate ?>">
            <?= $Page->operator->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_operator">
                <span<?= $Page->operator->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->operator->getDisplayValue($Page->operator->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible && (!$Page->isConfirm() || $Page->datetime->multiUpdateSelected())) { // datetime ?>
    <div id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?= $Page->datetime->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_datetime"><?= $Page->datetime->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_datetime" id="u_datetime" value="<?= $Page->datetime->MultiUpdate ?>">
            <?= $Page->datetime->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_datetime">
                <span<?= $Page->datetime->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->datetime->getDisplayValue($Page->datetime->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_operator->Visible && (!$Page->isConfirm() || $Page->d_operator->multiUpdateSelected())) { // d_operator ?>
    <div id="r_d_operator"<?= $Page->d_operator->rowAttributes() ?>>
        <label for="x_d_operator" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_d_operator" id="u_d_operator" class="form-check-input ew-multi-select" value="1"<?= $Page->d_operator->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_d_operator"><?= $Page->d_operator->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_d_operator" id="u_d_operator" value="<?= $Page->d_operator->MultiUpdate ?>">
            <?= $Page->d_operator->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_operator->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_d_operator">
                <span<?= $Page->d_operator->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->d_operator->getDisplayValue($Page->d_operator->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_d_operator" data-hidden="1" name="x_d_operator" id="x_d_operator" value="<?= HtmlEncode($Page->d_operator->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_datetime->Visible && (!$Page->isConfirm() || $Page->d_datetime->multiUpdateSelected())) { // d_datetime ?>
    <div id="r_d_datetime"<?= $Page->d_datetime->rowAttributes() ?>>
        <label for="x_d_datetime" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_d_datetime" id="u_d_datetime" class="form-check-input ew-multi-select" value="1"<?= $Page->d_datetime->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_d_datetime"><?= $Page->d_datetime->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_d_datetime" id="u_d_datetime" value="<?= $Page->d_datetime->MultiUpdate ?>">
            <?= $Page->d_datetime->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_datetime->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_d_datetime">
                <span<?= $Page->d_datetime->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->d_datetime->getDisplayValue($Page->d_datetime->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_d_datetime" data-hidden="1" name="x_d_datetime" id="x_d_datetime" value="<?= HtmlEncode($Page->d_datetime->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible && (!$Page->isConfirm() || $Page->no_of_emi->multiUpdateSelected())) { // no_of_emi ?>
    <div id="r_no_of_emi"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_no_of_emi" id="u_no_of_emi" class="form-check-input ew-multi-select" value="1"<?= $Page->no_of_emi->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_no_of_emi"><?= $Page->no_of_emi->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_no_of_emi" id="u_no_of_emi" value="<?= $Page->no_of_emi->MultiUpdate ?>">
            <?= $Page->no_of_emi->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_emi->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_no_of_emi">
                <input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_info" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?> aria-describedby="x_no_of_emi_help">
                <?= $Page->no_of_emi->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_no_of_emi">
                <span<?= $Page->no_of_emi->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->no_of_emi->getDisplayValue($Page->no_of_emi->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_no_of_emi" data-hidden="1" name="x_no_of_emi" id="x_no_of_emi" value="<?= HtmlEncode($Page->no_of_emi->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fund_o->Visible && (!$Page->isConfirm() || $Page->fund_o->multiUpdateSelected())) { // fund_o ?>
    <div id="r_fund_o"<?= $Page->fund_o->rowAttributes() ?>>
        <label for="x_fund_o" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_fund_o" id="u_fund_o" class="form-check-input ew-multi-select" value="1"<?= $Page->fund_o->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_fund_o"><?= $Page->fund_o->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_fund_o" id="u_fund_o" value="<?= $Page->fund_o->MultiUpdate ?>">
            <?= $Page->fund_o->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fund_o->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_fund_o">
                <input type="<?= $Page->fund_o->getInputTextType() ?>" name="x_fund_o" id="x_fund_o" data-table="b_account_info" data-field="x_fund_o" value="<?= $Page->fund_o->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->fund_o->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fund_o->formatPattern()) ?>"<?= $Page->fund_o->editAttributes() ?> aria-describedby="x_fund_o_help">
                <?= $Page->fund_o->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->fund_o->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_fund_o">
                <span<?= $Page->fund_o->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->fund_o->getDisplayValue($Page->fund_o->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_fund_o" data-hidden="1" name="x_fund_o" id="x_fund_o" value="<?= HtmlEncode($Page->fund_o->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fund_o_no->Visible && (!$Page->isConfirm() || $Page->fund_o_no->multiUpdateSelected())) { // fund_o_no ?>
    <div id="r_fund_o_no"<?= $Page->fund_o_no->rowAttributes() ?>>
        <label for="x_fund_o_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_fund_o_no" id="u_fund_o_no" class="form-check-input ew-multi-select" value="1"<?= $Page->fund_o_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_fund_o_no"><?= $Page->fund_o_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_fund_o_no" id="u_fund_o_no" value="<?= $Page->fund_o_no->MultiUpdate ?>">
            <?= $Page->fund_o_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fund_o_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_fund_o_no">
                    <select
                        id="x_fund_o_no"
                        name="x_fund_o_no"
                        class="form-select ew-select<?= $Page->fund_o_no->isInvalidClass() ?>"
                        <?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
                        data-select2-id="fb_account_infoupdate_x_fund_o_no"
                        <?php } ?>
                        data-table="b_account_info"
                        data-field="x_fund_o_no"
                        data-value-separator="<?= $Page->fund_o_no->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->fund_o_no->getPlaceHolder()) ?>"
                        <?= $Page->fund_o_no->editAttributes() ?>>
                        <?= $Page->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
                    </select>
                    <?= $Page->fund_o_no->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->fund_o_no->getErrorMessage() ?></div>
                <?= $Page->fund_o_no->Lookup->getParamTag($Page, "p_x_fund_o_no") ?>
                <?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_infoupdate", function() {
                    var options = { name: "x_fund_o_no", selectId: "fb_account_infoupdate_x_fund_o_no" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_infoupdate.lists.fund_o_no?.lookupOptions.length) {
                        options.data = { id: "x_fund_o_no", form: "fb_account_infoupdate" };
                    } else {
                        options.ajax = { id: "x_fund_o_no", form: "fb_account_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.fund_o_no.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_fund_o_no">
                <span<?= $Page->fund_o_no->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->fund_o_no->getDisplayValue($Page->fund_o_no->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info" data-field="x_fund_o_no" data-hidden="1" name="x_fund_o_no" id="x_fund_o_no" value="<?= HtmlEncode($Page->fund_o_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible && (!$Page->isConfirm() || $Page->int_->multiUpdateSelected())) { // int_@ ?>
    <div id="r_int_"<?= $Page->int_->rowAttributes() ?>>
        <label for="x_int_" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_int_" id="u_int_" class="form-check-input ew-multi-select" value="1"<?= $Page->int_->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_int_"><?= $Page->int_->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_int_" id="u_int_" value="<?= $Page->int_->MultiUpdate ?>">
            <?= $Page->int_->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->int_->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_int_">
                <input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_info" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?> aria-describedby="x_int__help">
                <?= $Page->int_->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->int_->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_int_">
                <span<?= $Page->int_->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->int_->getDisplayValue($Page->int_->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info" data-field="x_int_" data-hidden="1" name="x_int_" id="x_int_" value="<?= HtmlEncode($Page->int_->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_infoupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_infoupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_infoupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fb_account_infoupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
