<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fb_account_infosrch" id="fb_account_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fb_account_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info: currentTable } });
var currentForm;
var fb_account_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_account_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["formal_name", [], fields.formal_name.isInvalid],
            ["agent", [], fields.agent.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "agent": <?= $Page->agent->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
<?php
if (!$Page->formal_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_formal_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->formal_name->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_formal_name" class="ew-search-caption ew-label"><?= $Page->formal_name->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE">
</div>
        </div>
        <div id="el_b_account_info_formal_name" class="ew-search-field">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
<?php
if (!$Page->agent->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_agent" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->agent->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_agent" class="ew-search-caption ew-label"><?= $Page->agent->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_agent" id="z_agent" value="LIKE">
</div>
        </div>
        <div id="el_b_account_info_agent" class="ew-search-field">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fb_account_infosrch_x_agent"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infosrch", function() {
    var options = { name: "x_agent", selectId: "fb_account_infosrch_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infosrch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fb_account_infosrch" };
    } else {
        options.ajax = { id: "x_agent", form: "fb_account_infosrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
<?php
if (!$Page->datetime->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_datetime" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->datetime->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_datetime" class="ew-search-caption ew-label"><?= $Page->datetime->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_b_account_info_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_account_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_infosrch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_b_account_info_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="b_account_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_infosrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_infosrch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fb_account_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fb_account_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fb_account_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fb_account_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fb_account_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fb_account_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fb_account_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_b_account_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_b_account_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_b_account_info_id" class="b_account_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
        <th data-name="b_type" class="<?= $Page->b_type->headerCellClass() ?>"><div id="elh_b_account_info_b_type" class="b_account_info_b_type"><?= $Page->renderFieldHeader($Page->b_type) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_grp" class="b_account_info_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->branch->Visible) { // branch ?>
        <th data-name="branch" class="<?= $Page->branch->headerCellClass() ?>"><div id="elh_b_account_info_branch" class="b_account_info_branch"><?= $Page->renderFieldHeader($Page->branch) ?></div></th>
<?php } ?>
<?php if ($Page->account_type->Visible) { // account_type ?>
        <th data-name="account_type" class="<?= $Page->account_type->headerCellClass() ?>"><div id="elh_b_account_info_account_type" class="b_account_info_account_type"><?= $Page->renderFieldHeader($Page->account_type) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_b_account_info_type" class="b_account_info_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
        <th data-name="formal_name" class="<?= $Page->formal_name->headerCellClass() ?>"><div id="elh_b_account_info_formal_name" class="b_account_info_formal_name"><?= $Page->renderFieldHeader($Page->formal_name) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_b_account_info_mobile" class="b_account_info_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
        <th data-name="agent" class="<?= $Page->agent->headerCellClass() ?>"><div id="elh_b_account_info_agent" class="b_account_info_agent"><?= $Page->renderFieldHeader($Page->agent) ?></div></th>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
        <th data-name="account_no" class="<?= $Page->account_no->headerCellClass() ?>"><div id="elh_b_account_info_account_no" class="b_account_info_account_no"><?= $Page->renderFieldHeader($Page->account_no) ?></div></th>
<?php } ?>
<?php if ($Page->loan_amount->Visible) { // loan_amount ?>
        <th data-name="loan_amount" class="<?= $Page->loan_amount->headerCellClass() ?>"><div id="elh_b_account_info_loan_amount" class="b_account_info_loan_amount"><?= $Page->renderFieldHeader($Page->loan_amount) ?></div></th>
<?php } ?>
<?php if ($Page->emi_amount->Visible) { // emi_amount ?>
        <th data-name="emi_amount" class="<?= $Page->emi_amount->headerCellClass() ?>"><div id="elh_b_account_info_emi_amount" class="b_account_info_emi_amount"><?= $Page->renderFieldHeader($Page->emi_amount) ?></div></th>
<?php } ?>
<?php if ($Page->frequency->Visible) { // frequency ?>
        <th data-name="frequency" class="<?= $Page->frequency->headerCellClass() ?>"><div id="elh_b_account_info_frequency" class="b_account_info_frequency"><?= $Page->renderFieldHeader($Page->frequency) ?></div></th>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
        <th data-name="disbursement_amount" class="<?= $Page->disbursement_amount->headerCellClass() ?>"><div id="elh_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount"><?= $Page->renderFieldHeader($Page->disbursement_amount) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_b_account_info_datetime" class="b_account_info_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
        <th data-name="otp_delivery_datetime" class="<?= $Page->otp_delivery_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime"><?= $Page->renderFieldHeader($Page->otp_delivery_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
        <th data-name="otp_verify_datetime" class="<?= $Page->otp_verify_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime"><?= $Page->renderFieldHeader($Page->otp_verify_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
        <th data-name="no_of_emi" class="<?= $Page->no_of_emi->headerCellClass() ?>"><div id="elh_b_account_info_no_of_emi" class="b_account_info_no_of_emi"><?= $Page->renderFieldHeader($Page->no_of_emi) ?></div></th>
<?php } ?>
<?php if ($Page->fund_o->Visible) { // fund_o ?>
        <th data-name="fund_o" class="<?= $Page->fund_o->headerCellClass() ?>"><div id="elh_b_account_info_fund_o" class="b_account_info_fund_o"><?= $Page->renderFieldHeader($Page->fund_o) ?></div></th>
<?php } ?>
<?php if ($Page->fund_o_no->Visible) { // fund_o_no ?>
        <th data-name="fund_o_no" class="<?= $Page->fund_o_no->headerCellClass() ?>"><div id="elh_b_account_info_fund_o_no" class="b_account_info_fund_o_no"><?= $Page->renderFieldHeader($Page->fund_o_no) ?></div></th>
<?php } ?>
<?php if ($Page->int_->Visible) { // int_@ ?>
        <th data-name="int_" class="<?= $Page->int_->headerCellClass() ?>"><div id="elh_b_account_info_int_" class="b_account_info_int_"><?= $Page->renderFieldHeader($Page->int_) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_id" class="el_b_account_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_type->Visible) { // b_type ?>
        <td data-name="b_type"<?= $Page->b_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_b_type" class="el_b_account_info_b_type">
<span<?= $Page->b_type->viewAttributes() ?>>
<?= $Page->b_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_grp" class="el_b_account_info_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->branch->Visible) { // branch ?>
        <td data-name="branch"<?= $Page->branch->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_branch" class="el_b_account_info_branch">
<span<?= $Page->branch->viewAttributes() ?>>
<?= $Page->branch->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->account_type->Visible) { // account_type ?>
        <td data-name="account_type"<?= $Page->account_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_account_type" class="el_b_account_info_account_type">
<span<?= $Page->account_type->viewAttributes() ?>>
<?= $Page->account_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_type" class="el_b_account_info_type">
<span<?= $Page->type->viewAttributes() ?>>
<?= $Page->type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->formal_name->Visible) { // formal_name ?>
        <td data-name="formal_name"<?= $Page->formal_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_formal_name" class="el_b_account_info_formal_name">
<span<?= $Page->formal_name->viewAttributes() ?>>
<?= $Page->formal_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_mobile" class="el_b_account_info_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent"<?= $Page->agent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_agent" class="el_b_account_info_agent">
<span<?= $Page->agent->viewAttributes() ?>>
<?= $Page->agent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->account_no->Visible) { // account_no ?>
        <td data-name="account_no"<?= $Page->account_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_account_no" class="el_b_account_info_account_no">
<span<?= $Page->account_no->viewAttributes() ?>>
<?= $Page->account_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->loan_amount->Visible) { // loan_amount ?>
        <td data-name="loan_amount"<?= $Page->loan_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_loan_amount" class="el_b_account_info_loan_amount">
<span<?= $Page->loan_amount->viewAttributes() ?>>
<?= $Page->loan_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emi_amount->Visible) { // emi_amount ?>
        <td data-name="emi_amount"<?= $Page->emi_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_emi_amount" class="el_b_account_info_emi_amount">
<span<?= $Page->emi_amount->viewAttributes() ?>>
<?= $Page->emi_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->frequency->Visible) { // frequency ?>
        <td data-name="frequency"<?= $Page->frequency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_frequency" class="el_b_account_info_frequency">
<span<?= $Page->frequency->viewAttributes() ?>>
<?= $Page->frequency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
        <td data-name="disbursement_amount"<?= $Page->disbursement_amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_disbursement_amount" class="el_b_account_info_disbursement_amount">
<span<?= $Page->disbursement_amount->viewAttributes() ?>>
<?= $Page->disbursement_amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_datetime" class="el_b_account_info_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
        <td data-name="otp_delivery_datetime"<?= $Page->otp_delivery_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_otp_delivery_datetime" class="el_b_account_info_otp_delivery_datetime">
<span<?= $Page->otp_delivery_datetime->viewAttributes() ?>>
<?= $Page->otp_delivery_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
        <td data-name="otp_verify_datetime"<?= $Page->otp_verify_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_otp_verify_datetime" class="el_b_account_info_otp_verify_datetime">
<span<?= $Page->otp_verify_datetime->viewAttributes() ?>>
<?= $Page->otp_verify_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
        <td data-name="no_of_emi"<?= $Page->no_of_emi->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_no_of_emi" class="el_b_account_info_no_of_emi">
<span<?= $Page->no_of_emi->viewAttributes() ?>>
<?= $Page->no_of_emi->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fund_o->Visible) { // fund_o ?>
        <td data-name="fund_o"<?= $Page->fund_o->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_fund_o" class="el_b_account_info_fund_o">
<span<?= $Page->fund_o->viewAttributes() ?>>
<?= $Page->fund_o->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fund_o_no->Visible) { // fund_o_no ?>
        <td data-name="fund_o_no"<?= $Page->fund_o_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_fund_o_no" class="el_b_account_info_fund_o_no">
<span<?= $Page->fund_o_no->viewAttributes() ?>>
<?= $Page->fund_o_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->int_->Visible) { // int_@ ?>
        <td data-name="int_"<?= $Page->int_->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_b_account_info_int_" class="el_b_account_info_int_">
<span<?= $Page->int_->viewAttributes() ?>>
<?= $Page->int_->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_b_account_info_id" class="b_account_info_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->b_type->Visible) { // b_type ?>
        <td data-name="b_type" class="<?= $Page->b_type->footerCellClass() ?>"><span id="elf_b_account_info_b_type" class="b_account_info_b_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_b_account_info_grp" class="b_account_info_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->branch->Visible) { // branch ?>
        <td data-name="branch" class="<?= $Page->branch->footerCellClass() ?>"><span id="elf_b_account_info_branch" class="b_account_info_branch">
        </span></td>
    <?php } ?>
    <?php if ($Page->account_type->Visible) { // account_type ?>
        <td data-name="account_type" class="<?= $Page->account_type->footerCellClass() ?>"><span id="elf_b_account_info_account_type" class="b_account_info_account_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type" class="<?= $Page->type->footerCellClass() ?>"><span id="elf_b_account_info_type" class="b_account_info_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->formal_name->Visible) { // formal_name ?>
        <td data-name="formal_name" class="<?= $Page->formal_name->footerCellClass() ?>"><span id="elf_b_account_info_formal_name" class="b_account_info_formal_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile" class="<?= $Page->mobile->footerCellClass() ?>"><span id="elf_b_account_info_mobile" class="b_account_info_mobile">
        </span></td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent" class="<?= $Page->agent->footerCellClass() ?>"><span id="elf_b_account_info_agent" class="b_account_info_agent">
        </span></td>
    <?php } ?>
    <?php if ($Page->account_no->Visible) { // account_no ?>
        <td data-name="account_no" class="<?= $Page->account_no->footerCellClass() ?>"><span id="elf_b_account_info_account_no" class="b_account_info_account_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->loan_amount->Visible) { // loan_amount ?>
        <td data-name="loan_amount" class="<?= $Page->loan_amount->footerCellClass() ?>"><span id="elf_b_account_info_loan_amount" class="b_account_info_loan_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->loan_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->emi_amount->Visible) { // emi_amount ?>
        <td data-name="emi_amount" class="<?= $Page->emi_amount->footerCellClass() ?>"><span id="elf_b_account_info_emi_amount" class="b_account_info_emi_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->emi_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->frequency->Visible) { // frequency ?>
        <td data-name="frequency" class="<?= $Page->frequency->footerCellClass() ?>"><span id="elf_b_account_info_frequency" class="b_account_info_frequency">
        </span></td>
    <?php } ?>
    <?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
        <td data-name="disbursement_amount" class="<?= $Page->disbursement_amount->footerCellClass() ?>"><span id="elf_b_account_info_disbursement_amount" class="b_account_info_disbursement_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->disbursement_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_b_account_info_datetime" class="b_account_info_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
        <td data-name="otp_delivery_datetime" class="<?= $Page->otp_delivery_datetime->footerCellClass() ?>"><span id="elf_b_account_info_otp_delivery_datetime" class="b_account_info_otp_delivery_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
        <td data-name="otp_verify_datetime" class="<?= $Page->otp_verify_datetime->footerCellClass() ?>"><span id="elf_b_account_info_otp_verify_datetime" class="b_account_info_otp_verify_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
        <td data-name="no_of_emi" class="<?= $Page->no_of_emi->footerCellClass() ?>"><span id="elf_b_account_info_no_of_emi" class="b_account_info_no_of_emi">
        </span></td>
    <?php } ?>
    <?php if ($Page->fund_o->Visible) { // fund_o ?>
        <td data-name="fund_o" class="<?= $Page->fund_o->footerCellClass() ?>"><span id="elf_b_account_info_fund_o" class="b_account_info_fund_o">
        </span></td>
    <?php } ?>
    <?php if ($Page->fund_o_no->Visible) { // fund_o_no ?>
        <td data-name="fund_o_no" class="<?= $Page->fund_o_no->footerCellClass() ?>"><span id="elf_b_account_info_fund_o_no" class="b_account_info_fund_o_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->int_->Visible) { // int_@ ?>
        <td data-name="int_" class="<?= $Page->int_->footerCellClass() ?>"><span id="elf_b_account_info_int_" class="b_account_info_int_">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
