<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fb_account_infoedit" id="fb_account_infoedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fb_account_infoedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fb_account_infoedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["b_type", [fields.b_type.visible && fields.b_type.required ? ew.Validators.required(fields.b_type.caption) : null], fields.b_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["branch", [fields.branch.visible && fields.branch.required ? ew.Validators.required(fields.branch.caption) : null], fields.branch.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["account_type", [fields.account_type.visible && fields.account_type.required ? ew.Validators.required(fields.account_type.caption) : null, ew.Validators.integer], fields.account_type.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["sign_image", [fields.sign_image.visible && fields.sign_image.required ? ew.Validators.fileRequired(fields.sign_image.caption) : null], fields.sign_image.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.integer], fields.aadhaar_no.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null, ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/)], fields.pan_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.fileRequired(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["agent", [fields.agent.visible && fields.agent.required ? ew.Validators.required(fields.agent.caption) : null], fields.agent.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["account_no", [fields.account_no.visible && fields.account_no.required ? ew.Validators.required(fields.account_no.caption) : null], fields.account_no.isInvalid],
            ["loan_amount", [fields.loan_amount.visible && fields.loan_amount.required ? ew.Validators.required(fields.loan_amount.caption) : null, ew.Validators.float], fields.loan_amount.isInvalid],
            ["emi_amount", [fields.emi_amount.visible && fields.emi_amount.required ? ew.Validators.required(fields.emi_amount.caption) : null, ew.Validators.float], fields.emi_amount.isInvalid],
            ["frequency", [fields.frequency.visible && fields.frequency.required ? ew.Validators.required(fields.frequency.caption) : null], fields.frequency.isInvalid],
            ["disbursement_amount", [fields.disbursement_amount.visible && fields.disbursement_amount.required ? ew.Validators.required(fields.disbursement_amount.caption) : null, ew.Validators.float], fields.disbursement_amount.isInvalid],
            ["d_operator", [fields.d_operator.visible && fields.d_operator.required ? ew.Validators.required(fields.d_operator.caption) : null], fields.d_operator.isInvalid],
            ["d_datetime", [fields.d_datetime.visible && fields.d_datetime.required ? ew.Validators.required(fields.d_datetime.caption) : null], fields.d_datetime.isInvalid],
            ["no_of_emi", [fields.no_of_emi.visible && fields.no_of_emi.required ? ew.Validators.required(fields.no_of_emi.caption) : null, ew.Validators.integer], fields.no_of_emi.isInvalid],
            ["fund_o", [fields.fund_o.visible && fields.fund_o.required ? ew.Validators.required(fields.fund_o.caption) : null, ew.Validators.float], fields.fund_o.isInvalid],
            ["fund_o_no", [fields.fund_o_no.visible && fields.fund_o_no.required ? ew.Validators.required(fields.fund_o_no.caption) : null], fields.fund_o_no.isInvalid],
            ["int_", [fields.int_.visible && fields.int_.required ? ew.Validators.required(fields.int_.caption) : null, ew.Validators.float], fields.int_.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "branch": <?= $Page->branch->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
            "fund_o_no": <?= $Page->fund_o_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_b_account_info_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_b_account_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="b_account_info" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
    <div id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <label id="elh_b_account_info_b_type" for="x_b_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_type->caption() ?><?= $Page->b_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_type->cellAttributes() ?>>
<span id="el_b_account_info_b_type">
    <select
        id="x_b_type"
        name="x_b_type"
        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
        <?php if (!$Page->b_type->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_b_type"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_b_type"
        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
        <?= $Page->b_type->editAttributes() ?>>
        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
    </select>
    <?= $Page->b_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage() ?></div>
<?php if (!$Page->b_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_b_type", selectId: "fb_account_infoedit_x_b_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.b_type?.lookupOptions.length) {
        options.data = { id: "x_b_type", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_b_type", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.b_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_b_account_info_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_b_account_info_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="b_account_info" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->branch->Visible) { // branch ?>
    <div id="r_branch"<?= $Page->branch->rowAttributes() ?>>
        <label id="elh_b_account_info_branch" for="x_branch" class="<?= $Page->LeftColumnClass ?>"><?= $Page->branch->caption() ?><?= $Page->branch->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->branch->cellAttributes() ?>>
<span id="el_b_account_info_branch">
    <select
        id="x_branch"
        name="x_branch"
        class="form-select ew-select<?= $Page->branch->isInvalidClass() ?>"
        <?php if (!$Page->branch->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_branch"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_branch"
        data-value-separator="<?= $Page->branch->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->branch->getPlaceHolder()) ?>"
        <?= $Page->branch->editAttributes() ?>>
        <?= $Page->branch->selectOptionListHtml("x_branch") ?>
    </select>
    <?= $Page->branch->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->branch->getErrorMessage() ?></div>
<?= $Page->branch->Lookup->getParamTag($Page, "p_x_branch") ?>
<?php if (!$Page->branch->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_branch", selectId: "fb_account_infoedit_x_branch" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.branch?.lookupOptions.length) {
        options.data = { id: "x_branch", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_branch", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.branch.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_b_account_info_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_b_account_info_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_category"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_category", selectId: "fb_account_infoedit_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_category", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->account_type->Visible) { // account_type ?>
    <div id="r_account_type"<?= $Page->account_type->rowAttributes() ?>>
        <label id="elh_b_account_info_account_type" for="x_account_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->account_type->caption() ?><?= $Page->account_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->account_type->cellAttributes() ?>>
<span id="el_b_account_info_account_type">
<input type="<?= $Page->account_type->getInputTextType() ?>" name="x_account_type" id="x_account_type" data-table="b_account_info" data-field="x_account_type" value="<?= $Page->account_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->account_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_type->formatPattern()) ?>"<?= $Page->account_type->editAttributes() ?> aria-describedby="x_account_type_help">
<?= $Page->account_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->account_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_b_account_info_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_b_account_info_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_type"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_type", selectId: "fb_account_infoedit_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_type", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label id="elh_b_account_info_formal_name" for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->formal_name->caption() ?><?= $Page->formal_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->formal_name->cellAttributes() ?>>
<span id="el_b_account_info_formal_name">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
<?= $Page->formal_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_b_account_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_b_account_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="b_account_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_b_account_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_b_account_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label id="elh_b_account_info_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->image->cellAttributes() ?>>
<span id="el_b_account_info_image">
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="b_account_info"
        data-field="x_image"
        data-size="48"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sign_image->Visible) { // sign_image ?>
    <div id="r_sign_image"<?= $Page->sign_image->rowAttributes() ?>>
        <label id="elh_b_account_info_sign_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sign_image->caption() ?><?= $Page->sign_image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sign_image->cellAttributes() ?>>
<span id="el_b_account_info_sign_image">
<div id="fd_x_sign_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_sign_image"
        name="x_sign_image"
        class="form-control ew-file-input"
        title="<?= $Page->sign_image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="b_account_info"
        data-field="x_sign_image"
        data-size="255"
        data-accept-file-types="<?= $Page->sign_image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->sign_image->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->sign_image->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->sign_image->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_sign_image_help"
        <?= ($Page->sign_image->ReadOnly || $Page->sign_image->Disabled) ? " disabled" : "" ?>
        <?= $Page->sign_image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->sign_image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->sign_image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_sign_image" id= "fn_x_sign_image" value="<?= $Page->sign_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_sign_image" id= "fa_x_sign_image" value="<?= (Post("fa_x_sign_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_sign_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_b_account_info_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_b_account_info_status">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
</span>
<selection-list hidden class="form-control" data-table="b_account_info" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
<?= $Page->status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<script>
loadjs.ready("fb_account_infoedit", function() {
    fb_account_infoedit.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.b_account_info.fields.status.autoSuggestOptions));
});
</script>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label id="elh_b_account_info_aadhaar_no" for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_b_account_info_aadhaar_no">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="b_account_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label id="elh_b_account_info_pan_no" for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pan_no->caption() ?><?= $Page->pan_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pan_no->cellAttributes() ?>>
<span id="el_b_account_info_pan_no">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="b_account_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
<?= $Page->pan_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label id="elh_b_account_info_id_proof" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id_proof->caption() ?><?= $Page->id_proof->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id_proof->cellAttributes() ?>>
<span id="el_b_account_info_id_proof">
<div id="fd_x_id_proof" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_id_proof"
        name="x_id_proof"
        class="form-control ew-file-input"
        title="<?= $Page->id_proof->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="b_account_info"
        data-field="x_id_proof"
        data-size="255"
        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_id_proof_help"
        <?= ($Page->id_proof->ReadOnly || $Page->id_proof->Disabled) ? " disabled" : "" ?>
        <?= $Page->id_proof->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->id_proof->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
<table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent"<?= $Page->agent->rowAttributes() ?>>
        <label id="elh_b_account_info_agent" for="x_agent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agent->caption() ?><?= $Page->agent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agent->cellAttributes() ?>>
<span id="el_b_account_info_agent">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_agent"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <?= $Page->agent->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_agent", selectId: "fb_account_infoedit_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_agent", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label id="elh_b_account_info_other_details" for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_details->caption() ?><?= $Page->other_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_details->cellAttributes() ?>>
<span id="el_b_account_info_other_details">
<input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="b_account_info" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help">
<?= $Page->other_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_name" for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_b_account_info_bank_name">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="b_account_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_ifsc_code" for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_ifsc_code->caption() ?><?= $Page->bank_ifsc_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el_b_account_info_bank_ifsc_code">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="b_account_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
<?= $Page->bank_ifsc_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_account_no" for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_b_account_info_bank_account_no">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="b_account_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
    <div id="r_account_no"<?= $Page->account_no->rowAttributes() ?>>
        <label id="elh_b_account_info_account_no" for="x_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->account_no->caption() ?><?= $Page->account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->account_no->cellAttributes() ?>>
<span id="el_b_account_info_account_no">
<span<?= $Page->account_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->account_no->getDisplayValue($Page->account_no->EditValue))) ?>"></span>
<input type="hidden" data-table="b_account_info" data-field="x_account_no" data-hidden="1" name="x_account_no" id="x_account_no" value="<?= HtmlEncode($Page->account_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible) { // loan_amount ?>
    <div id="r_loan_amount"<?= $Page->loan_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_loan_amount" for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->loan_amount->caption() ?><?= $Page->loan_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->loan_amount->cellAttributes() ?>>
<span id="el_b_account_info_loan_amount">
<input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_info" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?> aria-describedby="x_loan_amount_help">
<?= $Page->loan_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible) { // emi_amount ?>
    <div id="r_emi_amount"<?= $Page->emi_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_emi_amount" for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emi_amount->caption() ?><?= $Page->emi_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emi_amount->cellAttributes() ?>>
<span id="el_b_account_info_emi_amount">
<input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_info" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?> aria-describedby="x_emi_amount_help">
<?= $Page->emi_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible) { // frequency ?>
    <div id="r_frequency"<?= $Page->frequency->rowAttributes() ?>>
        <label id="elh_b_account_info_frequency" for="x_frequency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->frequency->caption() ?><?= $Page->frequency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->frequency->cellAttributes() ?>>
<span id="el_b_account_info_frequency">
    <select
        id="x_frequency"
        name="x_frequency"
        class="form-select ew-select<?= $Page->frequency->isInvalidClass() ?>"
        <?php if (!$Page->frequency->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_frequency"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_frequency"
        data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->frequency->getPlaceHolder()) ?>"
        <?= $Page->frequency->editAttributes() ?>>
        <?= $Page->frequency->selectOptionListHtml("x_frequency") ?>
    </select>
    <?= $Page->frequency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->frequency->getErrorMessage() ?></div>
<?php if (!$Page->frequency->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_frequency", selectId: "fb_account_infoedit_x_frequency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.frequency?.lookupOptions.length) {
        options.data = { id: "x_frequency", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_frequency", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.frequency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
    <div id="r_disbursement_amount"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_disbursement_amount" for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->disbursement_amount->caption() ?><?= $Page->disbursement_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->disbursement_amount->cellAttributes() ?>>
<span id="el_b_account_info_disbursement_amount">
<input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_info" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?> aria-describedby="x_disbursement_amount_help">
<?= $Page->disbursement_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
    <div id="r_no_of_emi"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label id="elh_b_account_info_no_of_emi" for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>"><?= $Page->no_of_emi->caption() ?><?= $Page->no_of_emi->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->no_of_emi->cellAttributes() ?>>
<span id="el_b_account_info_no_of_emi">
<input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_info" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?> aria-describedby="x_no_of_emi_help">
<?= $Page->no_of_emi->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fund_o->Visible) { // fund_o ?>
    <div id="r_fund_o"<?= $Page->fund_o->rowAttributes() ?>>
        <label id="elh_b_account_info_fund_o" for="x_fund_o" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fund_o->caption() ?><?= $Page->fund_o->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fund_o->cellAttributes() ?>>
<span id="el_b_account_info_fund_o">
<input type="<?= $Page->fund_o->getInputTextType() ?>" name="x_fund_o" id="x_fund_o" data-table="b_account_info" data-field="x_fund_o" value="<?= $Page->fund_o->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->fund_o->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fund_o->formatPattern()) ?>"<?= $Page->fund_o->editAttributes() ?> aria-describedby="x_fund_o_help">
<?= $Page->fund_o->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fund_o->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fund_o_no->Visible) { // fund_o_no ?>
    <div id="r_fund_o_no"<?= $Page->fund_o_no->rowAttributes() ?>>
        <label id="elh_b_account_info_fund_o_no" for="x_fund_o_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fund_o_no->caption() ?><?= $Page->fund_o_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fund_o_no->cellAttributes() ?>>
<span id="el_b_account_info_fund_o_no">
    <select
        id="x_fund_o_no"
        name="x_fund_o_no"
        class="form-select ew-select<?= $Page->fund_o_no->isInvalidClass() ?>"
        <?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoedit_x_fund_o_no"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_fund_o_no"
        data-value-separator="<?= $Page->fund_o_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fund_o_no->getPlaceHolder()) ?>"
        <?= $Page->fund_o_no->editAttributes() ?>>
        <?= $Page->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
    </select>
    <?= $Page->fund_o_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->fund_o_no->getErrorMessage() ?></div>
<?= $Page->fund_o_no->Lookup->getParamTag($Page, "p_x_fund_o_no") ?>
<?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoedit", function() {
    var options = { name: "x_fund_o_no", selectId: "fb_account_infoedit_x_fund_o_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoedit.lists.fund_o_no?.lookupOptions.length) {
        options.data = { id: "x_fund_o_no", form: "fb_account_infoedit" };
    } else {
        options.ajax = { id: "x_fund_o_no", form: "fb_account_infoedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.fund_o_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible) { // int_@ ?>
    <div id="r_int_"<?= $Page->int_->rowAttributes() ?>>
        <label id="elh_b_account_info_int_" for="x_int_" class="<?= $Page->LeftColumnClass ?>"><?= $Page->int_->caption() ?><?= $Page->int_->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->int_->cellAttributes() ?>>
<span id="el_b_account_info_int_">
<input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_info" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?> aria-describedby="x_int__help">
<?= $Page->int_->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->int_->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_infoedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_infoedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");\
    $('#x_aadhaar_no').attr('type', 'number');
    $('#x_mobile').attr('type', 'number');
    $('#x_otp').attr('type', 'number');
    $('#x_no_of_emi').attr('type', 'number');
    		var grp = $("#x_grp").val();
    		if (grp == 130101)
    		{
    			$("#r_loan_amount").show();
    			$("#r_emi_amount").show();
    			$("#r_disbursement_amount").show();
    			$("#r_frequency").show();
    			$("#r_fund_o").hide();
    			$("#r_fund_o_no").hide();
    			$("#r_no_of_emi").hide();
    		}
    		else if (grp == 130102)
    		{
    			$("#r_loan_amount").show();
    			$("#r_emi_amount").show();
    			$("#r_disbursement_amount").show();
    			$("#r_frequency").show();
    			$("#r_fund_o").show();
    			$("#r_fund_o_no").show();
    			$("#r_no_of_emi").show();
    		}
    		else if (grp == 230401)
    		{
    			$("#r_loan_amount").hide();
    			$("#r_emi_amount").hide();
    			$("#r_disbursement_amount").hide();
    			$("#r_frequency").hide();
    			$("#r_fund_o").hide();
    			$("#r_fund_o_no").hide();
    			$("#r_no_of_emi").hide();
    		}
});
</script>
