<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoAgentUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info_agent: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fb_account_info_agentupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fb_account_info_agentupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["b_type", [fields.b_type.visible && fields.b_type.required ? ew.Validators.required(fields.b_type.caption) : null], fields.b_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["account_type", [fields.account_type.visible && fields.account_type.required ? ew.Validators.required(fields.account_type.caption) : null], fields.account_type.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null], fields.aadhaar_no.isInvalid],
            ["account_no", [fields.account_no.visible && fields.account_no.required ? ew.Validators.required(fields.account_no.caption) : null], fields.account_no.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email, ew.Validators.selected], fields._email.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.status.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null], fields.pan_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.fileRequired(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["agent", [fields.agent.visible && fields.agent.required ? ew.Validators.required(fields.agent.caption) : null], fields.agent.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["loan_amount", [fields.loan_amount.visible && fields.loan_amount.required ? ew.Validators.required(fields.loan_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.loan_amount.isInvalid],
            ["int_", [fields.int_.visible && fields.int_.required ? ew.Validators.required(fields.int_.caption) : null, ew.Validators.float, ew.Validators.selected], fields.int_.isInvalid],
            ["disbursement_amount", [fields.disbursement_amount.visible && fields.disbursement_amount.required ? ew.Validators.required(fields.disbursement_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.disbursement_amount.isInvalid],
            ["emi_amount", [fields.emi_amount.visible && fields.emi_amount.required ? ew.Validators.required(fields.emi_amount.caption) : null, ew.Validators.float, ew.Validators.selected], fields.emi_amount.isInvalid],
            ["no_of_emi", [fields.no_of_emi.visible && fields.no_of_emi.required ? ew.Validators.required(fields.no_of_emi.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.no_of_emi.isInvalid],
            ["frequency", [fields.frequency.visible && fields.frequency.required ? ew.Validators.required(fields.frequency.caption) : null], fields.frequency.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "account_type": <?= $Page->account_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_info_agentupdate" id="fb_account_info_agentupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_b_account_info_agentupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->b_type->Visible && (!$Page->isConfirm() || $Page->b_type->multiUpdateSelected())) { // b_type ?>
    <div id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <label for="x_b_type" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_b_type" id="u_b_type" class="form-check-input ew-multi-select" value="1"<?= $Page->b_type->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_b_type"><?= $Page->b_type->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_b_type" id="u_b_type" value="<?= $Page->b_type->MultiUpdate ?>">
            <?= $Page->b_type->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_type->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_b_type">
                    <select
                        id="x_b_type"
                        name="x_b_type"
                        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
                        <?php if (!$Page->b_type->IsNativeSelect) { ?>
                        data-select2-id="fb_account_info_agentupdate_x_b_type"
                        <?php } ?>
                        data-table="b_account_info_agent"
                        data-field="x_b_type"
                        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
                        <?= $Page->b_type->editAttributes() ?>>
                        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
                    </select>
                    <?= $Page->b_type->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage() ?></div>
                <?php if (!$Page->b_type->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    var options = { name: "x_b_type", selectId: "fb_account_info_agentupdate_x_b_type" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_info_agentupdate.lists.b_type?.lookupOptions.length) {
                        options.data = { id: "x_b_type", form: "fb_account_info_agentupdate" };
                    } else {
                        options.ajax = { id: "x_b_type", form: "fb_account_info_agentupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.b_type.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_b_type">
                <span<?= $Page->b_type->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->b_type->getDisplayValue($Page->b_type->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_b_type" data-hidden="1" name="x_b_type" id="x_b_type" value="<?= HtmlEncode($Page->b_type->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_type->Visible && (!$Page->isConfirm() || $Page->account_type->multiUpdateSelected())) { // account_type ?>
    <div id="r_account_type"<?= $Page->account_type->rowAttributes() ?>>
        <label for="x_account_type" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_account_type" id="u_account_type" class="form-check-input ew-multi-select" value="1"<?= $Page->account_type->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_account_type"><?= $Page->account_type->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_account_type" id="u_account_type" value="<?= $Page->account_type->MultiUpdate ?>">
            <?= $Page->account_type->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_type->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_account_type">
                    <select
                        id="x_account_type"
                        name="x_account_type"
                        class="form-select ew-select<?= $Page->account_type->isInvalidClass() ?>"
                        <?php if (!$Page->account_type->IsNativeSelect) { ?>
                        data-select2-id="fb_account_info_agentupdate_x_account_type"
                        <?php } ?>
                        data-table="b_account_info_agent"
                        data-field="x_account_type"
                        data-value-separator="<?= $Page->account_type->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->account_type->getPlaceHolder()) ?>"
                        data-ew-action="autofill"
                        <?= $Page->account_type->editAttributes() ?>>
                        <?= $Page->account_type->selectOptionListHtml("x_account_type") ?>
                    </select>
                    <?= $Page->account_type->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->account_type->getErrorMessage() ?></div>
                <?= $Page->account_type->Lookup->getParamTag($Page, "p_x_account_type") ?>
                <?php if (!$Page->account_type->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    var options = { name: "x_account_type", selectId: "fb_account_info_agentupdate_x_account_type" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_info_agentupdate.lists.account_type?.lookupOptions.length) {
                        options.data = { id: "x_account_type", form: "fb_account_info_agentupdate" };
                    } else {
                        options.ajax = { id: "x_account_type", form: "fb_account_info_agentupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.account_type.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_account_type">
                <span<?= $Page->account_type->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->account_type->getDisplayValue($Page->account_type->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_account_type" data-hidden="1" name="x_account_type" id="x_account_type" value="<?= HtmlEncode($Page->account_type->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible && (!$Page->isConfirm() || $Page->account_no->multiUpdateSelected())) { // account_no ?>
    <div id="r_account_no"<?= $Page->account_no->rowAttributes() ?>>
        <label for="x_account_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_account_no" id="u_account_no" class="form-check-input ew-multi-select" value="1"<?= $Page->account_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_account_no"><?= $Page->account_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_account_no" id="u_account_no" value="<?= $Page->account_no->MultiUpdate ?>">
            <?= $Page->account_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_account_no">
                <input type="<?= $Page->account_no->getInputTextType() ?>" name="x_account_no" id="x_account_no" data-table="b_account_info_agent" data-field="x_account_no" value="<?= $Page->account_no->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_no->formatPattern()) ?>"<?= $Page->account_no->editAttributes() ?> aria-describedby="x_account_no_help">
                <?= $Page->account_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->account_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_account_no">
                <span<?= $Page->account_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->account_no->getDisplayValue($Page->account_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_account_no" data-hidden="1" name="x_account_no" id="x_account_no" value="<?= HtmlEncode($Page->account_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible && (!$Page->isConfirm() || $Page->_email->multiUpdateSelected())) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?= $Page->_email->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__email"><?= $Page->_email->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u__email" id="u__email" value="<?= $Page->_email->MultiUpdate ?>">
            <?= $Page->_email->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent__email">
                <input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_info_agent" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
                <?= $Page->_email->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent__email">
                <span<?= $Page->_email->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_email->getDisplayValue($Page->_email->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x__email" data-hidden="1" name="x__email" id="x__email" value="<?= HtmlEncode($Page->_email->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible && (!$Page->isConfirm() || $Page->image->multiUpdateSelected())) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?= $Page->image->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_image"><?= $Page->image->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_image" id="u_image" value="<?= $Page->image->MultiUpdate ?>">
            <?= $Page->image->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_image">
                <div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info_agent"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
                        <?= $Page->image->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_image">
                <div id="fd_x_image">
                    <input
                        type="file"
                        id="x_image"
                        name="x_image"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->image->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info_agent"
                        data-field="x_image"
                        data-size="48"
                        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
                        data-max-number-of-files="null"
                        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
                        aria-describedby="x_image_help"
                        <?= $Page->image->editAttributes() ?>
                    >
                    <?= $Page->image->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
                <input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
                <table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible && (!$Page->isConfirm() || $Page->status->multiUpdateSelected())) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?= $Page->status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_status"><?= $Page->status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_status" id="u_status" value="<?= $Page->status->MultiUpdate ?>">
            <?= $Page->status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_status">
                <?php
                if (IsRTL()) {
                    $Page->status->EditAttrs["dir"] = "rtl";
                }
                ?>
                <span id="as_x_status" class="ew-auto-suggest">
                    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
                </span>
                <selection-list hidden class="form-control" data-table="b_account_info_agent" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
                <?= $Page->status->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    fb_account_info_agentupdate.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.b_account_info_agent.fields.status.autoSuggestOptions));
                });
                </script>
                <?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_status">
                <span<?= $Page->status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible && (!$Page->isConfirm() || $Page->id_proof->multiUpdateSelected())) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?= $Page->id_proof->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_id_proof"><?= $Page->id_proof->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_id_proof" id="u_id_proof" value="<?= $Page->id_proof->MultiUpdate ?>">
            <?= $Page->id_proof->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_id_proof">
                <div id="fd_x_id_proof" class="fileinput-button ew-file-drop-zone">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info_agent"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= ($Page->id_proof->ReadOnly || $Page->id_proof->Disabled) ? " disabled" : "" ?>
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_id_proof">
                <div id="fd_x_id_proof">
                    <input
                        type="file"
                        id="x_id_proof"
                        name="x_id_proof"
                        class="form-control ew-file-input d-none"
                        title="<?= $Page->id_proof->title() ?>"
                        lang="<?= CurrentLanguageID() ?>"
                        data-table="b_account_info_agent"
                        data-field="x_id_proof"
                        data-size="255"
                        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
                        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
                        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
                        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
                        multiple
                        aria-describedby="x_id_proof_help"
                        <?= $Page->id_proof->editAttributes() ?>
                    >
                    <?= $Page->id_proof->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
                </div>
                <input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
                <input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="<?= (Post("fa_x_id_proof") == "0") ? "0" : "1" ?>">
                <table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible && (!$Page->isConfirm() || $Page->agent->multiUpdateSelected())) { // agent ?>
    <div id="r_agent"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_agent" id="u_agent" class="form-check-input ew-multi-select" value="1"<?= $Page->agent->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_agent"><?= $Page->agent->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_agent" id="u_agent" value="<?= $Page->agent->MultiUpdate ?>">
            <?= $Page->agent->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$Page->userIDAllow("update")) { // Non system admin ?>
                <span id="el_b_account_info_agent_agent">
                    <select
                        id="x_agent"
                        name="x_agent"
                        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
                        <?php if (!$Page->agent->IsNativeSelect) { ?>
                        data-select2-id="fb_account_info_agentupdate_x_agent"
                        <?php } ?>
                        data-table="b_account_info_agent"
                        data-field="x_agent"
                        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
                        <?= $Page->agent->editAttributes() ?>>
                        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
                    </select>
                    <?= $Page->agent->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
                <?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
                <?php if (!$Page->agent->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    var options = { name: "x_agent", selectId: "fb_account_info_agentupdate_x_agent" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_info_agentupdate.lists.agent?.lookupOptions.length) {
                        options.data = { id: "x_agent", form: "fb_account_info_agentupdate" };
                    } else {
                        options.ajax = { id: "x_agent", form: "fb_account_info_agentupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.agent.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_agent">
                    <select
                        id="x_agent"
                        name="x_agent"
                        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
                        <?php if (!$Page->agent->IsNativeSelect) { ?>
                        data-select2-id="fb_account_info_agentupdate_x_agent"
                        <?php } ?>
                        data-table="b_account_info_agent"
                        data-field="x_agent"
                        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
                        <?= $Page->agent->editAttributes() ?>>
                        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
                    </select>
                    <?= $Page->agent->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage() ?></div>
                <?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
                <?php if (!$Page->agent->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    var options = { name: "x_agent", selectId: "fb_account_info_agentupdate_x_agent" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_info_agentupdate.lists.agent?.lookupOptions.length) {
                        options.data = { id: "x_agent", form: "fb_account_info_agentupdate" };
                    } else {
                        options.ajax = { id: "x_agent", form: "fb_account_info_agentupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.agent.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } ?>
                <?php } else { ?>
                <span id="el_b_account_info_agent_agent">
                <span<?= $Page->agent->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->agent->getDisplayValue($Page->agent->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_agent" data-hidden="1" name="x_agent" id="x_agent" value="<?= HtmlEncode($Page->agent->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible && (!$Page->isConfirm() || $Page->other_details->multiUpdateSelected())) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?= $Page->other_details->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_other_details"><?= $Page->other_details->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_other_details" id="u_other_details" value="<?= $Page->other_details->MultiUpdate ?>">
            <?= $Page->other_details->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_other_details">
                <textarea data-table="b_account_info_agent" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help"><?= $Page->other_details->EditValue ?></textarea>
                <?= $Page->other_details->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_other_details">
                <span<?= $Page->other_details->viewAttributes() ?>>
                <?= $Page->other_details->ViewValue ?></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_other_details" data-hidden="1" name="x_other_details" id="x_other_details" value="<?= HtmlEncode($Page->other_details->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible && (!$Page->isConfirm() || $Page->loan_amount->multiUpdateSelected())) { // loan_amount ?>
    <div id="r_loan_amount"<?= $Page->loan_amount->rowAttributes() ?>>
        <label for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_loan_amount" id="u_loan_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->loan_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_loan_amount"><?= $Page->loan_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_loan_amount" id="u_loan_amount" value="<?= $Page->loan_amount->MultiUpdate ?>">
            <?= $Page->loan_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loan_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_loan_amount">
                <input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_info_agent" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?> aria-describedby="x_loan_amount_help">
                <?= $Page->loan_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_loan_amount">
                <span<?= $Page->loan_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->loan_amount->getDisplayValue($Page->loan_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_loan_amount" data-hidden="1" name="x_loan_amount" id="x_loan_amount" value="<?= HtmlEncode($Page->loan_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible && (!$Page->isConfirm() || $Page->int_->multiUpdateSelected())) { // int_@ ?>
    <div id="r_int_"<?= $Page->int_->rowAttributes() ?>>
        <label for="x_int_" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_int_" id="u_int_" class="form-check-input ew-multi-select" value="1"<?= $Page->int_->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_int_"><?= $Page->int_->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_int_" id="u_int_" value="<?= $Page->int_->MultiUpdate ?>">
            <?= $Page->int_->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->int_->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_int_">
                <input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_info_agent" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?> aria-describedby="x_int__help">
                <?= $Page->int_->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->int_->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_int_">
                <span<?= $Page->int_->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->int_->getDisplayValue($Page->int_->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_int_" data-hidden="1" name="x_int_" id="x_int_" value="<?= HtmlEncode($Page->int_->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible && (!$Page->isConfirm() || $Page->disbursement_amount->multiUpdateSelected())) { // disbursement_amount ?>
    <div id="r_disbursement_amount"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_disbursement_amount" id="u_disbursement_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->disbursement_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_disbursement_amount"><?= $Page->disbursement_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_disbursement_amount" id="u_disbursement_amount" value="<?= $Page->disbursement_amount->MultiUpdate ?>">
            <?= $Page->disbursement_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->disbursement_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_disbursement_amount">
                <input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_info_agent" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?> aria-describedby="x_disbursement_amount_help">
                <?= $Page->disbursement_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_disbursement_amount">
                <span<?= $Page->disbursement_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->disbursement_amount->getDisplayValue($Page->disbursement_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_disbursement_amount" data-hidden="1" name="x_disbursement_amount" id="x_disbursement_amount" value="<?= HtmlEncode($Page->disbursement_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible && (!$Page->isConfirm() || $Page->emi_amount->multiUpdateSelected())) { // emi_amount ?>
    <div id="r_emi_amount"<?= $Page->emi_amount->rowAttributes() ?>>
        <label for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_emi_amount" id="u_emi_amount" class="form-check-input ew-multi-select" value="1"<?= $Page->emi_amount->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_emi_amount"><?= $Page->emi_amount->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_emi_amount" id="u_emi_amount" value="<?= $Page->emi_amount->MultiUpdate ?>">
            <?= $Page->emi_amount->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_amount->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_emi_amount">
                <input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_info_agent" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?> aria-describedby="x_emi_amount_help">
                <?= $Page->emi_amount->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_emi_amount">
                <span<?= $Page->emi_amount->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->emi_amount->getDisplayValue($Page->emi_amount->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_emi_amount" data-hidden="1" name="x_emi_amount" id="x_emi_amount" value="<?= HtmlEncode($Page->emi_amount->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible && (!$Page->isConfirm() || $Page->no_of_emi->multiUpdateSelected())) { // no_of_emi ?>
    <div id="r_no_of_emi"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_no_of_emi" id="u_no_of_emi" class="form-check-input ew-multi-select" value="1"<?= $Page->no_of_emi->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_no_of_emi"><?= $Page->no_of_emi->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_no_of_emi" id="u_no_of_emi" value="<?= $Page->no_of_emi->MultiUpdate ?>">
            <?= $Page->no_of_emi->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_emi->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_no_of_emi">
                <input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_info_agent" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?> aria-describedby="x_no_of_emi_help">
                <?= $Page->no_of_emi->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_no_of_emi">
                <span<?= $Page->no_of_emi->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->no_of_emi->getDisplayValue($Page->no_of_emi->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_no_of_emi" data-hidden="1" name="x_no_of_emi" id="x_no_of_emi" value="<?= HtmlEncode($Page->no_of_emi->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible && (!$Page->isConfirm() || $Page->frequency->multiUpdateSelected())) { // frequency ?>
    <div id="r_frequency"<?= $Page->frequency->rowAttributes() ?>>
        <label for="x_frequency" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_frequency" id="u_frequency" class="form-check-input ew-multi-select" value="1"<?= $Page->frequency->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_frequency"><?= $Page->frequency->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_frequency" id="u_frequency" value="<?= $Page->frequency->MultiUpdate ?>">
            <?= $Page->frequency->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->frequency->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_b_account_info_agent_frequency">
                    <select
                        id="x_frequency"
                        name="x_frequency"
                        class="form-select ew-select<?= $Page->frequency->isInvalidClass() ?>"
                        <?php if (!$Page->frequency->IsNativeSelect) { ?>
                        data-select2-id="fb_account_info_agentupdate_x_frequency"
                        <?php } ?>
                        data-table="b_account_info_agent"
                        data-field="x_frequency"
                        data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->frequency->getPlaceHolder()) ?>"
                        <?= $Page->frequency->editAttributes() ?>>
                        <?= $Page->frequency->selectOptionListHtml("x_frequency") ?>
                    </select>
                    <?= $Page->frequency->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->frequency->getErrorMessage() ?></div>
                <?php if (!$Page->frequency->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fb_account_info_agentupdate", function() {
                    var options = { name: "x_frequency", selectId: "fb_account_info_agentupdate_x_frequency" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fb_account_info_agentupdate.lists.frequency?.lookupOptions.length) {
                        options.data = { id: "x_frequency", form: "fb_account_info_agentupdate" };
                    } else {
                        options.ajax = { id: "x_frequency", form: "fb_account_info_agentupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.frequency.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_b_account_info_agent_frequency">
                <span<?= $Page->frequency->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->frequency->getDisplayValue($Page->frequency->ViewValue) ?></span></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_frequency" data-hidden="1" name="x_frequency" id="x_frequency" value="<?= HtmlEncode($Page->frequency->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible && (!$Page->isConfirm() || $Page->operator->multiUpdateSelected())) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?= $Page->operator->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_operator"><?= $Page->operator->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_operator" id="u_operator" value="<?= $Page->operator->MultiUpdate ?>">
            <?= $Page->operator->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_agent_operator">
                <span<?= $Page->operator->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->operator->getDisplayValue($Page->operator->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible && (!$Page->isConfirm() || $Page->datetime->multiUpdateSelected())) { // datetime ?>
    <div id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?= $Page->datetime->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_datetime"><?= $Page->datetime->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_datetime" id="u_datetime" value="<?= $Page->datetime->MultiUpdate ?>">
            <?= $Page->datetime->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <?php } else { ?>
                <span id="el_b_account_info_agent_datetime">
                <span<?= $Page->datetime->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->datetime->getDisplayValue($Page->datetime->ViewValue))) ?>"></span>
                <input type="hidden" data-table="b_account_info_agent" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_info_agentupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_info_agentupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_info_agentupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fb_account_info_agentupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info_agent");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
