<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoAgentSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info_agent: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_account_info_agentsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_account_info_agentsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["b_type", [], fields.b_type.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["account_type", [], fields.account_type.isInvalid],
            ["aadhaar_no", [ew.Validators.regex(/^[2-9]{1}[0-9]{3}[0-9]{4}[0-9]{4}$/)], fields.aadhaar_no.isInvalid],
            ["account_no", [], fields.account_no.isInvalid],
            ["formal_name", [], fields.formal_name.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["status", [ew.Validators.integer], fields.status.isInvalid],
            ["pan_no", [ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/)], fields.pan_no.isInvalid],
            ["id_proof", [], fields.id_proof.isInvalid],
            ["agent", [], fields.agent.isInvalid],
            ["other_details", [], fields.other_details.isInvalid],
            ["loan_amount", [ew.Validators.float], fields.loan_amount.isInvalid],
            ["int_", [ew.Validators.float], fields.int_.isInvalid],
            ["disbursement_amount", [ew.Validators.float], fields.disbursement_amount.isInvalid],
            ["emi_amount", [ew.Validators.float], fields.emi_amount.isInvalid],
            ["no_of_emi", [ew.Validators.integer], fields.no_of_emi.isInvalid],
            ["frequency", [], fields.frequency.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["otp_delivery_datetime", [ew.Validators.datetime(fields.otp_delivery_datetime.clientFormatPattern)], fields.otp_delivery_datetime.isInvalid],
            ["otp_verify_datetime", [ew.Validators.datetime(fields.otp_verify_datetime.clientFormatPattern)], fields.otp_verify_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "account_type": <?= $Page->account_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_info_agentsearch" id="fb_account_info_agentsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->b_type->Visible) { // b_type ?>
    <div id="r_b_type" class="row"<?= $Page->b_type->rowAttributes() ?>>
        <label for="x_b_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_b_type"><?= $Page->b_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_type" id="z_b_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_b_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_b_type"
        name="x_b_type"
        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
        <?php if (!$Page->b_type->IsNativeSelect) { ?>
        data-select2-id="fb_account_info_agentsearch_x_b_type"
        <?php } ?>
        data-table="b_account_info_agent"
        data-field="x_b_type"
        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
        <?= $Page->b_type->editAttributes() ?>>
        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage(false) ?></div>
<?php if (!$Page->b_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    var options = { name: "x_b_type", selectId: "fb_account_info_agentsearch_x_b_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_info_agentsearch.lists.b_type?.lookupOptions.length) {
        options.data = { id: "x_b_type", form: "fb_account_info_agentsearch" };
    } else {
        options.ajax = { id: "x_b_type", form: "fb_account_info_agentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.b_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fb_account_info_agentsearch_x_grp"
        <?php } ?>
        data-table="b_account_info_agent"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    var options = { name: "x_grp", selectId: "fb_account_info_agentsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_info_agentsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fb_account_info_agentsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fb_account_info_agentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_type->Visible) { // account_type ?>
    <div id="r_account_type" class="row"<?= $Page->account_type->rowAttributes() ?>>
        <label for="x_account_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_account_type"><?= $Page->account_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_account_type" id="z_account_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_account_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_account_type"
        name="x_account_type"
        class="form-select ew-select<?= $Page->account_type->isInvalidClass() ?>"
        <?php if (!$Page->account_type->IsNativeSelect) { ?>
        data-select2-id="fb_account_info_agentsearch_x_account_type"
        <?php } ?>
        data-table="b_account_info_agent"
        data-field="x_account_type"
        data-value-separator="<?= $Page->account_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->account_type->getPlaceHolder()) ?>"
        <?= $Page->account_type->editAttributes() ?>>
        <?= $Page->account_type->selectOptionListHtml("x_account_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->account_type->getErrorMessage(false) ?></div>
<?= $Page->account_type->Lookup->getParamTag($Page, "p_x_account_type") ?>
<?php if (!$Page->account_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    var options = { name: "x_account_type", selectId: "fb_account_info_agentsearch_x_account_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_info_agentsearch.lists.account_type?.lookupOptions.length) {
        options.data = { id: "x_account_type", form: "fb_account_info_agentsearch" };
    } else {
        options.ajax = { id: "x_account_type", form: "fb_account_info_agentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.account_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no" class="row"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_aadhaar_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="b_account_info_agent" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
    <div id="r_account_no" class="row"<?= $Page->account_no->rowAttributes() ?>>
        <label for="x_account_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_account_no"><?= $Page->account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_account_no" id="z_account_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_account_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->account_no->getInputTextType() ?>" name="x_account_no" id="x_account_no" data-table="b_account_info_agent" data-field="x_account_no" value="<?= $Page->account_no->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_no->formatPattern()) ?>"<?= $Page->account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->account_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name" class="row"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_formal_name"><?= $Page->formal_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_formal_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_info_agent" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="b_account_info_agent" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_info_agent" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="b_account_info_agent" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_status" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="b_account_info_agent" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    fb_account_info_agentsearch.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.b_account_info_agent.fields.status.autoSuggestOptions));
});
</script>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no" class="row"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_pan_no"><?= $Page->pan_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_pan_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="b_account_info_agent" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof" class="row"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_id_proof"><?= $Page->id_proof->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_id_proof" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id_proof->getInputTextType() ?>" name="x_id_proof" id="x_id_proof" data-table="b_account_info_agent" data-field="x_id_proof" value="<?= $Page->id_proof->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->id_proof->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id_proof->formatPattern()) ?>"<?= $Page->id_proof->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_agent" id="z_agent" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fb_account_info_agentsearch_x_agent"
        <?php } ?>
        data-table="b_account_info_agent"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    var options = { name: "x_agent", selectId: "fb_account_info_agentsearch_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_info_agentsearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fb_account_info_agentsearch" };
    } else {
        options.ajax = { id: "x_agent", form: "fb_account_info_agentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details" class="row"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_other_details"><?= $Page->other_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other_details" id="z_other_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_other_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="b_account_info_agent" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible) { // loan_amount ?>
    <div id="r_loan_amount" class="row"<?= $Page->loan_amount->rowAttributes() ?>>
        <label for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_loan_amount"><?= $Page->loan_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_loan_amount" id="z_loan_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loan_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_loan_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_info_agent" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible) { // int_@ ?>
    <div id="r_int_" class="row"<?= $Page->int_->rowAttributes() ?>>
        <label for="x_int_" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_int_"><?= $Page->int_->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_int_" id="z_int_" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->int_->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_int_" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_info_agent" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->int_->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
    <div id="r_disbursement_amount" class="row"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_disbursement_amount"><?= $Page->disbursement_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_disbursement_amount" id="z_disbursement_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->disbursement_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_disbursement_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_info_agent" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible) { // emi_amount ?>
    <div id="r_emi_amount" class="row"<?= $Page->emi_amount->rowAttributes() ?>>
        <label for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_emi_amount"><?= $Page->emi_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emi_amount" id="z_emi_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_emi_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_info_agent" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
    <div id="r_no_of_emi" class="row"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_no_of_emi"><?= $Page->no_of_emi->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_emi->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_no_of_emi" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_info_agent" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible) { // frequency ?>
    <div id="r_frequency" class="row"<?= $Page->frequency->rowAttributes() ?>>
        <label for="x_frequency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_frequency"><?= $Page->frequency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_frequency" id="z_frequency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->frequency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_frequency" class="ew-search-field ew-search-field-single">
    <select
        id="x_frequency"
        name="x_frequency"
        class="form-select ew-select<?= $Page->frequency->isInvalidClass() ?>"
        <?php if (!$Page->frequency->IsNativeSelect) { ?>
        data-select2-id="fb_account_info_agentsearch_x_frequency"
        <?php } ?>
        data-table="b_account_info_agent"
        data-field="x_frequency"
        data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->frequency->getPlaceHolder()) ?>"
        <?= $Page->frequency->editAttributes() ?>>
        <?= $Page->frequency->selectOptionListHtml("x_frequency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->frequency->getErrorMessage(false) ?></div>
<?php if (!$Page->frequency->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_info_agentsearch", function() {
    var options = { name: "x_frequency", selectId: "fb_account_info_agentsearch_x_frequency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_info_agentsearch.lists.frequency?.lookupOptions.length) {
        options.data = { id: "x_frequency", form: "fb_account_info_agentsearch" };
    } else {
        options.ajax = { id: "x_frequency", form: "fb_account_info_agentsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info_agent.fields.frequency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="b_account_info_agent" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="b_account_info_agent" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_info_agentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_info_agentsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
    <div id="r_otp_delivery_datetime" class="row"<?= $Page->otp_delivery_datetime->rowAttributes() ?>>
        <label for="x_otp_delivery_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_otp_delivery_datetime"><?= $Page->otp_delivery_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_otp_delivery_datetime" id="z_otp_delivery_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->otp_delivery_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_otp_delivery_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->otp_delivery_datetime->getInputTextType() ?>" name="x_otp_delivery_datetime" id="x_otp_delivery_datetime" data-table="b_account_info_agent" data-field="x_otp_delivery_datetime" value="<?= $Page->otp_delivery_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->otp_delivery_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->otp_delivery_datetime->formatPattern()) ?>"<?= $Page->otp_delivery_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->otp_delivery_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->otp_delivery_datetime->ReadOnly && !$Page->otp_delivery_datetime->Disabled && !isset($Page->otp_delivery_datetime->EditAttrs["readonly"]) && !isset($Page->otp_delivery_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_info_agentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_info_agentsearch", "x_otp_delivery_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
    <div id="r_otp_verify_datetime" class="row"<?= $Page->otp_verify_datetime->rowAttributes() ?>>
        <label for="x_otp_verify_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_info_agent_otp_verify_datetime"><?= $Page->otp_verify_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_otp_verify_datetime" id="z_otp_verify_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->otp_verify_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_info_agent_otp_verify_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->otp_verify_datetime->getInputTextType() ?>" name="x_otp_verify_datetime" id="x_otp_verify_datetime" data-table="b_account_info_agent" data-field="x_otp_verify_datetime" value="<?= $Page->otp_verify_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->otp_verify_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->otp_verify_datetime->formatPattern()) ?>"<?= $Page->otp_verify_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->otp_verify_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->otp_verify_datetime->ReadOnly && !$Page->otp_verify_datetime->Disabled && !isset($Page->otp_verify_datetime->EditAttrs["readonly"]) && !isset($Page->otp_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_info_agentsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_info_agentsearch", "x_otp_verify_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_info_agentsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_info_agentsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_account_info_agentsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info_agent");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
