<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fb_account_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fb_account_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["b_type", [fields.b_type.visible && fields.b_type.required ? ew.Validators.required(fields.b_type.caption) : null], fields.b_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["branch", [fields.branch.visible && fields.branch.required ? ew.Validators.required(fields.branch.caption) : null], fields.branch.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["account_type", [fields.account_type.visible && fields.account_type.required ? ew.Validators.required(fields.account_type.caption) : null, ew.Validators.integer], fields.account_type.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.integer], fields.aadhaar_no.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null, ew.Validators.regex(/([A-Z]){5}([0-9]){4}([A-Z]){1}$/)], fields.pan_no.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["loan_amount", [fields.loan_amount.visible && fields.loan_amount.required ? ew.Validators.required(fields.loan_amount.caption) : null, ew.Validators.float], fields.loan_amount.isInvalid],
            ["emi_amount", [fields.emi_amount.visible && fields.emi_amount.required ? ew.Validators.required(fields.emi_amount.caption) : null, ew.Validators.float], fields.emi_amount.isInvalid],
            ["frequency", [fields.frequency.visible && fields.frequency.required ? ew.Validators.required(fields.frequency.caption) : null], fields.frequency.isInvalid],
            ["disbursement_amount", [fields.disbursement_amount.visible && fields.disbursement_amount.required ? ew.Validators.required(fields.disbursement_amount.caption) : null, ew.Validators.float], fields.disbursement_amount.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["no_of_emi", [fields.no_of_emi.visible && fields.no_of_emi.required ? ew.Validators.required(fields.no_of_emi.caption) : null, ew.Validators.integer], fields.no_of_emi.isInvalid],
            ["fund_o", [fields.fund_o.visible && fields.fund_o.required ? ew.Validators.required(fields.fund_o.caption) : null, ew.Validators.float], fields.fund_o.isInvalid],
            ["fund_o_no", [fields.fund_o_no.visible && fields.fund_o_no.required ? ew.Validators.required(fields.fund_o_no.caption) : null], fields.fund_o_no.isInvalid],
            ["int_", [fields.int_.visible && fields.int_.required ? ew.Validators.required(fields.int_.caption) : null, ew.Validators.float], fields.int_.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "branch": <?= $Page->branch->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
            "fund_o_no": <?= $Page->fund_o_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_infoadd" id="fb_account_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_b_account_info_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>></div></div>
    </div>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
    <div id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <label id="elh_b_account_info_b_type" for="x_b_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_type->caption() ?><?= $Page->b_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_type->cellAttributes() ?>>
<span id="el_b_account_info_b_type">
    <select
        id="x_b_type"
        name="x_b_type"
        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
        <?php if (!$Page->b_type->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_b_type"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_b_type"
        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
        <?= $Page->b_type->editAttributes() ?>>
        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
    </select>
    <?= $Page->b_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage() ?></div>
<?php if (!$Page->b_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_b_type", selectId: "fb_account_infoadd_x_b_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.b_type?.lookupOptions.length) {
        options.data = { id: "x_b_type", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_b_type", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.b_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_b_account_info_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_b_account_info_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_grp"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_grp", selectId: "fb_account_infoadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->branch->Visible) { // branch ?>
    <div id="r_branch"<?= $Page->branch->rowAttributes() ?>>
        <label id="elh_b_account_info_branch" for="x_branch" class="<?= $Page->LeftColumnClass ?>"><?= $Page->branch->caption() ?><?= $Page->branch->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->branch->cellAttributes() ?>>
<span id="el_b_account_info_branch">
    <select
        id="x_branch"
        name="x_branch"
        class="form-select ew-select<?= $Page->branch->isInvalidClass() ?>"
        <?php if (!$Page->branch->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_branch"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_branch"
        data-value-separator="<?= $Page->branch->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->branch->getPlaceHolder()) ?>"
        <?= $Page->branch->editAttributes() ?>>
        <?= $Page->branch->selectOptionListHtml("x_branch") ?>
    </select>
    <?= $Page->branch->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->branch->getErrorMessage() ?></div>
<?= $Page->branch->Lookup->getParamTag($Page, "p_x_branch") ?>
<?php if (!$Page->branch->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_branch", selectId: "fb_account_infoadd_x_branch" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.branch?.lookupOptions.length) {
        options.data = { id: "x_branch", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_branch", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.branch.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_b_account_info_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_b_account_info_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_category"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_category", selectId: "fb_account_infoadd_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_category", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->account_type->Visible) { // account_type ?>
    <div id="r_account_type"<?= $Page->account_type->rowAttributes() ?>>
        <label id="elh_b_account_info_account_type" for="x_account_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->account_type->caption() ?><?= $Page->account_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->account_type->cellAttributes() ?>>
<span id="el_b_account_info_account_type">
<input type="<?= $Page->account_type->getInputTextType() ?>" name="x_account_type" id="x_account_type" data-table="b_account_info" data-field="x_account_type" value="<?= $Page->account_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->account_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_type->formatPattern()) ?>"<?= $Page->account_type->editAttributes() ?> aria-describedby="x_account_type_help">
<?= $Page->account_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->account_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_b_account_info_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_b_account_info_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_type"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_type", selectId: "fb_account_infoadd_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_type", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label id="elh_b_account_info_formal_name" for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->formal_name->caption() ?><?= $Page->formal_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->formal_name->cellAttributes() ?>>
<span id="el_b_account_info_formal_name">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_info" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
<?= $Page->formal_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_b_account_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_b_account_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="b_account_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_b_account_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_b_account_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_b_account_info_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_b_account_info_status">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
</span>
<selection-list hidden class="form-control" data-table="b_account_info" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
<?= $Page->status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<script>
loadjs.ready("fb_account_infoadd", function() {
    fb_account_infoadd.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.b_account_info.fields.status.autoSuggestOptions));
});
</script>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label id="elh_b_account_info_aadhaar_no" for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_b_account_info_aadhaar_no">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="b_account_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label id="elh_b_account_info_pan_no" for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pan_no->caption() ?><?= $Page->pan_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pan_no->cellAttributes() ?>>
<span id="el_b_account_info_pan_no">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="b_account_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
<?= $Page->pan_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label id="elh_b_account_info_other_details" for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_details->caption() ?><?= $Page->other_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_details->cellAttributes() ?>>
<span id="el_b_account_info_other_details">
<input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="b_account_info" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help">
<?= $Page->other_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_name" for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_b_account_info_bank_name">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="b_account_info" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_ifsc_code" for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_ifsc_code->caption() ?><?= $Page->bank_ifsc_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el_b_account_info_bank_ifsc_code">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="b_account_info" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
<?= $Page->bank_ifsc_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label id="elh_b_account_info_bank_account_no" for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_b_account_info_bank_account_no">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="b_account_info" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible) { // loan_amount ?>
    <div id="r_loan_amount"<?= $Page->loan_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_loan_amount" for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->loan_amount->caption() ?><?= $Page->loan_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->loan_amount->cellAttributes() ?>>
<span id="el_b_account_info_loan_amount">
<input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_info" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?> aria-describedby="x_loan_amount_help">
<?= $Page->loan_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible) { // emi_amount ?>
    <div id="r_emi_amount"<?= $Page->emi_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_emi_amount" for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emi_amount->caption() ?><?= $Page->emi_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emi_amount->cellAttributes() ?>>
<span id="el_b_account_info_emi_amount">
<input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_info" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?> aria-describedby="x_emi_amount_help">
<?= $Page->emi_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible) { // frequency ?>
    <div id="r_frequency"<?= $Page->frequency->rowAttributes() ?>>
        <label id="elh_b_account_info_frequency" for="x_frequency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->frequency->caption() ?><?= $Page->frequency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->frequency->cellAttributes() ?>>
<span id="el_b_account_info_frequency">
    <select
        id="x_frequency"
        name="x_frequency"
        class="form-select ew-select<?= $Page->frequency->isInvalidClass() ?>"
        <?php if (!$Page->frequency->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_frequency"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_frequency"
        data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->frequency->getPlaceHolder()) ?>"
        <?= $Page->frequency->editAttributes() ?>>
        <?= $Page->frequency->selectOptionListHtml("x_frequency") ?>
    </select>
    <?= $Page->frequency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->frequency->getErrorMessage() ?></div>
<?php if (!$Page->frequency->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_frequency", selectId: "fb_account_infoadd_x_frequency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.frequency?.lookupOptions.length) {
        options.data = { id: "x_frequency", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_frequency", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.frequency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
    <div id="r_disbursement_amount"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label id="elh_b_account_info_disbursement_amount" for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->disbursement_amount->caption() ?><?= $Page->disbursement_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->disbursement_amount->cellAttributes() ?>>
<span id="el_b_account_info_disbursement_amount">
<input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_info" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?> aria-describedby="x_disbursement_amount_help">
<?= $Page->disbursement_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
    <div id="r_no_of_emi"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label id="elh_b_account_info_no_of_emi" for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>"><?= $Page->no_of_emi->caption() ?><?= $Page->no_of_emi->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->no_of_emi->cellAttributes() ?>>
<span id="el_b_account_info_no_of_emi">
<input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_info" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?> aria-describedby="x_no_of_emi_help">
<?= $Page->no_of_emi->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fund_o->Visible) { // fund_o ?>
    <div id="r_fund_o"<?= $Page->fund_o->rowAttributes() ?>>
        <label id="elh_b_account_info_fund_o" for="x_fund_o" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fund_o->caption() ?><?= $Page->fund_o->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fund_o->cellAttributes() ?>>
<span id="el_b_account_info_fund_o">
<input type="<?= $Page->fund_o->getInputTextType() ?>" name="x_fund_o" id="x_fund_o" data-table="b_account_info" data-field="x_fund_o" value="<?= $Page->fund_o->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->fund_o->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fund_o->formatPattern()) ?>"<?= $Page->fund_o->editAttributes() ?> aria-describedby="x_fund_o_help">
<?= $Page->fund_o->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fund_o->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fund_o_no->Visible) { // fund_o_no ?>
    <div id="r_fund_o_no"<?= $Page->fund_o_no->rowAttributes() ?>>
        <label id="elh_b_account_info_fund_o_no" for="x_fund_o_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fund_o_no->caption() ?><?= $Page->fund_o_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fund_o_no->cellAttributes() ?>>
<span id="el_b_account_info_fund_o_no">
    <select
        id="x_fund_o_no"
        name="x_fund_o_no"
        class="form-select ew-select<?= $Page->fund_o_no->isInvalidClass() ?>"
        <?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
        data-select2-id="fb_account_infoadd_x_fund_o_no"
        <?php } ?>
        data-table="b_account_info"
        data-field="x_fund_o_no"
        data-value-separator="<?= $Page->fund_o_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fund_o_no->getPlaceHolder()) ?>"
        <?= $Page->fund_o_no->editAttributes() ?>>
        <?= $Page->fund_o_no->selectOptionListHtml("x_fund_o_no") ?>
    </select>
    <?= $Page->fund_o_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->fund_o_no->getErrorMessage() ?></div>
<?= $Page->fund_o_no->Lookup->getParamTag($Page, "p_x_fund_o_no") ?>
<?php if (!$Page->fund_o_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_infoadd", function() {
    var options = { name: "x_fund_o_no", selectId: "fb_account_infoadd_x_fund_o_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_infoadd.lists.fund_o_no?.lookupOptions.length) {
        options.data = { id: "x_fund_o_no", form: "fb_account_infoadd" };
    } else {
        options.ajax = { id: "x_fund_o_no", form: "fb_account_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_info.fields.fund_o_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->int_->Visible) { // int_@ ?>
    <div id="r_int_"<?= $Page->int_->rowAttributes() ?>>
        <label id="elh_b_account_info_int_" for="x_int_" class="<?= $Page->LeftColumnClass ?>"><?= $Page->int_->caption() ?><?= $Page->int_->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->int_->cellAttributes() ?>>
<span id="el_b_account_info_int_">
<input type="<?= $Page->int_->getInputTextType() ?>" name="x_int_" id="x_int_" data-table="b_account_info" data-field="x_int_" value="<?= $Page->int_->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->int_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->int_->formatPattern()) ?>"<?= $Page->int_->editAttributes() ?> aria-describedby="x_int__help">
<?= $Page->int_->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->int_->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $('#x_aadhaar_no').attr('type', 'number');
    $('#x_mobile').attr('type', 'number');
    $('#x_otp').attr('type', 'number');
    $('#x_no_of_emi').attr('type', 'number');
    			$("#x_loan_amount").val('');
    			$("#r_loan_amount").hide();
    			$("#x_emi_amount").val('');
    			$("#r_emi_amount").hide();
    			$("#x_disbursement_amount").val('');
    			$("#r_disbursement_amount").hide();
    			$("#x_frequency").val('');
    			$("#r_frequency").hide();
    			$("#x_fund_o").val('');
    			$("#r_fund_o").hide();
    			$("#x_fund_o_no").val('');
    			$("#r_fund_o_no").hide();
    			$("#x_no_of_emi").val('');
    			$("#r_no_of_emi").hide();
});
</script>
