<?php

namespace PHPMaker2024\fibre;

// Page object
$BAccountCompiledSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { b_account_compiled: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fb_account_compiledsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fb_account_compiledsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["account_no", [], fields.account_no.isInvalid],
            ["formal_name", [], fields.formal_name.isInvalid],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["loan_amount", [ew.Validators.float], fields.loan_amount.isInvalid],
            ["emi_amount", [ew.Validators.float], fields.emi_amount.isInvalid],
            ["no_of_emi", [ew.Validators.integer], fields.no_of_emi.isInvalid],
            ["disbursement_amount", [ew.Validators.float], fields.disbursement_amount.isInvalid],
            ["frequency", [], fields.frequency.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["end_date", [ew.Validators.datetime(fields.end_date.clientFormatPattern)], fields.end_date.isInvalid],
            ["due_emi", [ew.Validators.integer], fields.due_emi.isInvalid],
            ["branch", [], fields.branch.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "frequency": <?= $Page->frequency->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "branch": <?= $Page->branch->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fb_account_compiledsearch" id="fb_account_compiledsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="b_account_compiled">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fb_account_compiledsearch_x_grp"
        <?php } ?>
        data-table="b_account_compiled"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_compiledsearch", function() {
    var options = { name: "x_grp", selectId: "fb_account_compiledsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_compiledsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fb_account_compiledsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fb_account_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_compiled.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
    <div id="r_account_no" class="row"<?= $Page->account_no->rowAttributes() ?>>
        <label for="x_account_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_account_no"><?= $Page->account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_account_no" id="z_account_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_account_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->account_no->getInputTextType() ?>" name="x_account_no" id="x_account_no" data-table="b_account_compiled" data-field="x_account_no" value="<?= $Page->account_no->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_no->formatPattern()) ?>"<?= $Page->account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->account_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name" class="row"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_formal_name"><?= $Page->formal_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_formal_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="b_account_compiled" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_balance"><?= $Page->balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance" id="z_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="b_account_compiled" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loan_amount->Visible) { // loan_amount ?>
    <div id="r_loan_amount" class="row"<?= $Page->loan_amount->rowAttributes() ?>>
        <label for="x_loan_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_loan_amount"><?= $Page->loan_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_loan_amount" id="z_loan_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loan_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_loan_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->loan_amount->getInputTextType() ?>" name="x_loan_amount" id="x_loan_amount" data-table="b_account_compiled" data-field="x_loan_amount" value="<?= $Page->loan_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->loan_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loan_amount->formatPattern()) ?>"<?= $Page->loan_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->loan_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_amount->Visible) { // emi_amount ?>
    <div id="r_emi_amount" class="row"<?= $Page->emi_amount->rowAttributes() ?>>
        <label for="x_emi_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_emi_amount"><?= $Page->emi_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emi_amount" id="z_emi_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_emi_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emi_amount->getInputTextType() ?>" name="x_emi_amount" id="x_emi_amount" data-table="b_account_compiled" data-field="x_emi_amount" value="<?= $Page->emi_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_amount->formatPattern()) ?>"<?= $Page->emi_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_emi->Visible) { // no_of_emi ?>
    <div id="r_no_of_emi" class="row"<?= $Page->no_of_emi->rowAttributes() ?>>
        <label for="x_no_of_emi" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_no_of_emi"><?= $Page->no_of_emi->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_emi->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_no_of_emi" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no_of_emi->getInputTextType() ?>" name="x_no_of_emi" id="x_no_of_emi" data-table="b_account_compiled" data-field="x_no_of_emi" value="<?= $Page->no_of_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_emi->formatPattern()) ?>"<?= $Page->no_of_emi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no_of_emi->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->disbursement_amount->Visible) { // disbursement_amount ?>
    <div id="r_disbursement_amount" class="row"<?= $Page->disbursement_amount->rowAttributes() ?>>
        <label for="x_disbursement_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_disbursement_amount"><?= $Page->disbursement_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_disbursement_amount" id="z_disbursement_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->disbursement_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_disbursement_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->disbursement_amount->getInputTextType() ?>" name="x_disbursement_amount" id="x_disbursement_amount" data-table="b_account_compiled" data-field="x_disbursement_amount" value="<?= $Page->disbursement_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->disbursement_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->disbursement_amount->formatPattern()) ?>"<?= $Page->disbursement_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->disbursement_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->frequency->Visible) { // frequency ?>
    <div id="r_frequency" class="row"<?= $Page->frequency->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_frequency"><?= $Page->frequency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_frequency" id="z_frequency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->frequency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_frequency" class="ew-search-field ew-search-field-single">
<template id="tp_x_frequency">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="b_account_compiled" data-field="x_frequency" name="x_frequency" id="x_frequency"<?= $Page->frequency->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_frequency" class="ew-item-list"></div>
<selection-list hidden
    id="x_frequency"
    name="x_frequency"
    value="<?= HtmlEncode($Page->frequency->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_frequency"
    data-target="dsl_x_frequency"
    data-repeatcolumn="5"
    class="form-control<?= $Page->frequency->isInvalidClass() ?>"
    data-table="b_account_compiled"
    data-field="x_frequency"
    data-value-separator="<?= $Page->frequency->displayValueSeparatorAttribute() ?>"
    <?= $Page->frequency->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->frequency->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fb_account_compiledsearch_x_status"
        <?php } ?>
        data-table="b_account_compiled"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_compiledsearch", function() {
    var options = { name: "x_status", selectId: "fb_account_compiledsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_compiledsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fb_account_compiledsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fb_account_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_compiled.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->end_date->Visible) { // end_date ?>
    <div id="r_end_date" class="row"<?= $Page->end_date->rowAttributes() ?>>
        <label for="x_end_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_end_date"><?= $Page->end_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_end_date" id="z_end_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->end_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_end_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->end_date->getInputTextType() ?>" name="x_end_date" id="x_end_date" data-table="b_account_compiled" data-field="x_end_date" value="<?= $Page->end_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->end_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->end_date->formatPattern()) ?>"<?= $Page->end_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->end_date->getErrorMessage(false) ?></div>
<?php if (!$Page->end_date->ReadOnly && !$Page->end_date->Disabled && !isset($Page->end_date->EditAttrs["readonly"]) && !isset($Page->end_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fb_account_compiledsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fb_account_compiledsearch", "x_end_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->due_emi->Visible) { // due_emi ?>
    <div id="r_due_emi" class="row"<?= $Page->due_emi->rowAttributes() ?>>
        <label for="x_due_emi" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_due_emi"><?= $Page->due_emi->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_due_emi" id="z_due_emi" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->due_emi->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_due_emi" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->due_emi->getInputTextType() ?>" name="x_due_emi" id="x_due_emi" data-table="b_account_compiled" data-field="x_due_emi" value="<?= $Page->due_emi->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->due_emi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->due_emi->formatPattern()) ?>"<?= $Page->due_emi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->due_emi->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->branch->Visible) { // branch ?>
    <div id="r_branch" class="row"<?= $Page->branch->rowAttributes() ?>>
        <label for="x_branch" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_branch"><?= $Page->branch->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_branch" id="z_branch" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->branch->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_branch" class="ew-search-field ew-search-field-single">
    <select
        id="x_branch"
        name="x_branch"
        class="form-select ew-select<?= $Page->branch->isInvalidClass() ?>"
        <?php if (!$Page->branch->IsNativeSelect) { ?>
        data-select2-id="fb_account_compiledsearch_x_branch"
        <?php } ?>
        data-table="b_account_compiled"
        data-field="x_branch"
        data-value-separator="<?= $Page->branch->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->branch->getPlaceHolder()) ?>"
        <?= $Page->branch->editAttributes() ?>>
        <?= $Page->branch->selectOptionListHtml("x_branch") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->branch->getErrorMessage(false) ?></div>
<?= $Page->branch->Lookup->getParamTag($Page, "p_x_branch") ?>
<?php if (!$Page->branch->IsNativeSelect) { ?>
<script>
loadjs.ready("fb_account_compiledsearch", function() {
    var options = { name: "x_branch", selectId: "fb_account_compiledsearch_x_branch" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fb_account_compiledsearch.lists.branch?.lookupOptions.length) {
        options.data = { id: "x_branch", form: "fb_account_compiledsearch" };
    } else {
        options.ajax = { id: "x_branch", form: "fb_account_compiledsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.b_account_compiled.fields.branch.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="b_account_compiled" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_b_account_compiled__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_b_account_compiled__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="b_account_compiled" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fb_account_compiledsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fb_account_compiledsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fb_account_compiledsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("b_account_compiled");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
