<?php

namespace PHPMaker2024\fibre;

// Page object
$AudittrailSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { audittrail: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var faudittrailsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("faudittrailsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["script", [], fields.script.isInvalid],
            ["user", [], fields.user.isInvalid],
            ["_action", [], fields._action.isInvalid],
            ["_table", [], fields._table.isInvalid],
            ["field", [], fields.field.isInvalid],
            ["keyvalue", [], fields.keyvalue.isInvalid],
            ["oldvalue", [], fields.oldvalue.isInvalid],
            ["newvalue", [], fields.newvalue.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="faudittrailsearch" id="faudittrailsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="audittrail">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="audittrail" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="audittrail" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->script->Visible) { // script ?>
    <div id="r_script" class="row"<?= $Page->script->rowAttributes() ?>>
        <label for="x_script" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_script"><?= $Page->script->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_script" id="z_script" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->script->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_script" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->script->getInputTextType() ?>" name="x_script" id="x_script" data-table="audittrail" data-field="x_script" value="<?= $Page->script->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->script->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->script->formatPattern()) ?>"<?= $Page->script->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->script->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user->Visible) { // user ?>
    <div id="r_user" class="row"<?= $Page->user->rowAttributes() ?>>
        <label for="x_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_user"><?= $Page->user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user" id="z_user" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_user" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user->getInputTextType() ?>" name="x_user" id="x_user" data-table="audittrail" data-field="x_user" value="<?= $Page->user->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user->formatPattern()) ?>"<?= $Page->user->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_action->Visible) { // action ?>
    <div id="r__action" class="row"<?= $Page->_action->rowAttributes() ?>>
        <label for="x__action" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail__action"><?= $Page->_action->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__action" id="z__action" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_action->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail__action" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_action->getInputTextType() ?>" name="x__action" id="x__action" data-table="audittrail" data-field="x__action" value="<?= $Page->_action->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_action->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_action->formatPattern()) ?>"<?= $Page->_action->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_action->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_table->Visible) { // table ?>
    <div id="r__table" class="row"<?= $Page->_table->rowAttributes() ?>>
        <label for="x__table" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail__table"><?= $Page->_table->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__table" id="z__table" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_table->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail__table" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_table->getInputTextType() ?>" name="x__table" id="x__table" data-table="audittrail" data-field="x__table" value="<?= $Page->_table->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_table->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_table->formatPattern()) ?>"<?= $Page->_table->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_table->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->field->Visible) { // field ?>
    <div id="r_field" class="row"<?= $Page->field->rowAttributes() ?>>
        <label for="x_field" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_field"><?= $Page->field->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_field" id="z_field" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->field->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_field" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->field->getInputTextType() ?>" name="x_field" id="x_field" data-table="audittrail" data-field="x_field" value="<?= $Page->field->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->field->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field->formatPattern()) ?>"<?= $Page->field->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->keyvalue->Visible) { // keyvalue ?>
    <div id="r_keyvalue" class="row"<?= $Page->keyvalue->rowAttributes() ?>>
        <label for="x_keyvalue" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_keyvalue"><?= $Page->keyvalue->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_keyvalue" id="z_keyvalue" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->keyvalue->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_keyvalue" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->keyvalue->getInputTextType() ?>" name="x_keyvalue" id="x_keyvalue" data-table="audittrail" data-field="x_keyvalue" value="<?= $Page->keyvalue->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->keyvalue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->keyvalue->formatPattern()) ?>"<?= $Page->keyvalue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->keyvalue->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->oldvalue->Visible) { // oldvalue ?>
    <div id="r_oldvalue" class="row"<?= $Page->oldvalue->rowAttributes() ?>>
        <label for="x_oldvalue" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_oldvalue"><?= $Page->oldvalue->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_oldvalue" id="z_oldvalue" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->oldvalue->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_oldvalue" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->oldvalue->getInputTextType() ?>" name="x_oldvalue" id="x_oldvalue" data-table="audittrail" data-field="x_oldvalue" value="<?= $Page->oldvalue->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->oldvalue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->oldvalue->formatPattern()) ?>"<?= $Page->oldvalue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->oldvalue->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->newvalue->Visible) { // newvalue ?>
    <div id="r_newvalue" class="row"<?= $Page->newvalue->rowAttributes() ?>>
        <label for="x_newvalue" class="<?= $Page->LeftColumnClass ?>"><span id="elh_audittrail_newvalue"><?= $Page->newvalue->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_newvalue" id="z_newvalue" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->newvalue->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_audittrail_newvalue" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->newvalue->getInputTextType() ?>" name="x_newvalue" id="x_newvalue" data-table="audittrail" data-field="x_newvalue" value="<?= $Page->newvalue->EditValue ?>" placeholder="<?= HtmlEncode($Page->newvalue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->newvalue->formatPattern()) ?>"<?= $Page->newvalue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->newvalue->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="faudittrailsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="faudittrailsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="faudittrailsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("audittrail");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
