<?php

namespace PHPMaker2024\fibre;

// Page object
$Assignimage = &$Page;
?>
<?php
$Page->showMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        .container {
            display: flex;
            gap: 20px;
        }
        .box {
            border: 1px solid #ccc;
            padding: 10px;
            width: 33%;
            max-height: 800px;
            overflow-y: auto;
        }
        .draggable {
            display: flex;
            align-items: center;
            cursor: move;
            margin: 5px 0;
            padding: 5px;
            background-color: #f0f0f0;
            opacity: 1;
            justify-content: space-between;
        }
        .dropzone {
            border: 1px dashed #ccc;
            padding: 10px;
            min-height: 150px;
            margin: 5px 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        img {
            width: 120px;
            height: 150px;
            object-fit: cover;
            margin-right: 10px;
        }
        .trash {
            border: 1px dashed red;
            padding: 20px;
            min-height: 150px;
            text-align: center;
            font-weight: bold;
            color: red;
        }
        .dropdown-container {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
        }
        select {
            padding: 8px;
            font-size: 16px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .dropdown-item {
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="dropdown-container">
        <div class="dropdown-item">
            <label for="folder-select">Select Folder:</label>
            <select id="folder-select">
                <option value="">-- Select a folder --</option>
            </select>
        </div>
        <div class="dropdown-item">
            <label for="class-select">Select Class:</label>
            <select id="class-select">
                <option value="">-- Select a class --</option>
            </select>
        </div>
    </div>

    <div class="container">
        <div class="box" id="images">
            <h4>Images</h4>
        </div>
        <div class="box" id="classes">
            <h4>Classes</h4>
        </div>
        <div class="box trash" id="trash">
            <h4>Trash (Drag images here to delete)</h4>
        </div>
    </div>

    <script>
        async function initialize() {
            const urlParams = new URLSearchParams(window.location.search);
            const classId = urlParams.get('f') || '101'
            const folderPath = urlParams.get('p') || 'NA-2025';

            await loadFolders(folderPath);
            await loadClassList(classId);

            if (!classId) return; // don't load data if class not selected

            const response = await fetch(`apcajaxs?action=get_classes_and_mappings&f=${classId}&p=${encodeURIComponent(folderPath)}`);
            const { classes, unassignedImages } = await response.json();

            const imageContainer = document.getElementById('images');
            const classContainer = document.getElementById('classes');

            unassignedImages.forEach(image => {
                const imgDiv = createImageDiv(image);
                imageContainer.appendChild(imgDiv);
            });

            classes.forEach(({ id, name, image }) => {
                const classDiv = document.createElement('div');
                classDiv.innerHTML = `<h5>${name}</h5>`;
                const dropzone = document.createElement('div');
                dropzone.className = 'dropzone';
                dropzone.dataset.classId = id;
                if (image) dropzone.appendChild(createImageElement(image));
                classDiv.appendChild(dropzone);
                classContainer.appendChild(classDiv);
            });

            setupDragAndDrop();
            setupDropdownChange();
        }

        function createImageDiv(image) {
            const div = document.createElement('div');
            div.className = 'draggable';
            div.draggable = true;
            div.dataset.imageName = image;

            div.appendChild(createImageElement(image));
            const name = document.createElement('span');
            name.textContent = image;
            div.appendChild(name);

            return div;
        }

        function createImageElement(image) {
            const img = document.createElement('img');
            img.src = image;
            img.alt = image;
            return img;
        }

        function setupDragAndDrop() {
            document.addEventListener('dragstart', event => {
                const draggable = event.target.closest('.draggable');
                if (draggable) {
                    const imageName = draggable.dataset.imageName;
                    event.dataTransfer.setData('imageName', imageName);
                }
            });

            document.addEventListener('dragover', event => {
                if (
                    event.target.classList.contains('dropzone') ||
                    event.target.classList.contains('trash') ||
                    event.target.id === 'images'
                ) {
                    event.preventDefault();
                }
            });

            document.addEventListener('drop', async event => {
                const imageName = event.dataTransfer.getData('imageName');
                const draggedElement = document.querySelector(`[data-image-name="${imageName}"]`);

                if (!imageName || !draggedElement) return;

                if (event.target.classList.contains('dropzone')) {
                    event.target.innerHTML = '';
                    event.target.appendChild(createImageElement(imageName));
                    draggedElement.remove();
                    await saveMapping(event.target.dataset.classId, imageName);
                } else if (event.target.classList.contains('trash')) {
                    draggedElement.remove();
                    await deleteImage(imageName);
                }
            });
        }

        function setupDropdownChange() {
            const classSelect = document.getElementById('class-select');
            const folderSelect = document.getElementById('folder-select');

            function reloadWithParams() {
                const classId = classSelect.value;
                const folder = folderSelect.value;
                const newURL = `${window.location.pathname}?f=${encodeURIComponent(classId)}&p=${encodeURIComponent(folder)}`;
                window.location.href = newURL;
            }

            classSelect.addEventListener('change', reloadWithParams);
            folderSelect.addEventListener('change', reloadWithParams);
        }

        async function loadFolders(selectedFolder = folderPath) {
            try {
                const response = await fetch(`apcajaxs?action=get_folders`);
                const { folders } = await response.json();

                const folderSelect = document.getElementById('folder-select');
                folders.forEach(folder => {
                    const option = document.createElement('option');
                    option.value = folder;
                    option.textContent = folder;
                    if (folder === selectedFolder) option.selected = true;
                    folderSelect.appendChild(option);
                });
            } catch (error) {
                console.error("Failed to load folders:", error.message);
            }
        }

        async function loadClassList(selectedClassId = loadClassList) {
            try {
                const response = await fetch(`apcajaxs?action=get_class_list`);
                const { classes } = await response.json();

                const classSelect = document.getElementById('class-select');
                classes.forEach(cls => {
                    const option = document.createElement('option');
                    option.value = cls.id;
                    option.textContent = cls.name;
                    if (cls.id.toString() === selectedClassId) option.selected = true;
                    classSelect.appendChild(option);
                });
            } catch (error) {
                console.error("Failed to load class list:", error.message);
            }
        }

        async function saveMapping(classId, imageName) {
            try {
                const response = await fetch('apcajaxs?action=save_mapping', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ class_id: classId, image_name: imageName })
                });

                const result = await response.json();
                if (result.error) {
                    console.error("Backend error:", result.error);
                } else {
                    console.log("Mapping saved successfully:", result);
                }
            } catch (error) {
                console.error("Failed to save mapping:", error.message);
            }
        }

        async function deleteImage(imageName) {
            try {
                await fetch('apcajaxs?action=delete_image', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ image_name: imageName })
                });
            } catch (error) {
                console.error("Failed to delete image:", error.message);
                alert("An error occurred while deleting the image.");
            }
        }

        initialize();
    </script>
</body>
</html>
<?= GetDebugMessage() ?>
