<?php

namespace PHPMaker2024\fibre;

// Page object
$ApcajaxS = &$Page;
?>
<?php
$Page->showMessage();
?>
<?php
$CDT = CurrentDateTime();
$CD = CurrentDate();
extract($_GET,EXTR_OVERWRITE);
$ns = 'namespace PHPMaker2024\fibre;';

$CUID = CurrentUserID();
//Education ERP

if ($action === 'rotate_resize')
{     
     ini_set('max_execution_time', 36000);
    // Path to the folder containing images
    $folderPath = '.p_uploads/education/image/'; // Replace with the path to your folder

    if (!is_dir($folderPath)) {
        die("Invalid folder path.");
    }

    $processedImages = [];

    // Open the directory
    $dir = opendir($folderPath);

    while (($file = readdir($dir)) !== false) {
        $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;

        // Process only files that are images
        if (is_file($filePath) && in_array(mime_content_type($filePath), ['image/jpeg', 'image/png', 'image/gif'])) {
            $imageType = mime_content_type($filePath);

            switch ($imageType) {
                case 'image/jpeg':
                    $img = imagecreatefromjpeg($filePath);
                    break;
                case 'image/png':
                    $img = imagecreatefrompng($filePath);
                    break;
                case 'image/gif':
                    $img = imagecreatefromgif($filePath);
                    break;
                default:
                    continue 2; // Skip unsupported image types
            }

            // Rotate the image 270 degrees clockwise
            $rotatedImg = imagerotate($img, -270, 0);

            // Get original dimensions
            $originalWidth = imagesx($rotatedImg);
            $originalHeight = imagesy($rotatedImg);

            // Calculate new dimensions while maintaining aspect ratio
            $maxWidth = 700;
            $maxHeight = 1000;
            $aspectRatio = min($maxWidth / $originalWidth, $maxHeight / $originalHeight);

            $newWidth = (int)($originalWidth * $aspectRatio);
            $newHeight = (int)($originalHeight * $aspectRatio);

            // Create a resized image
            $resizedImg = imagescale($rotatedImg, $newWidth, $newHeight);

            // Save the image back to the folder
            switch ($imageType) {
                case 'image/jpeg':
                    imagejpeg($resizedImg, $filePath);
                    break;
                case 'image/png':
                    imagepng($resizedImg, $filePath);
                    break;
                case 'image/gif':
                    imagegif($resizedImg, $filePath);
                    break;
            }

            // Free memory
            imagedestroy($img);
            imagedestroy($rotatedImg);
            imagedestroy($resizedImg);

            $processedImages[] = $file;
        }
    }

    closedir($dir);

    // Return a JSON response
    echo json_encode([
        'status' => 'success',
        'message' => 'Images processed successfully!',
        'processedImages' => $processedImages
    ]);
    exit;
}

if ($action === 'get_folders') {
    $folderPath = '.p_uploads/education/';
    $folders = [];
    $items = scandir($folderPath);
    sort($items);
    foreach ($items as $item) 
     {
          if ($item !== '.' && $item !== '..' && is_dir($folderPath . $item)) 
          {
                $folders[] = $item;
          }
     }
    echo json_encode(['folders' => $folders]);
    exit;
}

if ($action === 'get_class_list') {
    $rows = ExecuteRows("SELECT `id`, `faculty` as `name` from `s_faculty` where `type` = 0 and `status` = 1 group by `faculty` order by `faculty` asc");
    echo json_encode(['classes' => $rows]);
    exit;
}

if ($action === 'get_classes_and_mappings') 
{
     $f = $_GET['f'] ?? null;
     $faculty = ExecuteScalar("SELECT `faculty` from `s_faculty` where `id` = $f");
     $pathfolder = $_GET['p'] ?? ExecuteScalar("SELECT distinct `path` as `path` FROM `s_admission_info` left join `s_faculty` on `s_admission_info`.`faculty` = `s_faculty`.`id` WHERE `s_faculty`.`faculty` = '$faculty' limit 1");
     $classes = ExecuteRows("SELECT  s_admission_info.s_pid as `id`, concat(s_admission_info.s_pid, ' - ', `s_personal_info`.`name`, ' - ', `s_personal_info`.`sr_no`, ' - ', `s_faculty`.`fac_sec`, ' - ', ifnull(s_personal_info.dob,'DOB-NA'), '<br>', ifnull(`s_admission_info`.`image`,'')) as `name`, concat('.p_uploads/education/' , `s_admission_info`.`path`, '/', `s_admission_info`.`image`) as `image` FROM s_admission_info left join s_personal_info on s_personal_info.id = s_admission_info.s_pid left join `s_faculty` on s_faculty.id = s_admission_info.faculty where `s_faculty`.`faculty` = '$faculty' ORDER BY `s_faculty`.`fac_sec`, s_personal_info.name ASC");
     $path = ".p_uploads/education/" . $pathfolder . "/";
       
     $assignedImages = ExecuteRows("SELECT SUBSTRING_INDEX(`image`, '/', -1) as `image` FROM `s_admission_info` left join `s_faculty` on `s_faculty`.`id` = s_admission_info.faculty WHERE `image` IS NOT NULL AND `s_faculty`.`faculty` = '$faculty'");

     $allImages = array_diff(scandir($path), ['.', '..']);
     sort($allImages);
     $assignedImageNames = array_map(fn($item) => $item['image'], $assignedImages);
     $unassignedImages = array_diff($allImages, $assignedImageNames);
     $unassignedImages = array_map(function ($image) use ($path) {
     return $path . $image;
          }, $unassignedImages);
     echo json_encode(["classes" => $classes, "unassignedImages" => array_values($unassignedImages)]);
     exit;
}

if ($action === 'save_mapping') 
{
     $jsonInput = file_get_contents('php://input');
     $data = json_decode($jsonInput, true);
     $classId = $data['class_id'] ?? null;
     $imageName = $data['image_name'] ?? null;
     if ($classId && $imageName) 
     {
          $im = ExecuteScalar("SELECT ifnull(`image`,0) as `image` from `s_admission_info` where `s_pid` = $classId");
          if ($im != 0)
          {
               $newImPath = preg_replace("/[^\/]+(?=\.\w+$)/", time(), $imageName);
               rename($im,$newImPath);    
          }
          $sr = ExecuteScalar("SELECT concat(substring_index(`sr_no`, '/', 1), '-', `s_admission_info`.`admission_year`) as `sr` from `s_personal_info` left join `s_admission_info` on `s_admission_info`.`s_pid` = `s_personal_info`.`id` where `s_personal_info`.`id` = $classId");
          $path = ExecuteScalar("SELECT `path` from `s_admission_info` where `s_pid` = $classId");
          $newImageName = preg_replace("/[^\/]+(?=\.\w+$)/", $sr, $imageName);
          $newImageName = preg_replace("#(?<=\.p_uploads/education/)[^/]+#", $path, $newImageName);
          $filename =  basename($newImageName);
          ExecuteStatement("UPDATE `s_admission_info` SET `image` = '$filename' WHERE `s_pid` = $classId");
       rename($imageName,$newImageName);
       echo json_encode(["status" => "success"]);
    }
    exit;
}

if ($action === 'rename_all') 
{
     $imall = ExecuteRows("SELECT `id`, concat('DSC_',`image`, '.JPG') as `image` from `s_images`");
     foreach($imall as $img)
     {
     $classId = $img['id'] ?? null;
     $imageName = '.p_uploads/education/image/' . $img['image'] ?? null;
          if ($classId && $imageName && file_exists($imageName)) 
          {
               $pathfolder = ExecuteScalar("SELECT distinct `path` as `path` FROM `s_admission_info` left join `s_faculty` on `s_admission_info`.`faculty` = `s_faculty`.`id` WHERE `s_admission_info`.`s_pid` = $classId limit 1");
               $im = ExecuteScalar("SELECT ifnull(`image`,0) as `image` from `s_admission_info` where `s_pid` = $classId");
               if ($im != 0)
               {
                    $newtmpimage = ".p_uploads/education/" . $pathfolder . "/" . time() . $im;
                    $oldImPath = '.p_uploads/education/' . $pathfolder . '/' . $im;
                    if (file_exists($oldImPath))
                         rename($oldImPath,$newtmpimage);    
               }
               $sr = ExecuteScalar("SELECT concat(substring_index(ifnull(`sr_no`, concat('ID-', `s_personal_info`.`id`)), '/', 1), '-', `s_admission_info`.`admission_year`) as `sr` from `s_personal_info` left join `s_admission_info` on `s_admission_info`.`s_pid` = `s_personal_info`.`id` where `s_personal_info`.`id` = $classId"); 
               $newPath = preg_replace("/[^\/]+(?=\.\w+$)/", $sr, $imageName);
               $filename =  basename($newPath);
               ExecuteStatement("UPDATE `s_admission_info` SET `image` = '$filename' WHERE `s_pid` = $classId");
               $newimage = ".p_uploads/education/" . $pathfolder . "/" . $filename;
               rename($imageName,$newimage);
               echo $imageName . $newimage . '<br>';
          }
     }
}

if ($action === 'delete_image') 
{
     $jsonInput = file_get_contents('php://input');
     $data = json_decode($jsonInput, true);
     $image = $data['image_name'] ?? null;
     if (file_exists($image)) 
     {
          $filename =  '.p_uploads/education/deleted/deleted_' . basename($image);
          rename($image,$filename);
          echo json_encode(["status" => "success"]);
          exit;
     }
     else
     {
     echo json_encode(["status" => "Image Not Exists"]);
     exit;
     }
}

if(isset($_GET['present']))
{
    ExecuteStatement("INSERT INTO `s_epc_live` (`s_pid`, `m_status`, `inout_datetime`) VALUES ($present, 98, CURRENT_DATE)");
    exit;
}

if(isset($_GET['absent'])) 
{
    ExecuteStatement("INSERT INTO `s_epc_live` (`s_pid`, `m_status`, `inout_datetime`) VALUES ($absent, 99, CURRENT_DATE)");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_attendance'])) {
    $updates = $_POST['updates'] ?? [];
$q= '';
    if (!is_array($updates) || empty($updates)) {
        echo json_encode(['success' => false, 'message' => 'No data received.']);
        exit;
    }

    foreach ($updates as $sid => $status) {
        $sid = intval($sid);
        if ($status === 'PR')
            $m_status = 98;
        elseif ($status === 'AB')
            $m_status = 99;
        else
            $m_status = 'NA';
        //$q .= "INSERT INTO `s_epc_live` (`s_pid`, `m_status`, `inout_datetime`) VALUES ($sid, $status, CURRENT_DATE)<br>";
        ExecuteStatement("INSERT INTO `s_epc_live` (`s_pid`, `m_status`, `inout_datetime`) VALUES ($sid, $m_status, CURRENT_DATE)");
    }
    echo json_encode(['success' => true]);
    exit;
}
?>
<?= GetDebugMessage() ?>
