<?php

namespace PHPMaker2024\fibre;

// Page object
$ApcView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fapcview" id="fapcview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { apc: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fapcview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fapcview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->apcid->Visible) { // apcid ?>
    <tr id="r_apcid"<?= $Page->apcid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_apcid"><?= $Page->apcid->caption() ?></span></td>
        <td data-name="apcid"<?= $Page->apcid->cellAttributes() ?>>
<span id="el_apc_apcid">
<span<?= $Page->apcid->viewAttributes() ?>>
<?= $Page->apcid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <tr id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_grp"><?= $Page->grp->caption() ?></span></td>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el_apc_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <tr id="r_code"<?= $Page->code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_code"><?= $Page->code->caption() ?></span></td>
        <td data-name="code"<?= $Page->code->cellAttributes() ?>>
<span id="el_apc_code">
<span<?= $Page->code->viewAttributes() ?>>
<?= $Page->code->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <tr id="r_description"<?= $Page->description->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_description"><?= $Page->description->caption() ?></span></td>
        <td data-name="description"<?= $Page->description->cellAttributes() ?>>
<span id="el_apc_description">
<span<?= $Page->description->viewAttributes() ?>>
<?php if (!EmptyString($Page->description->getViewValue()) && $Page->description->linkAttributes() != "") { ?>
<a<?= $Page->description->linkAttributes() ?>><?= $Page->description->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->cron->Visible) { // cron ?>
    <tr id="r_cron"<?= $Page->cron->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_cron"><?= $Page->cron->caption() ?></span></td>
        <td data-name="cron"<?= $Page->cron->cellAttributes() ?>>
<span id="el_apc_cron">
<span<?= $Page->cron->viewAttributes() ?>>
<?= $Page->cron->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->next_cycle->Visible) { // next_cycle ?>
    <tr id="r_next_cycle"<?= $Page->next_cycle->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_next_cycle"><?= $Page->next_cycle->caption() ?></span></td>
        <td data-name="next_cycle"<?= $Page->next_cycle->cellAttributes() ?>>
<span id="el_apc_next_cycle">
<span<?= $Page->next_cycle->viewAttributes() ?>>
<?= $Page->next_cycle->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->delay->Visible) { // delay ?>
    <tr id="r_delay"<?= $Page->delay->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_delay"><?= $Page->delay->caption() ?></span></td>
        <td data-name="delay"<?= $Page->delay->cellAttributes() ?>>
<span id="el_apc_delay">
<span<?= $Page->delay->viewAttributes() ?>>
<?= $Page->delay->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->delay_method->Visible) { // delay_method ?>
    <tr id="r_delay_method"<?= $Page->delay_method->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_delay_method"><?= $Page->delay_method->caption() ?></span></td>
        <td data-name="delay_method"<?= $Page->delay_method->cellAttributes() ?>>
<span id="el_apc_delay_method">
<span<?= $Page->delay_method->viewAttributes() ?>>
<?= $Page->delay_method->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->last_updated->Visible) { // last_updated ?>
    <tr id="r_last_updated"<?= $Page->last_updated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_last_updated"><?= $Page->last_updated->caption() ?></span></td>
        <td data-name="last_updated"<?= $Page->last_updated->cellAttributes() ?>>
<span id="el_apc_last_updated">
<span<?= $Page->last_updated->viewAttributes() ?>>
<?= $Page->last_updated->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->user_level->Visible) { // user_level ?>
    <tr id="r_user_level"<?= $Page->user_level->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_user_level"><?= $Page->user_level->caption() ?></span></td>
        <td data-name="user_level"<?= $Page->user_level->cellAttributes() ?>>
<span id="el_apc_user_level">
<span<?= $Page->user_level->viewAttributes() ?>>
<?= $Page->user_level->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
    <tr id="r__visible"<?= $Page->_visible->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc__visible"><?= $Page->_visible->caption() ?></span></td>
        <td data-name="_visible"<?= $Page->_visible->cellAttributes() ?>>
<span id="el_apc__visible">
<span<?= $Page->_visible->viewAttributes() ?>>
<?= $Page->_visible->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_apc_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_apc_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_apc_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <tr id="r_order_by"<?= $Page->order_by->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_order_by"><?= $Page->order_by->caption() ?></span></td>
        <td data-name="order_by"<?= $Page->order_by->cellAttributes() ?>>
<span id="el_apc_order_by">
<span<?= $Page->order_by->viewAttributes() ?>>
<?= $Page->order_by->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <tr id="r_url"<?= $Page->url->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_apc_url"><?= $Page->url->caption() ?></span></td>
        <td data-name="url"<?= $Page->url->cellAttributes() ?>>
<span id="el_apc_url">
<span<?= $Page->url->viewAttributes() ?>>
<?= $Page->url->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
